/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.logula;

import com.codahale.logula.Formatter;
import com.codahale.logula.Logging;
import com.codahale.logula.LoggingMXBean$;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.net.SyslogAppender;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logging$
implements ScalaObject {
    public static final Logging$ MODULE$;

    static {
        new Logging$();
    }

    public void configure() {
        this.configure((Function1<Logging.LoggingConfig, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Logging.LoggingConfig x$1) {
            }
        }));
    }

    public void configure(Function1<Logging.LoggingConfig, Object> f2) {
        Logging.LoggingConfig config = new Logging.LoggingConfig();
        f2.apply(config);
        Logger root2 = Logger.getRootLogger();
        root2.getLoggerRepository().resetConfiguration();
        root2.setLevel(config.level());
        ((HashMap)config.loggers().filter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Level> tuple2) {
                Tuple2<String, Level> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Level> tuple2) {
                Tuple2<String, Level> tuple22 = tuple2;
                if (tuple22 != null) {
                    Logger.getLogger(tuple22._1()).setLevel(tuple22._2());
                    return;
                }
                throw new MatchError(tuple22);
            }
        });
        AsyncAppender appender = new AsyncAppender();
        root2.addAppender(appender);
        if (config.console().enabled()) {
            ConsoleAppender console = new ConsoleAppender(new Formatter());
            console.setThreshold(config.console().threshold());
            appender.addAppender(console);
        }
        if (config.file().enabled()) {
            RollingFileAppender rollingLog = new RollingFileAppender();
            rollingLog.setLayout(new Formatter());
            rollingLog.setAppend(true);
            rollingLog.setFile(config.file().filename());
            rollingLog.setMaximumFileSize(config.file().maxSize() * 1024);
            rollingLog.setMaxBackupIndex(config.file().retainedFiles());
            rollingLog.activateOptions();
            rollingLog.setThreshold(config.file().threshold());
            appender.addAppender(rollingLog);
        }
        if (config.syslog().enabled()) {
            PatternLayout layout = new PatternLayout("%c: %m");
            SyslogAppender syslog = new SyslogAppender(layout, "localhost", SyslogAppender.getFacility("local2"));
            appender.addAppender(syslog);
        }
        if (config.registerWithJMX()) {
            try {
                MBeanServer mbeans = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("com.codahale.logula:type=Logging");
                mbeans.registerMBean(LoggingMXBean$.MODULE$, name);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {}
        }
    }

    private Logging$() {
        MODULE$ = this;
    }
}

