/*
 * Decompiled with CFR 0.152.
 */
package cnveth;

import de.hu.berlin.wbi.objects.MutationMention;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import seth.ner.wrapper.Type;

public class CNVRecognizer {
    private static final String prefix = "(^|[\\.\\s\\(\\['\"/,\\-])";
    private static final String cnvKeywords = "(copy number variation|CNV|amplification|polymorphism|increased copy number)";
    private static final String preposition = "(of|on|in)";
    private static final Pattern cnv = Pattern.compile("(^|[\\.\\s\\(\\['\"/,\\-])(copy number variation|CNV|amplification|polymorphism|increased copy number)s? (of|on|in) ", 2);

    public List<MutationMention> extractMutations(String text2) {
        ArrayList<MutationMention> result2 = new ArrayList<MutationMention>();
        Matcher matcher = cnv.matcher(text2);
        while (matcher.find()) {
            int begin = matcher.start(2);
            int end = matcher.end(3);
            MutationMention mm = new MutationMention(begin, end, text2.substring(begin, end), null, null, null, null, Type.COPY_NUMBER_VARIATION, MutationMention.Tool.CNVETH);
            result2.add(mm);
        }
        return result2;
    }
}

