/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.Argument;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArgumentCollectionImpl
implements ArgumentCollection {
    private final Map<String, List<String>> m_arguments;
    private final List<String> m_unparsed;

    public ArgumentCollectionImpl(Map<String, List<String>> arguments, List<String> unparsed) {
        this.m_arguments = arguments;
        this.m_unparsed = unparsed;
    }

    public boolean hasUnparsed() {
        return !this.m_unparsed.isEmpty();
    }

    @Override
    public List<String> getUnparsed() {
        return new ArrayList<String>(this.m_unparsed);
    }

    @Override
    public Iterator<Argument> iterator() {
        return new Iterator<Argument>(){
            final Iterator<Map.Entry<String, List<String>>> m_iterator;
            {
                this.m_iterator = ArgumentCollectionImpl.this.m_arguments.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_iterator.hasNext();
            }

            @Override
            public Argument next() {
                Map.Entry<String, List<String>> next2 = this.m_iterator.next();
                return new ArgumentImpl(next2.getKey(), next2.getValue());
            }

            @Override
            public void remove() {
                this.m_iterator.remove();
            }
        };
    }

    boolean containsAny(String ... options) {
        return this.containsAny(Arrays.asList(options));
    }

    @Override
    public boolean containsAny(List<String> options) {
        for (String option : options) {
            if (!this.m_arguments.containsKey(option)) continue;
            return true;
        }
        return false;
    }

    List<String> getValues(String ... options) {
        return this.getValues(Arrays.asList(options));
    }

    @Override
    public List<String> getValues(List<String> options) {
        for (String option : options) {
            if (!this.m_arguments.containsKey(option)) continue;
            return this.m_arguments.get(option);
        }
        return null;
    }
}

