/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XOMTools {
    public static Node getNextSibling(Node node) {
        ParentNode parent = node.getParent();
        int i = parent.indexOf(node);
        if (i + 1 >= parent.getChildCount()) {
            return null;
        }
        return parent.getChild(i + 1);
    }

    public static Node getNextSibling(Node current, String tagName) {
        Element next2;
        Element matchedElement = null;
        while ((next2 = (Element)XOMTools.getNextSibling(current)) != null) {
            if (next2.getLocalName().equals(tagName)) {
                matchedElement = next2;
                break;
            }
            current = next2;
        }
        return matchedElement;
    }

    public static Node getPreviousSibling(Node node) {
        ParentNode parent = node.getParent();
        int i = parent.indexOf(node);
        if (i == 0) {
            return null;
        }
        return parent.getChild(i - 1);
    }

    public static Node getPreviousSibling(Node current, String tagName) {
        Element prev;
        Element matchedElement = null;
        while ((prev = (Element)XOMTools.getPreviousSibling(current)) != null) {
            if (prev.getLocalName().equals(tagName)) {
                matchedElement = prev;
                break;
            }
            current = prev;
        }
        return matchedElement;
    }

    public static void insertBefore(Node node, Node newNode) {
        ParentNode parent = node.getParent();
        int i = parent.indexOf(node);
        parent.insertChild(newNode, i);
    }

    public static void insertAfter(Node node, Node newNode) {
        ParentNode parent = node.getParent();
        int i = parent.indexOf(node);
        parent.insertChild(newNode, i + 1);
    }

    public static Node getNext(Node node) {
        Element parent = (Element)node.getParent();
        if (parent == null || parent.getLocalName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(node);
        if (index + 1 >= parent.getChildCount()) {
            return XOMTools.getNext(parent);
        }
        Element next2 = (Element)parent.getChild(index + 1);
        Elements children2 = next2.getChildElements();
        while (children2.size() != 0) {
            next2 = children2.get(0);
            children2 = next2.getChildElements();
        }
        return next2;
    }

    public static Node getPrevious(Node node) {
        Element parent = (Element)node.getParent();
        if (parent == null || parent.getLocalName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(node);
        if (index == 0) {
            return XOMTools.getPrevious(parent);
        }
        Element previous = (Element)parent.getChild(index - 1);
        Elements children2 = previous.getChildElements();
        while (children2.size() != 0) {
            previous = children2.get(children2.size() - 1);
            children2 = previous.getChildElements();
        }
        return previous;
    }

    public static void setTextChild(Element group, String newName) {
        Node textNode = group.getChild(0);
        if (!(textNode instanceof Text)) {
            throw new IllegalArgumentException("No Text Child Found!");
        }
        ((Text)textNode).setValue(newName);
    }

    public static List<Element> getNextSiblingsOfType(Element currentElem, String type) {
        ArrayList<Element> laterSiblingElementsOfType = new ArrayList<Element>();
        Element parent = (Element)currentElem.getParent();
        if (parent == null) {
            return laterSiblingElementsOfType;
        }
        Elements potentialMatches = parent.getChildElements(type);
        int indexOfCurrentElem = parent.indexOf(currentElem);
        for (int i = 0; i < potentialMatches.size(); ++i) {
            if (parent.indexOf(potentialMatches.get(i)) <= indexOfCurrentElem) continue;
            laterSiblingElementsOfType.add(potentialMatches.get(i));
        }
        return laterSiblingElementsOfType;
    }

    public static List<Element> getNextAdjacentSiblingsOfType(Element currentElem, String type) {
        ArrayList<Element> siblingElementsOfType = new ArrayList<Element>();
        Element parent = (Element)currentElem.getParent();
        if (parent == null) {
            return siblingElementsOfType;
        }
        Element nextSibling = (Element)XOMTools.getNextSibling(currentElem);
        while (nextSibling != null && nextSibling.getLocalName().equals(type)) {
            siblingElementsOfType.add(nextSibling);
            nextSibling = (Element)XOMTools.getNextSibling(nextSibling);
        }
        return siblingElementsOfType;
    }

    public static List<Element> getNextSiblingsOfTypes(Element currentElem, String[] types) {
        ArrayList<Element> laterSiblingElementsOfTypes = new ArrayList<Element>();
        currentElem = (Element)XOMTools.getNextSibling(currentElem);
        while (currentElem != null) {
            String name = currentElem.getLocalName();
            for (String type : types) {
                if (!name.equals(type)) continue;
                laterSiblingElementsOfTypes.add(currentElem);
                break;
            }
            currentElem = (Element)XOMTools.getNextSibling(currentElem);
        }
        return laterSiblingElementsOfTypes;
    }

    public static List<Element> getPreviousSiblingsOfType(Element currentElem, String type) {
        ArrayList<Element> earlierSiblingElementsOfType = new ArrayList<Element>();
        Element parent = (Element)currentElem.getParent();
        if (parent == null) {
            return earlierSiblingElementsOfType;
        }
        Elements potentialMatches = parent.getChildElements(type);
        int indexOfCurrentElem = parent.indexOf(currentElem);
        for (int i = 0; i < potentialMatches.size(); ++i) {
            if (parent.indexOf(potentialMatches.get(i)) >= indexOfCurrentElem) continue;
            earlierSiblingElementsOfType.add(potentialMatches.get(i));
        }
        return earlierSiblingElementsOfType;
    }

    public static Element getNextSiblingIgnoringCertainElements(Element startingEl, String[] elementsToIgnore) {
        ParentNode parent = startingEl.getParent();
        if (parent == null) {
            return null;
        }
        int i = parent.indexOf(startingEl);
        if (i + 1 >= parent.getChildCount()) {
            return null;
        }
        Element next2 = (Element)parent.getChild(i + 1);
        String elName = next2.getLocalName();
        for (String namesToIgnore : elementsToIgnore) {
            if (!elName.equals(namesToIgnore)) continue;
            return XOMTools.getNextSiblingIgnoringCertainElements(next2, elementsToIgnore);
        }
        return next2;
    }

    public static Element getPreviousSiblingIgnoringCertainElements(Element startingEl, String[] elementsToIgnore) {
        ParentNode parent = startingEl.getParent();
        if (parent == null) {
            return null;
        }
        int i = parent.indexOf(startingEl);
        if (i == 0) {
            return null;
        }
        Element previous = (Element)parent.getChild(i - 1);
        String elName = previous.getLocalName();
        for (String namesToIgnore : elementsToIgnore) {
            if (!elName.equals(namesToIgnore)) continue;
            return XOMTools.getPreviousSiblingIgnoringCertainElements(previous, elementsToIgnore);
        }
        return previous;
    }

    public static List<Element> getDescendantElementsWithTagName(Element startingElement, String elementName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>();
        Elements children2 = startingElement.getChildElements();
        for (int i = children2.size() - 1; i >= 0; --i) {
            stack.add(children2.get(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            if (currentElement.getLocalName().equals(elementName)) {
                matchingElements.add(currentElement);
            }
            children2 = currentElement.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                stack.add(child);
            }
        }
        return matchingElements;
    }

    public static List<Element> getDescendantElementsWithTagNames(Element startingElement, String[] elementNames) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>();
        Elements children2 = startingElement.getChildElements();
        for (int i = children2.size() - 1; i >= 0; --i) {
            stack.add(children2.get(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            String currentElName = currentElement.getLocalName();
            for (String targetTagName : elementNames) {
                if (!currentElName.equals(targetTagName)) continue;
                matchingElements.add(currentElement);
                break;
            }
            children2 = currentElement.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                stack.add(child);
            }
        }
        return matchingElements;
    }

    public static List<Element> getChildElementsWithTagNames(Element startingElement, String[] elementNames) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        Elements children2 = startingElement.getChildElements();
        int childCount = children2.size();
        block0: for (int i = 0; i < childCount; ++i) {
            Element child = children2.get(i);
            String currentElName = child.getLocalName();
            for (String targetTagName : elementNames) {
                if (!currentElName.equals(targetTagName)) continue;
                matchingElements.add(child);
                continue block0;
            }
        }
        return matchingElements;
    }

    public static List<Element> getChildElementsWithTagName(Element startingElement, String elementName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        Elements children2 = startingElement.getChildElements();
        int childCount = children2.size();
        for (int i = 0; i < childCount; ++i) {
            Element child = children2.get(i);
            String currentElName = child.getLocalName();
            if (!currentElName.equals(elementName)) continue;
            matchingElements.add(child);
        }
        return matchingElements;
    }

    public static List<Element> getDescendantElementsWithTagNameAndAttribute(Element startingElement, String elementName, String attributeName, String attributeValue) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        LinkedList<Element> stack = new LinkedList<Element>();
        Elements children2 = startingElement.getChildElements();
        for (int i = children2.size() - 1; i >= 0; --i) {
            stack.add(children2.get(i));
        }
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            if (currentElement.getLocalName().equals(elementName) && attributeValue.equals(currentElement.getAttributeValue(attributeName))) {
                matchingElements.add(currentElement);
            }
            children2 = currentElement.getChildElements();
            for (int i = children2.size() - 1; i >= 0; --i) {
                Element child = children2.get(i);
                stack.add(child);
            }
        }
        return matchingElements;
    }

    public static List<Element> getChildElementsWithTagNameAndAttribute(Element startingElement, String elementName, String attributeName, String attributeValue) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        Elements children2 = startingElement.getChildElements();
        for (int i = 0; i < children2.size(); ++i) {
            Element child = children2.get(i);
            if (!child.getLocalName().equals(elementName) || !attributeValue.equals(child.getAttributeValue(attributeName))) continue;
            matchingElements.add(child);
        }
        return matchingElements;
    }

    public static int[] countNumberOfElementsAndNumberOfChildLessElements(Element startingElement) {
        int[] counts = new int[2];
        LinkedList<Element> stack = new LinkedList<Element>();
        stack.add(startingElement);
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.removeLast();
            Elements children2 = currentElement.getChildElements();
            int childCount = children2.size();
            if (childCount == 0) {
                counts[1] = counts[1] + 1;
                continue;
            }
            for (int i = 0; i < childCount; ++i) {
                counts[0] = counts[0] + 1;
                stack.add(children2.get(i));
            }
        }
        return counts;
    }

    public static List<Element> getSiblingsUpToElementWithTagName(Element startingEl, String tagName) {
        ArrayList<Element> laterSiblings = new ArrayList<Element>();
        Element nextEl = (Element)XOMTools.getNextSibling(startingEl);
        while (nextEl != null && !nextEl.getLocalName().equals(tagName)) {
            laterSiblings.add(nextEl);
            nextEl = (Element)XOMTools.getNextSibling(nextEl);
        }
        return laterSiblings;
    }
}

