/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WordRulesOmittedSpaceCorrector {
    private static final Pattern matchAteOrIteEnding = Pattern.compile("[ai]t[e]?$", 2);
    private final BuildState state;
    private final Element parse;

    WordRulesOmittedSpaceCorrector(BuildState state, Element parse) {
        this.state = state;
        this.parse = parse;
    }

    void correctOmittedSpaces() throws StructureBuildingException {
        List<Element> wordRules = XOMTools.getDescendantElementsWithTagName(this.parse, "wordRule");
        for (Element wordRule : wordRules) {
            WordRule wordRuleVal = WordRule.valueOf(wordRule.getAttributeValue("wordRule"));
            if (wordRuleVal == WordRule.divalentFunctionalGroup) {
                this.checkAndCorrectOmittedSpacesInDivalentFunctionalGroupRule(wordRule);
                continue;
            }
            if (wordRuleVal != WordRule.simple) continue;
            this.checkAndCorrectOmittedSpaceEster(wordRule);
        }
    }

    private void checkAndCorrectOmittedSpacesInDivalentFunctionalGroupRule(Element divalentFunctionalGroupWordRule) {
        Element firstSubstituent;
        Elements children2;
        List<Element> substituentWords = XOMTools.getChildElementsWithTagNameAndAttribute(divalentFunctionalGroupWordRule, "word", "type", "substituent");
        if (substituentWords.size() == 1 && (children2 = substituentWords.get(0).getChildElements()).size() == 2 && (firstSubstituent = children2.get(0)).getAttribute("locant") == null && firstSubstituent.getAttribute("multiplier") == null) {
            Element subToMove = children2.get(1);
            subToMove.detach();
            Element newWord = new Element("word");
            newWord.addAttribute(new Attribute("type", "substituent"));
            newWord.appendChild(subToMove);
            XOMTools.insertAfter(substituentWords.get(0), newWord);
        }
    }

    private void checkAndCorrectOmittedSpaceEster(Element wordRule) throws StructureBuildingException {
        Element rootGroup;
        Fragment rootFrag;
        int functionalAtomsCount;
        List<Element> roots;
        Elements words = wordRule.getChildElements("word");
        if (words.size() != 1) {
            return;
        }
        Element word = words.get(0);
        String wordRuleContents = wordRule.getAttributeValue("value");
        if (matchAteOrIteEnding.matcher(wordRuleContents).find() && (roots = XOMTools.getChildElementsWithTagName(word, "root")).size() == 1 && (functionalAtomsCount = (rootFrag = this.state.xmlFragmentMap.get(rootGroup = roots.get(0).getFirstChildElement("group"))).getFunctionalAtoms().size()) > 0) {
            List<Element> substituentsAndBrackets = XOMTools.getChildElementsWithTagNames(word, new String[]{"substituent", "bracket"});
            if (substituentsAndBrackets.size() == 0) {
                return;
            }
            Element firstChild = substituentsAndBrackets.get(0);
            if (!this.checkSuitabilityOfSubstituentForEsterFormation(firstChild, functionalAtomsCount)) {
                return;
            }
            if (substituentsAndBrackets.size() > 1 && (this.allBarFirstSubstituentHaveLocants(substituentsAndBrackets) || this.insufficientSubstitutableHydrogenForSubstition(substituentsAndBrackets, rootFrag))) {
                this.transformToEster(wordRule, firstChild);
            } else if (substituentsAndBrackets.size() == 1) {
                String multiplierValue = firstChild.getAttributeValue("multiplier");
                int multiplier = 1;
                if (multiplierValue != null) {
                    multiplier = Integer.parseInt(multiplierValue);
                }
                if (this.specialCaseWhereEsterPreferred(this.getRightMostGroup(firstChild), multiplierValue, wordRuleContents) || this.substitutionWouldBeAmbiguous(rootGroup, rootFrag, multiplier)) {
                    this.transformToEster(wordRule, firstChild);
                }
            }
        }
    }

    private boolean allBarFirstSubstituentHaveLocants(List<Element> substituentsAndBrackets) {
        if (substituentsAndBrackets.size() <= 1) {
            return false;
        }
        for (int i = 1; i < substituentsAndBrackets.size(); ++i) {
            if (substituentsAndBrackets.get(i).getAttribute("locant") != null) continue;
            return false;
        }
        return true;
    }

    private boolean insufficientSubstitutableHydrogenForSubstition(List<Element> substituentsAndBrackets, Fragment frag) {
        int substitutableHydrogens = this.getAtomForEachSubstitutableHydrogen(frag).size();
        for (int i = 1; i < substituentsAndBrackets.size(); ++i) {
            Element subOrBracket = substituentsAndBrackets.get(i);
            Fragment f2 = this.state.xmlFragmentMap.get(this.getRightMostGroup(subOrBracket));
            String multiplierValue = subOrBracket.getAttributeValue("multiplier");
            int multiplier = 1;
            if (multiplierValue != null) {
                multiplier = Integer.parseInt(multiplierValue);
            }
            substitutableHydrogens -= this.getTotalOutAtomValency(f2) * multiplier;
        }
        int firstFragSubstitutableHydrogenRequired = this.getTotalOutAtomValency(this.state.xmlFragmentMap.get(this.getRightMostGroup(substituentsAndBrackets.get(0))));
        String multiplierValue = substituentsAndBrackets.get(0).getAttributeValue("multiplier");
        int multiplier = 1;
        if (multiplierValue != null) {
            multiplier = Integer.parseInt(multiplierValue);
        }
        return substitutableHydrogens >= 0 && substitutableHydrogens - firstFragSubstitutableHydrogenRequired * multiplier < 0;
    }

    private int getTotalOutAtomValency(Fragment f2) {
        int outAtomValency = 0;
        for (OutAtom outAtom : f2.getOutAtoms()) {
            outAtomValency += outAtom.getValency();
        }
        return outAtomValency;
    }

    private boolean specialCaseWhereEsterPreferred(Element substituentGroupEl, String multiplierValue, String wordRuleContents) {
        String potentialString;
        if (multiplierValue != null && Integer.parseInt(multiplierValue) == 1) {
            return true;
        }
        return substituentGroupEl.getAttributeValue("type").equals("chain") && "alkaneStem".equals(substituentGroupEl.getAttributeValue("subType")) && wordRuleContents.matches(potentialString = "(?i)" + substituentGroupEl.getValue() + "yl[\\-]?(form|methan|acet|ethan)[o]?ate");
    }

    private boolean substitutionWouldBeAmbiguous(Element rootGroup, Fragment frag, int multiplier) {
        if (multiplier == 1 && (rootGroup.getAttribute("defaultInID") != null || rootGroup.getAttribute("defaultInLocant") != null)) {
            return false;
        }
        List<Atom> atomForEachSubstitutableHydrogen = this.getAtomForEachSubstitutableHydrogen(frag);
        StereoAnalyser analyzer = new StereoAnalyser(frag);
        HashSet<Integer> uniqueEnvironments = new HashSet<Integer>();
        for (Atom a : atomForEachSubstitutableHydrogen) {
            uniqueEnvironments.add(analyzer.getAtomEnvironmentNumber(a));
        }
        if (atomForEachSubstitutableHydrogen.size() == multiplier) {
            return false;
        }
        return uniqueEnvironments.size() != 1 || multiplier != 1 && multiplier != atomForEachSubstitutableHydrogen.size() - 1;
    }

    private boolean checkSuitabilityOfSubstituentForEsterFormation(Element subOrBracket, int rootFunctionalAtomsCount) {
        int multiplier;
        if (subOrBracket.getAttribute("locant") != null) {
            return false;
        }
        List<OutAtom> outAtomsOfFinalGroup = this.state.xmlFragmentMap.get(this.getRightMostGroup(subOrBracket)).getOutAtoms();
        if (outAtomsOfFinalGroup.size() != 1 || outAtomsOfFinalGroup.get(0).getValency() != 1) {
            return false;
        }
        String multiplierStr = subOrBracket.getAttributeValue("multiplier");
        return multiplierStr == null || (multiplier = Integer.parseInt(multiplierStr)) <= rootFunctionalAtomsCount;
    }

    private Element getRightMostGroup(Element subOrBracket) {
        Element group = subOrBracket.getLocalName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subOrBracket) : subOrBracket.getFirstChildElement("group");
        return group;
    }

    private List<Atom> getAtomForEachSubstitutableHydrogen(Fragment frag) {
        ArrayList<Atom> substitutableAtoms = new ArrayList<Atom>();
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            int currentValency;
            if (FragmentTools.isFunctionalAtomOrAldehyde(atom)) continue;
            int currentExpectedValency = atom.determineValency(true);
            for (int i = currentValency = atom.getIncomingValency() + (atom.hasSpareValency() ? 1 : 0) + atom.getOutValency(); i < currentExpectedValency; ++i) {
                substitutableAtoms.add(atom);
            }
        }
        return substitutableAtoms;
    }

    private void transformToEster(Element parentSimpleWordRule, Element substituentOrBracket) throws StructureBuildingException {
        parentSimpleWordRule.getAttribute("wordRule").setValue(WordRule.ester.toString());
        Elements childElsOfSub = substituentOrBracket.getChildElements();
        Element lastChildElOfSub = childElsOfSub.get(childElsOfSub.size() - 1);
        if (lastChildElOfSub.getLocalName().equals("hyphen")) {
            lastChildElOfSub.detach();
        }
        substituentOrBracket.detach();
        Element newSubstituentWord = new Element("word");
        newSubstituentWord.addAttribute(new Attribute("type", "substituent"));
        newSubstituentWord.appendChild(substituentOrBracket);
        parentSimpleWordRule.insertChild(newSubstituentWord, 0);
        String multiplierStr = substituentOrBracket.getAttributeValue("multiplier");
        if (multiplierStr != null) {
            substituentOrBracket.removeAttribute(substituentOrBracket.getAttribute("multiplier"));
            int multiplier = Integer.parseInt(multiplierStr);
            for (int i = 1; i < multiplier; ++i) {
                Element clone2 = this.state.fragManager.cloneElement(this.state, newSubstituentWord);
                XOMTools.insertAfter(newSubstituentWord, clone2);
            }
        }
    }
}

