/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.apache.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildResults;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructureBuildingMethods {
    private static final Logger LOG = Logger.getLogger(StructureBuildingMethods.class);
    private static final Pattern matchCompoundLocant = Pattern.compile("[\\[\\(\\{](\\d+[a-z]?'*)[\\]\\)\\}]");

    private StructureBuildingMethods() {
    }

    static void resolveWordOrBracket(BuildState state, Element word) throws StructureBuildingException {
        if (word.getLocalName().equals("wordRule")) {
            return;
        }
        if (!word.getLocalName().equals("word") && !word.getLocalName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        StructureBuildingMethods.recursivelyResolveLocantedFeatures(state, word);
        StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, word);
        List<Element> subsBracketsAndRoots = XOMTools.getDescendantElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (Element subsBracketsAndRoot : subsBracketsAndRoots) {
            if (subsBracketsAndRoot.getAttribute("multiplier") == null) continue;
            throw new StructureBuildingException("Structure building problem: multiplier on :" + subsBracketsAndRoot.getLocalName() + " was never used");
        }
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(word, "group");
        for (int i = 0; i < groups.size(); ++i) {
            Element group = groups.get(i);
            if (group.getAttribute("resolved") != null || i == groups.size() - 1) continue;
            throw new StructureBuildingException("Structure building problem: Bond was not made from :" + group.getValue() + " but one should of been");
        }
    }

    static void recursivelyResolveLocantedFeatures(BuildState state, Element word) throws StructureBuildingException {
        if (!word.getLocalName().equals("word") && !word.getLocalName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        List<Element> subsBracketsAndRoots = XOMTools.getChildElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (int i = subsBracketsAndRoots.size() - 1; i >= 0; --i) {
            Element subBracketOrRoot = subsBracketsAndRoots.get(i);
            if (subBracketOrRoot.getLocalName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveLocantedFeatures(state, subBracketOrRoot);
                if (!StructureBuildingMethods.potentiallyCanSubstitute(subBracketOrRoot)) continue;
                StructureBuildingMethods.performAdditiveOperations(state, subBracketOrRoot);
                StructureBuildingMethods.performLocantedSubstitutiveOperations(state, subBracketOrRoot);
                continue;
            }
            StructureBuildingMethods.resolveRootOrSubstituentLocanted(state, subBracketOrRoot);
        }
    }

    static void recursivelyResolveUnLocantedFeatures(BuildState state, Element word) throws StructureBuildingException {
        if (!word.getLocalName().equals("word") && !word.getLocalName().equals("bracket")) {
            throw new StructureBuildingException("A word or bracket is the expected input");
        }
        List<Element> subsBracketsAndRoots = XOMTools.getChildElementsWithTagNames(word, new String[]{"bracket", "substituent", "root"});
        for (int i = subsBracketsAndRoots.size() - 1; i >= 0; --i) {
            Element subBracketOrRoot = subsBracketsAndRoots.get(i);
            if (subBracketOrRoot.getLocalName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, subBracketOrRoot);
                if (!StructureBuildingMethods.potentiallyCanSubstitute(subBracketOrRoot)) continue;
                StructureBuildingMethods.performUnLocantedSubstitutiveOperations(state, subBracketOrRoot);
                continue;
            }
            StructureBuildingMethods.resolveRootOrSubstituentUnLocanted(state, subBracketOrRoot);
        }
    }

    static void resolveRootOrSubstituentLocanted(BuildState state, Element subOrRoot) throws StructureBuildingException {
        StructureBuildingMethods.resolveLocantedFeatures(state, subOrRoot);
        boolean foundSomethingToSubstitute = StructureBuildingMethods.potentiallyCanSubstitute(subOrRoot);
        if (foundSomethingToSubstitute) {
            StructureBuildingMethods.performAdditiveOperations(state, subOrRoot);
            StructureBuildingMethods.performLocantedSubstitutiveOperations(state, subOrRoot);
        }
    }

    static void resolveRootOrSubstituentUnLocanted(BuildState state, Element subOrRoot) throws StructureBuildingException {
        boolean foundSomethingToSubstitute = StructureBuildingMethods.potentiallyCanSubstitute(subOrRoot);
        StructureBuildingMethods.resolveUnLocantedFeatures(state, subOrRoot);
        if (foundSomethingToSubstitute) {
            StructureBuildingMethods.performUnLocantedSubstitutiveOperations(state, subOrRoot);
        }
    }

    private static void performLocantedSubstitutiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        Element group = subBracketOrRoot.getLocalName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
        if (group.getAttribute("resolved") != null) {
            return;
        }
        Fragment frag = state.xmlFragmentMap.get(group);
        if (frag.getOutAtoms().size() >= 1 && subBracketOrRoot.getAttribute("locant") != null) {
            String locantString = subBracketOrRoot.getAttributeValue("locant");
            if (frag.getOutAtoms().size() > 1) {
                StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
            }
            if (subBracketOrRoot.getAttribute("multiplier") != null) {
                StructureBuildingMethods.multiplyOutAndSubstitute(state, subBracketOrRoot);
            } else {
                Fragment parentFrag = StructureBuildingMethods.findFragmentWithLocant(state, subBracketOrRoot, locantString);
                if (parentFrag == null) {
                    throw new StructureBuildingException("Cannot find in scope fragment with atom with locant " + locantString + ".");
                }
                group.addAttribute(new Attribute("resolved", "yes"));
                Element groupToAttachTo = state.xmlFragmentMap.getElement(parentFrag);
                if (groupToAttachTo.getAttribute("acceptsAdditiveBonds") != null && parentFrag.getOutAtoms().size() > 0 && groupToAttachTo.getAttribute("isAMultiRadical") != null && parentFrag.getAtomByLocantOrThrow(locantString).getOutValency() > 0 && frag.getOutAtom(0).getValency() == 1) {
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, parentFrag);
                } else {
                    StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, parentFrag.getAtomByLocantOrThrow(locantString));
                }
            }
        }
    }

    private static void performUnLocantedSubstitutiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        Element group = subBracketOrRoot.getLocalName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
        if (group.getAttribute("resolved") != null) {
            return;
        }
        Fragment frag = state.xmlFragmentMap.get(group);
        if (frag.getOutAtoms().size() >= 1) {
            if (subBracketOrRoot.getAttribute("locant") != null) {
                throw new StructureBuildingException("Substituent has an unused outAtom and has a locant but locanted susbtitution should already been been performed!");
            }
            if (frag.getOutAtoms().size() > 1) {
                StructureBuildingMethods.checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(frag, group);
            }
            if (subBracketOrRoot.getAttribute("multiplier") != null) {
                StructureBuildingMethods.multiplyOutAndSubstitute(state, subBracketOrRoot);
            } else {
                if ("perhalogeno".equals(group.getAttributeValue("subType"))) {
                    StructureBuildingMethods.performPerHalogenoSubstitution(state, frag, subBracketOrRoot);
                } else {
                    Atom atomToJoinTo = StructureBuildingMethods.findAtomForSubstitution(state, subBracketOrRoot, frag.getOutAtom(0).getValency());
                    if (atomToJoinTo == null) {
                        throw new StructureBuildingException("Unlocanted substitution failed: unable to find suitable atom to bond atom with id:" + frag.getOutAtom(0).getAtom().getID() + " to!");
                    }
                    StructureBuildingMethods.joinFragmentsSubstitutively(state, frag, atomToJoinTo);
                }
                group.addAttribute(new Attribute("resolved", "yes"));
            }
        }
    }

    private static void performPerHalogenoSubstitution(BuildState state, Fragment perhalogenFrag, Element subBracketOrRoot) throws StructureBuildingException {
        int i;
        List<Fragment> fragmentsToAttachTo = StructureBuildingMethods.findAlternativeFragments(state, subBracketOrRoot);
        ArrayList<Atom> atomsToHalogenate = new ArrayList<Atom>();
        for (Fragment fragment : fragmentsToAttachTo) {
            for (Atom atom : fragment.getAtomList()) {
                int substitutableHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom);
                if (substitutableHydrogen > 0 && atom.hasSpareValency()) {
                    --substitutableHydrogen;
                }
                if (substitutableHydrogen > 0 && FragmentTools.isCharacteristicAtom(atom)) continue;
                for (int i2 = 0; i2 < substitutableHydrogen; ++i2) {
                    atomsToHalogenate.add(atom);
                }
            }
        }
        ArrayList<Fragment> halogens = new ArrayList<Fragment>();
        halogens.add(perhalogenFrag);
        for (i = 0; i < atomsToHalogenate.size() - 1; ++i) {
            halogens.add(state.fragManager.copyFragment(perhalogenFrag));
        }
        for (i = 0; i < atomsToHalogenate.size(); ++i) {
            Fragment halogen = (Fragment)halogens.get(i);
            Atom from2 = halogen.getOutAtom(0).getAtom();
            halogen.removeOutAtom(0);
            state.fragManager.createBond(from2, (Atom)atomsToHalogenate.get(i), 1);
        }
        for (i = 1; i < atomsToHalogenate.size(); ++i) {
            state.fragManager.incorporateFragment((Fragment)halogens.get(i), perhalogenFrag);
        }
    }

    private static void multiplyOutAndSubstitute(BuildState state, Element subOrBracket) throws StructureBuildingException {
        int multiplier = Integer.parseInt(subOrBracket.getAttributeValue("multiplier"));
        subOrBracket.removeAttribute(subOrBracket.getAttribute("multiplier"));
        String[] locants = null;
        if (subOrBracket.getAttribute("locant") != null) {
            locants = OpsinTools.MATCH_COMMA.split(subOrBracket.getAttributeValue("locant"));
        }
        Element parentWordOrBracket = (Element)subOrBracket.getParent();
        int indexOfSubOrBracket = parentWordOrBracket.indexOf(subOrBracket);
        subOrBracket.detach();
        ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
        Element multiplierEl = subOrBracket.getFirstChildElement("multiplier");
        if (multiplierEl == null) {
            throw new StructureBuildingException("Multiplier not found where multiplier expected");
        }
        for (int j = subOrBracket.indexOf(multiplierEl) - 1; j >= 0; --j) {
            Element el = (Element)subOrBracket.getChild(j);
            el.detach();
            elementsNotToBeMultiplied.add(el);
        }
        multiplierEl.detach();
        ArrayList<Element> multipliedElements = new ArrayList<Element>();
        for (int i = multiplier - 1; i >= 0; --i) {
            Element currentElement;
            if (i != 0) {
                currentElement = state.fragManager.cloneElement(state, subOrBracket, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(currentElement, StringTools.multiplyString("'", i));
            } else {
                currentElement = subOrBracket;
            }
            multipliedElements.add(currentElement);
            parentWordOrBracket.insertChild(currentElement, indexOfSubOrBracket);
            if (locants != null) {
                currentElement.getAttribute("locant").setValue(locants[i]);
                StructureBuildingMethods.performLocantedSubstitutiveOperations(state, currentElement);
            } else {
                StructureBuildingMethods.performUnLocantedSubstitutiveOperations(state, currentElement);
            }
            currentElement.detach();
        }
        for (Element multipliedElement : multipliedElements) {
            parentWordOrBracket.insertChild(multipliedElement, indexOfSubOrBracket);
        }
        for (Element el : elementsNotToBeMultiplied) {
            subOrBracket.insertChild(el, 0);
        }
    }

    static void resolveLocantedFeatures(BuildState state, Element subOrRoot) throws StructureBuildingException {
        String locant;
        int i;
        String locant2;
        int i2;
        Elements groups = subOrRoot.getChildElements("group");
        if (groups.size() != 1) {
            throw new StructureBuildingException("Each sub or root should only have one group element. This indicates a bug in OPSIN");
        }
        Element group = groups.get(0);
        Fragment thisFrag = state.xmlFragmentMap.get(group);
        ArrayList<Element> unsaturators = new ArrayList<Element>();
        ArrayList<Element> heteroatoms = new ArrayList<Element>();
        ArrayList<Element> hydrogenElements = new ArrayList<Element>();
        ArrayList<Element> dehydroElements = new ArrayList<Element>();
        ArrayList<Element> substractivePrefixElements = new ArrayList<Element>();
        Elements children2 = subOrRoot.getChildElements();
        for (i2 = 0; i2 < children2.size(); ++i2) {
            Element currentEl = children2.get(i2);
            String elName = currentEl.getLocalName();
            if (elName.equals("unsaturator")) {
                unsaturators.add(currentEl);
                continue;
            }
            if (elName.equals("heteroatom")) {
                heteroatoms.add(currentEl);
                continue;
            }
            if (elName.equals("subtractivePrefix")) {
                substractivePrefixElements.add(currentEl);
                continue;
            }
            if (elName.equals("hydro")) {
                if (!currentEl.getValue().equals("dehydro")) {
                    hydrogenElements.add(currentEl);
                    continue;
                }
                dehydroElements.add(currentEl);
                continue;
            }
            if (elName.equals("indicatedHydrogen")) {
                hydrogenElements.add(currentEl);
                continue;
            }
            if (!elName.equals("addedHydrogen")) continue;
            hydrogenElements.add(currentEl);
        }
        for (i2 = substractivePrefixElements.size() - 1; i2 >= 0; --i2) {
            Element substractivePrefix = (Element)substractivePrefixElements.get(i2);
            locant2 = substractivePrefix.getAttributeValue("locant");
            String element = substractivePrefix.getAttributeValue("value");
            FragmentTools.removeTerminalAtom(state, thisFrag, element, locant2);
            substractivePrefix.detach();
        }
        for (i2 = hydrogenElements.size() - 1; i2 >= 0; --i2) {
            Element hydrogen = (Element)hydrogenElements.get(i2);
            locant2 = hydrogen.getAttributeValue("locant");
            if (locant2 == null) continue;
            Atom a = thisFrag.getAtomByLocantOrThrow(locant2);
            if (!a.hasSpareValency()) {
                throw new StructureBuildingException("hydrogen addition at locant: " + locant2 + " was requested, but this atom is not unsaturated");
            }
            a.setSpareValency(false);
            hydrogenElements.remove(hydrogen);
            hydrogen.detach();
        }
        ArrayList<Atom> atomsToFormTripleBondsBetween = new ArrayList<Atom>();
        for (i = dehydroElements.size() - 1; i >= 0; --i) {
            Element dehydro = (Element)dehydroElements.get(i);
            locant = dehydro.getAttributeValue("locant");
            if (locant != null) {
                Atom a = thisFrag.getAtomByLocantOrThrow(locant);
                if (!a.hasSpareValency()) {
                    a.setSpareValency(true);
                } else {
                    atomsToFormTripleBondsBetween.add(a);
                }
            } else {
                throw new StructureBuildingException("locants are assumed to be required for the use of dehydro to be unambiguous");
            }
            hydrogenElements.remove(dehydro);
            dehydro.detach();
        }
        StructureBuildingMethods.addDehydroInducedTripleBonds(atomsToFormTripleBondsBetween);
        for (i = unsaturators.size() - 1; i >= 0; --i) {
            Element unsaturator = (Element)unsaturators.get(i);
            locant = unsaturator.getAttributeValue("locant");
            int bondOrder = Integer.parseInt(unsaturator.getAttributeValue("value"));
            if (bondOrder <= 1) {
                unsaturator.detach();
                continue;
            }
            if (locant == null) continue;
            unsaturators.remove(unsaturator);
            Matcher matcher = matchCompoundLocant.matcher(locant);
            if (matcher.find()) {
                String compoundLocant = matcher.group(1);
                locant = matcher.replaceAll("");
                FragmentTools.unsaturate(thisFrag.getAtomByLocantOrThrow(locant), compoundLocant, bondOrder, thisFrag);
            } else {
                FragmentTools.unsaturate(thisFrag.getAtomByLocantOrThrow(locant), bondOrder, thisFrag);
            }
            unsaturator.detach();
        }
        for (i = heteroatoms.size() - 1; i >= 0; --i) {
            Element heteroatomEl = (Element)heteroatoms.get(i);
            locant = heteroatomEl.getAttributeValue("locant");
            if (locant == null) continue;
            Atom heteroatom = state.fragManager.getHeteroatom(heteroatomEl.getAttributeValue("value"));
            Atom atomToBeReplaced = thisFrag.getAtomByLocantOrThrow(locant);
            if (heteroatom.getElement().equals(atomToBeReplaced.getElement()) && heteroatom.getCharge() == atomToBeReplaced.getCharge()) {
                throw new StructureBuildingException("The replacement term " + heteroatomEl.getValue() + " was used on an atom that already is a " + heteroatom.getElement());
            }
            state.fragManager.replaceAtomWithAtom(thisFrag.getAtomByLocantOrThrow(locant), heteroatom, true);
            if (heteroatomEl.getAttribute("lambda") != null) {
                thisFrag.getAtomByLocantOrThrow(locant).setLambdaConventionValency(Integer.parseInt(heteroatomEl.getAttributeValue("lambda")));
            }
            heteroatoms.remove(heteroatomEl);
            heteroatomEl.detach();
        }
    }

    private static void addDehydroInducedTripleBonds(List<Atom> atomsToFormTripleBondsBetween) throws StructureBuildingException {
        if (atomsToFormTripleBondsBetween.size() > 0) {
            HashSet<Atom> atoms = new HashSet<Atom>(atomsToFormTripleBondsBetween);
            if (atomsToFormTripleBondsBetween.size() != atoms.size()) {
                throw new StructureBuildingException("locants specified for dehydro specify the same atom too many times");
            }
            for (int i = atomsToFormTripleBondsBetween.size() - 1; i >= 0; i -= 2) {
                Atom neighbour2;
                Atom a;
                block4: {
                    a = atomsToFormTripleBondsBetween.get(i);
                    List<Atom> neighbours = a.getAtomNeighbours();
                    for (Atom neighbour2 : neighbours) {
                        if (!atomsToFormTripleBondsBetween.contains(neighbour2)) continue;
                        break block4;
                    }
                    throw new StructureBuildingException("dehydro indicated atom should form a triple bond but no adjacent atoms also had hydrogen removed!");
                }
                atomsToFormTripleBondsBetween.remove(i);
                atomsToFormTripleBondsBetween.remove(neighbour2);
                Bond b = a.getBondToAtomOrThrow(neighbour2);
                b.setOrder(3);
                a.setSpareValency(false);
                neighbour2.setSpareValency(false);
            }
        }
    }

    static void resolveUnLocantedFeatures(BuildState state, Element subOrRoot) throws StructureBuildingException {
        Elements groups = subOrRoot.getChildElements("group");
        if (groups.size() != 1) {
            throw new StructureBuildingException("Each sub or root should only have one group element. This indicates a bug in OPSIN");
        }
        Element group = groups.get(0);
        Fragment thisFrag = state.xmlFragmentMap.get(group);
        List<Atom> atomList = thisFrag.getAtomList();
        ArrayList<Element> unsaturators = new ArrayList<Element>();
        ArrayList<Element> heteroatoms = new ArrayList<Element>();
        ArrayList<Element> hydrogenElements = new ArrayList<Element>();
        Elements children2 = subOrRoot.getChildElements();
        for (int i = 0; i < children2.size(); ++i) {
            Element currentEl = children2.get(i);
            String elName = currentEl.getLocalName();
            if (elName.equals("unsaturator")) {
                unsaturators.add(currentEl);
                continue;
            }
            if (elName.equals("heteroatom")) {
                heteroatoms.add(currentEl);
                continue;
            }
            if (elName.equals("hydro")) {
                if (currentEl.getValue().equals("dehydro")) continue;
                hydrogenElements.add(currentEl);
                continue;
            }
            if (elName.equals("indicatedHydrogen")) {
                hydrogenElements.add(currentEl);
                continue;
            }
            if (!elName.equals("addedHydrogen")) continue;
            hydrogenElements.add(currentEl);
        }
        if (hydrogenElements.size() > 0) {
            LinkedList<Atom> atomsWithSV = new LinkedList<Atom>();
            LinkedList<Atom> atomsWhichImplicitlyWillHaveTheirSVRemoved = new LinkedList<Atom>();
            for (Atom atom : atomList) {
                if (atom.getType().equals("suffix")) break;
                atom.ensureSVIsConsistantWithValency(false);
                if (!atom.hasSpareValency()) continue;
                if (StructureBuildingMethods.atomWillHaveSVImplicitlyRemoved(atom)) {
                    atomsWhichImplicitlyWillHaveTheirSVRemoved.add(atom);
                    continue;
                }
                atomsWithSV.add(atom);
            }
            atomsWithSV.addAll(atomsWhichImplicitlyWillHaveTheirSVRemoved);
            boolean saturateAllAtoms = false;
            for (Element hydrogenElement : hydrogenElements) {
                if (!hydrogenElement.getValue().equals("perhydro")) continue;
                saturateAllAtoms = true;
                hydrogenElement.detach();
            }
            if (saturateAllAtoms) {
                if (hydrogenElements.size() != 1) {
                    throw new StructureBuildingException("Unexpected indication of hydrogen when perhydro makes such indication redundnant");
                }
                for (Atom atomToReduceSpareValencyOn : atomsWithSV) {
                    atomToReduceSpareValencyOn.setSpareValency(false);
                }
            } else {
                if (hydrogenElements.size() > atomsWithSV.size()) {
                    throw new StructureBuildingException("Cannot find atom to add hydrogen to (" + hydrogenElements.size() + " hydrogen adding tags but only " + atomsWithSV.size() + " positions that can be hydrogenated)");
                }
                for (Element hydrogenElement : hydrogenElements) {
                    Atom atomToReduceSpareValencyOn = (Atom)atomsWithSV.removeFirst();
                    atomToReduceSpareValencyOn.setSpareValency(false);
                    hydrogenElement.detach();
                }
            }
        }
        for (Element unsaturator : unsaturators) {
            int bondOrder = Integer.parseInt(unsaturator.getAttributeValue("value"));
            if (bondOrder <= 1) {
                unsaturator.detach();
                continue;
            }
            Bond bondToUnsaturate = StructureBuildingMethods.findBondToUnSaturate(atomList, bondOrder, false);
            if (bondToUnsaturate == null) {
                bondToUnsaturate = StructureBuildingMethods.findBondToUnSaturate(atomList, bondOrder, true);
            }
            if (bondToUnsaturate == null) {
                throw new StructureBuildingException("Cannot find bond to unsaturate using unsaturator: " + unsaturator.getValue());
            }
            bondToUnsaturate.setOrder(bondOrder);
            unsaturator.detach();
        }
        int atomIndice = 0;
        for (Element heteroatomEl : heteroatoms) {
            Atom heteroatom = state.fragManager.getHeteroatom(heteroatomEl.getAttributeValue("value"));
            String heteroatomSymbol = heteroatom.getElement();
            Atom atomToReplaceWithHeteroAtom = null;
            while (atomIndice < atomList.size()) {
                Atom possibleAtom = atomList.get(atomIndice);
                if (!possibleAtom.getType().equals("suffix") && (!heteroatomSymbol.equals(possibleAtom.getElement()) || heteroatom.getCharge() != possibleAtom.getCharge()) && (possibleAtom.getElement().equals("C") || heteroatomSymbol.equals("C") || possibleAtom.getElement().equals("O") && (heteroatomSymbol.equals("S") || heteroatomSymbol.equals("Se") || heteroatomSymbol.equals("Te"))) && ValencyChecker.checkValencyAvailableForReplacementByHeteroatom(possibleAtom, heteroatom)) {
                    atomToReplaceWithHeteroAtom = possibleAtom;
                    break;
                }
                ++atomIndice;
            }
            if (atomToReplaceWithHeteroAtom == null) {
                throw new StructureBuildingException("Cannot find suitable atom for heteroatom replacement");
            }
            state.fragManager.replaceAtomWithAtom(atomToReplaceWithHeteroAtom, heteroatom, true);
            if (heteroatomEl.getAttribute("lambda") != null) {
                atomToReplaceWithHeteroAtom.setLambdaConventionValency(Integer.parseInt(heteroatomEl.getAttributeValue("lambda")));
            }
            ++atomIndice;
            heteroatomEl.detach();
        }
        if (thisFrag.getOutAtoms().size() > 0) {
            for (OutAtom outAtom : thisFrag.getOutAtoms()) {
                if (outAtom.isSetExplicitly()) continue;
                Atom atomToAssociateOutAtomWith = thisFrag.getAtomOrNextSuitableAtom(outAtom.getAtom(), outAtom.getValency(), true);
                if (atomToAssociateOutAtomWith == null) {
                    throw new StructureBuildingException("Failed to assign all unlocanted radicals to actual atoms without violating valency");
                }
                outAtom.setAtom(atomToAssociateOutAtomWith);
                outAtom.setSetExplicitly(true);
            }
        }
    }

    static Bond findBondToUnSaturate(List<Atom> atomList, int bondOrder, boolean allowAdjacentUnsaturatedBonds) {
        Bond bondToUnsaturate = null;
        block0: for (Atom atom1 : atomList) {
            Set<Bond> bonds = atom1.getBonds();
            if (!allowAdjacentUnsaturatedBonds) {
                for (Bond bond : bonds) {
                    if (bond.getOrder() == 1) continue;
                    continue block0;
                }
            }
            block2: for (Bond bond : bonds) {
                if (bond.getOrder() != 1 || atom1.hasSpareValency() || "suffix".equals(atom1.getType()) || atom1.getProperty(Atom.ISALDEHYDE) != null || !ValencyChecker.checkValencyAvailableForBond(atom1, bondOrder - 1 + atom1.getOutValency())) continue;
                Atom atom2 = bond.getOtherAtom(atom1);
                if (!allowAdjacentUnsaturatedBonds) {
                    for (Bond bond2 : atom2.getBonds()) {
                        if (bond2.getOrder() == 1) continue;
                        continue block2;
                    }
                }
                if (atom2.hasSpareValency() || "suffix".equals(atom2.getType()) || atom2.getProperty(Atom.ISALDEHYDE) != null || !ValencyChecker.checkValencyAvailableForBond(atom2, bondOrder - 1 + atom2.getOutValency())) continue;
                bondToUnsaturate = bond;
                break block0;
            }
        }
        return bondToUnsaturate;
    }

    private static boolean atomWillHaveSVImplicitlyRemoved(Atom atom) throws StructureBuildingException {
        boolean canFormDoubleBond = false;
        for (Atom aa : atom.getFrag().getIntraFragmentAtomNeighbours(atom)) {
            if (!aa.hasSpareValency()) continue;
            canFormDoubleBond = true;
        }
        if (!canFormDoubleBond) {
            return true;
        }
        if (atom.hasSpareValency()) {
            atom.ensureSVIsConsistantWithValency(true);
            if (!atom.hasSpareValency()) {
                atom.setSpareValency(true);
                return true;
            }
        }
        return false;
    }

    private static void performAdditiveOperations(BuildState state, Element subBracketOrRoot) throws StructureBuildingException {
        block17: {
            int outAtomCount;
            Fragment frag;
            Element group;
            block18: {
                Atom toAtom;
                block20: {
                    block19: {
                        if (subBracketOrRoot.getAttribute("locant") != null) {
                            return;
                        }
                        group = subBracketOrRoot.getLocalName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(subBracketOrRoot) : subBracketOrRoot.getFirstChildElement("group");
                        if (group.getAttribute("resolved") != null) {
                            return;
                        }
                        frag = state.xmlFragmentMap.get(group);
                        outAtomCount = frag.getOutAtoms().size();
                        if (outAtomCount < 1) break block17;
                        if (subBracketOrRoot.getAttribute("multiplier") != null) break block18;
                        Element nextSiblingEl = (Element)XOMTools.getNextSibling(subBracketOrRoot);
                        if (nextSiblingEl.getAttribute("multiplier") == null || outAtomCount < Integer.parseInt(nextSiblingEl.getAttributeValue("multiplier")) && (outAtomCount != 1 || frag.getOutAtom(0).getValency() != Integer.parseInt(nextSiblingEl.getAttributeValue("multiplier"))) || !StructureBuildingMethods.hasRootLikeOrMultiRadicalGroup(state, nextSiblingEl)) break block19;
                        if (outAtomCount == 1) {
                            FragmentTools.splitOutAtomIntoValency1OutAtoms(frag.getOutAtom(0));
                        }
                        StructureBuildingMethods.performMultiplicativeOperations(state, group, nextSiblingEl);
                        break block17;
                    }
                    if (group.getAttribute("isAMultiRadical") == null) break block20;
                    Fragment nextFrag = StructureBuildingMethods.getNextInScopeMultiValentFragment(state, subBracketOrRoot);
                    if (nextFrag == null) break block17;
                    Element nextMultiRadicalGroup = state.xmlFragmentMap.getElement(nextFrag);
                    Element parentSubOrRoot = (Element)nextMultiRadicalGroup.getParent();
                    if (state.currentWordRule != WordRule.polymer) {
                        Fragment adjacentFrag;
                        if (nextMultiRadicalGroup.getAttribute("iminoLike") != null && nextFrag != (adjacentFrag = state.xmlFragmentMap.get(OpsinTools.getNextGroup(subBracketOrRoot))) && (StructureBuildingMethods.potentiallyCanSubstitute((Element)nextMultiRadicalGroup.getParent()) || StructureBuildingMethods.potentiallyCanSubstitute((Element)nextMultiRadicalGroup.getParent().getParent()))) {
                            return;
                        }
                        if (group.getAttribute("iminoLike") != null && StructureBuildingMethods.levelsToWordEl(group) > StructureBuildingMethods.levelsToWordEl(nextMultiRadicalGroup)) {
                            return;
                        }
                    }
                    if (parentSubOrRoot.getAttribute("multiplier") != null) {
                        throw new StructureBuildingException("Attempted to form additive bond to a multiplied component");
                    }
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, nextFrag);
                    break block17;
                }
                List<Fragment> siblingFragments = StructureBuildingMethods.findAlternativeFragments(state, subBracketOrRoot);
                if (siblingFragments.size() <= 0) break block17;
                Fragment nextFrag = siblingFragments.get(siblingFragments.size() - 1);
                Element nextGroup = state.xmlFragmentMap.getElement(nextFrag);
                if (nextGroup.getAttribute("acceptsAdditiveBonds") != null && nextFrag != null && nextGroup.getAttribute("isAMultiRadical") != null && (nextFrag.getOutAtoms().size() > 1 || nextGroup.getAttribute("resolved") != null && nextFrag.getOutAtoms().size() >= 1) && StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom = nextFrag.getOutAtom(0).getAtom()) == 0) {
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.joinFragmentsAdditively(state, frag, nextFrag);
                }
                if (group.getAttribute("resolved") != null || siblingFragments.size() <= 1) break block17;
                for (int i = 0; i < siblingFragments.size() - 1; ++i) {
                    Fragment lastFrag = siblingFragments.get(i);
                    Element lastGroup = state.xmlFragmentMap.getElement(lastFrag);
                    if (lastGroup.getAttribute("acceptsAdditiveBonds") != null && lastFrag != null && lastGroup.getAttribute("isAMultiRadical") != null && (lastFrag.getOutAtoms().size() > 1 || lastGroup.getAttribute("resolved") != null && lastFrag.getOutAtoms().size() >= 1)) {
                        Atom toAtom2 = lastFrag.getOutAtom(0).getAtom();
                        if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom2) != 0) break block17;
                        group.addAttribute(new Attribute("resolved", "yes"));
                        StructureBuildingMethods.joinFragmentsAdditively(state, frag, lastFrag);
                        break block17;
                    }
                    if (lastFrag.getAtomOrNextSuitableAtom(lastFrag.getDefaultInAtom(), frag.getOutAtom(outAtomCount - 1).getValency(), true) == null) {
                        continue;
                    }
                    break block17;
                }
                break block17;
            }
            List<Fragment> siblingFragments = StructureBuildingMethods.findAlternativeFragments(state, subBracketOrRoot);
            if (siblingFragments.size() > 0) {
                Atom toAtom;
                int multiplier = Integer.parseInt(subBracketOrRoot.getAttributeValue("multiplier"));
                Fragment nextFrag = siblingFragments.get(siblingFragments.size() - 1);
                Element nextGroup = state.xmlFragmentMap.getElement(nextFrag);
                if (nextGroup.getAttribute("acceptsAdditiveBonds") != null && nextFrag != null && nextGroup.getAttribute("isAMultiRadical") != null && (nextFrag.getOutAtoms().size() >= multiplier || nextGroup.getAttribute("resolved") != null && nextFrag.getOutAtoms().size() >= multiplier + 1) && StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom = nextFrag.getOutAtom(0).getAtom()) == 0) {
                    group.addAttribute(new Attribute("resolved", "yes"));
                    StructureBuildingMethods.multiplyOutAndAdditivelyBond(state, subBracketOrRoot, nextFrag);
                }
                if (group.getAttribute("resolved") == null && siblingFragments.size() > 1) {
                    for (int i = 0; i < siblingFragments.size() - 1; ++i) {
                        Fragment lastFrag = siblingFragments.get(i);
                        Element lastGroup = state.xmlFragmentMap.getElement(lastFrag);
                        if (lastGroup.getAttribute("acceptsAdditiveBonds") != null && lastFrag != null && lastGroup.getAttribute("isAMultiRadical") != null && (lastFrag.getOutAtoms().size() >= multiplier || lastGroup.getAttribute("resolved") != null && lastFrag.getOutAtoms().size() >= multiplier + 1)) {
                            Atom toAtom3 = lastFrag.getOutAtom(0).getAtom();
                            if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(toAtom3) != 0) break;
                            group.addAttribute(new Attribute("resolved", "yes"));
                            StructureBuildingMethods.multiplyOutAndAdditivelyBond(state, subBracketOrRoot, lastFrag);
                            break;
                        }
                        if (lastFrag.getAtomOrNextSuitableAtom(lastFrag.getDefaultInAtom(), frag.getOutAtom(outAtomCount - 1).getValency(), true) == null) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private static boolean hasRootLikeOrMultiRadicalGroup(BuildState state, Element subBracketOrRoot) {
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(subBracketOrRoot, "group");
        if (subBracketOrRoot.getAttribute("inLocants") != null) {
            return true;
        }
        for (Element group : groups) {
            Fragment frag = state.xmlFragmentMap.get(group);
            int outAtomCount = frag.getOutAtoms().size();
            if (!(group.getAttribute("isAMultiRadical") != null ? outAtomCount >= 1 : outAtomCount == 0 && group.getAttribute("resolved") == null)) continue;
            return true;
        }
        return false;
    }

    private static void multiplyOutAndAdditivelyBond(BuildState state, Element subOrBracket, Fragment fragToAdditivelyBondTo) throws StructureBuildingException {
        int multiplier = Integer.parseInt(subOrBracket.getAttributeValue("multiplier"));
        subOrBracket.removeAttribute(subOrBracket.getAttribute("multiplier"));
        ArrayList<Element> clonedElements = new ArrayList<Element>();
        ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
        for (int i = multiplier - 1; i >= 0; --i) {
            Element currentElement;
            if (i != 0) {
                currentElement = state.fragManager.cloneElement(state, subOrBracket, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(currentElement, StringTools.multiplyString("'", i));
                clonedElements.add(currentElement);
            } else {
                currentElement = subOrBracket;
                Element multiplierEl = subOrBracket.getFirstChildElement("multiplier");
                if (multiplierEl == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier expected");
                }
                for (int j = subOrBracket.indexOf(multiplierEl) - 1; j >= 0; --j) {
                    Element el = (Element)subOrBracket.getChild(j);
                    el.detach();
                    elementsNotToBeMultiplied.add(el);
                }
                multiplierEl.detach();
            }
            Element group = currentElement.getLocalName().equals("bracket") ? StructureBuildingMethods.findRightMostGroupInBracket(currentElement) : currentElement.getFirstChildElement("group");
            Fragment frag = state.xmlFragmentMap.get(group);
            if (frag.getOutAtoms().size() != 1) {
                throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have one OutAtom in this case but had: " + frag.getOutAtoms().size());
            }
            StructureBuildingMethods.joinFragmentsAdditively(state, frag, fragToAdditivelyBondTo);
        }
        for (Element clone2 : clonedElements) {
            XOMTools.insertAfter(subOrBracket, clone2);
        }
        for (Element el : elementsNotToBeMultiplied) {
            subOrBracket.insertChild(el, 0);
        }
    }

    private static void performMultiplicativeOperations(BuildState state, Element group, Element multipliedParent) throws StructureBuildingException {
        BuildResults multiRadicalBR = new BuildResults(state, (Element)group.getParent());
        StructureBuildingMethods.performMultiplicativeOperations(state, multiRadicalBR, multipliedParent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void performMultiplicativeOperations(BuildState state, BuildResults multiRadicalBR, Element multipliedParent) throws StructureBuildingException {
        int multiplier = Integer.parseInt(multipliedParent.getAttributeValue("multiplier"));
        if (multiplier != multiRadicalBR.getOutAtomCount()) {
            if (multiRadicalBR.getOutAtomCount() == multiplier * 2) {
                // empty if block
            }
            if (multiplier != multiRadicalBR.getOutAtomCount()) {
                throw new StructureBuildingException("Multiplication bond formation failure: number of outAtoms disagree with multiplier(multiplier: " + multiplier + ", outAtom count: " + multiRadicalBR.getOutAtomCount() + ")");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(multiplier + " multiplicative bonds to be formed");
        }
        multipliedParent.removeAttribute(multipliedParent.getAttribute("multiplier"));
        List<Object> inLocants = null;
        if (multipliedParent.getAttribute("inLocants") != null) {
            String inLocantsString = multipliedParent.getAttributeValue("inLocants");
            if (inLocantsString.equals("default")) {
                inLocants = new ArrayList(multiplier);
                for (int i = 0; i < multiplier; ++i) {
                    inLocants.add("default");
                }
            } else {
                inLocants = StringTools.arrayToList(OpsinTools.MATCH_COMMA.split(inLocantsString));
                if (inLocants.size() != multiplier) {
                    throw new StructureBuildingException("Mismatch between multiplier and number of inLocants in multiplicative nomenclature");
                }
            }
        }
        ArrayList<Element> clonedElements = new ArrayList<Element>();
        BuildResults newBr = new BuildResults();
        for (int i = multiplier - 1; i >= 0; --i) {
            Element multipliedGroup;
            Element multipliedElement;
            if (i != 0) {
                multipliedElement = state.fragManager.cloneElement(state, multipliedParent, i);
                StructureBuildingMethods.addPrimesToLocantedStereochemistryElements(multipliedElement, StringTools.multiplyString("'", i));
                clonedElements.add(multipliedElement);
            } else {
                multipliedElement = multipliedParent;
            }
            if (multipliedElement.getLocalName().equals("bracket")) {
                multipliedGroup = StructureBuildingMethods.getFirstMultiValentGroup(state, multipliedElement);
                if (multipliedGroup == null) {
                    List<Element> groups = XOMTools.getDescendantElementsWithTagName(multipliedElement, "group");
                    if (inLocants == null) {
                        throw new StructureBuildingException("OPSIN Bug? in locants must be specified for a multiplied root in multiplicative nomenclature");
                    }
                    if (((String)inLocants.get(0)).equals("default")) {
                        multipliedGroup = groups.get(groups.size() - 1);
                    } else {
                        block2: for (int j = groups.size() - 1; j >= 0; --j) {
                            Fragment possibleFrag = state.xmlFragmentMap.get(groups.get(j));
                            for (String string2 : inLocants) {
                                if (!possibleFrag.hasLocant(string2)) continue;
                                multipliedGroup = groups.get(j);
                                break block2;
                            }
                        }
                    }
                    if (multipliedGroup == null) {
                        throw new StructureBuildingException("Locants for inAtoms on the root were either misassigned to the root or were invalid: " + inLocants.toString() + " could not be assigned!");
                    }
                }
            } else {
                multipliedGroup = multipliedElement.getFirstChildElement("group");
            }
            Fragment multipliedFrag = state.xmlFragmentMap.get(multipliedGroup);
            Fragment multiRadicalFrag = multiRadicalBR.getOutAtom(i).getAtom().getFrag();
            Element multiRadicalGroup = state.xmlFragmentMap.getElement(multiRadicalFrag);
            if (multiRadicalGroup.getAttribute("resolved") == null) {
                StructureBuildingMethods.resolveUnLocantedFeatures(state, (Element)multiRadicalGroup.getParent());
                multiRadicalGroup.addAttribute(new Attribute("resolved", "yes"));
            }
            boolean substitutivelyBondedToRoot = false;
            if (inLocants != null) {
                void var14_23;
                if (multipliedElement.getLocalName().equals("bracket")) {
                    Element element = StructureBuildingMethods.findRightMostGroupInBracket(multipliedElement);
                } else {
                    Element element = multipliedElement.getFirstChildElement("group");
                }
                var14_23.addAttribute(new Attribute("resolved", "yes"));
                if (multipliedGroup.getAttribute("isAMultiRadical") != null) {
                    if (!multipliedParent.getAttributeValue("inLocants").equals("default")) {
                        throw new StructureBuildingException("inLocants should not be specified for a multiradical parent in multiplicative nomenclature");
                    }
                } else {
                    Atom atomToJoinTo = null;
                    for (int j = inLocants.size() - 1; j >= 0; --j) {
                        String locant = (String)inLocants.get(j);
                        if (locant.equals("default")) {
                            atomToJoinTo = multipliedFrag.getAtomOrNextSuitableAtomOrThrow(multipliedFrag.getDefaultInAtom(), 1, true);
                            inLocants.remove(j);
                            break;
                        }
                        Atom inAtom = multipliedFrag.getAtomByLocant(locant);
                        if (inAtom == null) continue;
                        atomToJoinTo = inAtom;
                        inLocants.remove(j);
                        break;
                    }
                    if (atomToJoinTo == null) {
                        throw new StructureBuildingException("Locants for inAtoms on the root were either misassigned to the root or were invalid: " + inLocants.toString() + " could not be assigned!");
                    }
                    OutAtom out = multiRadicalBR.getOutAtom(i);
                    Atom from2 = out.getAtom();
                    int bondOrder = out.getValency();
                    if (!out.isSetExplicitly()) {
                        from2 = from2.getFrag().getAtomOrNextSuitableAtomOrThrow(from2, bondOrder, false);
                    }
                    multiRadicalFrag.removeOutAtom(out);
                    state.fragManager.createBond(from2, atomToJoinTo, bondOrder);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Substitutively bonded (multiplicative to root) " + from2.getID() + " (" + state.xmlFragmentMap.getElement(from2.getFrag()).getValue() + ") " + atomToJoinTo.getID() + " (" + state.xmlFragmentMap.getElement(atomToJoinTo.getFrag()).getValue() + ")");
                    }
                    substitutivelyBondedToRoot = true;
                }
            }
            if (!substitutivelyBondedToRoot) {
                StructureBuildingMethods.joinFragmentsAdditively(state, multiRadicalBR.getOutAtom(i).getAtom().getFrag(), multipliedFrag);
            }
            if (multipliedElement.getLocalName().equals("bracket")) {
                StructureBuildingMethods.recursivelyResolveUnLocantedFeatures(state, multipliedElement);
            }
            if (inLocants != null) continue;
            newBr.mergeBuildResults(new BuildResults(state, multipliedElement));
        }
        if (newBr.getFragmentCount() == 1) {
            throw new StructureBuildingException("Multiplicative nomenclature cannot yield only one temporary terminal fragment");
        }
        if (newBr.getFragmentCount() >= 2) {
            List<Element> siblings = XOMTools.getNextSiblingsOfTypes(multipliedParent, new String[]{"substituent", "bracket", "root"});
            if (siblings.size() == 0) {
                Element parentOfMultipliedEl = (Element)multipliedParent.getParent();
                if (!parentOfMultipliedEl.getLocalName().equals("bracket")) throw new StructureBuildingException("Could not find suitable element to continue multiplicative nomenclature");
                siblings = XOMTools.getNextSiblingsOfTypes(parentOfMultipliedEl, new String[]{"substituent", "bracket", "root"});
                if (siblings.get(0).getAttribute("multiplier") == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier was expected for succesful multiplicative nomenclature");
                }
                StructureBuildingMethods.performMultiplicativeOperations(state, newBr, siblings.get(0));
            } else {
                if (siblings.get(0).getAttribute("multiplier") == null) {
                    throw new StructureBuildingException("Multiplier not found where multiplier was expected for successful multiplicative nomenclature");
                }
                StructureBuildingMethods.performMultiplicativeOperations(state, newBr, siblings.get(0));
            }
        }
        for (Element clone2 : clonedElements) {
            XOMTools.insertAfter(multipliedParent, clone2);
        }
    }

    private static Fragment getNextInScopeMultiValentFragment(BuildState state, Element substituentOrBracket) throws StructureBuildingException {
        if (!substituentOrBracket.getLocalName().equals("substituent") && !substituentOrBracket.getLocalName().equals("bracket")) {
            throw new StructureBuildingException("Input to this function should be a substituent or bracket");
        }
        if (substituentOrBracket.getParent() == null) {
            throw new StructureBuildingException("substituent did not have a parent!");
        }
        Element parent = (Element)substituentOrBracket.getParent();
        List<Element> children2 = XOMTools.getChildElementsWithTagNames(parent, new String[]{"substituent", "bracket", "root"});
        int indexOfSubstituent = parent.indexOf(substituentOrBracket);
        for (Element child : children2) {
            List<Element> childDescendants;
            if (parent.indexOf(child) <= indexOfSubstituent || child.getAttribute("multiplier") != null) continue;
            if (child.getLocalName().equals("bracket")) {
                childDescendants = XOMTools.getDescendantElementsWithTagNames(child, new String[]{"substituent", "root"});
            } else {
                childDescendants = new ArrayList<Element>();
                childDescendants.add(child);
            }
            for (Element descendantChild : childDescendants) {
                Element group = descendantChild.getFirstChildElement("group");
                if (group == null) {
                    throw new StructureBuildingException("substituent/root is missing its group");
                }
                Fragment possibleFrag = state.xmlFragmentMap.get(group);
                if (group.getAttribute("isAMultiRadical") == null || possibleFrag.getOutAtoms().size() < 2 && (possibleFrag.getOutAtoms().size() < 1 || group.getAttribute("resolved") == null)) continue;
                return possibleFrag;
            }
        }
        return null;
    }

    private static Element getFirstMultiValentGroup(BuildState state, Element bracket) throws StructureBuildingException {
        if (!bracket.getLocalName().equals("bracket")) {
            throw new StructureBuildingException("Input to this function should be a bracket");
        }
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(bracket, "group");
        for (Element group : groups) {
            Fragment possibleFrag = state.xmlFragmentMap.get(group);
            if (group.getAttribute("isAMultiRadical") == null || possibleFrag.getOutAtoms().size() < 2 && (possibleFrag.getOutAtoms().size() < 1 || group.getAttribute("resolved") == null)) continue;
            return group;
        }
        return null;
    }

    private static void joinFragmentsAdditively(BuildState state, Fragment fragToBeJoined, Fragment parentFrag) throws StructureBuildingException {
        int outAtomCountOnFragToBeJoined;
        Element elOfFragToBeJoined = state.xmlFragmentMap.getElement(fragToBeJoined);
        if ("epoxyLike".equals(elOfFragToBeJoined.getAttributeValue("subType"))) {
            List<OutAtom> outAtoms = fragToBeJoined.getOutAtoms();
            for (OutAtom outAtom : outAtoms) {
                if (outAtom.getLocant() == null) continue;
                throw new StructureBuildingException("Inappropriate use of " + elOfFragToBeJoined.getValue());
            }
        }
        if ((outAtomCountOnFragToBeJoined = fragToBeJoined.getOutAtoms().size()) == 0) {
            throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have at least one OutAtom but had none");
        }
        List<OutAtom> outAtomsOnParent = parentFrag.getOutAtoms();
        if (outAtomsOnParent.size() == 0) {
            throw new StructureBuildingException("Additive bond formation failure: Fragment expected to have at least one OutAtom but had none");
        }
        OutAtom in = null;
        if (outAtomsOnParent.size() > 1) {
            int firstOutAtomOrder = outAtomsOnParent.get(0).getValency();
            boolean unresolvedAmbiguity = false;
            for (OutAtom outAtom : outAtomsOnParent) {
                if (outAtom.getValency() == firstOutAtomOrder) continue;
                unresolvedAmbiguity = true;
            }
            if (unresolvedAmbiguity) {
                List<OutAtom> outAtomsOnfragToBeJoined = fragToBeJoined.getOutAtoms();
                firstOutAtomOrder = outAtomsOnfragToBeJoined.get(0).getValency();
                unresolvedAmbiguity = false;
                for (OutAtom outAtom : outAtomsOnfragToBeJoined) {
                    if (outAtom.getValency() == firstOutAtomOrder) continue;
                    unresolvedAmbiguity = true;
                }
                if (unresolvedAmbiguity && outAtomsOnfragToBeJoined.size() == 2) {
                    List<OutAtom> previousOutAtoms;
                    Element previousGroup = (Element)OpsinTools.getPreviousGroup(elOfFragToBeJoined);
                    if (previousGroup != null && (previousOutAtoms = state.xmlFragmentMap.get(previousGroup).getOutAtoms()).size() > 1) {
                        int previousGroupFirstOutAtomOrder = previousOutAtoms.get(0).getValency();
                        unresolvedAmbiguity = false;
                        for (OutAtom outAtom : previousOutAtoms) {
                            if (outAtom.getValency() == previousGroupFirstOutAtomOrder) continue;
                            unresolvedAmbiguity = true;
                        }
                        if (!unresolvedAmbiguity && previousGroupFirstOutAtomOrder == outAtomsOnParent.get(0).getValency()) {
                            for (OutAtom outAtom : outAtomsOnParent) {
                                if (outAtom.getValency() == previousGroupFirstOutAtomOrder) continue;
                                in = outAtom;
                                break;
                            }
                        }
                    }
                } else {
                    for (OutAtom outAtom : outAtomsOnParent) {
                        if (outAtom.getValency() != firstOutAtomOrder) continue;
                        in = outAtom;
                        break;
                    }
                }
            }
        }
        if (in == null) {
            in = parentFrag.getOutAtom(0);
        }
        Atom to2 = in.getAtom();
        int bondOrder = in.getValency();
        if (!in.isSetExplicitly()) {
            to2 = to2.getFrag().getAtomOrNextSuitableAtomOrThrow(to2, bondOrder, false);
        }
        parentFrag.removeOutAtom(in);
        OutAtom out = null;
        for (int i = outAtomCountOnFragToBeJoined - 1; i >= 0; --i) {
            if (fragToBeJoined.getOutAtom(i).getValency() != bondOrder) continue;
            out = fragToBeJoined.getOutAtom(i);
            break;
        }
        if (out == null) {
            if (outAtomCountOnFragToBeJoined >= bondOrder) {
                int valency = 0;
                Atom lastOutAtom = fragToBeJoined.getOutAtom(outAtomCountOnFragToBeJoined - 1).getAtom();
                for (int i = outAtomCountOnFragToBeJoined - 1; i >= 0; --i) {
                    OutAtom nextOutAtom = fragToBeJoined.getOutAtom(i);
                    if (nextOutAtom.getAtom() != lastOutAtom) {
                        throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
                    }
                    if ((valency += nextOutAtom.getValency()) == bondOrder) {
                        nextOutAtom.setValency(valency);
                        out = nextOutAtom;
                        break;
                    }
                    fragToBeJoined.removeOutAtom(nextOutAtom);
                }
                if (out == null) {
                    throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
                }
            } else {
                throw new StructureBuildingException("Additive bond formation failure: bond order disagreement");
            }
        }
        Atom from2 = out.getAtom();
        if (!out.isSetExplicitly()) {
            from2 = from2.getFrag().getAtomOrNextSuitableAtomOrThrow(from2, bondOrder, false);
        }
        fragToBeJoined.removeOutAtom(out);
        state.fragManager.createBond(from2, to2, bondOrder);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Additively bonded " + from2.getID() + " (" + state.xmlFragmentMap.getElement(from2.getFrag()).getValue() + ") " + to2.getID() + " (" + state.xmlFragmentMap.getElement(to2.getFrag()).getValue() + ")");
        }
    }

    private static void joinFragmentsSubstitutively(BuildState state, Fragment fragToBeJoined, Atom atomToJoinTo) throws StructureBuildingException {
        Element elOfFragToBeJoined = state.xmlFragmentMap.getElement(fragToBeJoined);
        if ("epoxyLike".equals(elOfFragToBeJoined.getAttributeValue("subType"))) {
            StructureBuildingMethods.formEpoxide(state, fragToBeJoined, atomToJoinTo);
            return;
        }
        int outAtomCount = fragToBeJoined.getOutAtoms().size();
        if (outAtomCount > 1) {
            throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had: " + outAtomCount);
        }
        if (outAtomCount == 0) {
            throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had none");
        }
        if (state.xmlFragmentMap.getElement(fragToBeJoined).getAttribute("iminoLike") != null && fragToBeJoined.getOutAtoms().size() == 1 && fragToBeJoined.getOutAtom(0).getValency() == 1) {
            fragToBeJoined.getOutAtom(0).setValency(2);
        }
        OutAtom out = fragToBeJoined.getOutAtom(0);
        Atom from2 = out.getAtom();
        int bondOrder = out.getValency();
        if (!out.isSetExplicitly()) {
            from2 = from2.getFrag().getAtomOrNextSuitableAtomOrThrow(from2, bondOrder, false);
        }
        fragToBeJoined.removeOutAtom(out);
        state.fragManager.createBond(from2, atomToJoinTo, bondOrder);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Substitutively bonded " + from2.getID() + " (" + state.xmlFragmentMap.getElement(from2.getFrag()).getValue() + ") " + atomToJoinTo.getID() + " (" + state.xmlFragmentMap.getElement(atomToJoinTo.getFrag()).getValue() + ")");
        }
    }

    static void formEpoxide(BuildState state, Fragment bridgingFragment, Atom atomToJoinTo) throws StructureBuildingException {
        int index;
        Fragment fragToJoinTo = atomToJoinTo.getFrag();
        List<Atom> atomList = fragToJoinTo.getAtomList();
        if (atomList.size() == 1) {
            throw new StructureBuildingException("Epoxides must be formed between two different atoms");
        }
        Atom firstAtomToJoinTo = bridgingFragment.getOutAtom(0).getLocant() != null ? fragToJoinTo.getAtomByLocantOrThrow(bridgingFragment.getOutAtom(0).getLocant()) : atomToJoinTo;
        Atom chalcogenAtom1 = bridgingFragment.getOutAtom(0).getAtom();
        bridgingFragment.removeOutAtom(0);
        Atom secondAtomToJoinTo = bridgingFragment.getOutAtom(0).getLocant() != null ? fragToJoinTo.getAtomByLocantOrThrow(bridgingFragment.getOutAtom(0).getLocant()) : ((index = atomList.indexOf(firstAtomToJoinTo)) + 1 >= atomList.size() ? fragToJoinTo.getAtomOrNextSuitableAtomOrThrow(atomList.get(index - 1), 1, true) : fragToJoinTo.getAtomOrNextSuitableAtomOrThrow(atomList.get(index + 1), 1, true));
        Atom chalcogenAtom2 = bridgingFragment.getOutAtom(0).getAtom();
        bridgingFragment.removeOutAtom(0);
        if (chalcogenAtom1.equals(chalcogenAtom2) && firstAtomToJoinTo == secondAtomToJoinTo) {
            throw new StructureBuildingException("Epoxides must be formed between two different atoms");
        }
        state.fragManager.createBond(chalcogenAtom1, firstAtomToJoinTo, 1);
        state.fragManager.createBond(chalcogenAtom2, secondAtomToJoinTo, 1);
        CycleDetector.assignWhetherAtomsAreInCycles(bridgingFragment);
    }

    private static Atom findAtomForSubstitution(BuildState state, Element subOrBracket, int bondOrder) {
        Fragment fragment;
        Atom to2 = null;
        List<Fragment> possibleParents = StructureBuildingMethods.findAlternativeFragments(state, subOrBracket);
        Iterator<Fragment> i$ = possibleParents.iterator();
        while (i$.hasNext() && (to2 = (fragment = i$.next()).getAtomOrNextSuitableAtom(fragment.getDefaultInAtom(), bondOrder, true)) == null) {
        }
        return to2;
    }

    static List<Fragment> findAlternativeFragments(BuildState state, Element startingElement) {
        Stack<Element> stack = new Stack<Element>();
        stack.add((Element)startingElement.getParent());
        ArrayList<Fragment> foundFragments = new ArrayList<Fragment>();
        boolean doneFirstIteration = false;
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.pop();
            if (currentElement.getLocalName().equals("group")) {
                Fragment groupFrag = state.xmlFragmentMap.get(currentElement);
                foundFragments.add(groupFrag);
                continue;
            }
            List<Element> siblings = XOMTools.getChildElementsWithTagNames(currentElement, new String[]{"bracket", "substituent", "root"});
            Stack<Element> bracketted = new Stack<Element>();
            for (Element bracketOrSubOrRoot : siblings) {
                if (!doneFirstIteration && currentElement.indexOf(bracketOrSubOrRoot) <= currentElement.indexOf(startingElement) || bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                if (bracketOrSubOrRoot.getLocalName().equals("bracket")) {
                    if ("implicit".equals(bracketOrSubOrRoot.getAttributeValue("type"))) {
                        stack.add(bracketOrSubOrRoot);
                        continue;
                    }
                    bracketted.add(bracketOrSubOrRoot);
                    continue;
                }
                Element group = bracketOrSubOrRoot.getFirstChildElement("group");
                stack.add(group);
            }
            stack.addAll(0, bracketted);
            doneFirstIteration = true;
        }
        return foundFragments;
    }

    private static Fragment findFragmentWithLocant(BuildState state, Element startingElement, String locant) throws StructureBuildingException {
        Stack<Element> stack = new Stack<Element>();
        stack.add((Element)startingElement.getParent());
        boolean doneFirstIteration = false;
        Fragment monoNuclearHydride = null;
        while (stack.size() > 0) {
            Element currentElement = (Element)stack.pop();
            if (currentElement.getLocalName().equals("substituent") || currentElement.getLocalName().equals("root")) {
                Fragment groupFrag = state.xmlFragmentMap.get(currentElement.getFirstChildElement("group"));
                if (monoNuclearHydride != null && currentElement.getAttribute("locant") != null) {
                    return monoNuclearHydride;
                }
                if (!groupFrag.hasLocant(locant)) continue;
                if (locant.equals("1") && groupFrag.getAtomList().size() == 1) {
                    if (monoNuclearHydride != null) continue;
                    monoNuclearHydride = groupFrag;
                    continue;
                }
                return groupFrag;
            }
            if (monoNuclearHydride != null) {
                return monoNuclearHydride;
            }
            List<Element> siblings = XOMTools.getChildElementsWithTagNames(currentElement, new String[]{"bracket", "substituent", "root"});
            Stack<Element> bracketted = new Stack<Element>();
            if (!doneFirstIteration) {
                int indexOfStartingEl = currentElement.indexOf(startingElement);
                Element substituentToTryFirst = null;
                for (Element bracketOrSubOrRoot : siblings) {
                    int indexOfCurrentEl = currentElement.indexOf(bracketOrSubOrRoot);
                    if (indexOfCurrentEl <= indexOfStartingEl || bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                    if (bracketOrSubOrRoot.getLocalName().equals("bracket")) {
                        if ("implicit".equals(bracketOrSubOrRoot.getAttributeValue("type"))) {
                            stack.add(bracketOrSubOrRoot);
                            continue;
                        }
                        bracketted.add(bracketOrSubOrRoot);
                        continue;
                    }
                    if (substituentToTryFirst == null && bracketOrSubOrRoot.getAttribute("locant") == null && OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) {
                        substituentToTryFirst = bracketOrSubOrRoot;
                        continue;
                    }
                    stack.add(bracketOrSubOrRoot);
                }
                if (substituentToTryFirst != null) {
                    stack.add(substituentToTryFirst);
                }
                doneFirstIteration = true;
            } else {
                for (Element bracketOrSubOrRoot : siblings) {
                    if (bracketOrSubOrRoot.getAttribute("multiplier") != null) continue;
                    if (bracketOrSubOrRoot.getLocalName().equals("bracket")) {
                        if ("implicit".equals(bracketOrSubOrRoot.getAttributeValue("type"))) {
                            stack.add(bracketOrSubOrRoot);
                            continue;
                        }
                        bracketted.add(bracketOrSubOrRoot);
                        continue;
                    }
                    stack.add(bracketOrSubOrRoot);
                }
            }
            stack.addAll(0, bracketted);
        }
        return monoNuclearHydride;
    }

    static Element findRightMostGroupInBracket(Element bracket) {
        List<Element> subsBracketsAndRoots = XOMTools.getChildElementsWithTagNames(bracket, new String[]{"bracket", "substituent", "root"});
        while (subsBracketsAndRoots.get(subsBracketsAndRoots.size() - 1).getLocalName().equals("bracket")) {
            subsBracketsAndRoots = XOMTools.getChildElementsWithTagNames(subsBracketsAndRoots.get(subsBracketsAndRoots.size() - 1), new String[]{"bracket", "substituent", "root"});
        }
        return subsBracketsAndRoots.get(subsBracketsAndRoots.size() - 1).getFirstChildElement("group");
    }

    private static boolean potentiallyCanSubstitute(Element subBracketOrRoot) {
        Element parent = (Element)subBracketOrRoot.getParent();
        Elements children2 = parent.getChildElements();
        for (int i = parent.indexOf(subBracketOrRoot) + 1; i < children2.size(); ++i) {
            if (children2.get(i).getLocalName().equals("hyphen")) continue;
            return true;
        }
        return false;
    }

    private static void checkAndApplySpecialCaseWhereOutAtomsCanBeCombinedOrThrow(Fragment frag, Element group) throws StructureBuildingException {
        int outAtomCount = frag.getOutAtoms().size();
        if (outAtomCount <= 1) {
            return;
        }
        if ("epoxyLike".equals(group.getAttributeValue("subType"))) {
            return;
        }
        String groupValue = group.getValue();
        if (groupValue.equals("oxy") || groupValue.equals("thio") || groupValue.equals("seleno") || groupValue.equals("telluro")) {
            return;
        }
        Atom firstOutAtom = frag.getOutAtom(0).getAtom();
        int valencyOfOutAtom = 0;
        for (int i = outAtomCount - 1; i >= 0; --i) {
            OutAtom out = frag.getOutAtom(i);
            if (out.getAtom() != firstOutAtom) {
                throw new StructureBuildingException("Substitutive bond formation failure: Fragment expected to have one OutAtom but had: " + outAtomCount);
            }
            valencyOfOutAtom += out.getValency();
            frag.removeOutAtom(i);
        }
        frag.addOutAtom(frag.getFirstAtom(), valencyOfOutAtom, (Boolean)true);
    }

    static int calculateSubstitutableHydrogenAtoms(Atom atom) {
        int valency = atom.determineValency(true);
        int currentValency = atom.getIncomingValency() + atom.getOutValency();
        return valency - currentValency;
    }

    private static void addPrimesToLocantedStereochemistryElements(Element subOrBracket, String primesString) {
        List<Element> stereoChemistryElements = XOMTools.getDescendantElementsWithTagName(subOrBracket, "stereoChemistry");
        for (Element stereoChemistryElement : stereoChemistryElements) {
            if (stereoChemistryElement.getAttribute("locant") == null) continue;
            stereoChemistryElement.getAttribute("locant").setValue(stereoChemistryElement.getAttributeValue("locant") + primesString);
        }
    }

    private static Integer levelsToWordEl(Element element) {
        int count2 = 0;
        while (!element.getLocalName().equals("word")) {
            if ((element = (Element)element.getParent()) == null) {
                return null;
            }
            ++count2;
        }
        return count2;
    }
}

