/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildResults;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructureBuilder {
    StructureBuilder() {
    }

    Fragment buildFragment(BuildState state, Element molecule) throws StructureBuildingException {
        Elements wordRules = molecule.getChildElements("wordRule");
        if (wordRules.size() == 0) {
            throw new StructureBuildingException("Molecule contains no words!?");
        }
        Stack<Element> wordRuleStack = new Stack<Element>();
        for (int i = wordRules.size() - 1; i >= 0; --i) {
            wordRuleStack.add(wordRules.get(i));
        }
        ArrayList<Fragment> rGroups = new ArrayList<Fragment>();
        ArrayList<Element> wordRulesVisited = new ArrayList<Element>();
        while (wordRuleStack.size() > 0) {
            Element nextWordRuleEl = (Element)wordRuleStack.peek();
            if (!wordRulesVisited.contains(nextWordRuleEl)) {
                wordRulesVisited.add(nextWordRuleEl);
                Elements wordRuleChildren = nextWordRuleEl.getChildElements("wordRule");
                if (wordRuleChildren.size() != 0) {
                    for (int i = wordRuleChildren.size() - 1; i >= 0; --i) {
                        wordRuleStack.add(wordRuleChildren.get(i));
                    }
                    continue;
                }
            }
            Element currentWordRuleEl = (Element)wordRuleStack.pop();
            WordRule wordRule = WordRule.valueOf(currentWordRuleEl.getAttributeValue("wordRule"));
            List<Element> words = XOMTools.getChildElementsWithTagNames(currentWordRuleEl, new String[]{"word", "wordRule"});
            state.currentWordRule = wordRule;
            if (wordRule == WordRule.simple) {
                for (Element word : words) {
                    if (!word.getLocalName().equals("word") || !word.getAttributeValue("type").equals(WordType.full.toString())) {
                        throw new StructureBuildingException("OPSIN bug: Unexpected contents of 'simple' wordRule");
                    }
                    StructureBuildingMethods.resolveWordOrBracket(state, word);
                }
                continue;
            }
            if (wordRule == WordRule.substituent) {
                for (Element word : words) {
                    if (!(word.getLocalName().equals("word") && word.getAttributeValue("type").equals(WordType.substituent.toString()) && state.n2sConfig.isAllowRadicals())) {
                        throw new StructureBuildingException("OPSIN bug: Unexpected contents of 'substituent' wordRule");
                    }
                    StructureBuildingMethods.resolveWordOrBracket(state, word);
                }
                continue;
            }
            if (wordRule == WordRule.ester || wordRule == WordRule.multiEster) {
                this.buildEster(state, words);
                continue;
            }
            if (wordRule == WordRule.divalentFunctionalGroup) {
                this.buildDiValentFunctionalGroup(state, words);
                continue;
            }
            if (wordRule == WordRule.monovalentFunctionalGroup) {
                this.buildMonovalentFunctionalGroup(state, words);
                continue;
            }
            if (wordRule == WordRule.functionalClassEster) {
                this.buildFunctionalClassEster(state, words);
                continue;
            }
            if (wordRule == WordRule.amide) {
                for (Element word : words) {
                    StructureBuildingMethods.resolveWordOrBracket(state, word);
                }
                continue;
            }
            if (wordRule == WordRule.oxide) {
                this.buildOxide(state, words);
                continue;
            }
            if (wordRule == WordRule.carbonylDerivative) {
                this.buildCarbonylDerivative(state, words);
                continue;
            }
            if (wordRule == WordRule.anhydride) {
                this.buildAnhydride(state, words);
                continue;
            }
            if (wordRule == WordRule.acidHalideOrPseudoHalide) {
                this.buildAcidHalideOrPseudoHalide(state, words);
                continue;
            }
            if (wordRule == WordRule.additionCompound) {
                this.buildAdditionCompound(state, words);
                continue;
            }
            if (wordRule == WordRule.glycol) {
                this.buildGlycol(state, words);
                continue;
            }
            if (wordRule == WordRule.glycolEther) {
                this.buildGlycolEther(state, words);
                continue;
            }
            if (wordRule == WordRule.acetal) {
                this.buildAcetal(state, words);
                continue;
            }
            if (wordRule == WordRule.biochemicalEster) {
                this.buildBiochemicalEster(state, words, wordRules.size());
                continue;
            }
            if (wordRule == WordRule.polymer) {
                rGroups.addAll(this.buildPolymer(state, words));
                continue;
            }
            if (wordRule == WordRule.hydrazide) {
                for (Element word : words) {
                    StructureBuildingMethods.resolveWordOrBracket(state, word);
                }
                continue;
            }
            throw new StructureBuildingException("Unknown Word Rule");
        }
        List<Element> groupElements = XOMTools.getDescendantElementsWithTagName(molecule, "group");
        this.processOxidoSpecialCase(state, groupElements);
        this.processOxidationNumbers(state, groupElements);
        state.fragManager.convertSpareValenciesToDoubleBonds();
        state.fragManager.checkValencies();
        boolean explicitStoichometryPresent = this.applyExplicitStoichometryIfProvided(state, wordRules);
        int overallCharge = state.fragManager.getOverallCharge();
        if (overallCharge != 0 && wordRules.size() > 1) {
            this.balanceChargeIfPossible(state, molecule, overallCharge, explicitStoichometryPresent);
        }
        StructureBuilder.makeHydrogensExplicit(state);
        Fragment uniFrag = state.fragManager.getUnifiedFragment();
        this.processStereochemistry(state, molecule, uniFrag);
        for (Fragment rGroup : rGroups) {
            Atom rAtom = rGroup.getFirstAtom();
            rAtom.setElement("R");
        }
        if (uniFrag.getOutAtoms().size() > 0 && !state.n2sConfig.isAllowRadicals()) {
            throw new StructureBuildingException("Radicals are currently set to not convert to structures");
        }
        return uniFrag;
    }

    private void buildEster(BuildState state, List<Element> words) throws StructureBuildingException {
        int wordIndice = 0;
        Element currentWord = words.get(wordIndice);
        BuildResults substituentsBr = new BuildResults();
        while (currentWord.getAttributeValue("type").equals(WordType.substituent.toString())) {
            StructureBuildingMethods.resolveWordOrBracket(state, currentWord);
            BuildResults substituentBr = new BuildResults(state, currentWord);
            int outAtomCount = substituentBr.getOutAtomCount();
            boolean traditionalEster = false;
            for (int i = 0; i < outAtomCount; ++i) {
                OutAtom out = substituentBr.getOutAtom(i);
                if (out.getValency() <= 1) continue;
                FragmentTools.splitOutAtomIntoValency1OutAtoms(out);
                traditionalEster = true;
            }
            if (traditionalEster) {
                substituentBr = new BuildResults(state, currentWord);
                outAtomCount = substituentBr.getOutAtomCount();
            }
            if (outAtomCount == 1) {
                String locantForSubstituent = currentWord.getAttributeValue("locant");
                if (locantForSubstituent != null) {
                    substituentBr.getFirstOutAtom().setLocant(locantForSubstituent);
                }
            } else if (outAtomCount == 0) {
                throw new StructureBuildingException("Substituent was expected to have at least one outAtom");
            }
            substituentsBr.mergeBuildResults(substituentBr);
            currentWord = words.get(++wordIndice);
        }
        if (wordIndice == words.size() || !words.get(wordIndice).getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Full word not found where full word expected: missing ate group in ester");
        }
        ArrayList<BuildResults> ateGroups = new ArrayList<BuildResults>();
        HashMap<BuildResults, String> buildResultsToLocant = new HashMap<BuildResults, String>();
        while (wordIndice < words.size()) {
            BuildResults ateBR;
            String locant;
            Element word = words.get(wordIndice);
            if (word.getAttributeValue("type").equals(WordType.full.toString())) {
                locant = word.getAttributeValue("locant");
                StructureBuildingMethods.resolveWordOrBracket(state, word);
                ateBR = new BuildResults(state, word);
                if (ateBR.getFunctionalAtomCount() < 1) {
                    throw new StructureBuildingException("bug? ate group did not have any functional atoms!");
                }
            } else {
                throw new StructureBuildingException("Non full word found where only full words were expected");
            }
            ateGroups.add(ateBR);
            buildResultsToLocant.put(ateBR, locant);
            ++wordIndice;
        }
        int outAtomCount = substituentsBr.getOutAtomCount();
        int esterIdCount = 0;
        for (BuildResults br : ateGroups) {
            esterIdCount += br.getFunctionalAtomCount();
        }
        if (outAtomCount > esterIdCount) {
            throw new StructureBuildingException("There are more radicals in the substituents(" + outAtomCount + ") than there are places to form esters(" + esterIdCount + ")");
        }
        for (int i = 0; i < outAtomCount; ++i) {
            Atom ateAtom;
            BuildResults ateBr = (BuildResults)ateGroups.get(i % ateGroups.size());
            if (substituentsBr.getFirstOutAtom().getLocant() != null) {
                ateAtom = this.determineFunctionalAtomToUse(substituentsBr.getFirstOutAtom().getLocant(), ateBr);
            } else {
                ateAtom = ateBr.getFunctionalAtom(0);
                ateBr.removeFunctionalAtom(0);
            }
            String locant = (String)buildResultsToLocant.get(ateBr);
            if (locant == null) {
                Atom atomOnSubstituentToUse = substituentsBr.getOutAtomTakingIntoAccountWhetherSetExplicitly(0);
                state.fragManager.createBond(ateAtom, atomOnSubstituentToUse, 1);
                substituentsBr.removeOutAtom(0);
            } else {
                Integer outAtomPosition = null;
                for (int j = 0; j < substituentsBr.getOutAtomCount(); ++j) {
                    if (!substituentsBr.getOutAtom(j).getAtom().hasLocant(locant)) continue;
                    outAtomPosition = j;
                    break;
                }
                if (outAtomPosition == null) {
                    throw new StructureBuildingException("Unable to find substituent with locant: " + locant + " to form ester!");
                }
                Atom atomOnSubstituentToUse = substituentsBr.getOutAtom(outAtomPosition).getAtom();
                state.fragManager.createBond(ateAtom, atomOnSubstituentToUse, 1);
                substituentsBr.removeOutAtom(outAtomPosition);
            }
            ateAtom.neutraliseCharge();
        }
    }

    private void buildDiValentFunctionalGroup(BuildState state, List<Element> words) throws StructureBuildingException {
        BuildResults substituent2;
        int wordIndice = 0;
        if (!words.get(wordIndice).getAttributeValue("type").equals(WordType.substituent.toString())) {
            throw new StructureBuildingException("word: " + wordIndice + " was expected to be a substituent");
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(wordIndice));
        BuildResults substituent1 = new BuildResults(state, words.get(wordIndice));
        if (substituent1.getOutAtom(0).getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent1.getOutAtom(0).getValency());
        }
        if (substituent1.getOutAtomCount() == 2) {
            if (substituent1.getOutAtom(1).getValency() != 1) {
                throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent1.getOutAtom(1).getValency());
            }
            substituent2 = substituent1;
        } else {
            if (substituent1.getOutAtomCount() != 1) {
                throw new StructureBuildingException("Expected one outAtom. Found " + substituent1.getOutAtomCount());
            }
            if (words.get(++wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                Element clone2 = state.fragManager.cloneElement(state, words.get(0));
                XOMTools.insertAfter(words.get(0), clone2);
                words = OpsinTools.elementsToElementArrayList(((Element)words.get(0).getParent()).getChildElements());
            } else {
                StructureBuildingMethods.resolveWordOrBracket(state, words.get(wordIndice));
            }
            substituent2 = new BuildResults(state, words.get(wordIndice));
            if (substituent2.getOutAtomCount() != 1) {
                throw new StructureBuildingException("Expected one outAtom. Found " + substituent2.getOutAtomCount());
            }
            if (substituent2.getOutAtom(0).getValency() != 1) {
                throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + substituent2.getOutAtom(0).getValency());
            }
        }
        if (words.get(++wordIndice) == null || !words.get(wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException(words.get(wordIndice).getValue() + " was expected to be a functionalTerm");
        }
        List<Element> functionalGroup = XOMTools.getDescendantElementsWithTagName(words.get(wordIndice), "functionalGroup");
        if (functionalGroup.size() != 1) {
            throw new StructureBuildingException("Unexpected number of functionalGroups found, could be a bug in OPSIN's grammar");
        }
        String smilesOfGroup = functionalGroup.get(0).getAttributeValue("value");
        Fragment diValentGroup = state.fragManager.buildSMILES(smilesOfGroup, "functionalClass", "none");
        Atom outAtom1 = substituent1.getOutAtomTakingIntoAccountWhetherSetExplicitly(0);
        substituent1.removeOutAtom(0);
        Atom outAtom2 = substituent2.getOutAtomTakingIntoAccountWhetherSetExplicitly(0);
        substituent2.removeOutAtom(0);
        if (diValentGroup.getOutAtoms().size() == 1) {
            state.fragManager.createBond(outAtom1, diValentGroup.getOutAtom(0).getAtom(), 1);
            diValentGroup.removeOutAtom(0);
            state.fragManager.createBond(outAtom2, diValentGroup.getFirstAtom(), 1);
        } else if (outAtom1 != outAtom2) {
            state.fragManager.createBond(outAtom1, diValentGroup.getFirstAtom(), 1);
            state.fragManager.createBond(outAtom2, diValentGroup.getFirstAtom(), 1);
        } else {
            state.fragManager.createBond(outAtom1, diValentGroup.getFirstAtom(), 2);
        }
        state.fragManager.incorporateFragment(diValentGroup, outAtom1.getFrag());
    }

    private void buildMonovalentFunctionalGroup(BuildState state, List<Element> words) throws StructureBuildingException {
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(words.get(0), "group");
        for (Element group : groups) {
            Fragment frag = state.xmlFragmentMap.get(group);
            for (int i = frag.getOutAtoms().size() - 1; i >= 0; --i) {
                OutAtom outAtom = frag.getOutAtom(i);
                if (outAtom.getValency() <= 1) continue;
                FragmentTools.splitOutAtomIntoValency1OutAtoms(outAtom);
            }
        }
        BuildResults substituentBR = new BuildResults(state, words.get(0));
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = XOMTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Fragment monoValentFunctionGroup = state.fragManager.buildSMILES(functionalGroups.get(0).getAttributeValue("value"), "functionalClass", "none");
            if (functionalGroups.get(0).getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                Atom ideAtom = monoValentFunctionGroup.getDefaultInAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(functionalGroups.get(0));
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier == null) continue;
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            for (int j = 1; j < multiplierValue; ++j) {
                functionalGroupFragments.add(state.fragManager.copyFragment(monoValentFunctionGroup));
            }
            possibleMultiplier.detach();
        }
        int outAtomCount = substituentBR.getOutAtomCount();
        if (outAtomCount > functionalGroupFragments.size()) {
            if (functionalGroupFragments.size() != 1) {
                throw new StructureBuildingException("Incorrect number of functional groups found to balance outAtoms");
            }
            Fragment monoValentFunctionGroup = (Fragment)functionalGroupFragments.get(0);
            for (int j = 1; j < outAtomCount; ++j) {
                functionalGroupFragments.add(state.fragManager.copyFragment(monoValentFunctionGroup));
            }
        } else if (functionalGroupFragments.size() > outAtomCount) {
            throw new StructureBuildingException("There are more function groups to attach than there are positions to attach them to!");
        }
        for (int i = 0; i < outAtomCount; ++i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            Atom ideAtom = ideFrag.getDefaultInAtom();
            Atom subAtom = substituentBR.getOutAtomTakingIntoAccountWhetherSetExplicitly(0);
            state.fragManager.createBond(ideAtom, subAtom, 1);
            substituentBR.removeOutAtom(0);
            state.fragManager.incorporateFragment(ideFrag, subAtom.getFrag());
        }
    }

    private void buildFunctionalClassEster(BuildState state, List<Element> words) throws StructureBuildingException {
        if (!words.get(0).getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        BuildResults acidBr = new BuildResults(state, words.get(0));
        if (acidBr.getFunctionalAtomCount() == 0) {
            throw new StructureBuildingException("No functionalAtoms detected!");
        }
        int i = 1;
        Element currentWord = words.get(i);
        while (currentWord.getAttributeValue("type").equals(WordType.substituent.toString())) {
            if (acidBr.getFunctionalAtomCount() == 0) {
                throw new StructureBuildingException("Insufficient functionalAtoms on acid");
            }
            StructureBuildingMethods.resolveWordOrBracket(state, currentWord);
            BuildResults substituentBr = new BuildResults(state, currentWord);
            if (substituentBr.getOutAtomCount() == 1) {
                Atom functionalAtom;
                String locantForSubstituent = currentWord.getAttributeValue("locant");
                if (locantForSubstituent != null) {
                    functionalAtom = this.determineFunctionalAtomToUse(locantForSubstituent, acidBr);
                } else {
                    functionalAtom = acidBr.getFunctionalAtom(0);
                    acidBr.removeFunctionalAtom(0);
                }
                if (substituentBr.getOutAtom(0).getValency() != 1) {
                    throw new StructureBuildingException("Substituent was expected to have only have an outgoing valency of 1");
                }
                state.fragManager.createBond(functionalAtom, substituentBr.getOutAtomTakingIntoAccountWhetherSetExplicitly(0), 1);
                if (functionalAtom.getCharge() == -1) {
                    functionalAtom.neutraliseCharge();
                }
            } else {
                throw new StructureBuildingException("Substituent was expected to have one outAtom");
            }
            substituentBr.removeOutAtom(0);
            currentWord = words.get(++i);
        }
        if (!words.get(i++).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("Number of words different to expectations; did not find ester");
        }
    }

    private void buildOxide(BuildState state, List<Element> words) throws StructureBuildingException {
        Element rightMostGroup;
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        ArrayList<Fragment> oxideFragments = new ArrayList<Fragment>();
        ArrayList<String> locantsForOxide = new ArrayList<String>();
        if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("Oxide functional term not found where expected!");
        }
        if (words.get(0).getLocalName().equals("wordRule")) {
            List<Element> fullWords = XOMTools.getDescendantElementsWithTagNameAndAttribute(words.get(0), "word", "type", WordType.full.toString());
            if (fullWords.size() == 0) {
                throw new StructureBuildingException("OPSIN is entirely unsure where the oxide goes so has decided not to guess");
            }
            rightMostGroup = StructureBuildingMethods.findRightMostGroupInBracket(fullWords.get(fullWords.size() - 1));
        } else {
            rightMostGroup = StructureBuildingMethods.findRightMostGroupInBracket(words.get(0));
        }
        int numberOfOxygenToAdd = 1;
        List<Element> multipliers = XOMTools.getDescendantElementsWithTagName(words.get(1), "multiplier");
        if (multipliers.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
        }
        if (multipliers.size() == 1) {
            numberOfOxygenToAdd = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            multipliers.get(0).detach();
        } else if ("elementaryAtom".equals(rightMostGroup.getAttributeValue("subType"))) {
            int valency;
            Atom elementaryAtom = state.xmlFragmentMap.get(rightMostGroup).getFirstAtom();
            int charge = elementaryAtom.getCharge();
            if (charge > 0 && charge % 2 == 0) {
                numberOfOxygenToAdd = charge / 2;
            } else if (elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) != null && (valency = elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) - elementaryAtom.getIncomingValency()) > 0 && valency % 2 == 0) {
                numberOfOxygenToAdd = valency / 2;
            }
        }
        List<Element> functionalGroup = XOMTools.getDescendantElementsWithTagName(words.get(1), "functionalGroup");
        if (functionalGroup.size() != 1) {
            throw new StructureBuildingException("Expected 1 group element found: " + functionalGroup.size());
        }
        String smilesReplacement = functionalGroup.get(0).getAttributeValue("value");
        String labels = functionalGroup.get(0).getAttributeValue("labels");
        for (int i = 0; i < numberOfOxygenToAdd; ++i) {
            oxideFragments.add(state.fragManager.buildSMILES(smilesReplacement, "functionalClass", labels));
        }
        List<Element> locantEls = XOMTools.getDescendantElementsWithTagName(words.get(1), "locant");
        if (locantEls.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 locant elements found: " + locantEls.size());
        }
        if (locantEls.size() == 1) {
            String[] locants = OpsinTools.MATCH_COMMA.split(StringTools.removeDashIfPresent(locantEls.get(0).getValue()));
            locantsForOxide.addAll(Arrays.asList(locants));
            locantEls.get(0).detach();
        }
        if (!locantsForOxide.isEmpty() && locantsForOxide.size() != oxideFragments.size()) {
            throw new StructureBuildingException("Mismatch between number of locants and number of oxides specified");
        }
        ArrayList<Fragment> orderedPossibleFragments = new ArrayList<Fragment>();
        Elements suffixEls = ((Element)rightMostGroup.getParent()).getChildElements("suffix");
        for (int i = suffixEls.size() - 1; i >= 0; --i) {
            Element suffixEl = suffixEls.get(i);
            Fragment suffixFrag = state.xmlFragmentMap.get(suffixEl);
            if (suffixFrag == null) continue;
            orderedPossibleFragments.add(suffixFrag);
        }
        Fragment groupToModify = state.xmlFragmentMap.get(rightMostGroup);
        orderedPossibleFragments.add(groupToModify);
        block2: for (int i = 0; i < oxideFragments.size(); ++i) {
            List<Atom> atomList;
            Atom oxideAtom = ((Fragment)oxideFragments.get(i)).getFirstAtom();
            if (!locantsForOxide.isEmpty()) {
                Atom atomToAddOxideTo = groupToModify.getAtomByLocantOrThrow((String)locantsForOxide.get(i));
                this.formAppropriateBondToOxideAndAdjustCharges(state, atomToAddOxideTo, oxideAtom);
                continue;
            }
            for (Fragment frag : orderedPossibleFragments) {
                String subTypeVal = state.xmlFragmentMap.getElement(frag).getAttributeValue("subType");
                if ("elementaryAtom".equals(subTypeVal)) {
                    Atom elementaryAtom = frag.getFirstAtom();
                    this.formAppropriateBondToOxideAndAdjustCharges(state, elementaryAtom, oxideAtom);
                    int chargeOnAtom = elementaryAtom.getCharge();
                    if (chargeOnAtom < 2) continue block2;
                    elementaryAtom.setCharge(chargeOnAtom - 2);
                    continue block2;
                }
                atomList = frag.getAtomList();
                for (Atom atom : atomList) {
                    if (atom.getElement().equals("C") || atom.getElement().equals("O")) continue;
                    this.formAppropriateBondToOxideAndAdjustCharges(state, atom, oxideAtom);
                    continue block2;
                }
            }
            Set<Bond> bondSet = groupToModify.getBondSet();
            for (Bond bond : bondSet) {
                if (bond.getOrder() != 2 || !bond.getFromAtom().getElement().equals("C") || !bond.getToAtom().getElement().equals("C")) continue;
                bond.setOrder(1);
                state.fragManager.createBond(bond.getFromAtom(), oxideAtom, 1);
                state.fragManager.createBond(bond.getToAtom(), oxideAtom, 1);
                continue block2;
            }
            for (Bond bond : bondSet) {
                Atom fromAtom = bond.getFromAtom();
                Atom toAtom = bond.getToAtom();
                if (!fromAtom.hasSpareValency() || !toAtom.hasSpareValency() || !fromAtom.getElement().equals("C") || !toAtom.getElement().equals("C")) continue;
                fromAtom.setSpareValency(false);
                toAtom.setSpareValency(false);
                state.fragManager.createBond(fromAtom, oxideAtom, 1);
                state.fragManager.createBond(toAtom, oxideAtom, 1);
                continue block2;
            }
            for (Fragment frag : orderedPossibleFragments) {
                atomList = frag.getAtomList();
                for (Atom atom : atomList) {
                    if (atom.getElement().equals("C")) continue;
                    this.formAppropriateBondToOxideAndAdjustCharges(state, atom, oxideAtom);
                    continue block2;
                }
            }
            throw new StructureBuildingException("Unable to find suitable atom or a double bond to add oxide to");
        }
        for (Fragment oxide : oxideFragments) {
            state.fragManager.incorporateFragment(oxide, groupToModify);
        }
    }

    private void formAppropriateBondToOxideAndAdjustCharges(BuildState state, Atom atomToAddOxideTo, Atom oxideAtom) throws StructureBuildingException {
        Integer maxVal = ValencyChecker.getMaximumValency(atomToAddOxideTo.getElement(), atomToAddOxideTo.getCharge());
        if (maxVal == null || atomToAddOxideTo.getIncomingValency() + atomToAddOxideTo.getOutValency() + 2 <= maxVal) {
            if (atomToAddOxideTo.getLambdaConventionValency() == null || !ValencyChecker.checkValencyAvailableForBond(atomToAddOxideTo, 2)) {
                atomToAddOxideTo.addChargeAndProtons(0, 2);
            }
            state.fragManager.createBond(atomToAddOxideTo, oxideAtom, 2);
        } else {
            if (atomToAddOxideTo.getCharge() != 0 || oxideAtom.getCharge() != 0) {
                throw new StructureBuildingException("Oxide appeared to refer to an atom that has insufficent valency to accept the addition of oxygen");
            }
            atomToAddOxideTo.addChargeAndProtons(1, 1);
            oxideAtom.addChargeAndProtons(-1, -1);
            maxVal = ValencyChecker.getMaximumValency(atomToAddOxideTo.getElement(), atomToAddOxideTo.getCharge());
            if (maxVal != null && atomToAddOxideTo.getIncomingValency() + atomToAddOxideTo.getOutValency() + 1 > maxVal) {
                throw new StructureBuildingException("Oxide appeared to refer to an atom that has insufficent valency to accept the addition of oxygen");
            }
            state.fragManager.createBond(atomToAddOxideTo, oxideAtom, 1);
        }
    }

    private void buildCarbonylDerivative(BuildState state, List<Element> words) throws StructureBuildingException {
        if (!WordType.full.toString().equals(words.get(0).getAttributeValue("type"))) {
            throw new StructureBuildingException("OPSIN bug: Wrong word type encountered when applying carbonylDerivative wordRule");
        }
        ArrayList<Fragment> replacementFragments = new ArrayList<Fragment>();
        ArrayList<String> locantForFunctionalTerm = new ArrayList<String>();
        if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            for (int i = 1; i < words.size(); ++i) {
                Fragment frag = state.xmlFragmentMap.get(this.findRightMostGroupInWordOrWordRule(words.get(i)));
                replacementFragments.add(frag);
                Elements children2 = words.get(i).getChildElements();
                if (children2.size() == 1 && children2.get(0).getLocalName().equals("bracket") && children2.get(0).getAttribute("locant") != null) {
                    locantForFunctionalTerm.add(children2.get(0).getAttributeValue("locant"));
                    continue;
                }
                if (children2.size() != 2 || children2.get(0).getAttribute("locant") == null) continue;
                String locant = children2.get(0).getAttributeValue("locant");
                if (!children2.get(1).getLocalName().equals("root") || frag.hasLocant(locant) || !OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) continue;
                locantForFunctionalTerm.add(children2.get(0).getAttributeValue("locant"));
                children2.get(0).removeAttribute(children2.get(0).getAttribute("locant"));
            }
        } else {
            List<Element> functionalGroup;
            int numberOfCarbonylReplacements = 1;
            List<Element> multipliers = XOMTools.getDescendantElementsWithTagName(words.get(1), "multiplier");
            if (multipliers.size() > 1) {
                throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
            }
            if (multipliers.size() == 1) {
                numberOfCarbonylReplacements = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
                multipliers.get(0).detach();
            }
            if ((functionalGroup = XOMTools.getDescendantElementsWithTagName(words.get(1), "functionalGroup")).size() != 1) {
                throw new StructureBuildingException("Expected 1 functionalGroup element found: " + functionalGroup.size());
            }
            String smilesReplacement = functionalGroup.get(0).getAttributeValue("value");
            String labels = functionalGroup.get(0).getAttributeValue("labels");
            for (int i = 0; i < numberOfCarbonylReplacements; ++i) {
                Fragment replacementFragment = state.fragManager.buildSMILES(smilesReplacement, "functionalClass", labels);
                if (i > 0) {
                    FragmentTools.relabelLocants(replacementFragment.getAtomList(), StringTools.multiplyString("'", i));
                }
                List<Atom> atomList = replacementFragment.getAtomList();
                for (Atom atom : atomList) {
                    atom.removeLocantsOtherThanElementSymbolLocants();
                }
                replacementFragments.add(replacementFragment);
            }
            List<Element> locantEls = XOMTools.getDescendantElementsWithTagName(words.get(1), "locant");
            if (locantEls.size() > 1) {
                throw new StructureBuildingException("Expected 0 or 1 locant elements found: " + locantEls.size());
            }
            if (locantEls.size() == 1) {
                String[] locants = OpsinTools.MATCH_COMMA.split(StringTools.removeDashIfPresent(locantEls.get(0).getValue()));
                locantForFunctionalTerm.addAll(Arrays.asList(locants));
                locantEls.get(0).detach();
            }
        }
        if (!locantForFunctionalTerm.isEmpty() && locantForFunctionalTerm.size() != replacementFragments.size()) {
            throw new StructureBuildingException("Mismatch between number of locants and number of carbonyl replacements");
        }
        Element rightMostGroup = this.findRightMostGroupInWordOrWordRule(words.get(0));
        Element parent = (Element)rightMostGroup.getParent();
        boolean multiplied = false;
        while (!parent.equals(words.get(0))) {
            if (parent.getAttribute("multiplier") != null) {
                multiplied = true;
            }
            parent = (Element)parent.getParent();
        }
        if (!multiplied) {
            List<Atom> carbonylOxygens = this.findCarbonylOxygens(state.xmlFragmentMap.get(rightMostGroup), locantForFunctionalTerm);
            int replacementsToPerform = Math.min(replacementFragments.size(), carbonylOxygens.size());
            this.replaceCarbonylOxygenWithReplacementFragments(state, words, replacementFragments, carbonylOxygens, replacementsToPerform);
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        if (replacementFragments.size() > 0) {
            BuildResults br = new BuildResults(state, words.get(0));
            ArrayList<Atom> carbonylOxygens = new ArrayList<Atom>();
            ArrayList<Fragment> fragments = new ArrayList<Fragment>(br.getFragments());
            ListIterator iterator2 = fragments.listIterator(fragments.size());
            while (iterator2.hasPrevious()) {
                carbonylOxygens.addAll(this.findCarbonylOxygens((Fragment)iterator2.previous(), locantForFunctionalTerm));
            }
            this.replaceCarbonylOxygenWithReplacementFragments(state, words, replacementFragments, carbonylOxygens, replacementFragments.size());
        }
    }

    private void replaceCarbonylOxygenWithReplacementFragments(BuildState state, List<Element> words, List<Fragment> replacementFragments, List<Atom> carbonylOxygens, int functionalReplacementsToPerform) throws StructureBuildingException {
        if (functionalReplacementsToPerform > carbonylOxygens.size()) {
            throw new StructureBuildingException("Insufficient carbonyl groups found!");
        }
        for (int i = 0; i < functionalReplacementsToPerform; ++i) {
            Atom carbonylOxygen = carbonylOxygens.remove(0);
            Fragment carbonylFrag = carbonylOxygen.getFrag();
            Fragment replacementFrag = replacementFragments.remove(0);
            List<Atom> atomList = replacementFrag.getAtomList();
            Atom atomToReplaceCarbonylOxygen = atomList.get(atomList.size() - 1);
            Atom numericLocantAtomConnectedToCarbonyl = OpsinTools.depthFirstSearchForAtomWithNumericLocant(carbonylOxygen);
            if (numericLocantAtomConnectedToCarbonyl != null) {
                atomList.get(0).addLocant(atomList.get(0).getElement() + numericLocantAtomConnectedToCarbonyl.getFirstLocant());
            }
            if (!words.get(1).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                StructureBuildingMethods.resolveWordOrBracket(state, words.get(1 + i));
            }
            for (Atom atom : atomList) {
                atom.removeLocantsOtherThanElementSymbolLocants();
                List<String> locants = atom.getLocants();
                for (int j = locants.size() - 1; j >= 0; --j) {
                    String locant = locants.get(j);
                    if (!carbonylFrag.hasLocant(locant)) continue;
                    atom.removeLocant(locant);
                }
            }
            state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(carbonylOxygen, atomToReplaceCarbonylOxygen);
            atomToReplaceCarbonylOxygen.setType(carbonylOxygen.getType());
            if (state.xmlFragmentMap.getElement(replacementFrag) != null) continue;
            state.fragManager.incorporateFragment(replacementFrag, carbonylFrag);
        }
    }

    private List<Atom> findCarbonylOxygens(Fragment fragment, List<String> locantForCarbonylAtom) throws StructureBuildingException {
        ArrayList<Atom> matches2 = new ArrayList<Atom>();
        List<Atom> rootFragAtomList = fragment.getAtomList();
        for (Atom atom : rootFragAtomList) {
            Bond b;
            List<Atom> neighbours;
            if (!atom.getElement().equals("O") || atom.getCharge() != 0 || (neighbours = atom.getAtomNeighbours()).size() != 1 || !neighbours.get(0).getElement().equals("C")) continue;
            if (!locantForCarbonylAtom.isEmpty()) {
                Atom numericLocantAtomConnectedToCarbonyl = OpsinTools.depthFirstSearchForAtomWithNumericLocant(atom);
                if (numericLocantAtomConnectedToCarbonyl == null) continue;
                boolean matchesLocant = false;
                for (String locant : locantForCarbonylAtom) {
                    if (!numericLocantAtomConnectedToCarbonyl.hasLocant(locant)) continue;
                    matchesLocant = true;
                }
                if (!matchesLocant) continue;
            }
            if ((b = atom.getBondToAtomOrThrow(neighbours.get(0))).getOrder() != 2) continue;
            matches2.add(atom);
        }
        return matches2;
    }

    private void buildAnhydride(BuildState state, List<Element> words) throws StructureBuildingException {
        if (words.size() != 2 && words.size() != 3) {
            throw new StructureBuildingException("Unexpected number of words in anhydride. Check wordRules.xml, this is probably a bug");
        }
        Element anhydrideWord = words.get(words.size() - 1);
        List<Element> functionalClass = XOMTools.getDescendantElementsWithTagName(anhydrideWord, "functionalGroup");
        if (functionalClass.size() != 1) {
            throw new StructureBuildingException("Expected 1 group element found: " + functionalClass.size());
        }
        String anhydrideSmiles = functionalClass.get(0).getAttributeValue("value");
        int numberOfAnhydrideLinkages = 1;
        List<Element> multipliers = XOMTools.getDescendantElementsWithTagName(anhydrideWord, "multiplier");
        if (multipliers.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 multiplier found: " + multipliers.size());
        }
        if (multipliers.size() == 1) {
            numberOfAnhydrideLinkages = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            multipliers.get(0).detach();
        }
        String anhydrideLocant = null;
        List<Element> anhydrideLocants = XOMTools.getDescendantElementsWithTagNames(anhydrideWord, new String[]{"locant", "colonSeperatedLocant"});
        if (anhydrideLocants.size() > 1) {
            throw new StructureBuildingException("Expected 0 or 1 anhydrideLocants found: " + anhydrideLocants.size());
        }
        if (anhydrideLocants.size() == 1) {
            anhydrideLocant = anhydrideLocants.get(0).getValue();
            anhydrideLocants.get(0).detach();
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        BuildResults br1 = new BuildResults(state, words.get(0));
        if (br1.getFunctionalAtomCount() == 0) {
            throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
        }
        if (words.size() == 3) {
            if (anhydrideLocant != null) {
                throw new StructureBuildingException("Unsupported or invalid anhydride");
            }
            StructureBuildingMethods.resolveWordOrBracket(state, words.get(1));
            BuildResults br2 = new BuildResults(state, words.get(1));
            if (br2.getFunctionalAtomCount() == 0) {
                throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
            }
            if (numberOfAnhydrideLinkages > 1) {
                for (int i = numberOfAnhydrideLinkages - 1; i >= 0; --i) {
                    BuildResults newAcidBr;
                    if (br2.getFunctionalAtomCount() == 0) {
                        throw new StructureBuildingException("Cannot find functionalAtom to form anhydride");
                    }
                    if (i != 0) {
                        Element newAcid = state.fragManager.cloneElement(state, words.get(0));
                        XOMTools.insertAfter(words.get(0), newAcid);
                        newAcidBr = new BuildResults(state, newAcid);
                    } else {
                        newAcidBr = br1;
                    }
                    this.formAnhydrideLink(state, anhydrideSmiles, newAcidBr, br2);
                }
            } else {
                if (br1.getFunctionalAtomCount() != 1 && br2.getFunctionalAtomCount() != 1) {
                    throw new StructureBuildingException("Invalid anhydride description");
                }
                this.formAnhydrideLink(state, anhydrideSmiles, br1, br2);
            }
        } else if (br1.getFunctionalAtomCount() > 1) {
            if (br1.getFunctionalAtomCount() == 2) {
                if (numberOfAnhydrideLinkages != 1 || anhydrideLocant != null) {
                    throw new StructureBuildingException("Unsupported or invalid anhydride");
                }
                this.formAnhydrideLink(state, anhydrideSmiles, br1, br1);
            } else {
                int i;
                if (anhydrideLocant == null) {
                    throw new StructureBuildingException("Anhydride formation appears to be ambiguous; More than 2 acids, no locants");
                }
                String[] acidLocants = OpsinTools.MATCH_COLON.split(StringTools.removeDashIfPresent(anhydrideLocant));
                if (acidLocants.length != numberOfAnhydrideLinkages) {
                    throw new StructureBuildingException("Mismatch between number of locants and number of anhydride linkages to form");
                }
                if (br1.getFunctionalAtomCount() < numberOfAnhydrideLinkages * 2) {
                    throw new StructureBuildingException("Mismatch between number of acid atoms and number of anhydride linkages to form");
                }
                ArrayList<Atom> functionalAtoms = new ArrayList<Atom>();
                for (i = 0; i < br1.getFunctionalAtomCount(); ++i) {
                    functionalAtoms.add(br1.getFunctionalAtom(i));
                }
                for (i = 0; i < numberOfAnhydrideLinkages; ++i) {
                    String[] locants = OpsinTools.MATCH_COMMA.split(acidLocants[i]);
                    Atom oxygen1 = null;
                    for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
                        Atom functionalAtom = (Atom)functionalAtoms.get(j);
                        Atom numericLocantAtomConnectedToFunctionalAtom = OpsinTools.depthFirstSearchForAtomWithNumericLocant(functionalAtom);
                        if (!numericLocantAtomConnectedToFunctionalAtom.hasLocant(locants[0])) continue;
                        oxygen1 = functionalAtom;
                        functionalAtoms.remove(j);
                        break;
                    }
                    Atom oxygen2 = null;
                    for (int j = functionalAtoms.size() - 1; j >= 0; --j) {
                        Atom functionalAtom = (Atom)functionalAtoms.get(j);
                        Atom numericLocantAtomConnectedToFunctionalAtom = OpsinTools.depthFirstSearchForAtomWithNumericLocant(functionalAtom);
                        if (!numericLocantAtomConnectedToFunctionalAtom.hasLocant(locants[1])) continue;
                        oxygen2 = functionalAtom;
                        functionalAtoms.remove(j);
                        break;
                    }
                    if (oxygen1 == null || oxygen2 == null) {
                        throw new StructureBuildingException("Unable to find locanted atom for anhydride formation");
                    }
                    this.formAnhydrideLink(state, anhydrideSmiles, oxygen1, oxygen2);
                }
            }
        } else {
            if (numberOfAnhydrideLinkages != 1 || anhydrideLocant != null) {
                throw new StructureBuildingException("Unsupported or invalid anhydride");
            }
            Element newAcid = state.fragManager.cloneElement(state, words.get(0));
            XOMTools.insertAfter(words.get(0), newAcid);
            BuildResults br2 = new BuildResults(state, newAcid);
            this.formAnhydrideLink(state, anhydrideSmiles, br1, br2);
        }
    }

    private void formAnhydrideLink(BuildState state, String anhydrideSmiles, BuildResults acidBr1, BuildResults acidBr2) throws StructureBuildingException {
        Atom oxygen1 = acidBr1.getFunctionalAtom(0);
        acidBr1.removeFunctionalAtom(0);
        Atom oxygen2 = acidBr2.getFunctionalAtom(0);
        acidBr2.removeFunctionalAtom(0);
        this.formAnhydrideLink(state, anhydrideSmiles, oxygen1, oxygen2);
    }

    private void formAnhydrideLink(BuildState state, String anhydrideSmiles, Atom oxygen1, Atom oxygen2) throws StructureBuildingException {
        if (!oxygen1.getElement().equals("O") || !oxygen2.getElement().equals("O") || oxygen1.getBonds().size() != 1 || oxygen2.getBonds().size() != 1) {
            throw new StructureBuildingException("Problem building anhydride");
        }
        Atom atomOnSecondAcidToConnectTo = oxygen2.getAtomNeighbours().get(0);
        state.fragManager.removeAtomAndAssociatedBonds(oxygen2);
        Fragment anhydride = state.fragManager.buildSMILES(anhydrideSmiles, "functionalClass", "none");
        Fragment acidFragment1 = oxygen1.getFrag();
        state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygen1, anhydride.getFirstAtom());
        List<Atom> atomsInAnhydrideLinkage = anhydride.getAtomList();
        state.fragManager.createBond(atomsInAnhydrideLinkage.get(atomsInAnhydrideLinkage.size() - 1), atomOnSecondAcidToConnectTo, 1);
        state.fragManager.incorporateFragment(anhydride, acidFragment1);
    }

    private void buildAcidHalideOrPseudoHalide(BuildState state, List<Element> words) throws StructureBuildingException {
        if (!words.get(0).getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        BuildResults acidBr = new BuildResults(state, words.get(0));
        int functionalAtomCount = acidBr.getFunctionalAtomCount();
        if (functionalAtomCount == 0) {
            throw new StructureBuildingException("No functionalAtoms detected!");
        }
        boolean monoMultiplierDetected = false;
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = XOMTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Fragment monoValentFunctionGroup = state.fragManager.buildSMILES(functionalGroups.get(0).getAttributeValue("value"), "functionalClass", "none");
            if (functionalGroups.get(0).getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                Atom ideAtom = monoValentFunctionGroup.getDefaultInAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(functionalGroups.get(0));
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier == null) continue;
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            if (multiplierValue == 1) {
                monoMultiplierDetected = true;
            }
            for (int j = 1; j < multiplierValue; ++j) {
                functionalGroupFragments.add(state.fragManager.copyFragment(monoValentFunctionGroup));
            }
            possibleMultiplier.detach();
        }
        int halideCount = functionalGroupFragments.size();
        if (halideCount > functionalAtomCount || !monoMultiplierDetected && halideCount < functionalAtomCount) {
            throw new StructureBuildingException("Mismatch between number of halide/pseudo halide fragments and acidic oxygens");
        }
        for (int i = halideCount - 1; i >= 0; --i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            Atom ideAtom = ideFrag.getDefaultInAtom();
            Atom acidAtom = acidBr.getFunctionalAtom(i);
            if (!acidAtom.getElement().equals("O")) {
                throw new StructureBuildingException("Atom type expected to be oxygen but was: " + acidAtom.getElement());
            }
            acidBr.removeFunctionalAtom(i);
            Fragment acidFragment = acidAtom.getFrag();
            state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(acidAtom, ideAtom);
            state.fragManager.incorporateFragment(ideFrag, acidFragment);
        }
    }

    private void buildAdditionCompound(BuildState state, List<Element> words) throws StructureBuildingException {
        Integer maximumVal;
        Atom ideAtom;
        if (!words.get(0).getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("Don't alter wordRules.xml without checking the consequences!");
        }
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(0));
        Element elementaryAtomEl = StructureBuildingMethods.findRightMostGroupInBracket(words.get(0));
        Fragment elementaryAtomFrag = state.xmlFragmentMap.get(elementaryAtomEl);
        Atom elementaryAtom = elementaryAtomFrag.getFirstAtom();
        int charge = elementaryAtom.getCharge();
        ArrayList<Fragment> functionalGroupFragments = new ArrayList<Fragment>();
        for (int i = 1; i < words.size(); ++i) {
            int expectedValency;
            Element functionalGroupWord = words.get(i);
            List<Element> functionalGroups = XOMTools.getDescendantElementsWithTagName(functionalGroupWord, "functionalGroup");
            if (functionalGroups.size() != 1) {
                throw new StructureBuildingException("Expected exactly 1 functionalGroup. Found " + functionalGroups.size());
            }
            Fragment monoValentFunctionGroup = state.fragManager.buildSMILES(functionalGroups.get(0).getAttributeValue("value"), "functionalClass", "none");
            if (functionalGroups.get(0).getAttributeValue("type").equals("monoValentStandaloneGroup")) {
                ideAtom = monoValentFunctionGroup.getDefaultInAtom();
                ideAtom.addChargeAndProtons(1, 1);
            }
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(functionalGroups.get(0));
            functionalGroupFragments.add(monoValentFunctionGroup);
            if (possibleMultiplier != null) {
                int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int j = 1; j < multiplierValue; ++j) {
                    functionalGroupFragments.add(state.fragManager.copyFragment(monoValentFunctionGroup));
                }
                possibleMultiplier.detach();
                continue;
            }
            if (words.size() != 2) continue;
            int incomingBondOrder = elementaryAtom.getIncomingValency();
            if (charge > 0) {
                expectedValency = incomingBondOrder + charge;
            } else if (elementaryAtom.getProperty(Atom.OXIDATION_NUMBER) != null) {
                expectedValency = elementaryAtom.getProperty(Atom.OXIDATION_NUMBER);
            } else if (elementaryAtomEl.getAttribute("commonOxidationStatesAndMax") != null) {
                String[] typicalOxidationStates = OpsinTools.MATCH_COMMA.split(OpsinTools.MATCH_COLON.split(elementaryAtomEl.getAttributeValue("commonOxidationStatesAndMax"))[0]);
                expectedValency = Integer.parseInt(typicalOxidationStates[0]);
            } else {
                expectedValency = ValencyChecker.getPossibleValencies(elementaryAtom.getElement(), charge)[0];
            }
            int implicitMultiplier = expectedValency - incomingBondOrder > 1 ? expectedValency - incomingBondOrder : 1;
            for (int j = 1; j < implicitMultiplier; ++j) {
                functionalGroupFragments.add(state.fragManager.copyFragment(monoValentFunctionGroup));
            }
        }
        int halideCount = functionalGroupFragments.size();
        if (charge > 0) {
            elementaryAtom.setCharge(charge - halideCount);
        }
        if ((maximumVal = ValencyChecker.getMaximumValency(elementaryAtom.getElement(), elementaryAtom.getCharge())) != null && halideCount > maximumVal) {
            throw new StructureBuildingException("Too many halides/psuedo halides addded to " + elementaryAtom.getElement());
        }
        for (int i = halideCount - 1; i >= 0; --i) {
            Fragment ideFrag = (Fragment)functionalGroupFragments.get(i);
            ideAtom = ideFrag.getDefaultInAtom();
            state.fragManager.incorporateFragment(ideFrag, ideAtom, elementaryAtomFrag, elementaryAtom, 1);
        }
    }

    private void buildGlycol(BuildState state, List<Element> words) throws StructureBuildingException {
        int wordIndice = 0;
        StructureBuildingMethods.resolveWordOrBracket(state, words.get(wordIndice));
        Element finalGroup = this.findRightMostGroupInWordOrWordRule(words.get(wordIndice));
        Fragment theDiRadical = state.xmlFragmentMap.get(finalGroup);
        if (theDiRadical.getOutAtoms().size() != 2) {
            throw new StructureBuildingException("Glycol class names (e.g. ethylene glycol) expect two outAtoms. Found: " + theDiRadical.getOutAtoms());
        }
        if (++wordIndice >= words.size() || !words.get(wordIndice).getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            throw new StructureBuildingException("Glycol functionalTerm word expected");
        }
        List<Element> functionalClassEls = XOMTools.getDescendantElementsWithTagName(words.get(wordIndice), "functionalClass");
        if (functionalClassEls.size() != 1) {
            throw new StructureBuildingException("Glycol functional class not found where expected");
        }
        Atom outAtom1 = theDiRadical.getAtomOrNextSuitableAtomOrThrow(theDiRadical.getOutAtom(0).getAtom(), theDiRadical.getOutAtom(0).getValency(), false);
        Fragment functionalFrag = state.fragManager.buildSMILES(functionalClassEls.get(0).getAttributeValue("value"), "functionalClass", "none");
        if (theDiRadical.getOutAtom(0).getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + theDiRadical.getOutAtom(0).getValency());
        }
        state.fragManager.createBond(outAtom1, functionalFrag.getFirstAtom(), 1);
        state.fragManager.incorporateFragment(functionalFrag, theDiRadical);
        Atom outAtom2 = theDiRadical.getAtomOrNextSuitableAtomOrThrow(theDiRadical.getOutAtom(1).getAtom(), theDiRadical.getOutAtom(1).getValency(), false);
        Fragment hydroxy = state.fragManager.buildSMILES("O", "functionalClass", "none");
        if (theDiRadical.getOutAtom(1).getValency() != 1) {
            throw new StructureBuildingException("OutAtom has unexpected valency. Expected 1. Actual: " + theDiRadical.getOutAtom(1).getValency());
        }
        state.fragManager.createBond(outAtom2, hydroxy.getFirstAtom(), 1);
        state.fragManager.incorporateFragment(hydroxy, theDiRadical);
        theDiRadical.removeOutAtom(1);
        theDiRadical.removeOutAtom(0);
    }

    private void buildGlycolEther(BuildState state, List<Element> words) throws StructureBuildingException {
        ArrayList<Element> wordsToAttachToGlcyol = new ArrayList<Element>();
        Element glycol = words.get(0);
        if (!glycol.getAttributeValue("type").equals(WordType.full.toString())) {
            throw new StructureBuildingException("OPSIN Bug: Cannot find glycol word!");
        }
        for (int i = 1; i < words.size(); ++i) {
            Element wordOrWordRule = words.get(i);
            if (!wordOrWordRule.getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
                wordsToAttachToGlcyol.add(wordOrWordRule);
                continue;
            }
            if (wordOrWordRule.getAttributeValue("value").equalsIgnoreCase("ether")) continue;
            throw new StructureBuildingException("Unexpected word encountered when applying glycol ether word rule " + wordOrWordRule.getAttributeValue("value"));
        }
        if (wordsToAttachToGlcyol.size() != 1 && wordsToAttachToGlcyol.size() != 2) {
            throw new StructureBuildingException("Unexpected number of substituents for glycol ether. Expected 1 or 2 found: " + wordsToAttachToGlcyol.size());
        }
        Element finalGroup = this.findRightMostGroupInWordOrWordRule(glycol);
        Fragment theDiRadical = state.xmlFragmentMap.get(finalGroup);
        List<Atom> atomList = theDiRadical.getAtomList();
        ArrayList<Atom> glycolAtoms = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (!atom.getElement().equals("O") || !atom.getType().equals("functionalClass")) continue;
            glycolAtoms.add(atom);
        }
        if (glycolAtoms.size() != 2) {
            throw new StructureBuildingException("OPSIN bug: unable to find the two glycol oxygens");
        }
        BuildResults br1 = new BuildResults(state, (Element)wordsToAttachToGlcyol.get(0));
        if (br1.getOutAtomCount() == 0) {
            throw new StructureBuildingException("Substituent had no outAtom to form glycol ether");
        }
        state.fragManager.createBond((Atom)glycolAtoms.get(0), br1.getOutAtom(0).getAtom(), 1);
        br1.removeOutAtom(0);
        if (wordsToAttachToGlcyol.size() == 2) {
            BuildResults br2 = new BuildResults(state, (Element)wordsToAttachToGlcyol.get(1));
            if (br2.getOutAtomCount() > 0) {
                state.fragManager.createBond((Atom)glycolAtoms.get(1), br2.getOutAtom(0).getAtom(), 1);
                br2.removeOutAtom(0);
            } else if (br2.getFunctionalAtomCount() > 0) {
                Atom ateAtom = br2.getFunctionalAtom(0);
                ateAtom.neutraliseCharge();
                state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity((Atom)glycolAtoms.get(1), br2.getFunctionalAtom(0));
                br2.removeFunctionalAtom(0);
            } else {
                throw new StructureBuildingException("Word had neither an outAtom or a functionalAtom! hence neither and ether or ester could be formed : " + ((Element)wordsToAttachToGlcyol.get(1)).getAttributeValue("value"));
            }
        }
    }

    private void buildAcetal(BuildState state, List<Element> words) throws StructureBuildingException {
        int bondsToForm;
        for (int i = 0; i < words.size() - 1; ++i) {
            StructureBuildingMethods.resolveWordOrBracket(state, words.get(i));
        }
        BuildResults substituentsBr = new BuildResults();
        for (int i = 1; i < words.size() - 1; ++i) {
            Element currentWord = words.get(i);
            BuildResults substituentBr = new BuildResults(state, currentWord);
            int outAtomCount = substituentBr.getOutAtomCount();
            if (outAtomCount == 1) {
                String locantForSubstituent = currentWord.getAttributeValue("locant");
                if (locantForSubstituent != null) {
                    substituentBr.getFirstOutAtom().setLocant(locantForSubstituent);
                }
            } else if (outAtomCount == 0) {
                throw new StructureBuildingException("Substituent was expected to have at least one outAtom");
            }
            substituentsBr.mergeBuildResults(substituentBr);
        }
        Element rightMostGroup = this.findRightMostGroupInWordOrWordRule(words.get(0));
        Fragment rootFragment = state.xmlFragmentMap.get(rightMostGroup);
        List<Atom> carbonylOxygen = this.findCarbonylOxygens(rootFragment, new ArrayList<String>());
        Element functionalWord = words.get(words.size() - 1);
        List<Element> functionalClasses = XOMTools.getDescendantElementsWithTagName(functionalWord, "functionalClass");
        if (functionalClasses.size() != 1) {
            throw new StructureBuildingException("OPSIN bug: unable to find acetal functionalClass");
        }
        Element functionalClassEl = functionalClasses.get(0);
        String functionalClass = functionalClassEl.getValue();
        Element beforeAcetal = (Element)XOMTools.getPreviousSibling(functionalClassEl);
        int numberOfAcetals = 1;
        List<Object> elements = null;
        if (beforeAcetal != null) {
            if (beforeAcetal.getLocalName().equals("multiplier")) {
                numberOfAcetals = Integer.parseInt(beforeAcetal.getAttributeValue("value"));
            } else {
                elements = this.determineChalcogenReplacementOfAcetal(functionalClassEl);
                if (elements.size() > 2) {
                    throw new StructureBuildingException(functionalClass + " only has two oxygen");
                }
                if (elements.size() == 1) {
                    elements.add("O");
                }
            }
        }
        if (elements == null) {
            elements = new ArrayList<String>();
            elements.add("O");
            elements.add("O");
        }
        if (carbonylOxygen.size() < numberOfAcetals) {
            throw new StructureBuildingException("Insufficient carbonyls to form " + numberOfAcetals + " " + functionalClass);
        }
        boolean hemiacetal = functionalClass.contains("hemi");
        ArrayList<Fragment> acetalFrags = new ArrayList<Fragment>();
        for (int i = 0; i < numberOfAcetals; ++i) {
            acetalFrags.add(this.formAcetal(state, carbonylOxygen, elements));
        }
        int n = bondsToForm = hemiacetal ? numberOfAcetals : 2 * numberOfAcetals;
        if (substituentsBr.getOutAtomCount() != bondsToForm) {
            throw new StructureBuildingException("incorrect number of susbtituents when forming " + functionalClass);
        }
        this.connectSubstituentsToAcetal(state, acetalFrags, substituentsBr, hemiacetal);
    }

    private List<String> determineChalcogenReplacementOfAcetal(Element functionalClassEl) throws StructureBuildingException {
        Element currentEl = (Element)functionalClassEl.getParent().getChild(0);
        int multiplier = 1;
        ArrayList<String> elements = new ArrayList<String>();
        while (currentEl != functionalClassEl) {
            if (currentEl.getLocalName().equals("multiplier")) {
                multiplier = Integer.parseInt(currentEl.getAttributeValue("value"));
            } else if (currentEl.getLocalName().equals("group")) {
                for (int i = 0; i < multiplier; ++i) {
                    elements.add(currentEl.getAttributeValue("value"));
                }
            } else {
                throw new StructureBuildingException("Unexpected element before acetal");
            }
            currentEl = (Element)XOMTools.getNextSibling(currentEl);
        }
        return elements;
    }

    private Fragment formAcetal(BuildState state, List<Atom> carbonylOxygen, List<String> elements) throws StructureBuildingException {
        Atom neighbouringCarbon = carbonylOxygen.get(0).getAtomNeighbours().get(0);
        state.fragManager.removeAtomAndAssociatedBonds(carbonylOxygen.get(0));
        carbonylOxygen.remove(0);
        Fragment acetalFrag = state.fragManager.buildSMILES(StringTools.stringListToString(elements, "."));
        FragmentTools.assignElementLocants(acetalFrag, new ArrayList<Fragment>());
        List<Atom> acetalAtomList = acetalFrag.getAtomList();
        Atom atom1 = acetalAtomList.get(0);
        state.fragManager.createBond(neighbouringCarbon, atom1, 1);
        Atom atom2 = acetalAtomList.get(1);
        state.fragManager.createBond(neighbouringCarbon, atom2, 1);
        state.fragManager.incorporateFragment(acetalFrag, neighbouringCarbon.getFrag());
        return acetalFrag;
    }

    private void buildBiochemicalEster(BuildState state, List<Element> words, int numberOfWordRules) throws StructureBuildingException {
        for (Element word : words) {
            if (!WordType.full.toString().equals(word.getAttributeValue("type"))) {
                throw new StructureBuildingException("Bug in word rule for biochemicalEster");
            }
            StructureBuildingMethods.resolveWordOrBracket(state, word);
        }
        for (int i = 1; i < words.size(); ++i) {
            String element;
            Atom atomOnBiochemicalFragment;
            Element ateWord = words.get(i);
            BuildResults br = new BuildResults(state, ateWord);
            String locant = ateWord.getAttributeValue("locant");
            if (br.getFunctionalAtomCount() == 0) {
                throw new StructureBuildingException("Unable to find functional atom to form biochemical ester");
            }
            Atom functionalAtom = br.getFunctionalAtom(0);
            br.removeFunctionalAtom(0);
            functionalAtom.neutraliseCharge();
            Fragment biochemicalFragment = state.xmlFragmentMap.get(this.findRightMostGroupInWordOrWordRule(words.get(0)));
            if (locant != null) {
                atomOnBiochemicalFragment = biochemicalFragment.getAtomByLocantOrThrow(locant);
                if (atomOnBiochemicalFragment.getBonds().size() != 1) {
                    atomOnBiochemicalFragment = biochemicalFragment.getAtomByLocantOrThrow("O" + locant);
                }
            } else {
                atomOnBiochemicalFragment = biochemicalFragment.getAtomByLocant("O5'");
                if (atomOnBiochemicalFragment == null) {
                    List<Atom> atoms = biochemicalFragment.getAtomList();
                    for (Atom atom : atoms) {
                        if (!atom.getElement().equals("O") || atom.getBonds().size() != 1 || atom.getFirstBond().getOrder() != 1) continue;
                        Atom adjacentAtom = atom.getAtomNeighbours().get(0);
                        List<Atom> neighbours = adjacentAtom.getAtomNeighbours();
                        if (adjacentAtom.getElement().equals("C") && neighbours.size() == 3) {
                            neighbours.remove(atom);
                            if (neighbours.get(0).getElement().equals("O") && adjacentAtom.getBondToAtomOrThrow(neighbours.get(0)).getOrder() == 2 || neighbours.get(1).getElement().equals("O") && adjacentAtom.getBondToAtomOrThrow(neighbours.get(1)).getOrder() == 2) continue;
                        }
                        atomOnBiochemicalFragment = atom;
                    }
                }
            }
            String string2 = element = atomOnBiochemicalFragment != null ? atomOnBiochemicalFragment.getElement() : null;
            if (atomOnBiochemicalFragment == null || atomOnBiochemicalFragment.getBonds().size() != 1 && !element.equals("O") && !element.equals("S") && !element.equals("Se") && !element.equals("Te")) {
                throw new StructureBuildingException("Failed to find hydroxy group on biochemical fragment");
            }
            state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(functionalAtom, atomOnBiochemicalFragment);
            Element ateGroup = this.findRightMostGroupInWordOrWordRule(ateWord);
            if (ateGroup.getAttribute("numberOfFunctionalAtomsToRemove") != null || numberOfWordRules != 1) continue;
            for (int j = br.getFunctionalAtomCount() - 1; j >= 0; --j) {
                Atom atomToDefunctionalise = br.getFunctionalAtom(j);
                br.removeFunctionalAtom(j);
                atomToDefunctionalise.neutraliseCharge();
            }
        }
    }

    private void connectSubstituentsToAcetal(BuildState state, List<Fragment> acetalFrags, BuildResults subBr, boolean hemiacetal) throws StructureBuildingException {
        HashMap<Fragment, Integer> usageMap = new HashMap<Fragment, Integer>();
        for (int i = subBr.getOutAtomCount() - 1; i >= 0; --i) {
            OutAtom out = subBr.getOutAtom(i);
            subBr.removeOutAtom(i);
            Atom atomToUse = null;
            if (out.getLocant() != null) {
                boolean numericLocant = OpsinTools.MATCH_NUMERIC_LOCANT.matcher(out.getLocant()).matches();
                for (Fragment possibleAcetalFrag : acetalFrags) {
                    if (numericLocant) {
                        Atom a = OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(possibleAcetalFrag.getFirstAtom(), out.getLocant());
                        if (a == null) continue;
                        List<Atom> atomList = possibleAcetalFrag.getAtomList();
                        if (atomList.get(0).getBonds().size() == 1) {
                            atomToUse = atomList.get(0);
                            break;
                        }
                        if (atomList.get(1).getBonds().size() != 1) continue;
                        atomToUse = atomList.get(1);
                        break;
                    }
                    if (!possibleAcetalFrag.hasLocant(out.getLocant())) continue;
                    atomToUse = possibleAcetalFrag.getAtomByLocantOrThrow(out.getLocant());
                    break;
                }
                if (atomToUse == null) {
                    throw new StructureBuildingException("Unable to find suitable acetalFrag");
                }
            } else {
                List<Atom> atomList = acetalFrags.get(0).getAtomList();
                if (atomList.get(0).getBonds().size() == 1) {
                    atomToUse = atomList.get(0);
                } else if (atomList.get(1).getBonds().size() == 1) {
                    atomToUse = atomList.get(1);
                } else {
                    throw new StructureBuildingException("OPSIN bug: unable to find acetal atom");
                }
            }
            Fragment acetalFrag = atomToUse.getFrag();
            int usage = usageMap.get(acetalFrag) != null ? (Integer)usageMap.get(acetalFrag) : 0;
            state.fragManager.createBond(out.getAtom(), atomToUse, out.getValency());
            if (++usage >= 2 || hemiacetal) {
                acetalFrags.remove(acetalFrag);
            }
            usageMap.put(acetalFrag, usage);
        }
    }

    private List<Fragment> buildPolymer(BuildState state, List<Element> words) throws StructureBuildingException {
        if (words.size() != 2) {
            throw new StructureBuildingException("Currently unsupported polymer name type");
        }
        Element polymer = words.get(1);
        StructureBuildingMethods.resolveWordOrBracket(state, polymer);
        BuildResults polymerBr = new BuildResults(state, polymer);
        ArrayList<Fragment> rGroups = new ArrayList<Fragment>();
        if (polymerBr.getOutAtomCount() != 2) {
            throw new StructureBuildingException("Polymer building failed: Two termini were not found; Expected 2 outAtoms, found: " + polymerBr.getOutAtomCount());
        }
        Atom inAtom = polymerBr.getOutAtomTakingIntoAccountWhetherSetExplicitly(0);
        Atom outAtom = polymerBr.getOutAtomTakingIntoAccountWhetherSetExplicitly(1);
        Fragment rGroup1 = state.fragManager.buildSMILES("[" + outAtom.getElement() + "|" + polymerBr.getOutAtom(0).getValency() + "]");
        state.fragManager.createBond(inAtom, rGroup1.getFirstAtom(), polymerBr.getOutAtom(0).getValency());
        Fragment rGroup2 = state.fragManager.buildSMILES("[" + inAtom.getElement() + "|" + polymerBr.getOutAtom(1).getValency() + "]");
        state.fragManager.createBond(outAtom, rGroup2.getFirstAtom(), polymerBr.getOutAtom(1).getValency());
        rGroups.add(rGroup1);
        rGroups.add(rGroup2);
        polymerBr.removeAllOutAtoms();
        return rGroups;
    }

    private Atom determineFunctionalAtomToUse(String locant, BuildResults mainGroupBR) throws StructureBuildingException {
        block11: {
            block10: {
                Atom possibleAtom;
                int i;
                for (i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                    possibleAtom = mainGroupBR.getFunctionalAtom(i);
                    if (!possibleAtom.hasLocant(locant)) continue;
                    mainGroupBR.removeFunctionalAtom(i);
                    if (possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                        possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT).remove(possibleAtom);
                    }
                    return possibleAtom;
                }
                if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant).matches()) break block10;
                for (i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                    possibleAtom = mainGroupBR.getFunctionalAtom(i);
                    if (OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(possibleAtom, locant) == null) continue;
                    mainGroupBR.removeFunctionalAtom(i);
                    if (possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                        possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT).remove(possibleAtom);
                    }
                    return possibleAtom;
                }
                break block11;
            }
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(locant).matches()) break block11;
            boolean isElementSymbol = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(locant).matches();
            for (int i = 0; i < mainGroupBR.getFunctionalAtomCount(); ++i) {
                Atom possibleAtom = mainGroupBR.getFunctionalAtom(i);
                if (possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                    Set<Atom> atoms = possibleAtom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
                    boolean foundAtom = false;
                    for (Atom a : atoms) {
                        if (!a.hasLocant(locant) && (!isElementSymbol || !a.getElement().equals(locant))) continue;
                        ArrayList<String> tempLocants = new ArrayList<String>(a.getLocants());
                        ArrayList<String> tempLocants2 = new ArrayList<String>(possibleAtom.getLocants());
                        a.clearLocants();
                        possibleAtom.clearLocants();
                        for (String l : tempLocants) {
                            possibleAtom.addLocant(l);
                        }
                        for (String l : tempLocants2) {
                            a.addLocant(l);
                        }
                        String originalElement = possibleAtom.getElement();
                        possibleAtom.setElement(a.getElement());
                        a.setElement(originalElement);
                        mainGroupBR.removeFunctionalAtom(i);
                        foundAtom = true;
                        break;
                    }
                    if (foundAtom) {
                        atoms.remove(possibleAtom);
                        return possibleAtom;
                    }
                }
                if (!isElementSymbol || !possibleAtom.getElement().equals(locant)) continue;
                return possibleAtom;
            }
        }
        throw new StructureBuildingException("Cannot find functional atom with locant: " + locant + " to form an ester with");
    }

    static void makeHydrogensExplicit(BuildState state) throws StructureBuildingException {
        Set<Fragment> fragments = state.fragManager.getFragPile();
        for (Fragment fragment : fragments) {
            if (fragment.getSubType().equals("elementaryAtom")) continue;
            List<Atom> atomList = fragment.getAtomList();
            for (Atom parentAtom : atomList) {
                int explicitHydrogensToAdd = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(parentAtom);
                for (int i = 0; i < explicitHydrogensToAdd; ++i) {
                    Atom hydrogen = state.fragManager.createAtom("H", fragment);
                    state.fragManager.createBond(parentAtom, hydrogen, 1);
                }
                if (parentAtom.getAtomParity() == null) continue;
                if (explicitHydrogensToAdd > 1) {
                    parentAtom.setAtomParity(null);
                    continue;
                }
                StructureBuilder.modifyAtomParityToTakeIntoAccountExplicitHydrogen(parentAtom);
            }
        }
    }

    private static void modifyAtomParityToTakeIntoAccountExplicitHydrogen(Atom atom) throws StructureBuildingException {
        AtomParity atomParity = atom.getAtomParity();
        if (!StereoAnalyser.isPossiblyStereogenic(atom)) {
            atom.setAtomParity(null);
        } else {
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            Integer positionOfImplicitHydrogen = null;
            Integer positionOfDeoxyHydrogen = null;
            for (int i = 0; i < atomRefs4.length; ++i) {
                if (atomRefs4[i].equals(AtomParity.hydrogen)) {
                    positionOfImplicitHydrogen = i;
                    continue;
                }
                if (!atomRefs4[i].equals(AtomParity.deoxyHydrogen)) continue;
                positionOfDeoxyHydrogen = i;
            }
            if (positionOfImplicitHydrogen != null || positionOfDeoxyHydrogen != null) {
                List<Atom> neighbours = atom.getAtomNeighbours();
                for (Atom atomRef : atomRefs4) {
                    neighbours.remove(atomRef);
                }
                if (neighbours.size() == 0) {
                    throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substitued a hydrogen at stereocentre");
                }
                if (neighbours.size() == 1 && positionOfDeoxyHydrogen != null) {
                    atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(0);
                    if (positionOfImplicitHydrogen != null) {
                        throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substitued a hydrogen at stereocentre");
                    }
                } else if (neighbours.size() == 1 && positionOfImplicitHydrogen != null) {
                    atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(0);
                } else if (neighbours.size() == 2 && positionOfDeoxyHydrogen != null && positionOfImplicitHydrogen != null) {
                    atomRefs4[positionOfDeoxyHydrogen.intValue()] = neighbours.get(0);
                    atomRefs4[positionOfImplicitHydrogen.intValue()] = neighbours.get(1);
                } else {
                    throw new StructureBuildingException("OPSIN Bug: Unable to determine which atom has substitued a hydrogen at stereocentre");
                }
            }
        }
    }

    private boolean applyExplicitStoichometryIfProvided(BuildState state, Elements wordRules) throws StructureBuildingException {
        boolean explicitStoichometryPresent = false;
        for (int i = 0; i < wordRules.size(); ++i) {
            Element wordRule = wordRules.get(i);
            if (wordRule.getAttribute("stoichometry") == null) continue;
            int stoichometry = Integer.parseInt(wordRule.getAttributeValue("stoichometry"));
            wordRule.removeAttribute(wordRule.getAttribute("stoichometry"));
            for (int j = 1; j < stoichometry; ++j) {
                Element clone2 = state.fragManager.cloneElement(state, wordRule);
                XOMTools.insertAfter(wordRule, clone2);
            }
            explicitStoichometryPresent = true;
        }
        return explicitStoichometryPresent;
    }

    private void balanceChargeIfPossible(BuildState state, Element molecule, int overallCharge, boolean explicitStoichometryPresent) throws StructureBuildingException {
        boolean success2;
        List<Element> wordRules = XOMTools.getChildElementsWithTagName(molecule, "wordRule");
        ArrayList<Element> positivelyChargedComponents = new ArrayList<Element>();
        ArrayList<Element> negativelyChargedComponents = new ArrayList<Element>();
        HashMap<Element, Integer> componentToChargeMapping = new HashMap<Element, Integer>();
        HashMap<Element, BuildResults> componentToBR = new HashMap<Element, BuildResults>();
        ArrayList<Element> cationicElements = new ArrayList<Element>();
        List<Element> elementaryAtoms = XOMTools.getDescendantElementsWithTagNameAndAttribute(molecule, "group", "subType", "elementaryAtom");
        for (Element elementaryAtom : elementaryAtoms) {
            String[] typicalOxidationStates;
            int typicalCharge;
            Fragment cationicFrag;
            if (elementaryAtom.getAttribute("commonOxidationStatesAndMax") == null || (cationicFrag = state.xmlFragmentMap.get(elementaryAtom)).getFirstAtom().getCharge() != 0 || (typicalCharge = Integer.parseInt((typicalOxidationStates = OpsinTools.MATCH_COMMA.split(OpsinTools.MATCH_COLON.split(elementaryAtom.getAttributeValue("commonOxidationStatesAndMax"))[0]))[typicalOxidationStates.length - 1])) <= cationicFrag.getFirstAtom().getAtomNeighbours().size()) continue;
            cationicElements.add(elementaryAtom);
        }
        if ((overallCharge = this.setCationicElementsToTypicalCharge(state, cationicElements, overallCharge)) == 0) {
            return;
        }
        if (cationicElements.size() == 1 && overallCharge < 0 && (success2 = this.setChargeOnCationicElementAppropriately(state, overallCharge, (Element)cationicElements.get(0)))) {
            return;
        }
        for (Element wordRule : wordRules) {
            BuildResults br = new BuildResults(state, wordRule);
            componentToBR.put(wordRule, br);
            int charge = br.getCharge();
            if (charge > 0) {
                positivelyChargedComponents.add(wordRule);
            } else if (charge < 0) {
                negativelyChargedComponents.add(wordRule);
            }
            componentToChargeMapping.put(wordRule, charge);
        }
        if (!explicitStoichometryPresent && (positivelyChargedComponents.size() == 1 && cationicElements.size() == 0 && negativelyChargedComponents.size() >= 1 || positivelyChargedComponents.size() >= 1 && negativelyChargedComponents.size() == 1) && (success = this.multiplyChargedComponents(state, negativelyChargedComponents, positivelyChargedComponents, componentToChargeMapping, overallCharge))) {
            return;
        }
        if (cationicElements.size() == 1 && (success = this.setChargeOnCationicElementAppropriately(state, overallCharge, (Element)cationicElements.get(0)))) {
            return;
        }
        if (overallCharge < 0) {
            int i;
            int functionalAtomCount;
            int chargeOnFunctionalAtoms = 0;
            for (Element wordRule : wordRules) {
                BuildResults br = (BuildResults)componentToBR.get(wordRule);
                functionalAtomCount = br.getFunctionalAtomCount();
                for (i = functionalAtomCount - 1; i >= 0; --i) {
                    chargeOnFunctionalAtoms += br.getFunctionalAtom(i).getCharge();
                }
            }
            if (chargeOnFunctionalAtoms <= overallCharge) {
                for (Element wordRule : wordRules) {
                    BuildResults br = (BuildResults)componentToBR.get(wordRule);
                    functionalAtomCount = br.getFunctionalAtomCount();
                    for (i = functionalAtomCount - 1; i >= 0; --i) {
                        if (overallCharge == 0) {
                            return;
                        }
                        overallCharge -= br.getFunctionalAtom(i).getCharge();
                        br.getFunctionalAtom(i).neutraliseCharge();
                        br.removeFunctionalAtom(i);
                    }
                }
            }
        }
    }

    private int setCationicElementsToTypicalCharge(BuildState state, List<Element> cationicElements, int overallCharge) {
        block0: for (Element cationicElement : cationicElements) {
            Fragment cationicFrag = state.xmlFragmentMap.get(cationicElement);
            String[] typicalOxidationStates = OpsinTools.MATCH_COMMA.split(OpsinTools.MATCH_COLON.split(cationicElement.getAttributeValue("commonOxidationStatesAndMax"))[0]);
            int incomingValency = cationicFrag.getFirstAtom().getIncomingValency();
            for (String typicalOxidationState : typicalOxidationStates) {
                int charge = Integer.parseInt(typicalOxidationState);
                if (charge < incomingValency) continue;
                overallCharge += (charge -= incomingValency);
                cationicFrag.getFirstAtom().setCharge(charge);
                continue block0;
            }
        }
        return overallCharge;
    }

    private boolean multiplyChargedComponents(BuildState state, List<Element> negativelyChargedComponents, List<Element> positivelyChargedComponents, HashMap<Element, Integer> componentToChargeMapping, int overallCharge) throws StructureBuildingException {
        Element componentToMultiply;
        if (overallCharge > 0) {
            if (negativelyChargedComponents.size() > 1) {
                return false;
            }
            componentToMultiply = negativelyChargedComponents.get(0);
        } else {
            if (positivelyChargedComponents.size() > 1) {
                return false;
            }
            componentToMultiply = positivelyChargedComponents.get(0);
        }
        int charge = componentToChargeMapping.get(componentToMultiply);
        if (overallCharge % charge == 0) {
            if (!this.componentCanBeMultiplied(componentToMultiply)) {
                return false;
            }
            int timesToDuplicate = Math.abs(overallCharge / charge);
            for (int i = 0; i < timesToDuplicate; ++i) {
                XOMTools.insertAfter(componentToMultiply, state.fragManager.cloneElement(state, componentToMultiply));
            }
        } else {
            int i;
            if (positivelyChargedComponents.size() > 1 || !this.componentCanBeMultiplied(positivelyChargedComponents.get(0))) {
                return false;
            }
            if (negativelyChargedComponents.size() > 1 || !this.componentCanBeMultiplied(negativelyChargedComponents.get(0))) {
                return false;
            }
            int positiveCharge = componentToChargeMapping.get(positivelyChargedComponents.get(0));
            int negativeCharge = Math.abs(componentToChargeMapping.get(negativelyChargedComponents.get(0)));
            int targetTotalAbsoluteCharge = positiveCharge * negativeCharge;
            for (i = targetTotalAbsoluteCharge / negativeCharge; i > 1; --i) {
                XOMTools.insertAfter(negativelyChargedComponents.get(0), state.fragManager.cloneElement(state, negativelyChargedComponents.get(0)));
            }
            for (i = targetTotalAbsoluteCharge / positiveCharge; i > 1; --i) {
                XOMTools.insertAfter(positivelyChargedComponents.get(0), state.fragManager.cloneElement(state, positivelyChargedComponents.get(0)));
            }
        }
        return true;
    }

    private boolean componentCanBeMultiplied(Element componentToMultiply) {
        if (componentToMultiply.getAttributeValue("wordRule").equals(WordRule.simple.toString()) && XOMTools.getChildElementsWithTagNameAndAttribute(componentToMultiply, "word", "type", WordType.full.toString()).size() > 1) {
            return false;
        }
        Element firstChild = (Element)componentToMultiply.getChild(0);
        while (firstChild.getChildElements().size() != 0) {
            firstChild = (Element)firstChild.getChild(0);
        }
        return !firstChild.getLocalName().equals("multiplier");
    }

    private boolean setChargeOnCationicElementAppropriately(BuildState state, int overallCharge, Element cationicElement) {
        Atom cation = state.xmlFragmentMap.get(cationicElement).getFirstAtom();
        int chargeOnCationNeeded = -(overallCharge - cation.getCharge());
        int maximumCharge = Integer.parseInt(OpsinTools.MATCH_COLON.split(cationicElement.getAttributeValue("commonOxidationStatesAndMax"))[1]);
        if (chargeOnCationNeeded >= 0 && chargeOnCationNeeded <= maximumCharge) {
            cation.setCharge(chargeOnCationNeeded);
            return true;
        }
        return false;
    }

    private Element findRightMostGroupInWordOrWordRule(Element wordOrWordRule) throws StructureBuildingException {
        if (wordOrWordRule.getLocalName().equals("wordRule")) {
            List<Element> words = XOMTools.getDescendantElementsWithTagName(wordOrWordRule, "word");
            for (int i = words.size() - 1; i >= 0; --i) {
                if (!words.get(i).getAttributeValue("type").equals(WordType.functionalTerm.toString())) continue;
                words.remove(words.get(i));
            }
            if (words.size() == 0) {
                throw new StructureBuildingException("OPSIN bug: word element not found where expected");
            }
            return StructureBuildingMethods.findRightMostGroupInBracket(words.get(words.size() - 1));
        }
        if (wordOrWordRule.getLocalName().equals("word")) {
            return StructureBuildingMethods.findRightMostGroupInBracket(wordOrWordRule);
        }
        throw new StructureBuildingException("OPSIN bug: expected word or wordRule");
    }

    private void processOxidoSpecialCase(BuildState state, List<Element> groups) {
        for (Element group : groups) {
            if (!"oxidoLike".equals(group.getAttributeValue("subType"))) continue;
            Atom oxidoAtom = state.xmlFragmentMap.get(group).getFirstAtom();
            Atom connectedAtom = oxidoAtom.getAtomNeighbours().get(0);
            String element = connectedAtom.getElement();
            if (this.checkForConnectedOxo(state, connectedAtom)) continue;
            if ("elementaryAtom".equals(connectedAtom.getFrag().getSubType()) || (element.equals("S") || element.equals("P")) && connectedAtom.getCharge() == 0 && ValencyChecker.checkValencyAvailableForBond(connectedAtom, 1)) {
                oxidoAtom.neutraliseCharge();
                oxidoAtom.getFirstBond().setOrder(2);
                continue;
            }
            if (!element.equals("N") || connectedAtom.getCharge() != 0) continue;
            int incomingValency = connectedAtom.getIncomingValency();
            if (incomingValency + connectedAtom.getOutValency() == 3 && connectedAtom.hasSpareValency()) {
                connectedAtom.addChargeAndProtons(1, 1);
                continue;
            }
            if (incomingValency + connectedAtom.getOutValency() != 4) continue;
            if (connectedAtom.getLambdaConventionValency() != null && connectedAtom.getLambdaConventionValency() == 5) {
                oxidoAtom.setCharge(0);
                oxidoAtom.setProtonsExplicitlyAddedOrRemoved(0);
                oxidoAtom.getFirstBond().setOrder(2);
                continue;
            }
            connectedAtom.addChargeAndProtons(1, 1);
        }
    }

    private boolean checkForConnectedOxo(BuildState state, Atom atom) {
        Set<Bond> bonds = atom.getBonds();
        for (Bond bond : bonds) {
            Atom connectedAtom = bond.getFromAtom() == atom ? bond.getToAtom() : bond.getFromAtom();
            Element correspondingEl = state.xmlFragmentMap.getElement(connectedAtom.getFrag());
            if (!correspondingEl.getValue().equals("oxo")) continue;
            return true;
        }
        return false;
    }

    private void processOxidationNumbers(BuildState state, List<Element> groups) throws StructureBuildingException {
        for (Element group : groups) {
            Atom atom;
            if (!"elementaryAtom".equals(group.getAttributeValue("subType")) || (atom = state.xmlFragmentMap.get(group).getFirstAtom()).getProperty(Atom.OXIDATION_NUMBER) == null) continue;
            List<Atom> neighbours = atom.getAtomNeighbours();
            int chargeThatWouldFormIfLigandsWereRemoved = 0;
            for (Atom neighbour : neighbours) {
                Element neighbourEl = state.xmlFragmentMap.getElement(neighbour.getFrag());
                Bond b = atom.getBondToAtomOrThrow(neighbour);
                if (neighbourEl.getValue().equals("carbon") && "nonCarboxylicAcid".equals(neighbourEl.getAttributeValue("type")) || neighbourEl.getValue().equals("nitrosyl")) continue;
                chargeThatWouldFormIfLigandsWereRemoved += b.getOrder();
            }
            atom.setCharge(atom.getProperty(Atom.OXIDATION_NUMBER) - chargeThatWouldFormIfLigandsWereRemoved);
        }
    }

    private void processStereochemistry(BuildState state, Element molecule, Fragment uniFrag) throws StructureBuildingException {
        List<Element> stereoChemistryEls = this.findStereochemistryElsInProcessingOrder(molecule);
        List<Atom> atomList = uniFrag.getAtomList();
        ArrayList<Atom> atomsWithPreDefinedAtomParity = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (atom.getAtomParity() == null) continue;
            atomsWithPreDefinedAtomParity.add(atom);
        }
        Set<Bond> bonds = uniFrag.getBondSet();
        ArrayList<Bond> bondsWithPreDefinedBondStereo = new ArrayList<Bond>();
        for (Bond bond : bonds) {
            if (bond.getBondStereo() == null) continue;
            bondsWithPreDefinedBondStereo.add(bond);
        }
        if (stereoChemistryEls.size() > 0 || atomsWithPreDefinedAtomParity.size() > 0 || bondsWithPreDefinedBondStereo.size() > 0) {
            StereoAnalyser stereoAnalyser = new StereoAnalyser(uniFrag);
            HashMap<Atom, StereoAnalyser.StereoCentre> atomStereoCentreMap = new HashMap<Atom, StereoAnalyser.StereoCentre>();
            List<StereoAnalyser.StereoCentre> stereoCentres = stereoAnalyser.findStereoCentres();
            for (StereoAnalyser.StereoCentre stereoCentre : stereoCentres) {
                atomStereoCentreMap.put(stereoCentre.getStereoAtom(), stereoCentre);
            }
            HashMap<Bond, StereoAnalyser.StereoBond> bondStereoBondMap = new HashMap<Bond, StereoAnalyser.StereoBond>();
            List<StereoAnalyser.StereoBond> stereoBonds = stereoAnalyser.findStereoBonds();
            for (StereoAnalyser.StereoBond stereoBond : stereoBonds) {
                Bond b = stereoBond.getBond();
                if (!FragmentTools.notIn6MemberOrSmallerRing(b)) continue;
                bondStereoBondMap.put(b, stereoBond);
            }
            StereochemistryHandler stereoChemistryHandler = new StereochemistryHandler(state, atomStereoCentreMap, bondStereoBondMap);
            stereoChemistryHandler.applyStereochemicalElements(stereoChemistryEls);
            stereoChemistryHandler.removeRedundantStereoCentres(atomsWithPreDefinedAtomParity, bondsWithPreDefinedBondStereo);
        }
    }

    private List<Element> findStereochemistryElsInProcessingOrder(Element parentEl) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        Elements children2 = parentEl.getChildElements();
        ArrayList<Element> stereochemistryElsAtThisLevel = new ArrayList<Element>();
        for (int i = children2.size() - 1; i >= 0; --i) {
            Element child = children2.get(i);
            if (child.getLocalName().equals("stereoChemistry")) {
                stereochemistryElsAtThisLevel.add(child);
                continue;
            }
            matchingElements.addAll(this.findStereochemistryElsInProcessingOrder(child));
        }
        Collections.reverse(stereochemistryElsAtThisLevel);
        matchingElements.addAll(stereochemistryElsAtThisLevel);
        return matchingElements;
    }
}

