/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.PreProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    public static String charListToString(List<Character> l) {
        StringBuffer sb = new StringBuffer();
        for (char c : l) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String stringListToString(List<String> l, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            sb.append(l.get(i));
            if (separator == null || i >= l.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static List<Character> stringToList(String s) {
        ArrayList<Character> cl = new ArrayList<Character>();
        for (int i = 0; i < s.length(); ++i) {
            cl.add(Character.valueOf(s.charAt(i)));
        }
        return cl;
    }

    public static String multiplyString(String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = n - 1; i >= 0; --i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String arrayToString(String[] stringArray, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            sb.append(stringArray[i]);
            sb.append(separator);
        }
        sb.append(stringArray[stringArray.length - 1]);
        return sb.toString();
    }

    public static String convertNonAsciiAndNormaliseRepresentation(String s) throws PreProcessingException {
        s = OpsinTools.MATCH_WHITESPACE.matcher(s).replaceAll(" ");
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c >= '\u0080') {
                sb.replace(i, i + 1, StringTools.getReplacementForNonASCIIChar(c));
                continue;
            }
            if (c == '`') {
                sb.replace(i, i + 1, "'");
                continue;
            }
            if (c == '\"') {
                sb.replace(i, i + 1, "''");
                continue;
            }
            if (c > '\u001f') continue;
            sb.replace(i, i + 1, "");
        }
        return sb.toString();
    }

    private static String getReplacementForNonASCIIChar(char c) throws PreProcessingException {
        switch (c) {
            case '\u03b1': {
                return "alpha";
            }
            case '\u03b2': {
                return "beta";
            }
            case '\u03b3': {
                return "gamma";
            }
            case '\u03b4': {
                return "delta";
            }
            case '\u03b5': {
                return "epsilon";
            }
            case '\u03b6': {
                return "zeta";
            }
            case '\u03b7': {
                return "eta";
            }
            case '\u03b8': {
                return "theta";
            }
            case '\u03b9': {
                return "iota";
            }
            case '\u03ba': {
                return "kappa";
            }
            case '\u03bb': {
                return "lambda";
            }
            case '\u03bc': {
                return "mu";
            }
            case '\u03bd': {
                return "nu";
            }
            case '\u03be': {
                return "xi";
            }
            case '\u03bf': {
                return "omicron";
            }
            case '\u03c0': {
                return "pi";
            }
            case '\u03c1': {
                return "rho";
            }
            case '\u03c2': {
                return "stigma";
            }
            case '\u03c3': {
                return "sigma";
            }
            case '\u03c4': {
                return "tau";
            }
            case '\u03c5': {
                return "upsilon";
            }
            case '\u03c6': {
                return "phi";
            }
            case '\u03c7': {
                return "chi";
            }
            case '\u03c8': {
                return "psi";
            }
            case '\u03c9': {
                return "omega";
            }
            case '\u1d05': {
                return "D";
            }
            case '\u029f': {
                return "L";
            }
            case '\u00b1': {
                return "+-";
            }
            case '\u2213': {
                return "-+";
            }
            case '\u00c6': {
                return "AE";
            }
            case '\u00e6': {
                return "ae";
            }
            case '\u0152': {
                return "OE";
            }
            case '\u0153': {
                return "oe";
            }
            case '\u0132': {
                return "IJ";
            }
            case '\u0133': {
                return "ij";
            }
            case '\u1d6b': {
                return "ue";
            }
            case '\ufb00': {
                return "ff";
            }
            case '\ufb01': {
                return "fi";
            }
            case '\ufb02': {
                return "fl";
            }
            case '\ufb03': {
                return "ffi";
            }
            case '\ufb04': {
                return "ffl";
            }
            case '\ufb06': {
                return "st";
            }
            case '\u00e0': {
                return "a";
            }
            case '\u00c0': {
                return "A";
            }
            case '\u00e1': {
                return "a";
            }
            case '\u00c1': {
                return "A";
            }
            case '\u00e2': {
                return "a";
            }
            case '\u00c2': {
                return "A";
            }
            case '\u00e3': {
                return "a";
            }
            case '\u00c3': {
                return "A";
            }
            case '\u00e4': {
                return "a";
            }
            case '\u00c4': {
                return "A";
            }
            case '\u00e5': {
                return "a";
            }
            case '\u00c5': {
                return "A";
            }
            case '\u00e7': {
                return "c";
            }
            case '\u00c7': {
                return "C";
            }
            case '\u00e8': {
                return "e";
            }
            case '\u00c8': {
                return "E";
            }
            case '\u00e9': {
                return "e";
            }
            case '\u00c9': {
                return "E";
            }
            case '\u00ea': {
                return "e";
            }
            case '\u00ca': {
                return "E";
            }
            case '\u00eb': {
                return "e";
            }
            case '\u00cb': {
                return "E";
            }
            case '\u00ec': {
                return "i";
            }
            case '\u00cc': {
                return "I";
            }
            case '\u00ed': {
                return "i";
            }
            case '\u00cd': {
                return "I";
            }
            case '\u00ee': {
                return "i";
            }
            case '\u00ce': {
                return "I";
            }
            case '\u00ef': {
                return "i";
            }
            case '\u00cf': {
                return "I";
            }
            case '\u00f2': {
                return "o";
            }
            case '\u00d2': {
                return "O";
            }
            case '\u00f3': {
                return "o";
            }
            case '\u00d3': {
                return "O";
            }
            case '\u00f4': {
                return "o";
            }
            case '\u00d4': {
                return "O";
            }
            case '\u00f5': {
                return "o";
            }
            case '\u00d5': {
                return "O";
            }
            case '\u00f6': {
                return "o";
            }
            case '\u00d6': {
                return "O";
            }
            case '\u00f9': {
                return "u";
            }
            case '\u00d9': {
                return "U";
            }
            case '\u00fa': {
                return "u";
            }
            case '\u00da': {
                return "U";
            }
            case '\u00fb': {
                return "u";
            }
            case '\u00db': {
                return "U";
            }
            case '\u00fc': {
                return "u";
            }
            case '\u00dc': {
                return "U";
            }
            case '\u00fd': {
                return "y";
            }
            case '\u00dd': {
                return "Y";
            }
            case '\u0115': {
                return "e";
            }
            case '\u0114': {
                return "E";
            }
            case '\u0117': {
                return "e";
            }
            case '\u0116': {
                return "E";
            }
            case '\u2018': {
                return "'";
            }
            case '\u2019': {
                return "'";
            }
            case '\u201b': {
                return "'";
            }
            case '\u201c': {
                return "''";
            }
            case '\u201d': {
                return "''";
            }
            case '\u2032': {
                return "'";
            }
            case '\u2033': {
                return "''";
            }
            case '\u2034': {
                return "'''";
            }
            case '\u2057': {
                return "''''";
            }
            case '\u2035': {
                return "'";
            }
            case '\u2036': {
                return "''";
            }
            case '\u2037': {
                return "'''";
            }
            case '\u00b4': {
                return "'";
            }
            case '\u02ca': {
                return "'";
            }
            case '\u0301': {
                return "'";
            }
            case '\u02dd': {
                return "''";
            }
            case '\u030b': {
                return "''";
            }
            case '\u2010': {
                return "-";
            }
            case '\u2011': {
                return "-";
            }
            case '\u2012': {
                return "-";
            }
            case '\u2013': {
                return "-";
            }
            case '\u2014': {
                return "-";
            }
            case '\u2015': {
                return "-";
            }
            case '\u2212': {
                return "-";
            }
            case '\u00a0': {
                return " ";
            }
            case '\u2007': {
                return " ";
            }
            case '\u202f': {
                return " ";
            }
            case '\u200b': {
                return "";
            }
            case '\u200d': {
                return "";
            }
            case '\ufeff': {
                return "";
            }
        }
        throw new PreProcessingException("Unrecognised unicode character: " + c);
    }

    public static List<String> arrayToList(String[] array) {
        ArrayList<String> list2 = new ArrayList<String>();
        list2.addAll(Arrays.asList(array));
        return list2;
    }

    public static String removeDashIfPresent(String locantText) {
        if (locantText.endsWith("-")) {
            locantText = locantText.substring(0, locantText.length() - 1);
        }
        return locantText;
    }

    public static int countTerminalPrimes(String locantText) {
        int numberOfPrimes = 0;
        for (int k = locantText.length() - 1; k > 0 && locantText.charAt(k) == '\''; --k) {
            ++numberOfPrimes;
        }
        return numberOfPrimes;
    }

    public static boolean endsWithCaseInsensitive(String str, String suffix) {
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(true, strOffset, suffix, 0, suffix.length());
    }
}

