/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.CipSequenceRules;
import uk.ac.cam.ch.wwmm.opsin.Fragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StereoAnalyser {
    private final Map<Atom, Integer> mappingToColour;
    private final Map<Atom, List<Integer>> atomNeighbourColours;
    private final Fragment molecule;
    private final AtomColourThenNeighbouringColoursComparator atomColourThenNeighbouringColoursComparator;
    private static final AtomicNumberThenAtomicMassComparator atomicNumberThenAtomicMassComparator = new AtomicNumberThenAtomicMassComparator();

    private static int compareAtomicNumberThenAtomicMass(Atom a, Atom b) {
        int atomicNumber2;
        int atomicNumber1 = AtomProperties.elementToAtomicNumber.get(a.getElement());
        if (atomicNumber1 > (atomicNumber2 = AtomProperties.elementToAtomicNumber.get(b.getElement()).intValue())) {
            return 1;
        }
        if (atomicNumber1 < atomicNumber2) {
            return -1;
        }
        Integer atomicMass1 = a.getIsotope();
        Integer atomicMass2 = b.getIsotope();
        if (atomicMass1 != null && atomicMass2 == null) {
            return 1;
        }
        if (atomicMass1 == null && atomicMass2 != null) {
            return -1;
        }
        if (atomicMass1 != null && atomicMass2 != null) {
            if (atomicMass1 > atomicMass2) {
                return 1;
            }
            if (atomicMass1 < atomicMass2) {
                return -1;
            }
        }
        return 0;
    }

    StereoAnalyser(Fragment molecule) {
        this.molecule = molecule;
        this.atomColourThenNeighbouringColoursComparator = new AtomColourThenNeighbouringColoursComparator();
        this.addGhostAtoms();
        List<Atom> atomList = molecule.getAtomList();
        this.mappingToColour = new HashMap<Atom, Integer>(atomList.size());
        this.atomNeighbourColours = new HashMap<Atom, List<Integer>>(atomList.size());
        Collections.sort(atomList, atomicNumberThenAtomicMassComparator);
        this.populateColoursByAtomicNumberAndMass(atomList);
        boolean changeFound = true;
        while (changeFound) {
            for (Atom atom : atomList) {
                List<Integer> neighbourColours = this.findColourOfNeighbours(atom);
                this.atomNeighbourColours.put(atom, neighbourColours);
            }
            Collections.sort(atomList, this.atomColourThenNeighbouringColoursComparator);
            changeFound = this.populateColoursAndReportIfColoursWereChanged(atomList);
        }
        this.removeGhostAtoms();
    }

    private void addGhostAtoms() {
        Set<Bond> bonds = this.molecule.getBondSet();
        int ghostIdCounter = -1;
        for (Bond bond : bonds) {
            int bondOrder;
            for (int i = bondOrder = bond.getOrder(); i > 1; --i) {
                Atom fromAtom = bond.getFromAtom();
                Atom toAtom = bond.getToAtom();
                Atom ghost1 = new Atom(ghostIdCounter--, fromAtom.getElement(), this.molecule);
                Bond b1 = new Bond(ghost1, toAtom, 1);
                toAtom.addBond(b1);
                ghost1.addBond(b1);
                this.molecule.addAtom(ghost1);
                Atom ghost2 = new Atom(ghostIdCounter--, toAtom.getElement(), this.molecule);
                Bond b2 = new Bond(ghost2, fromAtom, 1);
                fromAtom.addBond(b2);
                ghost2.addBond(b2);
                this.molecule.addAtom(ghost2);
            }
        }
    }

    private void removeGhostAtoms() {
        List<Atom> atomList = this.molecule.getAtomList();
        for (Atom atom : atomList) {
            if (atom.getID() >= 0) continue;
            Atom adjacentAtom = atom.getAtomNeighbours().get(0);
            adjacentAtom.removeBond(atom.getFirstBond());
            this.molecule.removeAtom(atom);
        }
    }

    private void populateColoursByAtomicNumberAndMass(List<Atom> atomList) {
        Atom lastAtom = null;
        ArrayList<Atom> atomsOfThisColour = new ArrayList<Atom>();
        int atomsSeen = 0;
        for (Atom atom : atomList) {
            if (lastAtom != null && StereoAnalyser.compareAtomicNumberThenAtomicMass(lastAtom, atom) != 0) {
                for (Atom a2 : atomsOfThisColour) {
                    this.mappingToColour.put(a2, atomsSeen);
                }
                atomsOfThisColour = new ArrayList();
            }
            lastAtom = atom;
            atomsOfThisColour.add(atom);
            ++atomsSeen;
        }
        if (!atomsOfThisColour.isEmpty()) {
            for (Atom a2 : atomsOfThisColour) {
                this.mappingToColour.put(a2, atomsSeen);
            }
        }
    }

    private boolean populateColoursAndReportIfColoursWereChanged(List<Atom> atomList) {
        Atom previousAtom = atomList.get(0);
        ArrayList<Atom> atomsOfThisColour = new ArrayList<Atom>();
        int atomsSeen = 0;
        boolean changeFound = false;
        for (Atom atom : atomList) {
            if (this.atomColourThenNeighbouringColoursComparator.compare(previousAtom, atom) != 0) {
                for (Atom atomOfThisColour : atomsOfThisColour) {
                    if (!changeFound && atomsSeen != this.mappingToColour.get(atomOfThisColour)) {
                        changeFound = true;
                    }
                    this.mappingToColour.put(atomOfThisColour, atomsSeen);
                }
                previousAtom = atom;
                atomsOfThisColour = new ArrayList();
            }
            atomsOfThisColour.add(atom);
            ++atomsSeen;
        }
        if (!atomsOfThisColour.isEmpty()) {
            for (Atom atomOfThisColour : atomsOfThisColour) {
                if (!changeFound && atomsSeen != this.mappingToColour.get(atomOfThisColour)) {
                    changeFound = true;
                }
                this.mappingToColour.put(atomOfThisColour, atomsSeen);
            }
        }
        return changeFound;
    }

    private List<Integer> findColourOfNeighbours(Atom atom) {
        ArrayList<Integer> colourOfAdjacentAtoms = new ArrayList<Integer>();
        Set<Bond> bonds = atom.getBonds();
        for (Bond bond : bonds) {
            Atom otherAtom = bond.getFromAtom() == atom ? bond.getToAtom() : bond.getFromAtom();
            colourOfAdjacentAtoms.add(this.mappingToColour.get(otherAtom));
        }
        Collections.sort(colourOfAdjacentAtoms);
        return colourOfAdjacentAtoms;
    }

    List<StereoCentre> findStereoCentres() {
        List<Atom> potentialStereoAtoms = this.getPotentialStereoCentres();
        ArrayList<Atom> trueStereoCentres = new ArrayList<Atom>();
        for (Atom potentialStereoAtom : potentialStereoAtoms) {
            if (!this.isTrueStereCentre(potentialStereoAtom)) continue;
            trueStereoCentres.add(potentialStereoAtom);
        }
        ArrayList<StereoCentre> stereoCentres = new ArrayList<StereoCentre>();
        for (Atom trueStereoCentreAtom : trueStereoCentres) {
            stereoCentres.add(new StereoCentre(trueStereoCentreAtom, true));
        }
        potentialStereoAtoms.removeAll(trueStereoCentres);
        List<Atom> paraStereoCentres = this.findParaStereoCentres(potentialStereoAtoms, trueStereoCentres);
        for (Atom paraStereoCentreAtom : paraStereoCentres) {
            stereoCentres.add(new StereoCentre(paraStereoCentreAtom, false));
        }
        return stereoCentres;
    }

    private List<Atom> getPotentialStereoCentres() {
        List<Atom> atomList = this.molecule.getAtomList();
        ArrayList<Atom> potentialStereoAtoms = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (!StereoAnalyser.isPossiblyStereogenic(atom)) continue;
            potentialStereoAtoms.add(atom);
        }
        return potentialStereoAtoms;
    }

    private boolean isTrueStereCentre(Atom potentialStereoAtom) {
        List<Atom> neighbours = potentialStereoAtom.getAtomNeighbours();
        if (neighbours.size() != 3 && neighbours.size() != 4) {
            return false;
        }
        int[] colours = new int[4];
        for (int i = neighbours.size() - 1; i >= 0; --i) {
            colours[i] = this.mappingToColour.get(neighbours.get(i));
        }
        boolean foundIdenticalNeighbour = false;
        block1: for (int i = 0; i < 4; ++i) {
            int cl = colours[i];
            for (int j = i + 1; j < 4; ++j) {
                if (cl != colours[j]) continue;
                foundIdenticalNeighbour = true;
                continue block1;
            }
        }
        return !foundIdenticalNeighbour;
    }

    private List<Atom> findParaStereoCentres(List<Atom> potentialStereoAtoms, List<Atom> trueStereoCentres) {
        ArrayList<Atom> paraStereoCentres = new ArrayList<Atom>();
        for (Atom potentialStereoAtom : potentialStereoAtoms) {
            List<Atom> neighbours = potentialStereoAtom.getAtomNeighbours();
            if (neighbours.size() != 4) continue;
            int[] colours = new int[4];
            for (int i = neighbours.size() - 1; i >= 0; --i) {
                colours[i] = this.mappingToColour.get(neighbours.get(i));
            }
            HashMap<Integer, Integer> foundPairs = new HashMap<Integer, Integer>();
            block2: for (int i = 0; i < 4; ++i) {
                int cl = colours[i];
                for (int j = i + 1; j < 4; ++j) {
                    if (cl != colours[j]) continue;
                    foundPairs.put(i, j);
                    continue block2;
                }
            }
            int pairs = foundPairs.keySet().size();
            if (pairs != 1 && pairs != 2) continue;
            boolean hasTrueStereoCentreInAllBranches = true;
            for (Map.Entry entry : foundPairs.entrySet()) {
                if (this.branchesHaveTrueStereocentre(neighbours.get((Integer)entry.getKey()), neighbours.get((Integer)entry.getValue()), potentialStereoAtom, trueStereoCentres)) continue;
                hasTrueStereoCentreInAllBranches = false;
                break;
            }
            if (!hasTrueStereoCentreInAllBranches) continue;
            paraStereoCentres.add(potentialStereoAtom);
        }
        return paraStereoCentres;
    }

    private boolean branchesHaveTrueStereocentre(Atom branchAtom1, Atom branchAtom2, Atom potentialStereoAtom, List<Atom> trueStereoCentres) {
        ArrayList<Atom> atomsToVisit = new ArrayList<Atom>();
        HashSet<Atom> visitedAtoms = new HashSet<Atom>();
        visitedAtoms.add(potentialStereoAtom);
        atomsToVisit.add(branchAtom1);
        atomsToVisit.add(branchAtom2);
        while (!atomsToVisit.isEmpty()) {
            ArrayList<Atom> newAtomsToVisit = new ArrayList<Atom>();
            while (!atomsToVisit.isEmpty()) {
                Atom atom = (Atom)atomsToVisit.remove(0);
                if (trueStereoCentres.contains(atom)) {
                    return true;
                }
                if (atomsToVisit.contains(atom)) {
                    do {
                        atomsToVisit.remove(atom);
                    } while (atomsToVisit.contains(atom));
                    continue;
                }
                List<Atom> neighbours = atom.getAtomNeighbours();
                for (Atom neighbour : neighbours) {
                    if (visitedAtoms.contains(neighbour)) continue;
                    newAtomsToVisit.add(neighbour);
                }
                visitedAtoms.add(atom);
            }
            atomsToVisit = newAtomsToVisit;
        }
        return false;
    }

    static boolean isPossiblyStereogenic(Atom atom) {
        return StereoAnalyser.isKnownPotentiallyStereogenic(atom) && !StereoAnalyser.isAchiralDueToResonanceOrTautomerism(atom);
    }

    static boolean isKnownPotentiallyStereogenic(Atom atom) {
        List<Atom> neighbours = atom.getAtomNeighbours();
        String element = atom.getElement();
        if (neighbours.size() == 4) {
            if (element.equals("B") || element.equals("C") || element.equals("Si") || element.equals("Ge") || element.equals("Sn") || element.equals("N") || element.equals("P") || element.equals("As") || element.equals("S") || element.equals("Se")) {
                return true;
            }
        } else if (neighbours.size() == 3) {
            if ((element.equals("S") || element.equals("Se")) && (atom.getIncomingValency() == 4 || atom.getCharge() == 1 && atom.getIncomingValency() == 3)) {
                return true;
            }
            if (element.equals("N") && atom.getCharge() == 0 && atom.getIncomingValency() == 3 && StereoAnalyser.atomsContainABondBetweenThemselves(neighbours)) {
                return true;
            }
        }
        return false;
    }

    private static boolean atomsContainABondBetweenThemselves(List<Atom> atoms) {
        for (Atom atom : atoms) {
            for (Atom neighbour : atom.getAtomNeighbours()) {
                if (!atoms.contains(neighbour)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isAchiralDueToResonanceOrTautomerism(Atom atom) {
        if (atom.getElement().equals("N") || atom.getElement().equals("P") || atom.getElement().equals("As") || atom.getElement().equals("S") || atom.getElement().equals("Se")) {
            List<Atom> neighbours = atom.getAtomNeighbours();
            HashSet<String> resonanceAndTautomerismAtomicElementPlusIsotopes = new HashSet<String>();
            for (Atom neighbour : neighbours) {
                String element = neighbour.getElement();
                if ((element.equals("O") || element.equals("S") || element.equals("Se") || element.equals("Te") || element.equals("N")) && StereoAnalyser.isOnlyBondedToHydrogensOtherThanGivenAtom(neighbour, atom)) {
                    if (resonanceAndTautomerismAtomicElementPlusIsotopes.contains(element + atom.getIsotope())) {
                        return true;
                    }
                    resonanceAndTautomerismAtomicElementPlusIsotopes.add(element + atom.getIsotope());
                }
                if (!element.equals("H") || neighbour.getBonds().size() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOnlyBondedToHydrogensOtherThanGivenAtom(Atom atom, Atom attachedNonHydrogen) {
        for (Atom neighbour : atom.getAtomNeighbours()) {
            if (neighbour.equals(attachedNonHydrogen) || neighbour.getElement().equals("H")) continue;
            return false;
        }
        return true;
    }

    List<StereoBond> findStereoBonds() {
        Set<Bond> bondSet = this.molecule.getBondSet();
        ArrayList<StereoBond> stereoBonds = new ArrayList<StereoBond>();
        for (Bond bond : bondSet) {
            if (bond.getOrder() != 2) continue;
            Atom a1 = bond.getFromAtom();
            List<Atom> neighbours1 = a1.getAtomNeighbours();
            neighbours1.remove(bond.getToAtom());
            if (neighbours1.size() != 2 && (neighbours1.size() != 1 || !a1.getElement().equals("N") || a1.getIncomingValency() != 3 || a1.getCharge() != 0) || neighbours1.size() == 2 && this.mappingToColour.get(neighbours1.get(0)).equals(this.mappingToColour.get(neighbours1.get(1)))) continue;
            Atom a2 = bond.getToAtom();
            List<Atom> neighbours2 = a2.getAtomNeighbours();
            neighbours2.remove(bond.getFromAtom());
            if (neighbours2.size() != 2 && (neighbours2.size() != 1 || !a2.getElement().equals("N") || a2.getIncomingValency() != 3 || a2.getCharge() != 0) || neighbours2.size() == 2 && this.mappingToColour.get(neighbours2.get(0)).equals(this.mappingToColour.get(neighbours2.get(1)))) continue;
            stereoBonds.add(new StereoBond(bond));
        }
        return stereoBonds;
    }

    Integer getAtomEnvironmentNumber(Atom a) {
        return this.mappingToColour.get(a);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AtomColourThenNeighbouringColoursComparator
    implements Comparator<Atom> {
        private AtomColourThenNeighbouringColoursComparator() {
        }

        @Override
        public int compare(Atom a, Atom b) {
            int colour2;
            int colour1 = (Integer)StereoAnalyser.this.mappingToColour.get(a);
            if (colour1 > (colour2 = ((Integer)StereoAnalyser.this.mappingToColour.get(b)).intValue())) {
                return 1;
            }
            if (colour1 < colour2) {
                return -1;
            }
            List colours1 = (List)StereoAnalyser.this.atomNeighbourColours.get(a);
            List colours2 = (List)StereoAnalyser.this.atomNeighbourColours.get(b);
            int colours1Size = colours1.size();
            int colours2Size = colours2.size();
            int differenceInSize = colours1Size - colours2Size;
            int maxCommonColourSize = colours1Size > colours2Size ? colours2Size : colours1Size;
            for (int i = 1; i <= maxCommonColourSize; ++i) {
                int difference = (Integer)colours1.get(colours1Size - i) - (Integer)colours2.get(colours2Size - i);
                if (difference > 0) {
                    return 1;
                }
                if (difference >= 0) continue;
                return -1;
            }
            if (differenceInSize > 0) {
                return 1;
            }
            if (differenceInSize < 0) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicNumberThenAtomicMassComparator
    implements Comparator<Atom> {
        private AtomicNumberThenAtomicMassComparator() {
        }

        @Override
        public int compare(Atom a, Atom b) {
            return StereoAnalyser.compareAtomicNumberThenAtomicMass(a, b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StereoBond {
        private final Bond bond;

        StereoBond(Bond bond) {
            this.bond = bond;
        }

        Bond getBond() {
            return this.bond;
        }

        List<Atom> getOrderedStereoAtoms() {
            Atom a1 = this.bond.getFromAtom();
            Atom a2 = this.bond.getToAtom();
            List<Atom> cipOrdered1 = new CipSequenceRules(a1).getNeighbouringAtomsInCIPOrderIgnoringGivenNeighbour(a2);
            List<Atom> cipOrdered2 = new CipSequenceRules(a2).getNeighbouringAtomsInCIPOrderIgnoringGivenNeighbour(a1);
            ArrayList<Atom> stereoAtoms = new ArrayList<Atom>();
            stereoAtoms.add(cipOrdered1.get(cipOrdered1.size() - 1));
            stereoAtoms.add(a1);
            stereoAtoms.add(a2);
            stereoAtoms.add(cipOrdered2.get(cipOrdered2.size() - 1));
            return stereoAtoms;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StereoCentre {
        private final Atom stereoAtom;
        private final boolean trueStereoCentre;

        StereoCentre(Atom stereoAtom, Boolean isTrueStereoCentre) {
            this.stereoAtom = stereoAtom;
            this.trueStereoCentre = isTrueStereoCentre;
        }

        Atom getStereoAtom() {
            return this.stereoAtom;
        }

        boolean isTrueStereoCentre() {
            return this.trueStereoCentre;
        }

        List<Atom> getCipOrderedAtoms() {
            List<Atom> cipOrderedAtoms = new CipSequenceRules(this.stereoAtom).getNeighbouringAtomsInCIPOrder();
            if (cipOrderedAtoms.size() == 3) {
                cipOrderedAtoms.add(0, this.stereoAtom);
            }
            return cipOrderedAtoms;
        }
    }
}

