/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Comparator;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SortAtomsForElementSymbols
implements Comparator<Atom> {
    final Map<Atom, Bond> atomToPreviousBondMap;

    public SortAtomsForElementSymbols(Map<Atom, Bond> atomToPreviousBondMap) {
        this.atomToPreviousBondMap = atomToPreviousBondMap;
    }

    @Override
    public int compare(Atom a, Atom b) {
        int expectedHydrogenB;
        Bond bondA = this.atomToPreviousBondMap.get(a);
        Bond bondB = this.atomToPreviousBondMap.get(b);
        if (bondA.getOrder() > bondB.getOrder()) {
            return 1;
        }
        if (bondA.getOrder() < bondB.getOrder()) {
            return -1;
        }
        if (a.getOutValency() > b.getOutValency()) {
            return -1;
        }
        if (a.getOutValency() < b.getOutValency()) {
            return 1;
        }
        int expectedHydrogenA = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(a);
        if (expectedHydrogenA > (expectedHydrogenB = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(b))) {
            return -1;
        }
        if (expectedHydrogenA < expectedHydrogenB) {
            return 1;
        }
        return 0;
    }
}

