/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SMILESWriter {
    private static final Map<String, Integer[]> organicAtomsToStandardValencies;
    private static final LinkedList<String> closureSymbols;
    private final LinkedList<String> availableClosureSymbols = new LinkedList<String>(closureSymbols);
    private final HashMap<Bond, String> bondToClosureSymbolMap = new HashMap();
    private final HashMap<Bond, Atom> bondToNextAtomMap = new LinkedHashMap<Bond, Atom>();
    private final Fragment structure;
    private final StringBuilder smilesBuilder = new StringBuilder();

    SMILESWriter(Fragment structure) {
        this.structure = structure;
    }

    String generateSmiles() {
        this.assignSmilesOrder();
        this.assignDoubleBondStereochemistrySlashes();
        List<Atom> atomList = this.structure.getAtomList();
        List<Atom> nonProtonAtomList = this.createNonProtonAtomList(atomList);
        int nonProtonCount = nonProtonAtomList.size();
        boolean isEmpty2 = true;
        for (int i = 0; i < nonProtonCount; ++i) {
            Atom currentAtom = nonProtonAtomList.get(i);
            if (currentAtom.getProperty(Atom.VISITED) != 0) continue;
            if (!isEmpty2) {
                this.smilesBuilder.append('.');
            }
            this.traverseSmiles(currentAtom, null, 0);
            isEmpty2 = false;
        }
        return this.smilesBuilder.toString();
    }

    private void assignSmilesOrder() {
        List<Atom> atomList = this.structure.getAtomList();
        for (Atom atom : atomList) {
            atom.setProperty(Atom.VISITED, null);
        }
        for (Atom a : atomList) {
            if (a.getProperty(Atom.VISITED) != null || this.isSmilesImplicitProton(a)) continue;
            this.traverseMolecule(a, null, 0);
        }
    }

    private void traverseMolecule(Atom currentAtom, Atom previousAtom, int depth) {
        if (currentAtom.getProperty(Atom.VISITED) != null) {
            return;
        }
        currentAtom.setProperty(Atom.VISITED, depth);
        Set<Bond> bonds = currentAtom.getBonds();
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (this.isSmilesImplicitProton(neighbour) || neighbour.equals(previousAtom)) continue;
            this.bondToNextAtomMap.put(bond, neighbour);
            this.traverseMolecule(neighbour, currentAtom, depth + 1);
        }
    }

    private boolean isSmilesImplicitProton(Atom atom) {
        Set<Bond> bondsFromNitrogen;
        if (!atom.getElement().equals("H") || atom.getIsotope() != null && atom.getIsotope() != 1) {
            return false;
        }
        List<Atom> neighbours = atom.getAtomNeighbours();
        if (neighbours.size() > 1) {
            return false;
        }
        boolean foundNonHydrogenNeighbour = false;
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement().equals("H")) continue;
            foundNonHydrogenNeighbour = true;
        }
        if (!foundNonHydrogenNeighbour) {
            return false;
        }
        if (neighbours.get(0).getElement().equals("N") && (bondsFromNitrogen = neighbours.get(0).getBonds()).size() == 2) {
            for (Bond bond : bondsFromNitrogen) {
                if (bond.getBondStereo() == null) continue;
                return false;
            }
        }
        return true;
    }

    private void assignDoubleBondStereochemistrySlashes() {
        Set<Bond> bonds = this.bondToNextAtomMap.keySet();
        for (Bond bond : bonds) {
            bond.setSmilesStereochemistry(null);
        }
        for (Bond bond : bonds) {
            BondStereo bondStereo = bond.getBondStereo();
            if (bondStereo == null) continue;
            Atom[] atomRefs4 = bondStereo.getAtomRefs4();
            Bond bond1 = atomRefs4[0].getBondToAtom(atomRefs4[1]);
            Bond bond2 = atomRefs4[2].getBondToAtom(atomRefs4[3]);
            if (bond1 == null || bond2 == null) {
                throw new RuntimeException("Bondstereo described atoms that are not bonded:" + bondStereo.toCML().toXML());
            }
            Atom bond1ToAtom = this.bondToNextAtomMap.get(bond1);
            Atom bond2ToAtom = this.bondToNextAtomMap.get(bond2);
            Bond.SMILES_BOND_DIRECTION bond1Slash = bond1.getSmilesStereochemistry();
            Bond.SMILES_BOND_DIRECTION bond2Slash = bond2.getSmilesStereochemistry();
            Bond.SMILES_BOND_DIRECTION bond1Direction = Bond.SMILES_BOND_DIRECTION.LSLASH;
            Bond.SMILES_BOND_DIRECTION bond2Direction = Bond.SMILES_BOND_DIRECTION.LSLASH;
            if (bondStereo.getBondStereoValue().equals((Object)BondStereo.BondStereoValue.CIS)) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (!bond1ToAtom.equals(atomRefs4[1])) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (!bond2ToAtom.equals(atomRefs4[3])) {
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            if (bond1Slash != null && !bond1Slash.equals((Object)bond1Direction)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            } else if (bond2Slash != null && !bond2Slash.equals((Object)bond2Direction)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
            }
            Bond bond1Other = null;
            Bond bond2Other = null;
            Bond.SMILES_BOND_DIRECTION bond1OtherDirection = null;
            Bond.SMILES_BOND_DIRECTION bond2OtherDirection = null;
            ArrayList<Bond> bondsFrom2ndAtom = new ArrayList<Bond>(atomRefs4[1].getBonds());
            bondsFrom2ndAtom.remove(bond1);
            bondsFrom2ndAtom.remove(bond);
            if (bondsFrom2ndAtom.size() == 1 && this.bondToNextAtomMap.containsKey(bondsFrom2ndAtom.get(0))) {
                bond1Other = (Bond)bondsFrom2ndAtom.get(0);
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1OtherDirection = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (!bond1ToAtom.equals(atomRefs4[1])) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION2 = bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
                if (!this.bondToNextAtomMap.get(bond1Other).equals(atomRefs4[1])) {
                    bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            ArrayList<Bond> bondsFrom3rdAtom = new ArrayList<Bond>(atomRefs4[2].getBonds());
            bondsFrom3rdAtom.remove(bond2);
            bondsFrom3rdAtom.remove(bond);
            if (bondsFrom3rdAtom.size() == 1 && this.bondToNextAtomMap.containsKey(bondsFrom3rdAtom.get(0))) {
                bond2Other = (Bond)bondsFrom3rdAtom.get(0);
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2OtherDirection = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (!bond2ToAtom.equals(atomRefs4[3])) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION3 = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
                if (!this.bondToNextAtomMap.get(bond2Other).equals(bond2Other.getOtherAtom(atomRefs4[2]))) {
                    Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION4 = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            if (bond1Other != null && bond1Other.getSmilesStereochemistry() != null && !bond1Other.getSmilesStereochemistry().equals((Object)bond1OtherDirection)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (bond2Other != null) {
                    bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            } else if (bond2Other != null && bond2Other.getSmilesStereochemistry() != null && !bond2Other.getSmilesStereochemistry().equals((Object)bond2OtherDirection)) {
                bond1Direction = bond1Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                bond2Direction = bond2Direction.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                Bond.SMILES_BOND_DIRECTION sMILES_BOND_DIRECTION = bond2OtherDirection = bond2OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                if (bond1Other != null) {
                    bond1OtherDirection = bond1OtherDirection.equals((Object)Bond.SMILES_BOND_DIRECTION.LSLASH) ? Bond.SMILES_BOND_DIRECTION.RSLASH : Bond.SMILES_BOND_DIRECTION.LSLASH;
                }
            }
            bond1.setSmilesStereochemistry(bond1Direction);
            bond2.setSmilesStereochemistry(bond2Direction);
            if (bond1Other != null) {
                bond1Other.setSmilesStereochemistry(bond1OtherDirection);
            }
            if (bond2Other == null) continue;
            bond2Other.setSmilesStereochemistry(bond2OtherDirection);
        }
    }

    private List<Atom> createNonProtonAtomList(List<Atom> atomList) {
        ArrayList<Atom> nonProtonAtomList = new ArrayList<Atom>();
        for (Atom atom : atomList) {
            if (atom.getProperty(Atom.VISITED) == null) continue;
            nonProtonAtomList.add(atom);
        }
        return nonProtonAtomList;
    }

    private void traverseSmiles(Atom currentAtom, Atom previousAtom, int depth) {
        Integer nDepth;
        Atom neighbour;
        String closure;
        Integer nDepth2;
        Atom neighbour2;
        this.smilesBuilder.append(this.atomToSmiles(currentAtom, depth, previousAtom));
        Set<Bond> bonds = currentAtom.getBonds();
        for (Bond bond : bonds) {
            neighbour2 = bond.getOtherAtom(currentAtom);
            nDepth2 = neighbour2.getProperty(Atom.VISITED);
            if (nDepth2 == null || nDepth2 > depth || neighbour2.equals(previousAtom)) continue;
            closure = this.bondToClosureSymbolMap.get(bond);
            this.availableClosureSymbols.addFirst(closure);
            this.smilesBuilder.append(closure);
        }
        for (Bond bond : bonds) {
            neighbour2 = bond.getOtherAtom(currentAtom);
            nDepth2 = neighbour2.getProperty(Atom.VISITED);
            if (nDepth2 == null || nDepth2 <= depth + 1) continue;
            closure = this.availableClosureSymbols.removeFirst();
            this.bondToClosureSymbolMap.put(bond, closure);
            this.smilesBuilder.append(this.bondToSmiles(bond));
            this.smilesBuilder.append(closure);
        }
        int count2 = 0;
        for (Bond bond : bonds) {
            neighbour = bond.getOtherAtom(currentAtom);
            nDepth = neighbour.getProperty(Atom.VISITED);
            if (nDepth == null || nDepth != depth + 1) continue;
            ++count2;
        }
        for (Bond bond : bonds) {
            neighbour = bond.getOtherAtom(currentAtom);
            nDepth = neighbour.getProperty(Atom.VISITED);
            if (nDepth == null || nDepth != depth + 1) continue;
            if (count2 > 1) {
                this.smilesBuilder.append('(');
            }
            this.smilesBuilder.append(this.bondToSmiles(bond));
            this.traverseSmiles(neighbour, currentAtom, depth + 1);
            if (count2 <= 1) continue;
            this.smilesBuilder.append(')');
            --count2;
        }
    }

    private String atomToSmiles(Atom atom, int depth, Atom previousAtom) {
        int charge;
        StringBuilder atomSmiles = new StringBuilder();
        int hydrogen = this.calculateNumberOfBondedExplicitHydrogen(atom);
        boolean needsSquareBrackets = this.determineWhetherAtomNeedsSquareBrackets(atom, hydrogen);
        if (needsSquareBrackets) {
            atomSmiles.append('[');
        }
        if (atom.getIsotope() != null) {
            atomSmiles.append(atom.getIsotope());
        }
        String elementSymbol = atom.getElement();
        if (atom.hasSpareValency()) {
            atomSmiles.append(elementSymbol.toLowerCase());
        } else if (elementSymbol.equals("R")) {
            atomSmiles.append('*');
        } else {
            atomSmiles.append(elementSymbol);
        }
        if (atom.getAtomParity() != null) {
            atomSmiles.append(this.atomParityToSmiles(atom, depth, previousAtom));
        }
        if (hydrogen != 0 && needsSquareBrackets && !elementSymbol.equals("H")) {
            atomSmiles.append('H');
            if (hydrogen != 1) {
                atomSmiles.append(String.valueOf(hydrogen));
            }
        }
        if ((charge = atom.getCharge()) != 0) {
            if (charge == 1) {
                atomSmiles.append('+');
            } else if (charge == -1) {
                atomSmiles.append('-');
            } else {
                if (charge > 0) {
                    atomSmiles.append('+');
                }
                atomSmiles.append(charge);
            }
        }
        if (needsSquareBrackets) {
            atomSmiles.append(']');
        }
        return atomSmiles.toString();
    }

    private int calculateNumberOfBondedExplicitHydrogen(Atom atom) {
        List<Atom> neighbours = atom.getAtomNeighbours();
        int count2 = 0;
        for (Atom neighbour : neighbours) {
            if (neighbour.getProperty(Atom.VISITED) != null) continue;
            ++count2;
        }
        return count2;
    }

    private boolean determineWhetherAtomNeedsSquareBrackets(Atom atom, int hydrogenCount) {
        int nonHydrogenValency;
        if (!organicAtomsToStandardValencies.containsKey(atom.getElement())) {
            return true;
        }
        if (atom.getCharge() != 0) {
            return true;
        }
        if (atom.getIsotope() != null) {
            return true;
        }
        if (atom.getAtomParity() != null) {
            return true;
        }
        List<Object> expectedValencies = Arrays.asList((Object[])organicAtomsToStandardValencies.get(atom.getElement()));
        int valency = atom.getIncomingValency();
        boolean valencyCanBeDescribedImplicitly = expectedValencies.contains(valency);
        int targetImplicitValency = valency;
        if (valency > (Integer)expectedValencies.get(expectedValencies.size() - 1)) {
            valencyCanBeDescribedImplicitly = true;
        }
        if (!valencyCanBeDescribedImplicitly) {
            return true;
        }
        int implicitValencyThatWouldBeGenerated = nonHydrogenValency = valency - hydrogenCount;
        for (int i = expectedValencies.size() - 1; i >= 0; --i) {
            if ((Integer)expectedValencies.get(i) < nonHydrogenValency) continue;
            implicitValencyThatWouldBeGenerated = (Integer)expectedValencies.get(i);
        }
        return targetImplicitValency != implicitValencyThatWouldBeGenerated;
    }

    private String atomParityToSmiles(Atom currentAtom, int depth, Atom previousAtom) {
        int i;
        AtomParity atomParity = currentAtom.getAtomParity();
        StringBuilder tetrahedralStereoChem = new StringBuilder();
        Atom[] atomRefs4 = (Atom[])atomParity.getAtomRefs4().clone();
        ArrayList<Atom> atomrefs4Current = new ArrayList<Atom>();
        Set<Bond> bonds = currentAtom.getBonds();
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || !neighbour.equals(previousAtom)) continue;
            atomrefs4Current.add(neighbour);
        }
        for (Atom atom : atomRefs4) {
            if (!atom.equals(currentAtom)) continue;
            atomrefs4Current.add(currentAtom);
        }
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) != null) continue;
            atomrefs4Current.add(currentAtom);
        }
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) > depth || neighbour.equals(previousAtom)) continue;
            atomrefs4Current.add(neighbour);
        }
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) <= depth + 1) continue;
            atomrefs4Current.add(neighbour);
        }
        for (Bond bond : bonds) {
            Atom neighbour = bond.getOtherAtom(currentAtom);
            if (neighbour.getProperty(Atom.VISITED) == null || neighbour.getProperty(Atom.VISITED) != depth + 1) continue;
            atomrefs4Current.add(neighbour);
        }
        Atom[] atomrefs4CurrentArr = new Atom[4];
        for (i = 0; i < atomrefs4Current.size(); ++i) {
            atomrefs4CurrentArr[i] = (Atom)atomrefs4Current.get(i);
        }
        for (i = 0; i < atomRefs4.length; ++i) {
            if (atomRefs4[i].getProperty(Atom.VISITED) != null) continue;
            atomRefs4[i] = currentAtom;
        }
        boolean equivalent = StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(atomRefs4, atomParity.getParity(), atomrefs4CurrentArr, 1);
        if (equivalent) {
            tetrahedralStereoChem.append("@@");
        } else {
            tetrahedralStereoChem.append("@");
        }
        return tetrahedralStereoChem.toString();
    }

    private String bondToSmiles(Bond bond) {
        String bondSmiles = "";
        int bondOrder = bond.getOrder();
        if (bondOrder == 2) {
            bondSmiles = "=";
        } else if (bondOrder == 3) {
            bondSmiles = "#";
        } else if (bond.getSmilesStereochemistry() != null) {
            bondSmiles = bond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH ? "/" : "\\";
        }
        return bondSmiles;
    }

    static {
        int i;
        organicAtomsToStandardValencies = new HashMap<String, Integer[]>();
        closureSymbols = new LinkedList();
        organicAtomsToStandardValencies.put("B", new Integer[]{3});
        organicAtomsToStandardValencies.put("C", new Integer[]{4});
        organicAtomsToStandardValencies.put("N", new Integer[]{3, 5});
        organicAtomsToStandardValencies.put("O", new Integer[]{2});
        organicAtomsToStandardValencies.put("P", new Integer[]{3, 5});
        organicAtomsToStandardValencies.put("S", new Integer[]{2, 4, 6});
        organicAtomsToStandardValencies.put("F", new Integer[]{1});
        organicAtomsToStandardValencies.put("Cl", new Integer[]{1});
        organicAtomsToStandardValencies.put("Br", new Integer[]{1});
        organicAtomsToStandardValencies.put("I", new Integer[]{1});
        for (i = 1; i <= 9; ++i) {
            closureSymbols.add(String.valueOf(i));
        }
        for (i = 10; i <= 99; ++i) {
            closureSymbols.add("%" + i);
        }
        closureSymbols.add("0");
    }
}

