/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentManager;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SMILESFragmentBuilder {
    private static final Set<String> organicAtoms = new HashSet<String>();
    private static final Set<String> aromaticAtoms = new HashSet<String>();

    SMILESFragmentBuilder() {
    }

    Fragment build(String smiles, FragmentManager fragManager) throws StructureBuildingException {
        return this.build(smiles, "", "", "", fragManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Fragment build(String smiles, String type, String subType, String labelMapping, FragmentManager fragManager) throws StructureBuildingException {
        char lastCharacter;
        if (smiles == null) {
            throw new StructureBuildingException("SMILES specified is null");
        }
        if (type == null) {
            throw new StructureBuildingException("type specified is null, use \"\" if a type is not desired ");
        }
        if (subType == null) {
            throw new StructureBuildingException("subType specified is null, use \"\" if a subType is not desired ");
        }
        if (labelMapping == null) {
            throw new StructureBuildingException("labelMapping is null use \"none\" if you do not want any numbering or \"numeric\" if you would like default numbering");
        }
        String[] labelMap = null;
        if (labelMapping.equals("")) {
            labelMapping = "numeric";
        }
        if (!labelMapping.equals("none") && !labelMapping.equals("fusedRing")) {
            labelMap = OpsinTools.MATCH_SLASH.split(labelMapping, -1);
        }
        int currentNumber = 1;
        Fragment currentFrag = new Fragment(type, subType);
        Stack<StackFrame> stack = new Stack<StackFrame>();
        stack.push(new StackFrame(null, 1));
        HashMap<String, StackFrame> closures = new HashMap<String, StackFrame>();
        String tmpString = smiles;
        char firstCharacter = tmpString.charAt(0);
        if (firstCharacter == '-' || firstCharacter == '=' || firstCharacter == '#') {
            tmpString = tmpString.substring(1);
        }
        if ((lastCharacter = tmpString.charAt(tmpString.length() - 1)) == '-' || lastCharacter == '=' || lastCharacter == '#') {
            tmpString = tmpString.substring(0, tmpString.length() - 1);
        }
        while (tmpString.length() > 0) {
            Character nextChar = Character.valueOf(tmpString.charAt(0));
            tmpString = tmpString.substring(1);
            if (nextChar.charValue() == '(') {
                stack.push(new StackFrame((StackFrame)stack.peek()));
                continue;
            }
            if (nextChar.charValue() == ')') {
                stack.pop();
                continue;
            }
            if (nextChar.charValue() == '-') {
                ((StackFrame)stack.peek()).bondOrder = 1;
                continue;
            }
            if (nextChar.charValue() == '=') {
                if (((StackFrame)stack.peek()).bondOrder != 1) {
                    throw new StructureBuildingException("= in unexpected position: bond order already defined!");
                }
                ((StackFrame)stack.peek()).bondOrder = 2;
                continue;
            }
            if (nextChar.charValue() == '#') {
                if (((StackFrame)stack.peek()).bondOrder != 1) {
                    throw new StructureBuildingException("# in unexpected position: bond order already defined!");
                }
                ((StackFrame)stack.peek()).bondOrder = 3;
                continue;
            }
            if (nextChar.charValue() == '/') {
                if (((StackFrame)stack.peek()).slash != null) {
                    throw new StructureBuildingException("/ in unexpected position: bond configuration already defined!");
                }
                ((StackFrame)stack.peek()).slash = Bond.SMILES_BOND_DIRECTION.RSLASH;
                continue;
            }
            if (nextChar.charValue() == '\\') {
                if (((StackFrame)stack.peek()).slash != null) {
                    throw new StructureBuildingException("\\ in unexpected position: bond configuration already defined!");
                }
                ((StackFrame)stack.peek()).slash = Bond.SMILES_BOND_DIRECTION.LSLASH;
                continue;
            }
            if (nextChar.charValue() == '.') {
                ((StackFrame)stack.peek()).atom = null;
                continue;
            }
            if (Character.isLetter(nextChar.charValue())) {
                String elementType = String.valueOf(nextChar);
                boolean spareValency = false;
                if (Character.isUpperCase(nextChar.charValue())) {
                    if (tmpString.length() > 0 && Character.isLowerCase(tmpString.charAt(0)) && organicAtoms.contains(elementType + tmpString.substring(0, 1))) {
                        elementType = elementType + tmpString.substring(0, 1);
                        tmpString = tmpString.substring(1);
                    } else if (!organicAtoms.contains(elementType)) {
                        throw new StructureBuildingException(elementType + " is not an organic Element. If it is actually an element it should be in square brackets");
                    }
                } else if (Character.isLowerCase(nextChar.charValue())) {
                    if (!aromaticAtoms.contains(elementType)) {
                        throw new StructureBuildingException(elementType + " is not an aromatic Element. If it is actually an element it should not be in lower case");
                    }
                    elementType = elementType.toUpperCase();
                    spareValency = true;
                }
                Atom atom = fragManager.createAtom(elementType, currentFrag);
                atom.setSpareValency(spareValency);
                if (labelMapping.equals("numeric")) {
                    atom.addLocant(Integer.toString(currentNumber));
                } else if (labelMap != null) {
                    String[] labels;
                    for (String label : labels = OpsinTools.MATCH_COMMA.split(labelMap[currentNumber - 1])) {
                        if (label.equals("")) continue;
                        atom.addLocant(label);
                    }
                }
                currentFrag.addAtom(atom);
                if (stack.peek().atom != null) {
                    Bond b = fragManager.createBond(stack.peek().atom, atom, stack.peek().bondOrder);
                    if (stack.peek().slash != null) {
                        b.setSmilesStereochemistry(stack.peek().slash);
                        stack.peek().slash = null;
                    }
                    if (stack.peek().atom.getAtomParity() != null) {
                        this.addAtomToAtomParity(stack.peek().atom.getAtomParity(), atom);
                    }
                }
                stack.peek().atom = atom;
                stack.peek().bondOrder = 1;
                ++currentNumber;
                continue;
            }
            if (nextChar.charValue() == '[') {
                int indexOfRightSquareBracket = tmpString.indexOf(93);
                if (indexOfRightSquareBracket == -1) {
                    throw new StructureBuildingException("[ without matching \"]\"");
                }
                String atomString = tmpString.substring(0, indexOfRightSquareBracket);
                tmpString = tmpString.substring(indexOfRightSquareBracket + 1);
                String isotope = "";
                while (atomString.length() > 0 && Character.isDigit(atomString.charAt(0))) {
                    isotope = isotope + atomString.charAt(0);
                    atomString = atomString.substring(1);
                }
                if (atomString.length() <= 0) {
                    throw new StructureBuildingException("No element found in square brackets");
                }
                nextChar = Character.valueOf(atomString.charAt(0));
                atomString = atomString.substring(1);
                String elementType = String.valueOf(nextChar);
                boolean spareValency = false;
                if (Character.isUpperCase(nextChar.charValue())) {
                    if (atomString.length() > 0 && Character.isLowerCase(atomString.charAt(0))) {
                        elementType = elementType + atomString.substring(0, 1);
                        atomString = atomString.substring(1);
                    }
                } else if (Character.isLowerCase(nextChar.charValue())) {
                    if (atomString.length() > 0 && Character.isLowerCase(atomString.charAt(0))) {
                        if (!aromaticAtoms.contains(elementType + atomString.substring(0, 1))) throw new StructureBuildingException(elementType + atomString.substring(0, 1) + " is not an aromatic Element. If it is actually an element it should not be in lower case");
                        elementType = elementType.toUpperCase() + atomString.substring(0, 1);
                        atomString = atomString.substring(1);
                    } else {
                        if (!aromaticAtoms.contains(elementType)) {
                            throw new StructureBuildingException(elementType + " is not an aromatic Element.");
                        }
                        elementType = elementType.toUpperCase();
                    }
                    spareValency = true;
                } else {
                    if (!elementType.equals("*")) throw new StructureBuildingException(elementType + " is not a valid element type!");
                    elementType = "R";
                }
                Atom atom = fragManager.createAtom(elementType, currentFrag);
                atom.setSpareValency(spareValency);
                if (!isotope.equals("")) {
                    atom.setIsotope(Integer.parseInt(isotope));
                }
                if (labelMapping.equals("numeric")) {
                    atom.addLocant(Integer.toString(currentNumber));
                } else if (labelMap != null) {
                    String[] labels;
                    for (String label : labels = OpsinTools.MATCH_COMMA.split(labelMap[currentNumber - 1])) {
                        if (label.equals("")) continue;
                        atom.addLocant(label);
                    }
                }
                currentFrag.addAtom(atom);
                if (stack.peek().atom != null) {
                    Bond b = fragManager.createBond(stack.peek().atom, atom, stack.peek().bondOrder);
                    if (stack.peek().slash != null) {
                        b.setSmilesStereochemistry(stack.peek().slash);
                        stack.peek().slash = null;
                    }
                    if (stack.peek().atom.getAtomParity() != null) {
                        this.addAtomToAtomParity(stack.peek().atom.getAtomParity(), atom);
                    }
                }
                Atom previousAtom = stack.peek().atom;
                stack.peek().atom = atom;
                stack.peek().bondOrder = 1;
                ++currentNumber;
                Integer hydrogenCount = 0;
                int charge = 0;
                Boolean chiralitySet = false;
                while (atomString.length() > 0) {
                    nextChar = Character.valueOf(atomString.charAt(0));
                    atomString = atomString.substring(1);
                    if (nextChar.charValue() == '@') {
                        if (chiralitySet.booleanValue()) {
                            throw new StructureBuildingException("Atom parity appeared to be specified twice for an atom in a square bracket!");
                        }
                        atomString = this.processTetrahedralStereochemistry(atomString, atom, previousAtom);
                        chiralitySet = true;
                        continue;
                    }
                    if (nextChar.charValue() == 'H') {
                        if (hydrogenCount == null || hydrogenCount != 0) {
                            throw new StructureBuildingException("Hydrogen count appeared to be specified twice for an atom in a square bracket!");
                        }
                        if (atomString.length() > 0 && atomString.charAt(0) == '?') {
                            atomString = atomString.substring(1);
                            hydrogenCount = null;
                            continue;
                        }
                        String hydrogenCountString = "";
                        while (atomString.length() > 0 && Character.isDigit(atomString.charAt(0))) {
                            hydrogenCountString = hydrogenCountString + atomString.substring(0, 1);
                            atomString = atomString.substring(1);
                        }
                        hydrogenCount = hydrogenCountString.equals("") ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(hydrogenCountString));
                        if (!atom.hasSpareValency()) continue;
                        currentFrag.addIndicatedHydrogen(atom);
                        continue;
                    }
                    if (nextChar.charValue() == '+' || nextChar.charValue() == '-') {
                        if (charge != 0) {
                            throw new StructureBuildingException("Charge appeared to be specified twice for an atom in a square bracket!");
                        }
                        charge = nextChar.charValue() == '+' ? 1 : -1;
                        String changeChargeStr = "";
                        int changeCharge = 1;
                        while (atomString.length() > 0 && Character.isDigit(atomString.charAt(0))) {
                            changeChargeStr = changeChargeStr + atomString.substring(0, 1);
                            atomString = atomString.substring(1);
                        }
                        if (changeChargeStr.equals("")) {
                            while (atomString.length() > 0) {
                                nextChar = Character.valueOf(atomString.charAt(0));
                                if (nextChar.charValue() == '+') {
                                    if (charge != 1) {
                                        throw new StructureBuildingException("Atom has both positive and negative charges specified!");
                                    }
                                } else {
                                    if (nextChar.charValue() != '-') break;
                                    if (charge != -1) {
                                        throw new StructureBuildingException("Atom has both negative and positive charges specified!");
                                    }
                                }
                                ++changeCharge;
                                atomString = atomString.substring(1);
                            }
                        }
                        changeCharge = changeChargeStr.equals("") ? changeCharge : Integer.parseInt(changeChargeStr);
                        atom.setCharge(atom.getCharge() + charge * changeCharge);
                        continue;
                    }
                    if (nextChar.charValue() != '|') throw new StructureBuildingException("Unexpected character found in square bracket");
                    String lambda = "";
                    while (atomString.length() > 0 && Character.isDigit(atomString.charAt(0))) {
                        lambda = lambda + atomString.substring(0, 1);
                        atomString = atomString.substring(1);
                    }
                    atom.setLambdaConventionValency(Integer.parseInt(lambda));
                }
                atom.setProperty(Atom.SMILES_HYDROGEN_COUNT, hydrogenCount);
                continue;
            }
            if (!Character.isDigit(nextChar.charValue()) && nextChar.charValue() != '%') throw new StructureBuildingException(nextChar + " is in an unexpected position. Check this is not a mistake and that this feature of SMILES is supported by OPSIN's SMILES parser");
            tmpString = this.processRingOpeningOrClosure(fragManager, stack, closures, tmpString, nextChar);
        }
        if (labelMap != null && labelMap.length >= currentNumber) {
            throw new StructureBuildingException("Group numbering has been invalidly defined in resource file: labels: " + labelMap.length + ", atoms: " + (currentNumber - 1));
        }
        if (!closures.isEmpty()) {
            throw new StructureBuildingException("Unmatched ring opening");
        }
        if (labelMapping.equals("fusedRing")) {
            FragmentTools.relabelFusedRingSystem(currentFrag);
        }
        List<Atom> atomList = currentFrag.getAtomList();
        this.verifyAndTakeIntoAccountLonePairsInAtomParities(atomList);
        this.addBondStereoElements(currentFrag);
        if (lastCharacter == '-' || lastCharacter == '=' || lastCharacter == '#') {
            Atom lastAtom = ((StackFrame)stack.peek()).atom;
            if (lastCharacter == '#') {
                currentFrag.addOutAtom(lastAtom, 3, (Boolean)true);
            } else if (lastCharacter == '=') {
                currentFrag.addOutAtom(lastAtom, 2, (Boolean)true);
            } else {
                currentFrag.addOutAtom(lastAtom, 1, (Boolean)true);
            }
        }
        if (firstCharacter == '-') {
            currentFrag.addOutAtom(currentFrag.getFirstAtom(), 1, (Boolean)true);
        } else if (firstCharacter == '=') {
            currentFrag.addOutAtom(currentFrag.getFirstAtom(), 2, (Boolean)true);
        } else if (firstCharacter == '#') {
            currentFrag.addOutAtom(currentFrag.getFirstAtom(), 3, (Boolean)true);
        }
        for (Atom atom : atomList) {
            if (atom.getProperty(Atom.SMILES_HYDROGEN_COUNT) == null || atom.getLambdaConventionValency() != null) continue;
            this.setupAtomValency(fragManager, atom);
        }
        CycleDetector.assignWhetherAtomsAreInCycles(currentFrag);
        return currentFrag;
    }

    private String processTetrahedralStereochemistry(String atomString, Atom atom, Atom previousAtom) {
        Boolean chiralityClockwise = false;
        if (atomString.length() > 0 && atomString.charAt(0) == '@') {
            chiralityClockwise = true;
            atomString = atomString.substring(1);
        }
        AtomParity atomParity = chiralityClockwise != false ? new AtomParity(new Atom[4], 1) : new AtomParity(new Atom[4], -1);
        Atom[] atomRefs4 = atomParity.getAtomRefs4();
        int indice = 0;
        if (previousAtom != null) {
            atomRefs4[indice] = previousAtom;
            ++indice;
        }
        if (atomString.length() > 0 && atomString.charAt(0) == 'H') {
            atomRefs4[indice] = AtomParity.hydrogen;
        }
        atom.setAtomParity(atomParity);
        return atomString;
    }

    private String processRingOpeningOrClosure(FragmentManager fragManager, Stack<StackFrame> stack, HashMap<String, StackFrame> closures, String tmpString, Character nextChar) throws StructureBuildingException {
        String closure = String.valueOf(nextChar);
        if (nextChar.charValue() == '%') {
            if (tmpString.length() >= 2 && Character.isDigit(tmpString.charAt(0)) && Character.isDigit(tmpString.charAt(1))) {
                closure = tmpString.substring(0, 2);
                tmpString = tmpString.substring(2);
            } else {
                throw new StructureBuildingException("A ring opening indice after a % must be two digits long");
            }
        }
        if (closures.containsKey(closure)) {
            this.processRingClosure(fragManager, stack, closures, closure);
        } else {
            if (stack.peek().atom == null) {
                throw new StructureBuildingException("A ring opening has appeared before any atom!");
            }
            this.processRingOpening(stack, closures, closure);
        }
        return tmpString;
    }

    private void processRingOpening(Stack<StackFrame> stack, HashMap<String, StackFrame> closures, String closure) throws StructureBuildingException {
        StackFrame sf = new StackFrame(stack.peek());
        if (stack.peek().slash != null) {
            sf.slash = stack.peek().slash;
            stack.peek().slash = null;
        }
        if (sf.atom.getAtomParity() != null) {
            Atom dummyRingClosureAtom = new Atom(closure);
            this.addAtomToAtomParity(sf.atom.getAtomParity(), dummyRingClosureAtom);
        }
        closures.put(closure, sf);
        stack.peek().bondOrder = 1;
    }

    private void addAtomToAtomParity(AtomParity atomParity, Atom atom) throws StructureBuildingException {
        Atom[] atomRefs4 = atomParity.getAtomRefs4();
        boolean setAtom = false;
        for (int i = 0; i < atomRefs4.length; ++i) {
            if (atomRefs4[i] != null) continue;
            atomRefs4[i] = atom;
            setAtom = true;
            break;
        }
        if (!setAtom) {
            throw new StructureBuildingException("Tetrahedral stereocentre specified in SMILES appears to involve more than 4 atoms");
        }
    }

    private void processRingClosure(FragmentManager fragManager, Stack<StackFrame> stack, HashMap<String, StackFrame> closures, String closure) throws StructureBuildingException {
        AtomParity atomParity;
        StackFrame sf = closures.remove(closure);
        int bondOrder = 1;
        if (sf.bondOrder > 1) {
            if (stack.peek().bondOrder > 1 && sf.bondOrder != stack.peek().bondOrder) {
                throw new StructureBuildingException("ring closure has two different bond orders specified!");
            }
            bondOrder = sf.bondOrder;
        } else if (stack.peek().bondOrder > 1) {
            bondOrder = stack.peek().bondOrder;
        }
        Bond b = stack.peek().slash == null ? fragManager.createBond(sf.atom, stack.peek().atom, bondOrder) : fragManager.createBond(stack.peek().atom, sf.atom, bondOrder);
        if (sf.slash != null) {
            if (stack.peek().slash != null) {
                if (sf.slash.equals((Object)stack.peek().slash)) {
                    throw new StructureBuildingException("Contradictory double bond stereoconfiguration");
                }
            } else {
                b.setSmilesStereochemistry(sf.slash);
            }
        } else if (stack.peek().slash != null) {
            b.setSmilesStereochemistry(stack.peek().slash);
            stack.peek().slash = null;
        }
        if (stack.peek().atom.getAtomParity() != null) {
            atomParity = stack.peek().atom.getAtomParity();
            this.addAtomToAtomParity(atomParity, sf.atom);
        }
        if (sf.atom.getAtomParity() != null) {
            atomParity = sf.atom.getAtomParity();
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            boolean replacedAtom = false;
            for (int i = 0; i < atomRefs4.length; ++i) {
                if (atomRefs4[i] == null || !atomRefs4[i].getElement().equals(closure)) continue;
                atomRefs4[i] = stack.peek().atom;
                replacedAtom = true;
                break;
            }
            if (!replacedAtom) {
                throw new StructureBuildingException("Unable to find ring closure atom in atomRefs4 of atomparity when building SMILES");
            }
        }
        stack.peek().bondOrder = 1;
    }

    private void verifyAndTakeIntoAccountLonePairsInAtomParities(List<Atom> atomList) throws StructureBuildingException {
        for (Atom atom : atomList) {
            AtomParity atomParity = atom.getAtomParity();
            if (atomParity == null) continue;
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            int nullAtoms = 0;
            int hydrogen = 0;
            for (Atom atomRefs4Atom : atomRefs4) {
                if (atomRefs4Atom == null) {
                    ++nullAtoms;
                    continue;
                }
                if (!atomRefs4Atom.equals(AtomParity.hydrogen)) continue;
                ++hydrogen;
            }
            if (nullAtoms == 0) continue;
            if (nullAtoms == 1 && hydrogen == 0 && (atom.getElement().equals("S") || atom.getElement().equals("Se"))) {
                if (atomList.indexOf(atomRefs4[0]) < atomList.indexOf(atom)) {
                    atomRefs4[3] = atomRefs4[2];
                    atomRefs4[2] = atomRefs4[1];
                    atomRefs4[1] = atom;
                    continue;
                }
                atomRefs4[3] = atomRefs4[2];
                atomRefs4[2] = atomRefs4[1];
                atomRefs4[1] = atomRefs4[0];
                atomRefs4[0] = atom;
                continue;
            }
            throw new StructureBuildingException("SMILES is malformed. Tetrahedral stereochemistry defined on a non tetrahedral centre");
        }
    }

    private void addBondStereoElements(Fragment currentFrag) throws StructureBuildingException {
        Set<Bond> bonds = currentFrag.getBondSet();
        for (Bond centralBond : bonds) {
            if (centralBond.getOrder() != 2) continue;
            Set<Bond> fromAtomBonds = centralBond.getFromAtom().getBonds();
            for (Bond preceedingBond : fromAtomBonds) {
                if (preceedingBond.getSmilesStereochemistry() == null) continue;
                Set<Bond> toAtomBonds = centralBond.getToAtom().getBonds();
                for (Bond followingBond : toAtomBonds) {
                    Atom[] atomRefs4;
                    BondStereo.BondStereoValue cisTrans;
                    boolean upSecond;
                    boolean upFirst;
                    if (followingBond.getSmilesStereochemistry() == null) continue;
                    Atom atom2 = centralBond.getFromAtom();
                    Atom atom1 = atom2 == preceedingBond.getToAtom() ? preceedingBond.getFromAtom() : preceedingBond.getToAtom();
                    Atom atom3 = centralBond.getToAtom();
                    Atom atom4 = atom3 == followingBond.getFromAtom() ? followingBond.getToAtom() : followingBond.getFromAtom();
                    if (preceedingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.LSLASH) {
                        upFirst = preceedingBond.getToAtom() == atom2;
                    } else if (preceedingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH) {
                        upFirst = preceedingBond.getToAtom() != atom2;
                    } else {
                        throw new StructureBuildingException((Object)((Object)preceedingBond.getSmilesStereochemistry()) + " is not a slash!");
                    }
                    if (followingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.LSLASH) {
                        upSecond = followingBond.getFromAtom() != atom3;
                    } else if (followingBond.getSmilesStereochemistry() == Bond.SMILES_BOND_DIRECTION.RSLASH) {
                        upSecond = followingBond.getFromAtom() == atom3;
                    } else {
                        throw new StructureBuildingException((Object)((Object)followingBond.getSmilesStereochemistry()) + " is not a slash!");
                    }
                    BondStereo.BondStereoValue bondStereoValue = cisTrans = upFirst == upSecond ? BondStereo.BondStereoValue.CIS : BondStereo.BondStereoValue.TRANS;
                    if (centralBond.getBondStereo() != null) {
                        atomRefs4 = centralBond.getBondStereo().getAtomRefs4();
                        if (!(atomRefs4[0].equals(atom1) || atomRefs4[3].equals(atom4) ? centralBond.getBondStereo().getBondStereoValue().equals((Object)cisTrans) : !centralBond.getBondStereo().getBondStereoValue().equals((Object)cisTrans))) continue;
                        throw new StructureBuildingException("Contradictory double bond stereoconfiguration");
                    }
                    atomRefs4 = new Atom[]{atom1, atom2, atom3, atom4};
                    centralBond.setBondStereoElement(atomRefs4, cisTrans);
                }
            }
        }
        for (Bond bond : bonds) {
            bond.setSmilesStereochemistry(null);
        }
    }

    private void setupAtomValency(FragmentManager fragManager, Atom atom) throws StructureBuildingException {
        block10: {
            int hydrogenCount;
            block9: {
                Integer defaultVal;
                hydrogenCount = atom.getProperty(Atom.SMILES_HYDROGEN_COUNT);
                int incomingValency = atom.getIncomingValency() + hydrogenCount + atom.getOutValency();
                int charge = atom.getCharge();
                int absoluteCharge = Math.abs(charge);
                String element = atom.getElement();
                if (atom.hasSpareValency()) {
                    Integer hwValency;
                    if (element.equals("C")) {
                        hwValency = 4;
                    } else {
                        hwValency = ValencyChecker.getHWValency(element);
                        if (hwValency == null) {
                            throw new StructureBuildingException(element + " is not expected to be aromatic!");
                        }
                    }
                    if (incomingValency < hwValency + absoluteCharge) {
                        ++incomingValency;
                    }
                }
                if ((defaultVal = ValencyChecker.getDefaultValency(element)) == null) break block9;
                if (defaultVal == incomingValency && charge == 0) break block10;
                Integer[] unchargedStableValencies = ValencyChecker.getPossibleValencies(element, 0);
                boolean hasPlausibleValency = false;
                for (Integer unchargedStableValency : unchargedStableValencies) {
                    if (Math.abs(incomingValency - unchargedStableValency) != Math.abs(charge)) continue;
                    atom.setProtonsExplicitlyAddedOrRemoved(incomingValency - unchargedStableValency);
                    if (!unchargedStableValency.equals(defaultVal)) {
                        atom.setMinimumValency(unchargedStableValency);
                    }
                    hasPlausibleValency = true;
                    break;
                }
                if (hasPlausibleValency) break block10;
                atom.setMinimumValency(incomingValency);
                break block10;
            }
            if (hydrogenCount > 0) {
                Fragment frag = atom.getFrag();
                for (int i = 0; i < hydrogenCount; ++i) {
                    Atom hydrogen = fragManager.createAtom("H", frag);
                    fragManager.createBond(atom, hydrogen, 1);
                }
            }
        }
    }

    static {
        organicAtoms.add("B");
        organicAtoms.add("C");
        organicAtoms.add("N");
        organicAtoms.add("O");
        organicAtoms.add("P");
        organicAtoms.add("S");
        organicAtoms.add("F");
        organicAtoms.add("Cl");
        organicAtoms.add("Br");
        organicAtoms.add("I");
        aromaticAtoms.add("c");
        aromaticAtoms.add("n");
        aromaticAtoms.add("o");
        aromaticAtoms.add("p");
        aromaticAtoms.add("s");
        aromaticAtoms.add("as");
        aromaticAtoms.add("se");
        aromaticAtoms.add("sb");
        aromaticAtoms.add("te");
    }

    private static class StackFrame {
        Atom atom;
        int bondOrder;
        Bond.SMILES_BOND_DIRECTION slash;

        StackFrame(Atom a, int bondOrderVal) {
            this.atom = a;
            this.bondOrder = bondOrderVal;
            this.slash = null;
        }

        StackFrame(StackFrame sf) {
            this.atom = sf.atom;
            this.bondOrder = sf.bondOrder;
        }
    }
}

