/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.PreProcessingException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class PreProcessor {
    private static final Pattern MATCH_DOLLAR = Pattern.compile("\\$");
    private static final Pattern MATCH_SULPH = Pattern.compile("sulph", 2);
    private static final Pattern MATCH_DOT_GREEK_DOT = Pattern.compile("\\.(alpha|beta|gamma|delta|epsilon|zeta|eta|omega)\\.", 2);
    private static final HashMap<String, String> GREEK_MAP = new HashMap();

    PreProcessor() {
    }

    static String preProcess(String chemicalName) throws PreProcessingException {
        if ("".equals(chemicalName = chemicalName.trim())) {
            throw new PreProcessingException("Input chemical name was blank!");
        }
        chemicalName = PreProcessor.processDollarPrefixedGreeks(chemicalName);
        chemicalName = PreProcessor.processDotSurroundedGreeks(chemicalName);
        chemicalName = StringTools.convertNonAsciiAndNormaliseRepresentation(chemicalName);
        chemicalName = MATCH_SULPH.matcher(chemicalName).replaceAll("sulf");
        return chemicalName;
    }

    private static String processDollarPrefixedGreeks(String chemicalName) {
        Matcher m = MATCH_DOLLAR.matcher(chemicalName);
        while (m.find()) {
            String letter2;
            if (chemicalName.length() <= m.end() || !GREEK_MAP.containsKey(letter2 = chemicalName.substring(m.end(), m.end() + 1).toLowerCase())) continue;
            chemicalName = chemicalName.substring(0, m.end() - 1) + GREEK_MAP.get(letter2) + chemicalName.substring(m.end() + 1);
            m = MATCH_DOLLAR.matcher(chemicalName);
        }
        return chemicalName;
    }

    private static String processDotSurroundedGreeks(String chemicalName) {
        Matcher m = MATCH_DOT_GREEK_DOT.matcher(chemicalName);
        while (m.find()) {
            chemicalName = chemicalName.substring(0, m.start()) + m.group(1) + chemicalName.substring(m.end());
            m = MATCH_DOT_GREEK_DOT.matcher(chemicalName);
        }
        return chemicalName;
    }

    static {
        GREEK_MAP.put("a", "alpha");
        GREEK_MAP.put("b", "beta");
        GREEK_MAP.put("g", "gamma");
        GREEK_MAP.put("d", "delta");
        GREEK_MAP.put("e", "epsilon");
        GREEK_MAP.put("l", "lambda");
    }
}

