/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.RunAutomaton;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.OpsinRadixTrie;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;

public class ParseRules {
    private RunAutomaton chemAutomaton;
    private char[] stateSymbols;
    private final ResourceManager resourceManager;

    ParseRules(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.chemAutomaton = resourceManager.chemicalAutomaton;
        this.stateSymbols = this.chemAutomaton.getCharIntervals();
    }

    public ParseRulesResults getParses(String chemicalWord) throws ParsingException {
        AnnotatorState startingAS = new AnnotatorState();
        startingAS.state = this.chemAutomaton.getInitialState();
        startingAS.annot = new ArrayList<Character>();
        startingAS.tokens = new ArrayList();
        startingAS.untokenisedChemicalName = chemicalWord;
        startingAS.untokenisedChemicalNameLowerCase = chemicalWord.toLowerCase();
        Stack<AnnotatorState> asStack = new Stack<AnnotatorState>();
        asStack.add(startingAS);
        int wordLengthRemainingOnLastSuccessfulAnnotations = chemicalWord.length();
        int wordLengthRemainingOnLongestAnnotation = chemicalWord.length();
        ArrayList<AnnotatorState> successfulAnnotations = new ArrayList<AnnotatorState>();
        AnnotatorState longestAnnotation = new AnnotatorState();
        longestAnnotation.state = this.chemAutomaton.getInitialState();
        longestAnnotation.annot = new ArrayList<Character>();
        longestAnnotation.tokens = new ArrayList();
        longestAnnotation.untokenisedChemicalName = chemicalWord;
        longestAnnotation.untokenisedChemicalNameLowerCase = chemicalWord.toLowerCase();
        int stateSymbolsSize = this.stateSymbols.length;
        while (!asStack.isEmpty()) {
            AnnotatorState as = (AnnotatorState)asStack.pop();
            String untokenisedChemicalNameLowerCase = as.untokenisedChemicalNameLowerCase;
            String untokenisedChemicalName = as.untokenisedChemicalName;
            int wordLength = untokenisedChemicalNameLowerCase.length();
            if (this.chemAutomaton.isAccept(as.state) && wordLength <= wordLengthRemainingOnLastSuccessfulAnnotations) {
                if (wordLength < wordLengthRemainingOnLastSuccessfulAnnotations) {
                    successfulAnnotations.clear();
                    wordLengthRemainingOnLastSuccessfulAnnotations = wordLength;
                } else if (successfulAnnotations.size() > 128) {
                    throw new ParsingException("Ambiguity in OPSIN's chemical grammar has produced more than 128 annotations. Parsing has been aborted. Please report this as a bug");
                }
                successfulAnnotations.add(as);
            }
            if (wordLength < wordLengthRemainingOnLongestAnnotation) {
                wordLengthRemainingOnLongestAnnotation = wordLength;
                longestAnnotation = as;
            }
            for (int i = 0; i < stateSymbolsSize; ++i) {
                List<Pattern> possibleRegexes;
                List<RunAutomaton> possibleAutomata;
                List<Integer> possibleTokenisations;
                char annotationCharacter = this.stateSymbols[i];
                int potentialNextState = this.chemAutomaton.step(as.state, annotationCharacter);
                if (potentialNextState == -1) continue;
                OpsinRadixTrie possibleTokenisationsTrie = this.resourceManager.symbolTokenNamesDict[i];
                if (possibleTokenisationsTrie != null && (possibleTokenisations = possibleTokenisationsTrie.findLengthsOfMatches(untokenisedChemicalNameLowerCase)) != null) {
                    Iterator<Serializable> i$ = possibleTokenisations.iterator();
                    while (i$.hasNext()) {
                        int tokenizationLength = (Integer)i$.next();
                        AnnotatorState newAs = new AnnotatorState();
                        newAs.untokenisedChemicalName = untokenisedChemicalName.substring(tokenizationLength);
                        newAs.untokenisedChemicalNameLowerCase = untokenisedChemicalNameLowerCase.substring(tokenizationLength);
                        newAs.tokens = new ArrayList<String>(as.tokens);
                        newAs.tokens.add(untokenisedChemicalNameLowerCase.substring(0, tokenizationLength));
                        newAs.annot = new ArrayList<Character>(as.annot);
                        newAs.annot.add(Character.valueOf(annotationCharacter));
                        newAs.state = potentialNextState;
                        asStack.add(newAs);
                    }
                }
                if ((possibleAutomata = this.resourceManager.symbolRegexAutomataDict[i]) != null) {
                    for (RunAutomaton automaton : possibleAutomata) {
                        int matchLength = automaton.run(untokenisedChemicalName, 0);
                        if (matchLength == -1) continue;
                        AnnotatorState newAs = new AnnotatorState();
                        newAs.untokenisedChemicalName = untokenisedChemicalName.substring(matchLength);
                        newAs.untokenisedChemicalNameLowerCase = untokenisedChemicalNameLowerCase.substring(matchLength);
                        newAs.tokens = new ArrayList<String>(as.tokens);
                        newAs.tokens.add(untokenisedChemicalName.substring(0, matchLength));
                        newAs.annot = new ArrayList<Character>(as.annot);
                        newAs.annot.add(Character.valueOf(annotationCharacter));
                        newAs.state = potentialNextState;
                        asStack.add(newAs);
                    }
                }
                if ((possibleRegexes = this.resourceManager.symbolRegexesDict[i]) == null) continue;
                for (Pattern pattern : possibleRegexes) {
                    Matcher mat = pattern.matcher(untokenisedChemicalName);
                    if (!mat.lookingAt()) continue;
                    AnnotatorState newAs = new AnnotatorState();
                    newAs.untokenisedChemicalName = untokenisedChemicalName.substring(mat.group(0).length());
                    newAs.untokenisedChemicalNameLowerCase = untokenisedChemicalNameLowerCase.substring(mat.group(0).length());
                    newAs.tokens = new ArrayList<String>(as.tokens);
                    newAs.tokens.add(mat.group(0));
                    newAs.annot = new ArrayList<Character>(as.annot);
                    newAs.annot.add(Character.valueOf(annotationCharacter));
                    newAs.state = potentialNextState;
                    asStack.add(newAs);
                }
            }
        }
        ArrayList<ParseTokens> outputList = new ArrayList<ParseTokens>();
        String uninterpretableName = chemicalWord;
        String unparseableName = longestAnnotation.untokenisedChemicalName;
        if (successfulAnnotations.size() > 0) {
            for (AnnotatorState as : successfulAnnotations) {
                ParseTokens pt = new ParseTokens(as.tokens, as.annot);
                outputList.add(pt);
                uninterpretableName = as.untokenisedChemicalName;
            }
        }
        return new ParseRulesResults(outputList, uninterpretableName, unparseableName);
    }

    private static class AnnotatorState {
        int state;
        List<Character> annot;
        ArrayList<String> tokens;
        String untokenisedChemicalName;
        String untokenisedChemicalNameLowerCase;

        private AnnotatorState() {
        }
    }
}

