/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.WordType;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpsinTools {
    static final Pattern MATCH_COLON = Pattern.compile(":");
    static final Pattern MATCH_COMMA = Pattern.compile(",");
    static final Pattern MATCH_DASH = Pattern.compile("-");
    static final Pattern MATCH_SEMICOLON = Pattern.compile(";");
    static final Pattern MATCH_SLASH = Pattern.compile("/");
    static final Pattern MATCH_SPACE = Pattern.compile(" ");
    static final Pattern MATCH_WHITESPACE = Pattern.compile("\\s+");
    static final Pattern MATCH_AMINOACID_STYLE_LOCANT = Pattern.compile("([A-Z][a-z]?)('*)((\\d+[a-z]?|alpha|beta|gamma|delta|epsilon|zeta|eta|omega)'*)");
    static final Pattern MATCH_ELEMENT_SYMBOL = Pattern.compile("[A-Z][a-z]?");
    static final Pattern MATCH_ELEMENT_SYMBOL_LOCANT = Pattern.compile("[A-Z][a-z]?'*");
    static final Pattern MATCH_NUMERIC_LOCANT = Pattern.compile("\\d+[a-z]?'*");
    static final char END_OF_SUBSTITUENT = '\u00e9';
    static final char END_OF_MAINGROUP = '\u00e2';
    static final char END_OF_FUNCTIONALTERM = '\u00fb';

    OpsinTools() {
    }

    static Element getNextNonChargeSuffix(Element currentEl) {
        Element next2 = (Element)XOMTools.getNextSibling(currentEl);
        while (next2 != null) {
            if (next2.getLocalName().equals("suffix") && !"charge".equals(next2.getAttributeValue("type"))) {
                return next2;
            }
            next2 = (Element)XOMTools.getNextSibling(next2);
        }
        return null;
    }

    static ArrayList<Element> elementsToElementArrayList(Elements elements) {
        ArrayList<Element> elementList = new ArrayList<Element>(elements.size());
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            elementList.add(elements.get(i));
        }
        return elementList;
    }

    static ArrayList<Element> combineElementLists(List<Element> list1, List<Element> list2) {
        ArrayList<Element> elementList = new ArrayList<Element>(list1);
        elementList.addAll(list2);
        return elementList;
    }

    static Node getPreviousGroup(Element current) {
        Element parent;
        if (current.getLocalName().equals("group")) {
            current = (Element)current.getParent();
        }
        if ((parent = (Element)current.getParent()) == null || parent.getLocalName().equals("wordRule")) {
            return null;
        }
        int index = parent.indexOf(current);
        if (index == 0) {
            return OpsinTools.getPreviousGroup(parent);
        }
        Element previous = (Element)parent.getChild(index - 1);
        Elements children2 = previous.getChildElements();
        while (children2.size() != 0) {
            previous = children2.get(children2.size() - 1);
            children2 = previous.getChildElements();
        }
        Elements groups = ((Element)previous.getParent()).getChildElements("group");
        if (groups.size() == 0) {
            return OpsinTools.getPreviousGroup(previous);
        }
        return groups.get(groups.size() - 1);
    }

    static Node getNextGroup(Element current) {
        Element parent;
        if (current.getLocalName().equals("group")) {
            current = (Element)current.getParent();
        }
        if ((parent = (Element)current.getParent()) == null || parent.getLocalName().equals("molecule")) {
            return null;
        }
        int index = parent.indexOf(current);
        if (index == parent.getChildElements().size() - 1) {
            return OpsinTools.getNextGroup(parent);
        }
        Element next2 = (Element)parent.getChild(index + 1);
        Elements children2 = next2.getChildElements();
        while (children2.size() != 0) {
            next2 = children2.get(0);
            children2 = next2.getChildElements();
        }
        Elements groups = ((Element)next2.getParent()).getChildElements("group");
        if (groups.size() == 0) {
            return OpsinTools.getNextGroup(next2);
        }
        return groups.get(0);
    }

    static Element getParentWordRule(Element el) {
        Element parent;
        for (parent = (Element)el.getParent(); parent != null && !parent.getLocalName().equals("wordRule"); parent = (Element)parent.getParent()) {
        }
        if (parent == null) {
            throw new RuntimeException("Cannot find enclosing wordRule element");
        }
        return parent;
    }

    static Element shallowCopy(Element elem2) {
        Element newElem = new Element(elem2.getLocalName());
        int attributeCount = elem2.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            newElem.addAttribute(new Attribute(elem2.getAttribute(i)));
        }
        return newElem;
    }

    static Atom depthFirstSearchForNonSuffixAtomWithLocant(Atom startingAtom, String targetLocant) {
        LinkedList<Atom> stack = new LinkedList<Atom>();
        stack.add(startingAtom);
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        while (stack.size() > 0) {
            Atom currentAtom = (Atom)stack.removeLast();
            atomsVisited.add(currentAtom);
            List<Atom> neighbours = currentAtom.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (atomsVisited.contains(neighbour)) continue;
                ArrayList<String> locants = new ArrayList<String>(neighbour.getLocants());
                locants.removeAll(neighbour.getElementSymbolLocants());
                if (locants.size() > 0 && !neighbour.getType().equals("suffix")) {
                    for (String neighbourLocant : locants) {
                        if (!targetLocant.equals(neighbourLocant)) continue;
                        return neighbour;
                    }
                    continue;
                }
                stack.add(neighbour);
            }
        }
        return null;
    }

    static Atom depthFirstSearchForAtomWithNumericLocant(Atom startingAtom) {
        LinkedList<Atom> stack = new LinkedList<Atom>();
        stack.add(startingAtom);
        HashSet<Atom> atomsVisited = new HashSet<Atom>();
        while (stack.size() > 0) {
            Atom currentAtom = (Atom)stack.removeLast();
            atomsVisited.add(currentAtom);
            List<Atom> neighbours = currentAtom.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (atomsVisited.contains(neighbour)) continue;
                List<String> locants = neighbour.getLocants();
                for (String neighbourLocant : locants) {
                    if (!MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                    return neighbour;
                }
                stack.add(neighbour);
            }
        }
        return null;
    }

    static WordType determineWordType(List<Character> annotations) throws ParsingException {
        Character finalAnnotation = annotations.get(annotations.size() - 1);
        if (finalAnnotation.equals(Character.valueOf('\u00e2'))) {
            return WordType.full;
        }
        if (finalAnnotation.equals(Character.valueOf('\u00e9'))) {
            return WordType.substituent;
        }
        if (finalAnnotation.equals(Character.valueOf('\u00fb'))) {
            return WordType.functionalTerm;
        }
        throw new ParsingException("OPSIN bug: Unable to determine word type!");
    }
}

