/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import nu.xom.Element;
import org.apache.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.SMILESWriter;

public class OpsinResult {
    private static final Logger LOG = Logger.getLogger(OpsinResult.class);
    private final Fragment structure;
    private final OPSIN_RESULT_STATUS status;
    private final String message;
    private final String chemicalName;
    private Element cml = null;
    private String smiles = null;

    OpsinResult(Fragment frag, OPSIN_RESULT_STATUS status, String message, String chemicalName) {
        this.structure = frag;
        this.status = status;
        this.message = message;
        this.chemicalName = chemicalName;
    }

    Fragment getStructure() {
        return this.structure;
    }

    public OPSIN_RESULT_STATUS getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getChemicalName() {
        return this.chemicalName;
    }

    public synchronized Element getCml() {
        if (this.cml == null && this.structure != null) {
            try {
                this.cml = this.structure.toCMLMolecule(this.chemicalName);
            }
            catch (Exception e) {
                LOG.debug("CML generation failed", e);
                this.cml = null;
            }
        }
        return this.cml;
    }

    public synchronized String getSmiles() {
        if (this.smiles == null && this.structure != null) {
            try {
                this.smiles = new SMILESWriter(this.structure).generateSmiles();
            }
            catch (Exception e) {
                LOG.debug("SMILES generation failed", e);
                this.smiles = null;
            }
        }
        return this.smiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPSIN_RESULT_STATUS {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

