/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.OpsinTrieNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpsinRadixTrie {
    final OpsinTrieNode rootNode = new OpsinTrieNode("", false);

    OpsinRadixTrie() {
    }

    void addToken(String token2) {
        int tokenLength = token2.length();
        String remaingStr = token2;
        OpsinTrieNode currentNode = this.rootNode;
        int i = 0;
        while (i < tokenLength) {
            int charsMatched = currentNode.getNumberOfMatchingCharacters(remaingStr);
            remaingStr = remaingStr.substring(charsMatched);
            i += charsMatched;
            currentNode = currentNode.add(remaingStr, charsMatched);
        }
        currentNode.setIsEndPoint(true);
    }

    List<Integer> findLengthsOfMatches(String untokenisedChemicalName) {
        OpsinTrieNode node;
        int untokenisedChemicalNameLength = untokenisedChemicalName.length();
        ArrayList<Integer> lengths = null;
        if (this.rootNode.isEndPoint()) {
            lengths = new ArrayList<Integer>();
            lengths.add(0);
        }
        OpsinTrieNode currentNode = this.rootNode;
        for (int i = 0; i < untokenisedChemicalNameLength && (node = currentNode.getChild(untokenisedChemicalName.charAt(i))) != null; ++i) {
            currentNode = node;
            int charsMatched = currentNode.getNumberOfMatchingCharacters(untokenisedChemicalName.substring(i));
            i += charsMatched - 1;
            if (charsMatched != currentNode.getValue().length()) break;
            if (!currentNode.isEndPoint()) continue;
            if (lengths == null) {
                lengths = new ArrayList();
            }
            lengths.add(i + 1);
        }
        return lengths;
    }

    List<Integer> findLengthsOfMatchesReadingStringRightToLeft(String untokenisedChemicalName) {
        OpsinTrieNode node;
        int untokenisedChemicalNameLength = untokenisedChemicalName.length();
        ArrayList<Integer> lengths = null;
        if (this.rootNode.isEndPoint()) {
            lengths = new ArrayList<Integer>();
            lengths.add(0);
        }
        OpsinTrieNode currentNode = this.rootNode;
        for (int i = untokenisedChemicalNameLength - 1; i >= 0 && (node = currentNode.getChild(untokenisedChemicalName.charAt(i))) != null; --i) {
            currentNode = node;
            int charsMatched = currentNode.getNumberOfMatchingCharactersInReverse(untokenisedChemicalName.substring(0, i + 1));
            i -= charsMatched - 1;
            if (charsMatched != currentNode.getValue().length()) break;
            if (!currentNode.isEndPoint()) continue;
            if (lengths == null) {
                lengths = new ArrayList();
            }
            lengths.add(untokenisedChemicalNameLength - i);
        }
        return lengths;
    }
}

