/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;
import org.apache.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.NameToStructure;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureException;
import uk.ac.cam.ch.wwmm.opsin.OpsinResult;

public class NameToInchi {
    private static final Logger LOG = Logger.getLogger(NameToInchi.class);
    private NameToStructure n2s = NameToStructure.getInstance();

    public String parseToInchi(String name) {
        OpsinResult result2 = this.n2s.parseChemicalName(name);
        return NameToInchi.convertResultToInChI(result2);
    }

    public String parseToStdInchi(String name) {
        OpsinResult result2 = this.n2s.parseChemicalName(name);
        return NameToInchi.convertResultToStdInChI(result2);
    }

    public static String convertResultToInChI(OpsinResult result2) {
        return NameToInchi.convertResultToInChI(result2, false);
    }

    public static String convertResultToStdInChI(OpsinResult result2) {
        return NameToInchi.convertResultToInChI(result2, true);
    }

    private static String convertResultToInChI(OpsinResult result2, boolean produceStdInChI) {
        if (result2.getStructure() != null) {
            String inchi = null;
            try {
                inchi = NameToInchi.opsinFragmentToInchi(result2.getStructure(), produceStdInChI);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(e.getMessage(), e);
                }
                return null;
            }
            if (inchi == null) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(inchi);
            }
            return inchi;
        }
        return null;
    }

    private static String opsinFragmentToInchi(Fragment frag, boolean produceStdInChI) throws JniInchiException {
        Atom[] atomRefs4;
        JniInchiInput input2;
        HashMap<Integer, JniInchiAtom> opsinIdAtomMap = new HashMap<Integer, JniInchiAtom>();
        if (produceStdInChI) {
            input2 = new JniInchiInput();
        } else {
            ArrayList<INCHI_OPTION> options = new ArrayList<INCHI_OPTION>();
            options.add(INCHI_OPTION.FixedH);
            input2 = new JniInchiInput(options);
        }
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            JniInchiAtom jAtom = input2.addAtom(new JniInchiAtom(0.0, 0.0, 0.0, atom.getElement()));
            jAtom.setCharge(atom.getCharge());
            Integer isotope = atom.getIsotope();
            if (isotope != null) {
                jAtom.setIsotopicMass(isotope);
            }
            jAtom.setImplicitH(0);
            opsinIdAtomMap.put(atom.getID(), jAtom);
        }
        Set<Bond> bondList = frag.getBondSet();
        for (Bond bond : bondList) {
            input2.addBond(new JniInchiBond((JniInchiAtom)opsinIdAtomMap.get(bond.getFrom()), (JniInchiAtom)opsinIdAtomMap.get(bond.getTo()), INCHI_BOND_TYPE.getValue(bond.getOrder())));
        }
        for (Atom atom : atomList) {
            AtomParity atomParity = atom.getAtomParity();
            if (atomParity == null) continue;
            atomRefs4 = atomParity.getAtomRefs4();
            int[] atomRefs4AsInt = new int[4];
            for (int i = 0; i < atomRefs4.length; ++i) {
                atomRefs4AsInt[i] = atomRefs4[i].getID();
            }
            INCHI_PARITY parity = INCHI_PARITY.UNKNOWN;
            if (atomParity.getParity() > 0) {
                parity = INCHI_PARITY.EVEN;
            } else if (atomParity.getParity() < 0) {
                parity = INCHI_PARITY.ODD;
            }
            input2.addStereo0D(JniInchiStereo0D.createNewTetrahedralStereo0D((JniInchiAtom)opsinIdAtomMap.get(atom.getID()), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[0]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[1]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[2]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[3]), parity));
        }
        for (Bond bond : bondList) {
            BondStereo bondStereo = bond.getBondStereo();
            if (bondStereo == null) continue;
            atomRefs4 = bondStereo.getAtomRefs4();
            int[] atomRefs4Ids = new int[4];
            for (int i = 0; i < atomRefs4.length; ++i) {
                atomRefs4Ids[i] = atomRefs4[i].getID();
            }
            if (BondStereo.BondStereoValue.CIS.equals((Object)bondStereo.getBondStereoValue())) {
                input2.addStereo0D(JniInchiStereo0D.createNewDoublebondStereo0D((JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[0]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[1]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[2]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[3]), INCHI_PARITY.ODD));
                continue;
            }
            if (!BondStereo.BondStereoValue.TRANS.equals((Object)bondStereo.getBondStereoValue())) continue;
            input2.addStereo0D(JniInchiStereo0D.createNewDoublebondStereo0D((JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[0]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[1]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[2]), (JniInchiAtom)opsinIdAtomMap.get(atomRefs4Ids[3]), INCHI_PARITY.EVEN));
        }
        JniInchiOutput output2 = JniInchiWrapper.getInchi(input2);
        if (output2 == null) {
            return null;
        }
        INCHI_RET ret = output2.getReturnStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inchi generation status: " + (Object)((Object)ret));
            if (!INCHI_RET.OKAY.equals((Object)ret)) {
                LOG.debug(output2.getMessage());
            }
        }
        if (!INCHI_RET.OKAY.equals((Object)ret) && !INCHI_RET.WARNING.equals((Object)ret)) {
            return null;
        }
        return output2.getInchi();
    }
}

