/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.CMLFragmentBuilder;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.IDManager;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.SMILESFragmentBuilder;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FragmentManager {
    private final Set<Fragment> fragPile;
    private final Set<Bond> bondPile;
    private final Map<Fragment, LinkedHashSet<Bond>> fragToInterFragmentBond;
    private final SMILESFragmentBuilder sBuilder;
    private final CMLFragmentBuilder cmlBuilder;
    private final IDManager idManager;

    FragmentManager(SMILESFragmentBuilder sBuilder, CMLFragmentBuilder cmlBuilder, IDManager idManager) {
        if (sBuilder == null || cmlBuilder == null || idManager == null) {
            throw new IllegalArgumentException("FragmentManager was parsed a null object in its constructor!");
        }
        this.sBuilder = sBuilder;
        this.cmlBuilder = cmlBuilder;
        this.idManager = idManager;
        this.fragPile = new LinkedHashSet<Fragment>();
        this.bondPile = new LinkedHashSet<Bond>();
        this.fragToInterFragmentBond = new HashMap<Fragment, LinkedHashSet<Bond>>();
    }

    Fragment buildCML(String idStr, String type, String subType) throws StructureBuildingException {
        Fragment newFrag = this.cmlBuilder.build(idStr, type, subType, this);
        this.addFragment(newFrag);
        return newFrag;
    }

    Fragment buildSMILES(String smiles) throws StructureBuildingException {
        return this.buildSMILES(smiles, "", "");
    }

    Fragment buildSMILES(String smiles, String type, String labelMapping) throws StructureBuildingException {
        return this.buildSMILES(smiles, type, "", labelMapping);
    }

    Fragment buildSMILES(String smiles, String type, String subType, String labelMapping) throws StructureBuildingException {
        Fragment newFrag = this.sBuilder.build(smiles, type, subType, labelMapping, this);
        this.addFragment(newFrag);
        return newFrag;
    }

    Fragment getUnifiedFragment() throws StructureBuildingException {
        Fragment outFrag = new Fragment();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(this.fragPile);
        this.addFragment(outFrag);
        for (Fragment f2 : fragments) {
            this.incorporateFragment(f2, outFrag);
        }
        return outFrag;
    }

    void incorporateFragment(Fragment childFrag, Fragment parentFrag) throws StructureBuildingException {
        for (Atom atom : childFrag.getAtomList()) {
            parentFrag.addAtom(atom);
        }
        for (Bond bond : childFrag.getBondSet()) {
            parentFrag.addBond(bond);
        }
        parentFrag.addOutAtoms(childFrag.getOutAtoms());
        parentFrag.addFunctionalAtoms(childFrag.getFunctionalAtoms());
        for (Bond bond : this.fragToInterFragmentBond.get(childFrag)) {
            if (bond.getFromAtom().getFrag() != parentFrag && bond.getToAtom().getFrag() != parentFrag) continue;
            if (bond.getFromAtom().getFrag() == parentFrag && bond.getToAtom().getFrag() == parentFrag) {
                parentFrag.addBond(bond);
                this.fragToInterFragmentBond.get(parentFrag).remove(bond);
                continue;
            }
            this.addInterFragmentBond(bond);
        }
        if (!this.fragPile.remove(childFrag)) {
            throw new StructureBuildingException("Fragment not found in fragPile");
        }
    }

    void incorporateFragment(Fragment childFrag, Atom fromAtom, Fragment parentFrag, Atom toAtom, int bondOrder) throws StructureBuildingException {
        if (!fromAtom.getFrag().equals(childFrag)) {
            throw new StructureBuildingException("OPSIN Bug: fromAtom was not associated with childFrag!");
        }
        if (!toAtom.getFrag().equals(parentFrag)) {
            throw new StructureBuildingException("OPSIN Bug: toAtom was not associated with parentFrag!");
        }
        this.incorporateFragment(childFrag, parentFrag);
        this.createBond(fromAtom, toAtom, bondOrder);
    }

    void replaceAtomWithSmiles(Atom a, String smiles) throws StructureBuildingException {
        this.replaceAtomWithAtom(a, this.getHeteroatom(smiles), false);
    }

    Atom getHeteroatom(String smiles) throws StructureBuildingException {
        Fragment heteroAtomFrag = this.sBuilder.build(smiles, this);
        List<Atom> atomList = heteroAtomFrag.getAtomList();
        if (atomList.size() != 1) {
            throw new StructureBuildingException("Heteroatom smiles described a fragment with multiple SMILES!");
        }
        return atomList.get(0);
    }

    void replaceAtomWithAtom(Atom a, Atom heteroAtom, boolean assignLocant) throws StructureBuildingException {
        String elementSymbol = heteroAtom.getElement();
        int replacementCharge = heteroAtom.getCharge();
        if (replacementCharge != 0) {
            if (a.getCharge() == 0) {
                a.addChargeAndProtons(replacementCharge, heteroAtom.getProtonsExplicitlyAddedOrRemoved());
            } else if (a.getCharge() == replacementCharge) {
                a.setProtonsExplicitlyAddedOrRemoved(heteroAtom.getProtonsExplicitlyAddedOrRemoved());
            } else {
                throw new StructureBuildingException("Charge conflict between replacement term and atom to be replaced");
            }
        }
        a.setElement(elementSymbol);
        a.removeElementSymbolLocants();
        if (assignLocant) {
            String primes = "";
            while (a.getFrag().getAtomByLocant(elementSymbol + primes) != null) {
                primes = primes + "'";
            }
            a.addLocant(elementSymbol + primes);
        }
    }

    Atom getAtomByID(int id) {
        for (Fragment f2 : this.fragPile) {
            Atom a = f2.getAtomByID(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    Atom getAtomByIDOrThrow(int id) throws StructureBuildingException {
        Atom a = this.getAtomByID(id);
        if (a == null) {
            throw new StructureBuildingException("Couldn't get atom by id");
        }
        return a;
    }

    void convertSpareValenciesToDoubleBonds() throws StructureBuildingException {
        for (Fragment f2 : this.fragPile) {
            FragmentTools.convertSpareValenciesToDoubleBonds(f2);
        }
    }

    void checkValencies() throws StructureBuildingException {
        for (Fragment f2 : this.fragPile) {
            f2.checkValencies();
        }
    }

    Set<Bond> getBondPile() {
        return Collections.unmodifiableSet(this.bondPile);
    }

    Set<Fragment> getFragPile() {
        return Collections.unmodifiableSet(this.fragPile);
    }

    private void addFragment(Fragment frag) {
        this.fragPile.add(frag);
        this.fragToInterFragmentBond.put(frag, new LinkedHashSet());
    }

    void removeFragment(Fragment frag) throws StructureBuildingException {
        if (!this.fragPile.remove(frag)) {
            throw new StructureBuildingException("Fragment not found in fragPile");
        }
        ArrayList interFragmentBondsInvolvingFragment = new ArrayList(this.fragToInterFragmentBond.get(frag));
        for (Bond bond : interFragmentBondsInvolvingFragment) {
            if (bond.getFromAtom().getFrag() == frag) {
                this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).remove(bond);
            } else {
                this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).remove(bond);
            }
            this.bondPile.remove(bond);
        }
        this.fragToInterFragmentBond.remove(frag);
    }

    int getOverallCharge() {
        int totalCharge = 0;
        for (Fragment frag : this.fragPile) {
            totalCharge += frag.getCharge();
        }
        return totalCharge;
    }

    Fragment copyFragment(Fragment originalFragment) throws StructureBuildingException {
        return this.copyAndRelabelFragment(originalFragment, 0);
    }

    Fragment copyAndRelabelFragment(Fragment originalFragment, int primesToAdd) throws StructureBuildingException {
        Fragment newFragment = new Fragment(originalFragment.getType(), originalFragment.getSubType());
        HashMap<Atom, Atom> oldToNewAtomMap = new HashMap<Atom, Atom>();
        List<Atom> atomList = originalFragment.getAtomList();
        List<OutAtom> outAtoms = originalFragment.getOutAtoms();
        List<FunctionalAtom> functionalAtoms = originalFragment.getFunctionalAtoms();
        Atom defaultInAtom = originalFragment.getDefaultInAtom();
        for (Atom atom : atomList) {
            int id = this.idManager.getNextID();
            ArrayList<String> newLocants = new ArrayList<String>(atom.getLocants());
            if (primesToAdd != 0) {
                for (int i = 0; i < newLocants.size(); ++i) {
                    String currentLocant = newLocants.get(i);
                    int currentPrimes = StringTools.countTerminalPrimes(currentLocant);
                    String locantSansPrimes = currentLocant.substring(0, currentLocant.length() - currentPrimes);
                    int highestNumberOfPrimesWithThisLocant = currentPrimes;
                    while (originalFragment.getAtomByLocant(locantSansPrimes + StringTools.multiplyString("'", highestNumberOfPrimesWithThisLocant + 1)) != null) {
                        ++highestNumberOfPrimesWithThisLocant;
                    }
                    newLocants.set(i, locantSansPrimes + StringTools.multiplyString("'", (highestNumberOfPrimesWithThisLocant + 1) * primesToAdd + currentPrimes));
                }
            }
            Atom newAtom = new Atom(id, atom.getElement(), newFragment);
            for (String newLocant : newLocants) {
                newAtom.addLocant(newLocant);
            }
            newAtom.setCharge(atom.getCharge());
            newAtom.setIsotope(atom.getIsotope());
            newAtom.setSpareValency(atom.hasSpareValency());
            newAtom.setProtonsExplicitlyAddedOrRemoved(atom.getProtonsExplicitlyAddedOrRemoved());
            newAtom.setLambdaConventionValency(atom.getLambdaConventionValency());
            newAtom.setAtomIsInACycle(atom.getAtomIsInACycle());
            newAtom.setType(atom.getType());
            newAtom.setMinimumValency(atom.getMinimumValency());
            newFragment.addAtom(newAtom);
            oldToNewAtomMap.put(atom, newAtom);
        }
        for (Atom atom : atomList) {
            if (atom.getAtomParity() != null) {
                Atom[] oldAtomRefs4 = atom.getAtomParity().getAtomRefs4();
                Atom[] newAtomRefs4 = new Atom[4];
                for (int i = 0; i < oldAtomRefs4.length; ++i) {
                    Atom oldAtom = oldAtomRefs4[i];
                    newAtomRefs4[i] = oldAtom.equals(AtomParity.hydrogen) ? AtomParity.hydrogen : (oldAtom.equals(AtomParity.deoxyHydrogen) ? AtomParity.deoxyHydrogen : (Atom)oldToNewAtomMap.get(oldAtom));
                }
                AtomParity newAtomParity = new AtomParity(newAtomRefs4, atom.getAtomParity().getParity());
                ((Atom)oldToNewAtomMap.get(atom)).setAtomParity(newAtomParity);
            }
            if (atom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                Set<Atom> oldAtoms = atom.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT);
                HashSet newAtoms = new HashSet();
                for (Atom oldAtom : oldAtoms) {
                    newAtoms.add(oldToNewAtomMap.get(oldAtom));
                }
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, newAtoms);
            }
            if (atom.getProperty(Atom.SMILES_HYDROGEN_COUNT) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.SMILES_HYDROGEN_COUNT, atom.getProperty(Atom.SMILES_HYDROGEN_COUNT));
            }
            if (atom.getProperty(Atom.OXIDATION_NUMBER) != null) {
                ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.OXIDATION_NUMBER, atom.getProperty(Atom.OXIDATION_NUMBER));
            }
            if (atom.getProperty(Atom.ISALDEHYDE) == null) continue;
            ((Atom)oldToNewAtomMap.get(atom)).setProperty(Atom.ISALDEHYDE, atom.getProperty(Atom.ISALDEHYDE));
        }
        for (OutAtom outAtom : outAtoms) {
            newFragment.addOutAtom((Atom)oldToNewAtomMap.get(outAtom.getAtom()), outAtom.getValency(), (Boolean)outAtom.isSetExplicitly());
            if (outAtom.getLocant() == null) continue;
            newFragment.getOutAtom(newFragment.getOutAtoms().size() - 1).setLocant(outAtom.getLocant() + StringTools.multiplyString("'", primesToAdd));
        }
        for (FunctionalAtom functionalAtom : functionalAtoms) {
            newFragment.addFunctionalAtom((Atom)oldToNewAtomMap.get(functionalAtom.getAtom()));
        }
        newFragment.setDefaultInAtom((Atom)oldToNewAtomMap.get(defaultInAtom));
        Set<Bond> bondSet = originalFragment.getBondSet();
        for (Bond bond : bondSet) {
            Bond newBond = this.createBond((Atom)oldToNewAtomMap.get(bond.getFromAtom()), (Atom)oldToNewAtomMap.get(bond.getToAtom()), bond.getOrder());
            newBond.setSmilesStereochemistry(bond.getSmilesStereochemistry());
            if (bond.getBondStereo() == null) continue;
            Atom[] oldAtomRefs4 = bond.getBondStereo().getAtomRefs4();
            Atom[] newAtomRefs4 = new Atom[4];
            for (int i = 0; i < oldAtomRefs4.length; ++i) {
                newAtomRefs4[i] = (Atom)oldToNewAtomMap.get(oldAtomRefs4[i]);
            }
            newBond.setBondStereoElement(newAtomRefs4, bond.getBondStereo().getBondStereoValue());
        }
        List<Atom> indicatedHydrogenAtoms = originalFragment.getIndicatedHydrogen();
        for (Atom atom : indicatedHydrogenAtoms) {
            newFragment.addIndicatedHydrogen((Atom)oldToNewAtomMap.get(atom));
        }
        this.addFragment(newFragment);
        return newFragment;
    }

    Element cloneElement(BuildState state, Element elementToBeCloned) throws StructureBuildingException {
        return this.cloneElement(state, elementToBeCloned, 0);
    }

    Element cloneElement(BuildState state, Element elementToBeCloned, int primesToAdd) throws StructureBuildingException {
        Element clone2 = new Element(elementToBeCloned);
        List<Element> originalGroups = XOMTools.getDescendantElementsWithTagName(elementToBeCloned, "group");
        List<Element> clonedGroups = XOMTools.getDescendantElementsWithTagName(clone2, "group");
        HashMap<Fragment, Fragment> oldNewFragmentMapping = new HashMap<Fragment, Fragment>();
        for (int i = 0; i < originalGroups.size(); ++i) {
            Fragment originalFragment = state.xmlFragmentMap.get(originalGroups.get(i));
            Fragment newFragment = this.copyAndRelabelFragment(originalFragment, primesToAdd);
            oldNewFragmentMapping.put(originalFragment, newFragment);
            state.xmlFragmentMap.put(clonedGroups.get(i), newFragment);
            List<Fragment> originalSuffixes = state.xmlSuffixMap.get(originalGroups.get(i));
            ArrayList<Fragment> newSuffixFragments = new ArrayList<Fragment>();
            for (Fragment suffix : originalSuffixes) {
                newSuffixFragments.add(state.fragManager.copyFragment(suffix));
            }
            state.xmlSuffixMap.put(clonedGroups.get(i), newSuffixFragments);
        }
        HashSet<Bond> interFragmentBondsToClone = new HashSet<Bond>();
        for (Fragment originalFragment : oldNewFragmentMapping.keySet()) {
            for (Bond bond : this.fragToInterFragmentBond.get(originalFragment)) {
                interFragmentBondsToClone.add(bond);
            }
        }
        for (Bond bond : interFragmentBondsToClone) {
            Atom originalFromAtom = bond.getFromAtom();
            Atom originalToAtom = bond.getToAtom();
            Fragment originalFragment1 = originalFromAtom.getFrag();
            Fragment originalFragment2 = originalToAtom.getFrag();
            if (!oldNewFragmentMapping.containsKey(originalFragment1) || !oldNewFragmentMapping.containsKey(originalFragment2)) {
                throw new StructureBuildingException("An element that was a clone contained a bond that went outside the scope of the cloning");
            }
            Fragment newFragment1 = (Fragment)oldNewFragmentMapping.get(originalFragment1);
            Fragment newFragment2 = (Fragment)oldNewFragmentMapping.get(originalFragment2);
            Atom fromAtom = newFragment1.getAtomList().get(originalFragment1.getAtomList().indexOf(originalFromAtom));
            Atom toAtom = newFragment2.getAtomList().get(originalFragment2.getAtomList().indexOf(originalToAtom));
            this.createBond(fromAtom, toAtom, bond.getOrder());
        }
        return clone2;
    }

    void replaceAtomWithAnotherAtomPreservingConnectivity(Atom atomToBeReplaced, Atom replacementAtom) {
        atomToBeReplaced.removeElementSymbolLocants();
        ArrayList<String> locants = new ArrayList<String>(atomToBeReplaced.getLocants());
        for (String locant : locants) {
            atomToBeReplaced.removeLocant(locant);
            replacementAtom.addLocant(locant);
        }
        Set<Bond> bonds = atomToBeReplaced.getBonds();
        for (Bond bond : bonds) {
            this.createBond(replacementAtom, bond.getOtherAtom(atomToBeReplaced), bond.getOrder());
        }
        this.removeAtomAndAssociatedBonds(atomToBeReplaced);
    }

    private void removeInterFragmentBondIfPresent(Bond bond) {
        if (this.bondPile.remove(bond)) {
            this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).remove(bond);
            this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).remove(bond);
        }
    }

    private void addInterFragmentBond(Bond bond) {
        this.bondPile.add(bond);
        this.fragToInterFragmentBond.get(bond.getFromAtom().getFrag()).add(bond);
        this.fragToInterFragmentBond.get(bond.getToAtom().getFrag()).add(bond);
    }

    Set<Bond> getInterFragmentBonds(Fragment frag) {
        return this.fragToInterFragmentBond.get(frag);
    }

    Atom createAtom(String elementSymbol, Fragment frag) throws StructureBuildingException {
        Atom a = new Atom(this.idManager.getNextID(), elementSymbol, frag);
        frag.addAtom(a);
        return a;
    }

    Bond createBond(Atom fromAtom, Atom toAtom, int bondOrder) {
        Bond b = new Bond(fromAtom, toAtom, bondOrder);
        fromAtom.addBond(b);
        toAtom.addBond(b);
        if (fromAtom.getFrag() == toAtom.getFrag()) {
            fromAtom.getFrag().addBond(b);
        } else {
            this.addInterFragmentBond(b);
        }
        return b;
    }

    void removeAtomAndAssociatedBonds(Atom atom) {
        ArrayList<Bond> bondsToBeRemoved = new ArrayList<Bond>(atom.getBonds());
        for (Bond bond : bondsToBeRemoved) {
            this.removeBond(bond);
        }
        atom.getFrag().removeAtom(atom);
    }

    void removeBond(Bond bond) {
        bond.getFromAtom().getFrag().removeBond(bond);
        bond.getFromAtom().removeBond(bond);
        bond.getToAtom().removeBond(bond);
        this.removeInterFragmentBondIfPresent(bond);
    }
}

