/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import nu.xom.Attribute;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Fragment {
    private final LinkedHashMap<Integer, Atom> atomMapFromId = new LinkedHashMap();
    private final Collection<Atom> atomCollection = this.atomMapFromId.values();
    private final HashMap<String, Atom> atomMapFromLocant = new HashMap();
    private final Set<Bond> bondSet = new LinkedHashSet<Bond>();
    private String type = "";
    private String subType = "";
    private final LinkedList<OutAtom> outAtoms = new LinkedList();
    private final LinkedList<FunctionalAtom> functionalAtoms = new LinkedList();
    private Atom defaultInAtom = null;
    private final List<Atom> indicatedHydrogen = new ArrayList<Atom>();

    Fragment(String type, String subType) throws StructureBuildingException {
        if (type == null) {
            throw new StructureBuildingException("Type specified for fragment is null");
        }
        if (subType == null) {
            throw new StructureBuildingException("subType specified for fragment is null");
        }
        this.type = type;
        this.subType = subType;
    }

    Fragment() {
    }

    Element toCMLMolecule(String chemicalName) {
        Element cml = new Element("cml", "http://www.xml-cml.org/schema");
        cml.addAttribute(new Attribute("convention", "conventions:molecular"));
        cml.addNamespaceDeclaration("conventions", "http://www.xml-cml.org/convention/");
        cml.addNamespaceDeclaration("cmlDict", "http://www.xml-cml.org/dictionary/cml/");
        cml.addNamespaceDeclaration("nameDict", "http://www.xml-cml.org/dictionary/cml/name/");
        Element molecule = new Element("molecule", "http://www.xml-cml.org/schema");
        Element name = new Element("name", "http://www.xml-cml.org/schema");
        name.appendChild(chemicalName);
        name.addAttribute(new Attribute("dictRef", "nameDict:unknown"));
        molecule.appendChild(name);
        molecule.addAttribute(new Attribute("id", "m1"));
        Element atomArray = new Element("atomArray", "http://www.xml-cml.org/schema");
        for (Atom atom : this.atomCollection) {
            atomArray.appendChild(atom.toCMLAtom());
        }
        Element bondArray = new Element("bondArray", "http://www.xml-cml.org/schema");
        for (Bond bond : this.bondSet) {
            bondArray.appendChild(bond.toCMLBond());
        }
        molecule.appendChild(atomArray);
        molecule.appendChild(bondArray);
        cml.appendChild(molecule);
        return cml;
    }

    void addAtom(Atom atom) {
        if (this.defaultInAtom == null) {
            this.defaultInAtom = atom;
        }
        List<String> locants = atom.getLocants();
        for (String locant : locants) {
            this.atomMapFromLocant.put(locant, atom);
        }
        this.atomMapFromId.put(atom.getID(), atom);
        atom.setFrag(this);
    }

    List<Atom> getAtomList() {
        return new ArrayList<Atom>(this.atomCollection);
    }

    void addBond(Bond bond) {
        this.bondSet.add(bond);
    }

    boolean removeBond(Bond bond) {
        return this.bondSet.remove(bond);
    }

    Set<Bond> getBondSet() {
        return Collections.unmodifiableSet(this.bondSet);
    }

    int getIDFromLocant(String locant) throws StructureBuildingException {
        Atom a = this.getAtomByLocant(locant);
        if (a != null) {
            return a.getID();
        }
        return 0;
    }

    int getIDFromLocantOrThrow(String locant) throws StructureBuildingException {
        int id = this.getIDFromLocant(locant);
        if (id == 0) {
            throw new StructureBuildingException("Couldn't find id from locant " + locant + ".");
        }
        return id;
    }

    Atom getAtomByLocant(String locant) throws StructureBuildingException {
        Atom a = this.atomMapFromLocant.get(locant);
        if (a != null) {
            return a;
        }
        Matcher m = OpsinTools.MATCH_AMINOACID_STYLE_LOCANT.matcher(locant);
        if (m.matches()) {
            Atom backboneAtom = this.atomMapFromLocant.get(m.group(3));
            if (backboneAtom == null) {
                return null;
            }
            a = FragmentTools.getAtomByAminoAcidStyleLocant(backboneAtom, m.group(1), m.group(2));
            if (a != null) {
                return a;
            }
        }
        return null;
    }

    Atom getAtomByLocantOrThrow(String locant) throws StructureBuildingException {
        Atom a = this.getAtomByLocant(locant);
        if (a == null) {
            throw new StructureBuildingException("Could not find the atom with locant " + locant + ".");
        }
        return a;
    }

    Atom getAtomByID(int id) {
        return this.atomMapFromId.get(id);
    }

    Atom getAtomByIDOrThrow(int id) throws StructureBuildingException {
        Atom a = this.getAtomByID(id);
        if (a == null) {
            throw new StructureBuildingException("Couldn't find atom with id " + id + ".");
        }
        return a;
    }

    Bond findBond(int ID1, int ID2) {
        Atom a = this.atomMapFromId.get(ID1);
        if (a != null) {
            for (Bond b : a.getBonds()) {
                if ((b.getFrom() != ID1 || b.getTo() != ID2) && (b.getTo() != ID1 || b.getFrom() != ID2)) continue;
                return b;
            }
        }
        return null;
    }

    Bond findBondOrThrow(int ID1, int ID2) throws StructureBuildingException {
        Bond b = this.findBond(ID1, ID2);
        if (b == null) {
            throw new StructureBuildingException("Couldn't find specified bond");
        }
        return b;
    }

    int getChainLength() throws StructureBuildingException {
        int length = 0;
        Atom next2 = this.getAtomByLocant(Integer.toString(length + 1));
        Atom previous = null;
        while (next2 != null && (previous == null || previous.getBondToAtom(next2) != null)) {
            previous = next2;
            next2 = this.getAtomByLocant(Integer.toString(++length + 1));
        }
        return length;
    }

    String getType() {
        return this.type;
    }

    String getSubType() {
        return this.subType;
    }

    List<OutAtom> getOutAtoms() {
        return Collections.unmodifiableList(this.outAtoms);
    }

    OutAtom getOutAtom(int i) {
        return this.outAtoms.get(i);
    }

    void addOutAtom(int id, int valency, Boolean setExplicitly) throws StructureBuildingException {
        this.addOutAtom(this.getAtomByIDOrThrow(id), valency, setExplicitly);
    }

    void addOutAtom(Atom atom, int valency, Boolean setExplicitly) {
        this.outAtoms.add(new OutAtom(atom, valency, setExplicitly));
    }

    void addOutAtoms(List<OutAtom> outAtoms) {
        this.outAtoms.addAll(outAtoms);
    }

    void removeOutAtom(int i) {
        OutAtom removedOutAtom = this.outAtoms.remove(i);
        if (removedOutAtom.isSetExplicitly()) {
            removedOutAtom.getAtom().addOutValency(-removedOutAtom.getValency());
        }
    }

    void removeOutAtom(OutAtom outAtom) {
        if (this.outAtoms.remove(outAtom) && outAtom.isSetExplicitly()) {
            outAtom.getAtom().addOutValency(-outAtom.getValency());
        }
    }

    List<FunctionalAtom> getFunctionalAtoms() {
        return Collections.unmodifiableList(this.functionalAtoms);
    }

    FunctionalAtom getFunctionalAtom(int i) {
        return this.functionalAtoms.get(i);
    }

    void addFunctionalAtom(Atom atom) {
        this.functionalAtoms.add(new FunctionalAtom(atom));
    }

    void addFunctionalAtoms(List<FunctionalAtom> functionalAtoms) {
        this.functionalAtoms.addAll(functionalAtoms);
    }

    FunctionalAtom removeFunctionalAtom(int i) {
        return this.functionalAtoms.remove(i);
    }

    void removeFunctionalAtom(FunctionalAtom functionalAtom) {
        this.functionalAtoms.remove(functionalAtom);
    }

    List<Atom> getIntraFragmentAtomNeighbours(Atom atom) throws StructureBuildingException {
        ArrayList<Atom> results = new ArrayList<Atom>();
        for (Bond b : atom.getBonds()) {
            Atom a;
            if (b.getFromAtom() == atom) {
                a = this.getAtomByID(b.getTo());
                if (a == null) continue;
                results.add(a);
                continue;
            }
            if (b.getToAtom() == atom) {
                a = this.getAtomByID(b.getFrom());
                if (a == null) continue;
                results.add(a);
                continue;
            }
            throw new StructureBuildingException("A bond associated with an atom does not involve it");
        }
        return results;
    }

    int getIntraFragmentIncomingValency(Atom atom) throws StructureBuildingException {
        int v = 0;
        for (Bond b : atom.getBonds()) {
            Atom a;
            if (b.getFromAtom() == atom) {
                a = this.getAtomByID(b.getTo());
                if (a == null || a.getType().equals("suffix")) continue;
                v += b.getOrder();
                continue;
            }
            if (b.getToAtom() == atom) {
                a = this.getAtomByID(b.getFrom());
                if (a == null || a.getType().equals("suffix")) continue;
                v += b.getOrder();
                continue;
            }
            throw new StructureBuildingException("A bond associated with an atom does not involve it");
        }
        return v;
    }

    void checkValencies() throws StructureBuildingException {
        for (Atom a : this.atomCollection) {
            if (ValencyChecker.checkValency(a)) continue;
            throw new StructureBuildingException("Atom is in unphysical valency state! Element: " + a.getElement() + " valency: " + a.getIncomingValency());
        }
    }

    void removeAtom(Atom atom) {
        int atomID = atom.getID();
        this.atomMapFromId.remove(atomID);
        for (String l : atom.getLocants()) {
            this.atomMapFromLocant.remove(l);
        }
        if (this.defaultInAtom == atom) {
            this.defaultInAtom = this.getFirstAtom();
        }
    }

    int getCharge() {
        int charge = 0;
        for (Atom a : this.atomCollection) {
            charge += a.getCharge();
        }
        return charge;
    }

    void setType(String type) {
        this.type = type;
    }

    Atom getDefaultInAtom() {
        return this.defaultInAtom;
    }

    void setDefaultInAtom(Atom inAtom) {
        this.defaultInAtom = inAtom;
    }

    void addMappingToAtomLocantMap(String locant, Atom a) {
        this.atomMapFromLocant.put(locant, a);
    }

    void removeMappingFromAtomLocantMap(String locant) {
        this.atomMapFromLocant.remove(locant);
    }

    boolean hasLocant(String locant) throws StructureBuildingException {
        return this.getAtomByLocant(locant) != null;
    }

    Set<String> getLocants() {
        return Collections.unmodifiableSet(this.atomMapFromLocant.keySet());
    }

    List<Atom> getIndicatedHydrogen() {
        return this.indicatedHydrogen;
    }

    void addIndicatedHydrogen(Atom atom) {
        this.indicatedHydrogen.add(atom);
    }

    Atom getAtomOrNextSuitableAtomOrThrow(Atom startingAtom, int additionalValencyRequired, boolean takeIntoAccountOutValency) throws StructureBuildingException {
        Atom a = this.getAtomOrNextSuitableAtom(startingAtom, additionalValencyRequired, takeIntoAccountOutValency);
        if (a == null) {
            throw new StructureBuildingException("No suitable atom found");
        }
        return a;
    }

    Atom getAtomOrNextSuitableAtom(Atom startingAtom, int additionalValencyRequired, boolean takeIntoAccountOutValency) {
        int currentExpectedValency;
        int atomListPosition;
        List<Atom> atomList = this.getAtomList();
        Atom currentAtom = startingAtom;
        int atomCounter = 0;
        int startingIndex = atomListPosition = atomList.indexOf(currentAtom);
        do {
            ++atomCounter;
            if (atomListPosition >= atomList.size()) {
                atomListPosition -= atomList.size();
            }
            if (FragmentTools.isCharacteristicAtom(currentAtom = atomList.get(atomListPosition))) {
                ++atomListPosition;
                continue;
            }
            currentExpectedValency = currentAtom.determineValency(takeIntoAccountOutValency);
            if (currentExpectedValency >= currentAtom.getIncomingValency() + additionalValencyRequired + (currentAtom.hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? currentAtom.getOutValency() : 0)) {
                return currentAtom;
            }
            ++atomListPosition;
        } while (atomCounter < atomList.size());
        atomListPosition = startingIndex;
        atomCounter = 0;
        do {
            ++atomCounter;
            if (atomListPosition >= atomList.size()) {
                atomListPosition -= atomList.size();
            }
            if (FragmentTools.isFunctionalAtomOrAldehyde(currentAtom = atomList.get(atomListPosition))) {
                ++atomListPosition;
                continue;
            }
            currentExpectedValency = currentAtom.determineValency(takeIntoAccountOutValency);
            if (currentExpectedValency >= currentAtom.getIncomingValency() + additionalValencyRequired + (currentAtom.hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? currentAtom.getOutValency() : 0)) {
                return currentAtom;
            }
            ++atomListPosition;
        } while (atomCounter < atomList.size());
        atomListPosition = startingIndex;
        atomCounter = 0;
        do {
            ++atomCounter;
            if (atomListPosition >= atomList.size()) {
                atomListPosition -= atomList.size();
            }
            if (ValencyChecker.checkValencyAvailableForBond(currentAtom, additionalValencyRequired + ((currentAtom = atomList.get(atomListPosition)).hasSpareValency() ? 1 : 0) + (takeIntoAccountOutValency ? currentAtom.getOutValency() : 0))) {
                return currentAtom;
            }
            ++atomListPosition;
        } while (atomCounter < atomList.size());
        atomListPosition = startingIndex;
        atomCounter = 0;
        do {
            ++atomCounter;
            if (atomListPosition >= atomList.size()) {
                atomListPosition -= atomList.size();
            }
            if (ValencyChecker.checkValencyAvailableForBond(currentAtom = atomList.get(atomListPosition), additionalValencyRequired + (takeIntoAccountOutValency ? currentAtom.getOutValency() : 0))) {
                return currentAtom;
            }
            ++atomListPosition;
        } while (atomCounter < atomList.size());
        return null;
    }

    int getIdOfFirstAtom() {
        return this.getFirstAtom().getID();
    }

    Atom getFirstAtom() {
        Iterator<Atom> atomIterator = this.atomCollection.iterator();
        if (atomIterator.hasNext()) {
            return atomIterator.next();
        }
        return null;
    }

    void reorderAtomCollection(List<Atom> atomList) throws StructureBuildingException {
        if (this.atomMapFromId.size() != atomList.size()) {
            throw new StructureBuildingException("atom list is not the same size as the number of atoms in the fragment");
        }
        this.atomMapFromId.clear();
        for (Atom atom : atomList) {
            this.atomMapFromId.put(atom.getID(), atom);
        }
    }

    void sortAtomListByLocant() throws StructureBuildingException {
        List<Atom> atomList = this.getAtomList();
        Collections.sort(atomList, new FragmentTools.SortByLocants());
        this.reorderAtomCollection(atomList);
    }
}

