/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CyclicAtomList {
    private int indice = -1;
    private final List<Atom> atomList;

    CyclicAtomList(List<Atom> atomList) {
        this.atomList = atomList;
    }

    CyclicAtomList(List<Atom> atomList, int indice) throws StructureBuildingException {
        this.atomList = atomList;
        this.setIndice(indice);
    }

    Atom get(int index) throws IndexOutOfBoundsException {
        return this.atomList.get(index);
    }

    int getIndice() {
        return this.indice;
    }

    void setIndice(int indice) throws StructureBuildingException {
        if (indice >= this.atomList.size()) {
            throw new StructureBuildingException("Specified indice is not within ringAtom list");
        }
        this.indice = indice;
    }

    Atom getNext() {
        int tempIndice = this.indice + 1;
        if (tempIndice >= this.atomList.size()) {
            tempIndice = 0;
        }
        this.indice = tempIndice;
        return this.atomList.get(this.indice);
    }

    Atom getPrevious() {
        int tempIndice = this.indice - 1;
        if (tempIndice < 0) {
            tempIndice = this.atomList.size() - 1;
        }
        this.indice = tempIndice;
        return this.atomList.get(this.indice);
    }

    Atom getCurrent() {
        return this.atomList.get(this.indice);
    }
}

