/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import uk.ac.cam.ch.wwmm.opsin.AtomProperties;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentGenerator {
    private static final Pattern matchNumberLocantsOnlyFusionBracket = Pattern.compile("\\[\\d+(,\\d+)*\\]");
    private static final Pattern matchCommaOrDot = Pattern.compile("[\\.,]");
    private static final Pattern matchAnnulene = Pattern.compile("[\\[\\(\\{]([1-9]\\d*)[\\]\\)\\}]annulen");
    private static final String elementSymbols = "(?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)";
    private static final Pattern matchStereochemistry = Pattern.compile("(.*?)(SR|RS|[RSEZrsezabx]|[cC][iI][sS]|[tT][rR][aA][nN][sS]|[aA][lL][pP][hH][aA]|[bB][eE][tT][aA]|[xX][iI])");
    private static final Pattern matchStar = Pattern.compile("\\^?\\*");
    private static final Pattern matchRS = Pattern.compile("[RSrs]");
    private static final Pattern matchEZ = Pattern.compile("[EZez]");
    private static final Pattern matchAlphaBetaStereochem = Pattern.compile("a|b|x|[aA][lL][pP][hH][aA]|[bB][eE][tT][aA]|[xX][iI]");
    private static final Pattern matchCisTrans = Pattern.compile("[cC][iI][sS]|[tT][rR][aA][nN][sS]");
    private static final Pattern matchLambdaConvention = Pattern.compile("(\\S+)?lambda\\D*(\\d+)\\D*");
    private static final Pattern matchCommaOrDash = Pattern.compile("[,-]");
    private static final Pattern matchHdigit = Pattern.compile("H\\d");
    private static final Pattern matchDigit = Pattern.compile("\\d+");
    private static final Pattern matchNonDigit = Pattern.compile("\\D+");
    private static final Pattern matchSuperscriptedLocant = Pattern.compile("((?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)'*)[\\^\\[\\(\\{~]*(?:[sS][uU][pP][ ]?)?([^\\^\\[\\(\\{~\\]\\)\\}]+)[^\\[\\(\\{]*");
    private static final Pattern matchIUPAC2004ElementLocant = Pattern.compile("(\\d+'*)-((?:He|Li|Be|B|C|N|O|F|Ne|Na|Mg|Al|Si|P|S|Cl|Ar|K|Ca|Sc|Ti|V|Cr|Mn|Fe|Co|Ni|Cu|Zn|Ga|Ge|As|Se|Br|Kr|Rb|Sr|Y|Zr|Nb|Mo|Tc|Ru|Rh|Pd|Ag|Cd|In|Sn|Sb|Te|I|Xe|Cs|Ba|La|Ce|Pr|Nd|Pm|Sm|Eu|Gd|Tb|Dy|Ho|Er|Tm|Yb|Lu|Hf|Ta|W|Re|Os|Ir|Pt|Au|Hg|Tl|Pb|Po|At|Rn|Fr|Ra|Ac|Th|Pa|U|Np|Pu|Am|Cm|Bk|Cf|Es|Fm|Md|No|Lr|Rf|Db|Sg|Bh|Hs|Mt|Ds)'*)(.*)");
    private static final Pattern matchBracketAtEndOfLocant = Pattern.compile("-?[\\[\\(\\{](.*)[\\]\\)\\}]$");
    private static final Pattern matchGreek = Pattern.compile("alpha|beta|gamma|delta|epsilon|zeta|eta|omega", 2);
    private static final Pattern matchInlineSuffixesThatAreAlsoGroups = Pattern.compile("carbonyl|oxy|sulfenyl|sulfinyl|sulfonyl|selenenyl|seleninyl|selenonyl|tellurenyl|tellurinyl|telluronyl");

    ComponentGenerator() {
    }

    void processParse(Element parse) throws ComponentGenerationException {
        List<Element> substituentsAndRoot = XOMTools.getDescendantElementsWithTagNames(parse, new String[]{"substituent", "root"});
        for (Element subOrRoot : substituentsAndRoot) {
            ComponentGenerator.resolveAmbiguities(subOrRoot);
            ComponentGenerator.processLocants(subOrRoot);
            this.convertOrthoMetaParaToLocants(subOrRoot);
            this.formAlkaneStemsFromComponents(subOrRoot);
            this.processAlkaneStemModifications(subOrRoot);
            this.processHeterogenousHydrides(subOrRoot);
            this.processIndicatedHydrogens(subOrRoot);
            ComponentGenerator.processStereochemistry(subOrRoot);
            this.processInfixes(subOrRoot);
            this.processSuffixPrefixes(subOrRoot);
            this.processLambdaConvention(subOrRoot);
        }
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(parse, "group");
        while (this.findAndStructureBrackets(substituentsAndRoot)) {
        }
        for (Element subOrRoot : substituentsAndRoot) {
            this.processHydroCarbonRings(subOrRoot);
            this.handleSuffixIrregularities(subOrRoot);
        }
        for (Element group : groups) {
            this.detectAlkaneFusedRingBridges(group);
            this.processRings(group);
            this.handleGroupIrregularities(group);
        }
    }

    static void resolveAmbiguities(Element subOrRoot) throws ComponentGenerationException {
        List<Element> multipliers = XOMTools.getChildElementsWithTagName(subOrRoot, "multiplier");
        for (Element apparentMultiplier : multipliers) {
            Element possibleLocantOrMultiplierOrSuffix;
            Element isThisALocant;
            int alkaneChainLength;
            if (!"basic".equals(apparentMultiplier.getAttributeValue("type")) && !"VonBaeyer".equals(apparentMultiplier.getAttributeValue("type"))) continue;
            int multiplierNum = Integer.parseInt(apparentMultiplier.getAttributeValue("value"));
            Element nextEl = (Element)XOMTools.getNextSibling(apparentMultiplier);
            if (multiplierNum >= 3 && nextEl != null && nextEl.getLocalName().equals("alkaneStemComponent") && (alkaneChainLength = Integer.parseInt(nextEl.getAttributeValue("value"))) >= 10 && alkaneChainLength > multiplierNum && ((isThisALocant = (Element)XOMTools.getPreviousSibling(apparentMultiplier)) == null || !isThisALocant.getLocalName().equals("locant") || OpsinTools.MATCH_COMMA.split(isThisALocant.getValue()).length != multiplierNum)) {
                throw new ComponentGenerationException(apparentMultiplier.getValue() + nextEl.getValue() + " should not have been lexed as two tokens!");
            }
            if (multiplierNum >= 4 && nextEl != null && nextEl.getLocalName().equals("hydrocarbonFusedRingSystem") && nextEl.getValue().equals("phen") && !"e".equals(nextEl.getAttributeValue("subsequentUnsemanticToken")) && (possibleLocantOrMultiplierOrSuffix = (Element)XOMTools.getNextSibling(nextEl)) != null && possibleLocantOrMultiplierOrSuffix.getLocalName().equals("suffix") && ((isThisALocant = (Element)XOMTools.getPreviousSibling(apparentMultiplier)) == null || !isThisALocant.getLocalName().equals("locant") || OpsinTools.MATCH_COMMA.split(isThisALocant.getValue()).length != 1)) {
                String multiplierAndGroup = apparentMultiplier.getValue() + nextEl.getValue();
                throw new ComponentGenerationException(multiplierAndGroup + " should not have been lexed as one token!");
            }
            if (multiplierNum <= 4 || apparentMultiplier.getValue().endsWith("a") || nextEl == null || !nextEl.getLocalName().equals("group") || !matchInlineSuffixesThatAreAlsoGroups.matcher(nextEl.getValue()).matches()) continue;
            throw new ComponentGenerationException(apparentMultiplier.getValue() + nextEl.getValue() + " should have been lexed as [alkane stem, inline suffix], not [multiplier, group]!");
        }
        List<Element> fusions = XOMTools.getChildElementsWithTagName(subOrRoot, "fusion");
        for (Element fusion : fusions) {
            Element possibleHWRing;
            String fusionText = fusion.getValue();
            if (!matchNumberLocantsOnlyFusionBracket.matcher(fusionText).matches() || (possibleHWRing = XOMTools.getNextSiblingIgnoringCertainElements(fusion, new String[]{"multiplier", "heteroatom"})) == null || !"hantzschWidman".equals(possibleHWRing.getAttributeValue("subType"))) continue;
            int heteroCount = 0;
            int multiplierValue = 1;
            Element currentElem = (Element)XOMTools.getNextSibling(fusion);
            while (currentElem != null && !currentElem.getLocalName().equals("group")) {
                if (currentElem.getLocalName().equals("heteroatom")) {
                    heteroCount += multiplierValue;
                    multiplierValue = 1;
                } else if (currentElem.getLocalName().equals("multiplier")) {
                    multiplierValue = Integer.parseInt(currentElem.getAttributeValue("value"));
                }
                currentElem = (Element)XOMTools.getNextSibling(currentElem);
            }
            String[] locants = OpsinTools.MATCH_COMMA.split(fusionText.substring(1, fusionText.length() - 1));
            if (locants.length != heteroCount) continue;
            boolean foundLocantNotInHwSystem = false;
            for (String locant : locants) {
                if (Integer.parseInt(locant) <= possibleHWRing.getAttributeValue("value").length() - 2) continue;
                foundLocantNotInHwSystem = true;
            }
            if (foundLocantNotInHwSystem) continue;
            throw new ComponentGenerationException("This fusion bracket is in fact more likely to be a description of the locants of a HW ring");
        }
    }

    static void processLocants(Element subOrRoot) throws ComponentGenerationException {
        List<Element> locants = XOMTools.getChildElementsWithTagName(subOrRoot, "locant");
        for (Element locant : locants) {
            List<String> individualLocants = ComponentGenerator.splitIntoIndividualLocants(StringTools.removeDashIfPresent(locant.getValue()));
            for (int i = 0; i < individualLocants.size(); ++i) {
                char lastChar;
                Matcher m;
                String locantText = individualLocants.get(i);
                if (locantText.contains("-") && (m = matchIUPAC2004ElementLocant.matcher(locantText)).matches()) {
                    locantText = m.group(2) + m.group(1) + m.group(3);
                }
                if (Character.isLetter(locantText.charAt(0))) {
                    m = matchSuperscriptedLocant.matcher(locantText);
                    if (m.lookingAt()) {
                        String replacementString = m.group(1) + m.group(2);
                        locantText = m.replaceFirst(replacementString);
                    }
                    if (locantText.length() >= 3) {
                        m = matchGreek.matcher(locantText);
                        while (m.find()) {
                            locantText = locantText.substring(0, m.start()) + m.group().toLowerCase() + locantText.substring(m.end());
                        }
                    }
                }
                if ((lastChar = locantText.charAt(locantText.length() - 1)) == ')' || lastChar == ']' || lastChar == '}') {
                    Matcher m2 = matchBracketAtEndOfLocant.matcher(locantText);
                    if (m2.find()) {
                        String brackettedText = m2.group(1);
                        if (StringTools.endsWithCaseInsensitive(brackettedText, "H")) {
                            String[] addedHydrogens;
                            locantText = m2.replaceFirst("");
                            for (String addedHydrogen : addedHydrogens = OpsinTools.MATCH_COMMA.split(brackettedText)) {
                                Element addedHydrogenElement = new Element("addedHydrogen");
                                addedHydrogenElement.addAttribute(new Attribute("locant", addedHydrogen.substring(0, addedHydrogen.length() - 1)));
                                XOMTools.insertBefore(locant, addedHydrogenElement);
                            }
                            if (locant.getAttribute("type") == null) {
                                locant.addAttribute(new Attribute("type", "addedHydrogenLocant"));
                            }
                        } else if (brackettedText.endsWith("R") || brackettedText.endsWith("S")) {
                            locantText = m2.replaceFirst("");
                            String rs = brackettedText;
                            Element newStereoChemEl = new Element("stereoChemistry");
                            newStereoChemEl.appendChild("(" + locantText + rs + ")");
                            newStereoChemEl.addAttribute(new Attribute("type", "stereochemistryBracket"));
                            XOMTools.insertBefore(locant, newStereoChemEl);
                        } else if (!matchDigit.matcher(brackettedText).matches()) {
                            throw new ComponentGenerationException("OPSIN bug: malformed locant text");
                        }
                    } else {
                        throw new ComponentGenerationException("OPSIN bug: malformed locant text");
                    }
                }
                individualLocants.set(i, locantText);
            }
            XOMTools.setTextChild(locant, StringTools.stringListToString(individualLocants, ","));
            Element afterLocants = (Element)XOMTools.getNextSibling(locant);
            if (afterLocants == null) {
                throw new ComponentGenerationException("Nothing after locant tag: " + locant.toXML());
            }
            if (individualLocants.size() != 1) continue;
            ComponentGenerator.ifCarbohydrateLocantConvertToAminoAcidStyleLocant(locant);
        }
    }

    private static void ifCarbohydrateLocantConvertToAminoAcidStyleLocant(Element locant) {
        Element possibleMultiplier;
        if (OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(locant.getValue()).matches() && (possibleMultiplier = (Element)XOMTools.getPreviousSibling(locant)) != null && possibleMultiplier.getLocalName().equals("multiplier")) {
            int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
            Element possibleOtherLocant = (Element)XOMTools.getPreviousSibling(possibleMultiplier);
            if (possibleOtherLocant != null) {
                String[] locantValues = OpsinTools.MATCH_COMMA.split(possibleOtherLocant.getValue());
                if (locantValues.length == Integer.parseInt(possibleMultiplier.getAttributeValue("value"))) {
                    for (int i = 0; i < locantValues.length; ++i) {
                        locantValues[i] = locant.getValue() + locantValues[i];
                    }
                    XOMTools.setTextChild(possibleOtherLocant, StringTools.arrayToString(locantValues, ","));
                    locant.detach();
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < multiplierValue - 1; ++i) {
                    sb.append(locant.getValue());
                    sb.append(StringTools.multiplyString("'", i));
                    sb.append(',');
                }
                sb.append(locant.getValue());
                sb.append(StringTools.multiplyString("'", multiplierValue - 1));
                Element newLocant = new Element("locant");
                newLocant.appendChild(sb.toString());
                XOMTools.insertBefore(possibleMultiplier, newLocant);
                locant.detach();
            }
        }
    }

    private static List<String> splitIntoIndividualLocants(String locantString) {
        ArrayList<String> individualLocants = new ArrayList<String>();
        char[] charArray = locantString.toCharArray();
        boolean inBracket = false;
        int indiceOfLastMatch = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == ',') {
                if (inBracket) continue;
                individualLocants.add(locantString.substring(indiceOfLastMatch, i));
                indiceOfLastMatch = i + 1;
                continue;
            }
            if (c == '(' || c == '[' || c == '{') {
                inBracket = true;
                continue;
            }
            if (c != ')' && c != ']' && c != '}') continue;
            inBracket = false;
        }
        individualLocants.add(locantString.substring(indiceOfLastMatch, charArray.length));
        return individualLocants;
    }

    private void convertOrthoMetaParaToLocants(Element subOrRoot) throws ComponentGenerationException {
        List<Element> ompLocants = XOMTools.getChildElementsWithTagName(subOrRoot, "orthoMetaPara");
        for (Element ompLocant : ompLocants) {
            String locantText = ompLocant.getValue();
            String firstChar = locantText.substring(0, 1);
            Element afterOmpLocant = (Element)XOMTools.getNextSibling(ompLocant);
            ompLocant.setLocalName("locant");
            ompLocant.removeChildren();
            ompLocant.addAttribute(new Attribute("type", "orthoMetaPara"));
            if (afterOmpLocant.getLocalName().equals("multiplier") && afterOmpLocant.getAttributeValue("value").equals("2") || afterOmpLocant.getAttribute("outIDs") != null && OpsinTools.MATCH_COMMA.split(afterOmpLocant.getAttributeValue("outIDs")).length > 1) {
                if ("o".equalsIgnoreCase(firstChar)) {
                    ompLocant.appendChild("1,ortho");
                    continue;
                }
                if ("m".equalsIgnoreCase(firstChar)) {
                    ompLocant.appendChild("1,meta");
                    continue;
                }
                if ("p".equalsIgnoreCase(firstChar)) {
                    ompLocant.appendChild("1,para");
                    continue;
                }
                throw new ComponentGenerationException(locantText + " was not identified as being either ortho, meta or para but according to the chemical grammar it should of been");
            }
            if ("o".equalsIgnoreCase(firstChar)) {
                ompLocant.appendChild("ortho");
                continue;
            }
            if ("m".equalsIgnoreCase(firstChar)) {
                ompLocant.appendChild("meta");
                continue;
            }
            if ("p".equalsIgnoreCase(firstChar)) {
                ompLocant.appendChild("para");
                continue;
            }
            throw new ComponentGenerationException(locantText + " was not identified as being either ortho, meta or para but according to the chemical grammar it should of been");
        }
    }

    private void formAlkaneStemsFromComponents(Element subOrRoot) {
        LinkedList<Element> alkaneStemComponents = new LinkedList<Element>(XOMTools.getChildElementsWithTagName(subOrRoot, "alkaneStemComponent"));
        while (!alkaneStemComponents.isEmpty()) {
            Element alkaneStemComponent = alkaneStemComponents.removeFirst();
            int alkaneChainLength = 0;
            StringBuilder alkaneName = new StringBuilder();
            alkaneChainLength += Integer.parseInt(alkaneStemComponent.getAttributeValue("value"));
            alkaneName.append(alkaneStemComponent.getValue());
            while (!alkaneStemComponents.isEmpty() && XOMTools.getNextSibling(alkaneStemComponent) == alkaneStemComponents.get(0)) {
                alkaneStemComponent.detach();
                alkaneStemComponent = alkaneStemComponents.removeFirst();
                alkaneChainLength += Integer.parseInt(alkaneStemComponent.getAttributeValue("value"));
                alkaneName.append(alkaneStemComponent.getValue());
            }
            Element alkaneStem = new Element("group");
            alkaneStem.appendChild(alkaneName.toString());
            alkaneStem.addAttribute(new Attribute("type", "chain"));
            alkaneStem.addAttribute(new Attribute("subType", "alkaneStem"));
            alkaneStem.addAttribute(new Attribute("valType", "SMILES"));
            alkaneStem.addAttribute(new Attribute("value", StringTools.multiplyString("C", alkaneChainLength)));
            alkaneStem.addAttribute(new Attribute("usableAsAJoiner", "yes"));
            StringBuilder labels = new StringBuilder();
            for (int i = 1; i < alkaneChainLength; ++i) {
                labels.append(i);
                labels.append("/");
            }
            labels.append(alkaneChainLength);
            alkaneStem.addAttribute(new Attribute("labels", labels.toString()));
            XOMTools.insertAfter(alkaneStemComponent, alkaneStem);
            alkaneStemComponent.detach();
        }
    }

    private void processAlkaneStemModifications(Element subOrRoot) throws ComponentGenerationException {
        Elements alkaneStemModifiers = subOrRoot.getChildElements("alkaneStemModifier");
        for (int i = 0; i < alkaneStemModifiers.size(); ++i) {
            String smiles;
            boolean suffixPresent;
            String type;
            Element alkaneStemModifier = alkaneStemModifiers.get(i);
            Element alkane = (Element)XOMTools.getNextSibling(alkaneStemModifier);
            if (alkane == null || !"chain".equals(alkane.getAttributeValue("type")) || !"alkaneStem".equals(alkane.getAttributeValue("subType"))) {
                throw new ComponentGenerationException("OPSIN Bug: AlkaneStem not found after alkaneStemModifier");
            }
            if (alkaneStemModifier.getAttribute("value") != null) {
                type = alkaneStemModifier.getAttributeValue("value");
            } else if (alkaneStemModifier.getValue().equals("n-")) {
                type = "normal";
            } else if (alkaneStemModifier.getValue().equals("i-")) {
                type = "iso";
            } else if (alkaneStemModifier.getValue().equals("s-")) {
                type = "sec";
            } else {
                throw new ComponentGenerationException("Unrecognised alkaneStem modifier");
            }
            alkaneStemModifier.detach();
            if (type.equals("normal")) continue;
            int chainLength = alkane.getAttributeValue("value").length();
            boolean bl = suffixPresent = subOrRoot.getChildElements("suffix").size() > 0;
            if (type.equals("tert")) {
                if (chainLength < 4) {
                    throw new ComponentGenerationException("ChainLength to small for tert modifier, required minLength 4. Found: " + chainLength);
                }
                if (chainLength > 8) {
                    throw new ComponentGenerationException("Interpretation of tert on an alkane chain of length: " + chainLength + " is ambiguous");
                }
                smiles = chainLength == 8 ? "C(C)(C)CC(C)(C)C" : "C(C)(C)C" + StringTools.multiplyString("C", chainLength - 4);
            } else if (type.equals("iso")) {
                if (chainLength < 3) {
                    throw new ComponentGenerationException("ChainLength to small for iso modifier, required minLength 3. Found: " + chainLength);
                }
                if (chainLength == 3 && !suffixPresent) {
                    throw new ComponentGenerationException("iso has no meaning without a suffix on an alkane chain of length 3");
                }
                smiles = StringTools.multiplyString("C", chainLength - 3) + "C(C)C";
            } else if (type.equals("sec")) {
                if (chainLength < 3) {
                    throw new ComponentGenerationException("ChainLength to small for sec modifier, required minLength 3. Found: " + chainLength);
                }
                if (!suffixPresent) {
                    throw new ComponentGenerationException("sec has no meaning without a suffix on an alkane chain");
                }
                smiles = "C(C)C" + StringTools.multiplyString("C", chainLength - 3);
            } else if (type.equals("neo")) {
                if (chainLength < 5) {
                    throw new ComponentGenerationException("ChainLength to small for neo modifier, required minLength 5. Found: " + chainLength);
                }
                smiles = StringTools.multiplyString("C", chainLength - 5) + "CC(C)(C)C";
            } else {
                throw new ComponentGenerationException("Unrecognised alkaneStem modifier");
            }
            alkane.getAttribute("value").setValue(smiles);
            alkane.removeAttribute(alkane.getAttribute("usableAsAJoiner"));
            alkane.getAttribute("labels").setValue("none");
        }
    }

    private void processHeterogenousHydrides(Element subOrRoot) throws ComponentGenerationException {
        List<Element> multipliers = XOMTools.getChildElementsWithTagName(subOrRoot, "multiplier");
        for (int i = 0; i < multipliers.size(); ++i) {
            Element possibleUnsaturator;
            Element possibleMultiplier;
            Element suffix;
            Element possiblyALocant;
            Element m = multipliers.get(i);
            if (m.getAttributeValue("type").equals("group")) continue;
            int mvalue = Integer.parseInt(m.getAttributeValue("value"));
            Element multipliedElem = (Element)XOMTools.getNextSibling(m);
            if (!multipliedElem.getLocalName().equals("group") || multipliedElem.getAttribute("subType") == null || !multipliedElem.getAttributeValue("subType").equals("heteroStem") || (possiblyALocant = (Element)XOMTools.getPreviousSibling(m)) != null && possiblyALocant.getLocalName().equals("locant") && mvalue == OpsinTools.MATCH_COMMA.split(possiblyALocant.getValue()).length && (suffix = (Element)XOMTools.getNextSibling(multipliedElem, "suffix")) != null && suffix.getAttributeValue("type").equals("inline") && !(possibleMultiplier = (Element)XOMTools.getPreviousSibling(suffix)).getLocalName().equals("multiplier")) continue;
            String heteroatomSmiles = multipliedElem.getAttributeValue("value");
            if (heteroatomSmiles.equals("B") && XOMTools.getPreviousSibling(m) == null && (possibleUnsaturator = (Element)XOMTools.getNextSibling(multipliedElem)) != null && possibleUnsaturator.getLocalName().equals("unsaturator") && possibleUnsaturator.getAttributeValue("value").equals("1")) {
                throw new ComponentGenerationException("Polyboranes are not currently supported");
            }
            String smiles = StringTools.multiplyString(heteroatomSmiles, mvalue);
            multipliedElem.getAttribute("value").setValue(smiles);
            m.detach();
            multipliers.remove(i--);
        }
        for (Element m : multipliers) {
            int j;
            Element possiblyAnUnsaturator;
            Element possiblyAnotherHeteroAtom;
            Element multipliedElem;
            if (m.getAttributeValue("type").equals("group") || !(multipliedElem = (Element)XOMTools.getNextSibling(m)).getLocalName().equals("heteroatom") || (possiblyAnotherHeteroAtom = (Element)XOMTools.getNextSibling(multipliedElem)) == null || !possiblyAnotherHeteroAtom.getLocalName().equals("heteroatom") || (possiblyAnUnsaturator = XOMTools.getNextSiblingIgnoringCertainElements(possiblyAnotherHeteroAtom, new String[]{"locant", "multiplier"})) == null || !possiblyAnUnsaturator.getLocalName().equals("unsaturator")) continue;
            if (possiblyAnUnsaturator.getAttributeValue("value").equals("1")) {
                this.checkForAmbiguityWithHWring(multipliedElem.getAttributeValue("value"), possiblyAnotherHeteroAtom.getAttributeValue("value"));
            }
            int mvalue = Integer.parseInt(m.getAttributeValue("value"));
            StringBuilder smilesSB = new StringBuilder();
            Element possiblyARingFormingEl = (Element)XOMTools.getPreviousSibling(m);
            boolean heteroatomChainWillFormARing = false;
            if (possiblyARingFormingEl != null && (possiblyARingFormingEl.getLocalName().equals("cyclo") || possiblyARingFormingEl.getLocalName().equals("vonBaeyer") || possiblyARingFormingEl.getLocalName().equals("spiro"))) {
                heteroatomChainWillFormARing = true;
                for (j = 0; j < mvalue; ++j) {
                    smilesSB.append(possiblyAnotherHeteroAtom.getAttributeValue("value"));
                    smilesSB.append(multipliedElem.getAttributeValue("value"));
                }
            } else {
                for (j = 0; j < mvalue - 1; ++j) {
                    smilesSB.append(multipliedElem.getAttributeValue("value"));
                    smilesSB.append(possiblyAnotherHeteroAtom.getAttributeValue("value"));
                }
                smilesSB.append(multipliedElem.getAttributeValue("value"));
            }
            String smiles = smilesSB.toString();
            smiles = matchHdigit.matcher(smiles).replaceAll("H?");
            multipliedElem.detach();
            Element addedGroup = new Element("group");
            addedGroup.addAttribute(new Attribute("value", smiles));
            addedGroup.addAttribute(new Attribute("valType", "SMILES"));
            addedGroup.addAttribute(new Attribute("type", "chain"));
            addedGroup.addAttribute(new Attribute("subType", "heteroStem"));
            if (!heteroatomChainWillFormARing) {
                addedGroup.addAttribute(new Attribute("usableAsAJoiner", "yes"));
            }
            addedGroup.appendChild(smiles);
            XOMTools.insertAfter(possiblyAnotherHeteroAtom, addedGroup);
            possiblyAnotherHeteroAtom.detach();
            m.detach();
        }
    }

    private void checkForAmbiguityWithHWring(String firstHeteroAtomSMILES, String secondHeteroAtomSMILES) throws ComponentGenerationException {
        Matcher m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(firstHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        String atom1Element = m.group();
        m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(secondHeteroAtomSMILES);
        if (!m.find()) {
            throw new ComponentGenerationException("Failed to extract element from heteroatom");
        }
        String atom2Element = m.group();
        if (AtomProperties.elementToHwPriority.get(atom1Element) > AtomProperties.elementToHwPriority.get(atom2Element) && (atom2Element.equals("O") || atom2Element.equals("S") || atom2Element.equals("Se") || atom2Element.equals("Te") || atom2Element.equals("Bi") || atom2Element.equals("Hg")) && !this.hasSiorGeorSnorPb(atom1Element, atom2Element)) {
            throw new ComponentGenerationException("Hantzch-widman ring misparsed as a heterogeneous hydride with alternating atoms");
        }
    }

    private boolean hasSiorGeorSnorPb(String atom1Element, String atom2Element) {
        return atom1Element.equals("Si") || atom1Element.equals("Ge") || atom1Element.equals("Sn") || atom1Element.equals("Pb") || atom2Element.equals("Si") || atom2Element.equals("Ge") || atom2Element.equals("Sn") || atom2Element.equals("Pb");
    }

    private void processIndicatedHydrogens(Element subOrRoot) throws ComponentGenerationException {
        List<Element> indicatedHydrogens = XOMTools.getChildElementsWithTagName(subOrRoot, "indicatedHydrogen");
        for (Element indicatedHydrogenGroup : indicatedHydrogens) {
            String[] hydrogenLocants;
            String txt = StringTools.removeDashIfPresent(indicatedHydrogenGroup.getValue());
            if (!StringTools.endsWithCaseInsensitive(txt, "h")) {
                txt = txt.substring(1, txt.length() - 1);
            }
            for (String hydrogenLocant : hydrogenLocants = OpsinTools.MATCH_COMMA.split(txt)) {
                if (!StringTools.endsWithCaseInsensitive(hydrogenLocant, "h")) {
                    throw new ComponentGenerationException("OPSIN Bug: malformed indicated hydrogen element!");
                }
                Element indicatedHydrogenEl = new Element("indicatedHydrogen");
                indicatedHydrogenEl.addAttribute(new Attribute("locant", hydrogenLocant.substring(0, hydrogenLocant.length() - 1)));
                XOMTools.insertBefore(indicatedHydrogenGroup, indicatedHydrogenEl);
            }
            indicatedHydrogenGroup.detach();
        }
    }

    static void processStereochemistry(Element subOrRoot) throws ComponentGenerationException {
        List<Element> stereoChemistryElements = XOMTools.getChildElementsWithTagName(subOrRoot, "stereoChemistry");
        for (Element stereoChemistryElement : stereoChemistryElements) {
            if (stereoChemistryElement.getAttributeValue("type").equals("stereochemistryBracket")) {
                ComponentGenerator.processStereochemistryBracket(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("cisOrTrans")) {
                ComponentGenerator.assignLocantUsingPreviousElementIfPresent(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("EorZ")) {
                stereoChemistryElement.addAttribute(new Attribute("value", stereoChemistryElement.getValue()));
                ComponentGenerator.assignLocantUsingPreviousElementIfPresent(stereoChemistryElement);
                continue;
            }
            if (!stereoChemistryElement.getAttributeValue("type").equals("alphaOrBeta")) continue;
            ComponentGenerator.processUnbracketedAlphaBetaStereochemistry(stereoChemistryElement);
        }
    }

    private static void processStereochemistryBracket(Element stereoChemistryElement) throws ComponentGenerationException {
        Matcher starMatcher;
        String txt = StringTools.removeDashIfPresent(stereoChemistryElement.getValue());
        if (txt.startsWith("rel-")) {
            txt = txt.substring(4);
        }
        if (!(txt = (starMatcher = matchStar.matcher(txt)).replaceAll("")).startsWith("rac-")) {
            String[] stereoChemistryDescriptors;
            txt = txt.substring(1, txt.length() - 1);
            for (String stereoChemistryDescriptor : stereoChemistryDescriptors = matchCommaOrDash.split(txt)) {
                Matcher m = matchStereochemistry.matcher(stereoChemistryDescriptor);
                if (m.matches()) {
                    if (m.group(2).equals("RS") || m.group(2).equals("SR")) continue;
                    Element stereoChemEl = new Element("stereoChemistry");
                    if (m.group(1).length() != 0) {
                        stereoChemEl.addAttribute(new Attribute("locant", m.group(1)));
                    }
                    stereoChemEl.appendChild(stereoChemistryDescriptor);
                    XOMTools.insertBefore(stereoChemistryElement, stereoChemEl);
                    if (matchRS.matcher(m.group(2)).matches()) {
                        stereoChemEl.addAttribute(new Attribute("type", "RorS"));
                        stereoChemEl.addAttribute(new Attribute("value", m.group(2).toUpperCase()));
                        continue;
                    }
                    if (matchEZ.matcher(m.group(2)).matches()) {
                        stereoChemEl.addAttribute(new Attribute("type", "EorZ"));
                        stereoChemEl.addAttribute(new Attribute("value", m.group(2).toUpperCase()));
                        continue;
                    }
                    if (matchAlphaBetaStereochem.matcher(m.group(2)).matches()) {
                        stereoChemEl.addAttribute(new Attribute("type", "alphaOrBeta"));
                        if (Character.toLowerCase(m.group(2).charAt(0)) == 'a') {
                            stereoChemEl.addAttribute(new Attribute("value", "alpha"));
                            continue;
                        }
                        if (Character.toLowerCase(m.group(2).charAt(0)) == 'b') {
                            stereoChemEl.addAttribute(new Attribute("value", "beta"));
                            continue;
                        }
                        if (Character.toLowerCase(m.group(2).charAt(0)) == 'x') {
                            stereoChemEl.addAttribute(new Attribute("value", "xi"));
                            continue;
                        }
                        throw new ComponentGenerationException("Malformed alpha/beta stereochemistry element: " + stereoChemistryElement.getValue());
                    }
                    if (matchCisTrans.matcher(m.group(2)).matches()) {
                        stereoChemEl.addAttribute(new Attribute("type", "cisOrTrans"));
                        stereoChemEl.addAttribute(new Attribute("value", m.group(2).toLowerCase()));
                        continue;
                    }
                    throw new ComponentGenerationException("Malformed stereochemistry element: " + stereoChemistryElement.getValue());
                }
                throw new ComponentGenerationException("Malformed stereochemistry element: " + stereoChemistryElement.getValue());
            }
        }
        stereoChemistryElement.detach();
    }

    private static void assignLocantUsingPreviousElementIfPresent(Element stereoChemistryElement) {
        Element possibleLocant = (Element)XOMTools.getPrevious(stereoChemistryElement);
        if (possibleLocant != null && possibleLocant.getLocalName().equals("locant") && OpsinTools.MATCH_COMMA.split(possibleLocant.getValue()).length == 1) {
            stereoChemistryElement.addAttribute(new Attribute("locant", possibleLocant.getValue()));
            possibleLocant.detach();
        }
    }

    private static void processUnbracketedAlphaBetaStereochemistry(Element stereoChemistryElement) throws ComponentGenerationException {
        String txt = StringTools.removeDashIfPresent(stereoChemistryElement.getValue());
        String[] stereoChemistryDescriptors = OpsinTools.MATCH_COMMA.split(txt);
        ArrayList<String> locants = new ArrayList<String>();
        boolean createLocantsEl = false;
        for (String stereoChemistryDescriptor : stereoChemistryDescriptors) {
            Matcher digitMatcher = matchDigit.matcher(stereoChemistryDescriptor);
            if (!digitMatcher.lookingAt()) continue;
            String locant = digitMatcher.group();
            String possibleAlphaBeta = digitMatcher.replaceAll("");
            locants.add(locant);
            Matcher alphaBetaMatcher = matchAlphaBetaStereochem.matcher(possibleAlphaBeta);
            if (alphaBetaMatcher.matches()) {
                Element stereoChemEl = new Element("stereoChemistry");
                stereoChemEl.addAttribute(new Attribute("locant", locant));
                stereoChemEl.appendChild(stereoChemistryDescriptor);
                XOMTools.insertBefore(stereoChemistryElement, stereoChemEl);
                stereoChemEl.addAttribute(new Attribute("type", "alphaOrBeta"));
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'a') {
                    stereoChemEl.addAttribute(new Attribute("value", "alpha"));
                    continue;
                }
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'b') {
                    stereoChemEl.addAttribute(new Attribute("value", "beta"));
                    continue;
                }
                if (Character.toLowerCase(possibleAlphaBeta.charAt(0)) == 'x') {
                    stereoChemEl.addAttribute(new Attribute("value", "xi"));
                    continue;
                }
                throw new ComponentGenerationException("Malformed alpha/beta stereochemistry element: " + stereoChemistryElement.getValue());
            }
            createLocantsEl = true;
        }
        if (!createLocantsEl) {
            createLocantsEl = true;
            List<Element> groups = XOMTools.getNextSiblingsOfType(stereoChemistryElement, "group");
            for (Element group : groups) {
                if (group.getAttributeValue("alphaBetaClockWiseAtomOrdering") == null) continue;
                createLocantsEl = false;
                break;
            }
        }
        if (createLocantsEl) {
            Element newLocantEl = new Element("locant");
            newLocantEl.appendChild(StringTools.stringListToString(locants, ","));
            XOMTools.insertAfter(stereoChemistryElement, newLocantEl);
        }
        stereoChemistryElement.detach();
    }

    private void processSuffixPrefixes(Element subOrRoot) throws ComponentGenerationException {
        List<Element> suffixPrefixes = XOMTools.getChildElementsWithTagName(subOrRoot, "suffixPrefix");
        for (Element suffixPrefix : suffixPrefixes) {
            Element suffix = (Element)XOMTools.getNextSibling(suffixPrefix);
            if (suffix == null || !suffix.getLocalName().equals("suffix")) {
                throw new ComponentGenerationException("OPSIN bug: suffix not found after suffixPrefix: " + suffixPrefix.getValue());
            }
            suffix.addAttribute(new Attribute("suffixPrefix", suffixPrefix.getAttributeValue("value")));
            suffixPrefix.detach();
        }
    }

    private void processInfixes(Element subOrRoot) throws ComponentGenerationException {
        List<Element> infixes = XOMTools.getChildElementsWithTagName(subOrRoot, "infix");
        for (Element infix : infixes) {
            Element possibleBracket;
            List<String> currentInfixInformation;
            Element suffix = XOMTools.getNextSiblingIgnoringCertainElements(infix, new String[]{"infix", "suffixPrefix", "multiplier"});
            if (suffix == null || !suffix.getLocalName().equals("suffix")) {
                throw new ComponentGenerationException("No suffix found next next to infix: " + infix.getValue());
            }
            if (suffix.getAttribute("infix") == null) {
                suffix.addAttribute(new Attribute("infix", ""));
                currentInfixInformation = new ArrayList<String>();
            } else {
                currentInfixInformation = StringTools.arrayToList(OpsinTools.MATCH_SEMICOLON.split(suffix.getAttributeValue("infix")));
            }
            String infixValue = infix.getAttributeValue("value");
            currentInfixInformation.add(infixValue);
            Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(infix);
            boolean multiplierPrecededBySuffixPrefixOrImmediatelyByMultiplier = false;
            if (possibleMultiplier.getLocalName().equals("multiplier")) {
                Element possibleSuffixPrefix = XOMTools.getPreviousSiblingIgnoringCertainElements(infix, new String[]{"multiplier", "infix"});
                if (possibleSuffixPrefix != null && possibleSuffixPrefix.getLocalName().equals("suffixPrefix")) {
                    multiplierPrecededBySuffixPrefixOrImmediatelyByMultiplier = true;
                }
                if ((possibleBracket = (Element)XOMTools.getPreviousSibling(possibleMultiplier)).getLocalName().equals("multiplier")) {
                    multiplierPrecededBySuffixPrefixOrImmediatelyByMultiplier = true;
                }
            } else {
                possibleBracket = possibleMultiplier;
                possibleMultiplier = null;
                infix.detach();
            }
            if (possibleBracket.getLocalName().equals("structuralOpenBracket")) {
                Element bracket = (Element)XOMTools.getNextSibling(suffix);
                if (!bracket.getLocalName().equals("structuralCloseBracket")) {
                    throw new ComponentGenerationException("Matching closing bracket not found around infix/suffix block");
                }
                if (possibleMultiplier != null) {
                    int multiplierVal = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                    for (int i = 1; i < multiplierVal; ++i) {
                        currentInfixInformation.add(infixValue);
                    }
                    possibleMultiplier.detach();
                    infix.detach();
                }
                possibleBracket.detach();
                bracket.detach();
            } else if (possibleMultiplier != null && multiplierPrecededBySuffixPrefixOrImmediatelyByMultiplier) {
                int multiplierVal = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int i = 1; i < multiplierVal; ++i) {
                    currentInfixInformation.add(infixValue);
                }
                possibleMultiplier.detach();
                infix.detach();
            } else if (possibleMultiplier != null && "group".equals(possibleMultiplier.getAttributeValue("type"))) {
                infix.detach();
            }
            suffix.getAttribute("infix").setValue(StringTools.stringListToString(currentInfixInformation, ";"));
        }
    }

    private void processLambdaConvention(Element subOrRoot) throws ComponentGenerationException {
        List<Element> lambdaConventionEls = XOMTools.getChildElementsWithTagName(subOrRoot, "lambdaConvention");
        boolean fusedRingPresent = false;
        if (lambdaConventionEls.size() > 0 && subOrRoot.getChildElements("group").size() > 1) {
            fusedRingPresent = true;
        }
        for (Element lambdaConventionEl : lambdaConventionEls) {
            boolean frontLocantsExpected = false;
            String[] lambdaValues = OpsinTools.MATCH_COMMA.split(StringTools.removeDashIfPresent(lambdaConventionEl.getValue()));
            Element possibleHeteroatomOrMultiplier = (Element)XOMTools.getNextSibling(lambdaConventionEl);
            int heteroCount = 0;
            int multiplierValue = 1;
            while (possibleHeteroatomOrMultiplier != null) {
                if (possibleHeteroatomOrMultiplier.getLocalName().equals("heteroatom")) {
                    heteroCount += multiplierValue;
                    multiplierValue = 1;
                } else {
                    if (!possibleHeteroatomOrMultiplier.getLocalName().equals("multiplier")) break;
                    multiplierValue = Integer.parseInt(possibleHeteroatomOrMultiplier.getAttributeValue("value"));
                }
                possibleHeteroatomOrMultiplier = (Element)XOMTools.getNextSibling(possibleHeteroatomOrMultiplier);
            }
            boolean assignLambdasToHeteroAtoms = false;
            if (lambdaValues.length == heteroCount) {
                if (!(fusedRingPresent && possibleHeteroatomOrMultiplier != null && possibleHeteroatomOrMultiplier.getLocalName().equals("group") && possibleHeteroatomOrMultiplier.getAttributeValue("subType").equals("hantzschWidman"))) {
                    assignLambdasToHeteroAtoms = true;
                }
            } else if (heteroCount == 0 && XOMTools.getNextSibling(lambdaConventionEl).equals(possibleHeteroatomOrMultiplier) && possibleHeteroatomOrMultiplier != null && fusedRingPresent && possibleHeteroatomOrMultiplier.getLocalName().equals("group") && (possibleHeteroatomOrMultiplier.getValue().equals("benzo") || possibleHeteroatomOrMultiplier.getValue().equals("benz")) && !((Element)XOMTools.getNextSibling(possibleHeteroatomOrMultiplier)).getLocalName().equals("fusion") || possibleHeteroatomOrMultiplier.getLocalName().equals("polyCyclicSpiro") && (possibleHeteroatomOrMultiplier.getAttributeValue("value").equals("spirobi") || possibleHeteroatomOrMultiplier.getAttributeValue("value").equals("spiroter"))) {
                frontLocantsExpected = true;
            }
            ArrayList<Element> heteroAtoms = new ArrayList<Element>();
            if (assignLambdasToHeteroAtoms) {
                Element multiplier = null;
                Element heteroatomOrMultiplier = (Element)XOMTools.getNextSibling(lambdaConventionEl);
                while (heteroatomOrMultiplier != null) {
                    if (heteroatomOrMultiplier.getLocalName().equals("heteroatom")) {
                        heteroAtoms.add(heteroatomOrMultiplier);
                        if (multiplier != null) {
                            for (int i = 1; i < Integer.parseInt(multiplier.getAttributeValue("value")); ++i) {
                                Element newHeteroAtom = new Element(heteroatomOrMultiplier);
                                XOMTools.insertBefore(heteroatomOrMultiplier, newHeteroAtom);
                                heteroAtoms.add(newHeteroAtom);
                            }
                            multiplier.detach();
                            multiplier = null;
                        }
                    } else {
                        if (!heteroatomOrMultiplier.getLocalName().equals("multiplier") || multiplier != null) break;
                        multiplier = heteroatomOrMultiplier;
                    }
                    heteroatomOrMultiplier = (Element)XOMTools.getNextSibling(heteroatomOrMultiplier);
                }
            }
            for (int i = 0; i < lambdaValues.length; ++i) {
                String lambdaValue = lambdaValues[i];
                Matcher m = matchLambdaConvention.matcher(lambdaValue);
                if (m.matches()) {
                    Attribute valencyChange = new Attribute("lambda", m.group(2));
                    Attribute locantAtr = null;
                    if (m.group(1) != null) {
                        locantAtr = new Attribute("locant", m.group(1));
                    }
                    if (frontLocantsExpected) {
                        if (m.group(1) == null) {
                            throw new ComponentGenerationException("Locant not found for lambda convention before a benzo fused ring system");
                        }
                        lambdaValues[i] = m.group(1);
                    }
                    if (assignLambdasToHeteroAtoms) {
                        Element heteroAtom = (Element)heteroAtoms.get(i);
                        heteroAtom.addAttribute(valencyChange);
                        if (locantAtr == null) continue;
                        heteroAtom.addAttribute(locantAtr);
                        continue;
                    }
                    Element newLambda = new Element("lambdaConvention");
                    newLambda.addAttribute(valencyChange);
                    if (locantAtr != null) {
                        newLambda.addAttribute(locantAtr);
                    }
                    XOMTools.insertBefore(lambdaConventionEl, newLambda);
                    continue;
                }
                if (!assignLambdasToHeteroAtoms) {
                    if (frontLocantsExpected) continue;
                    throw new ComponentGenerationException("Lambda convention not specified for locant: " + lambdaValue);
                }
                Element heteroAtom = (Element)heteroAtoms.get(i);
                heteroAtom.addAttribute(new Attribute("locant", lambdaValue));
            }
            if (!frontLocantsExpected) {
                lambdaConventionEl.detach();
                continue;
            }
            lambdaConventionEl.setLocalName("locant");
            XOMTools.setTextChild(lambdaConventionEl, StringTools.arrayToString(lambdaValues, ","));
        }
    }

    private boolean findAndStructureBrackets(List<Element> substituentsAndRoot) throws ComponentGenerationException {
        int blevel = 0;
        Element openBracket = null;
        Element closeBracket = null;
        for (Element sub : substituentsAndRoot) {
            Elements children2 = sub.getChildElements();
            for (int i = 0; i < children2.size(); ++i) {
                Element child = children2.get(i);
                if (child.getLocalName().equals("openbracket")) {
                    if (openBracket == null) {
                        openBracket = child;
                    }
                    ++blevel;
                    continue;
                }
                if (!child.getLocalName().equals("closebracket") || --blevel != 0) continue;
                closeBracket = child;
                Element bracket = this.structureBrackets(openBracket, closeBracket);
                while (this.findAndStructureBrackets(XOMTools.getDescendantElementsWithTagName(bracket, "substituent"))) {
                }
                return true;
            }
        }
        if (blevel != 0) {
            throw new ComponentGenerationException("Brackets do not match!");
        }
        return false;
    }

    private Element structureBrackets(Element openBracket, Element closeBracket) throws ComponentGenerationException {
        Node nextNode;
        Element bracket = new Element("bracket");
        XOMTools.insertBefore(openBracket.getParent(), bracket);
        while (!openBracket.getParent().getChild(0).equals(openBracket)) {
            Node n = openBracket.getParent().getChild(0);
            n.detach();
            bracket.appendChild(n);
        }
        Node currentNode = openBracket.getParent();
        while (!currentNode.equals(closeBracket.getParent())) {
            nextNode = XOMTools.getNextSibling(currentNode);
            currentNode.detach();
            bracket.appendChild(currentNode);
            currentNode = nextNode;
            if (currentNode != null) continue;
            throw new ComponentGenerationException("Brackets within a word do not match!");
        }
        currentNode.detach();
        bracket.appendChild(currentNode);
        currentNode = XOMTools.getNextSibling(closeBracket);
        while (currentNode != null) {
            nextNode = XOMTools.getNextSibling(currentNode);
            currentNode.detach();
            bracket.appendChild(currentNode);
            currentNode = nextNode;
        }
        openBracket.detach();
        closeBracket.detach();
        return bracket;
    }

    private void processHydroCarbonRings(Element subOrRoot) throws ComponentGenerationException {
        List<Element> annulens = XOMTools.getChildElementsWithTagName(subOrRoot, "annulen");
        for (Element annulen : annulens) {
            String annulenValue = annulen.getValue();
            Matcher match = matchAnnulene.matcher(annulenValue);
            match.matches();
            if (match.groupCount() != 1) {
                throw new ComponentGenerationException("Invalid annulen tag");
            }
            int annulenSize = Integer.valueOf(match.group(1));
            if (annulenSize < 3) {
                throw new ComponentGenerationException("Invalid annulen tag");
            }
            String SMILES = "c1" + StringTools.multiplyString("c", annulenSize - 1);
            SMILES = SMILES + "1";
            Element group = new Element("group");
            group.addAttribute(new Attribute("value", SMILES));
            group.addAttribute(new Attribute("valType", "SMILES"));
            group.addAttribute(new Attribute("type", "ring"));
            group.addAttribute(new Attribute("subType", "arylGroup"));
            group.appendChild(annulenValue);
            annulen.getParent().replaceChild(annulen, group);
        }
        List<Element> hydrocarbonFRSystems = XOMTools.getChildElementsWithTagName(subOrRoot, "hydrocarbonFusedRingSystem");
        for (Element hydrocarbonFRSystem : hydrocarbonFRSystems) {
            Element multiplier = (Element)XOMTools.getPreviousSibling(hydrocarbonFRSystem);
            if (multiplier != null && multiplier.getLocalName().equals("multiplier")) {
                int j;
                int multiplierValue = Integer.parseInt(multiplier.getAttributeValue("value"));
                String classOfHydrocarbonFRSystem = hydrocarbonFRSystem.getAttributeValue("value");
                Element newGroup = new Element("group");
                StringBuilder smilesSB = new StringBuilder();
                if (classOfHydrocarbonFRSystem.equals("polyacene")) {
                    if (multiplierValue <= 3) {
                        throw new ComponentGenerationException("Invalid polyacene");
                    }
                    smilesSB.append("c1ccc");
                    for (j = 2; j <= multiplierValue; ++j) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(j));
                        smilesSB.append("c");
                    }
                    smilesSB.append("ccc");
                    for (j = multiplierValue; j > 2; --j) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(j));
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyaphene")) {
                    int j2;
                    int ringsOnPlane;
                    int ringsAbovePlane;
                    if (multiplierValue <= 3) {
                        throw new ComponentGenerationException("Invalid polyaphene");
                    }
                    smilesSB.append("c1ccc");
                    int ringOpeningCounter = 2;
                    if (multiplierValue % 2 == 0) {
                        ringsAbovePlane = (multiplierValue - 2) / 2;
                        ringsOnPlane = ringsAbovePlane + 1;
                    } else {
                        ringsOnPlane = ringsAbovePlane = (multiplierValue - 1) / 2;
                    }
                    for (j2 = 1; j2 <= ringsAbovePlane; ++j2) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                        smilesSB.append("c");
                    }
                    for (j2 = 1; j2 <= ringsOnPlane; ++j2) {
                        smilesSB.append("cc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                    }
                    smilesSB.append("ccc");
                    --ringOpeningCounter;
                    for (j2 = 1; j2 <= ringsOnPlane; ++j2) {
                        smilesSB.append("cc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                    }
                    for (j2 = 1; j2 < ringsAbovePlane; ++j2) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyalene")) {
                    if (multiplierValue < 5) {
                        throw new ComponentGenerationException("Invalid polyalene");
                    }
                    smilesSB.append("c1");
                    for (j = 3; j < multiplierValue; ++j) {
                        smilesSB.append("c");
                    }
                    smilesSB.append("c2");
                    for (j = 3; j <= multiplierValue; ++j) {
                        smilesSB.append("c");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polyphenylene")) {
                    if (multiplierValue < 2) {
                        throw new ComponentGenerationException("Invalid polyphenylene");
                    }
                    smilesSB.append("c1cccc2");
                    for (j = 1; j < multiplierValue; ++j) {
                        smilesSB.append("c3ccccc3");
                    }
                    smilesSB.append("c12");
                } else if (classOfHydrocarbonFRSystem.equals("polynaphthylene")) {
                    if (multiplierValue < 3) {
                        throw new ComponentGenerationException("Invalid polynaphthylene");
                    }
                    smilesSB.append("c1cccc2cc3");
                    for (j = 1; j < multiplierValue; ++j) {
                        smilesSB.append("c4cc5ccccc5cc4");
                    }
                    smilesSB.append("c3cc12");
                } else if (classOfHydrocarbonFRSystem.equals("polyhelicene")) {
                    int j3;
                    if (multiplierValue < 6) {
                        throw new ComponentGenerationException("Invalid polyhelicene");
                    }
                    smilesSB.append("c1c");
                    int ringOpeningCounter = 2;
                    for (j3 = 1; j3 < multiplierValue; ++j3) {
                        smilesSB.append("ccc");
                        smilesSB.append(this.ringClosure(ringOpeningCounter++));
                    }
                    smilesSB.append("cccc");
                    --ringOpeningCounter;
                    for (j3 = 2; j3 < multiplierValue; ++j3) {
                        smilesSB.append("c");
                        smilesSB.append(this.ringClosure(ringOpeningCounter--));
                    }
                    smilesSB.append("c12");
                } else {
                    throw new ComponentGenerationException("Unknown semi-trivially named hydrocarbon fused ring system");
                }
                newGroup.addAttribute(new Attribute("value", smilesSB.toString()));
                newGroup.addAttribute(new Attribute("valType", "SMILES"));
                newGroup.addAttribute(new Attribute("labels", "fusedRing"));
                newGroup.addAttribute(new Attribute("type", "ring"));
                newGroup.addAttribute(new Attribute("subType", "hydrocarbonFusedRingSystem"));
                newGroup.appendChild(multiplier.getValue() + hydrocarbonFRSystem.getValue());
                hydrocarbonFRSystem.getParent().replaceChild(hydrocarbonFRSystem, newGroup);
                multiplier.detach();
                continue;
            }
            throw new ComponentGenerationException("Invalid semi-trivially named hydrocarbon fused ring system");
        }
    }

    private void handleSuffixIrregularities(Element subOrRoot) throws ComponentGenerationException {
        List<Element> suffixes = XOMTools.getChildElementsWithTagName(subOrRoot, "suffix");
        for (Element suffix : suffixes) {
            Element beforeSuffix;
            String o;
            Element group;
            String suffixValue = suffix.getValue();
            if (suffixValue.equals("ic") || suffixValue.equals("ous")) {
                Node next2 = XOMTools.getNext(suffix);
                if (next2 != null) continue;
                throw new ComponentGenerationException("\"acid\" not found after " + suffixValue);
            }
            if (suffixValue.equals("quinone") || suffixValue.equals("quinon")) {
                suffix.removeAttribute(suffix.getAttribute("additionalValue"));
                XOMTools.setTextChild(suffix, "one");
                Element multiplier = new Element("multiplier");
                multiplier.addAttribute(new Attribute("value", "2"));
                multiplier.appendChild("di");
                XOMTools.insertBefore(suffix, multiplier);
                continue;
            }
            if (suffixValue.equals("ylene") || suffixValue.equals("ylen")) {
                suffix.removeAttribute(suffix.getAttribute("additionalValue"));
                XOMTools.setTextChild(suffix, "yl");
                Element alk = (Element)XOMTools.getPreviousSibling(suffix, "group");
                if (alk.getAttribute("usableAsAJoiner") != null) {
                    alk.getAttribute("usableAsAJoiner").detach();
                }
                Element multiplier = new Element("multiplier");
                multiplier.addAttribute(new Attribute("value", "2"));
                multiplier.appendChild("di");
                XOMTools.insertBefore(suffix, multiplier);
                continue;
            }
            if (!suffixValue.equals("ylium") || !"acylium".equals(suffix.getAttributeValue("value")) || suffix.getAttribute("suffixPrefix") != null || suffix.getAttribute("infix") != null || (group = (Element)XOMTools.getPreviousSibling(suffix, "group")) != null && ("acidStem".equals(group.getAttributeValue("type")) || "chalcogenAcidStem".equals(group.getAttributeValue("type")) || "nonCarboxylicAcid".equals(group.getAttributeValue("type"))) || (o = (beforeSuffix = (Element)XOMTools.getPreviousSibling(suffix)).getAttributeValue("subsequentUnsemanticToken")) != null && StringTools.endsWithCaseInsensitive(o, "o")) continue;
            if (group != null && "arylSubstituent".equals(group.getAttributeValue("subType"))) {
                suffix.getAttribute("value").setValue("ylium");
                suffix.getAttribute("type").setValue("charge");
                suffix.removeAttribute(suffix.getAttribute("subType"));
                continue;
            }
            throw new ComponentGenerationException("ylium is intended to be the removal of H- in this context not the formation of an acylium ion");
        }
    }

    private void detectAlkaneFusedRingBridges(Element group) {
        Element possibleBridgeFormer;
        if ("alkaneStem".equals(group.getAttributeValue("subType")) && (possibleBridgeFormer = XOMTools.getNextSiblingIgnoringCertainElements(group, new String[]{"unsaturator"})) != null && possibleBridgeFormer.getLocalName().equals("bridgeFormingO")) {
            possibleBridgeFormer.detach();
            group.setLocalName("fusedRingBridge");
        }
    }

    private void processRings(Element group) throws ComponentGenerationException {
        Element previous = (Element)XOMTools.getPreviousSibling(group);
        if (previous != null) {
            String previousElType = previous.getLocalName();
            if (previousElType.equals("spiro")) {
                this.processSpiroSystem(group, previous);
            } else if (previousElType.equals("vonBaeyer")) {
                this.processVonBaeyerSystem(group, previous);
            } else if (previousElType.equals("cyclo")) {
                this.processCyclisedChain(group, previous);
            }
        }
    }

    private void processSpiroSystem(Element chainGroup, Element spiroEl) throws NumberFormatException, ComponentGenerationException {
        int[][] spiroDescriptors = this.getSpiroDescriptors(StringTools.removeDashIfPresent(spiroEl.getValue()));
        Element multiplier = (Element)XOMTools.getPreviousSibling(spiroEl);
        int numberOfSpiros = 1;
        if (multiplier != null && multiplier.getLocalName().equals("multiplier")) {
            numberOfSpiros = Integer.parseInt(multiplier.getAttributeValue("value"));
            multiplier.detach();
        }
        int numberOfCarbonInDescriptors = 0;
        for (int[] spiroDescriptor : spiroDescriptors) {
            numberOfCarbonInDescriptors += spiroDescriptor[0];
        }
        if ((numberOfCarbonInDescriptors += numberOfSpiros) != chainGroup.getAttributeValue("value").length()) {
            throw new ComponentGenerationException("Disagreement between number of atoms in spiro descriptor: " + numberOfCarbonInDescriptors + " and number of atoms in chain: " + chainGroup.getAttributeValue("value").length());
        }
        int numOfOpenedBrackets = 1;
        int curIndex = 2;
        String smiles = "C0" + StringTools.multiplyString("C", spiroDescriptors[0][0]) + "10(";
        for (int i = 1; i < spiroDescriptors.length; ++i) {
            if (spiroDescriptors[i][1] >= 0) {
                int ringOpeningPos = this.findIndexOfRingOpenings(smiles, spiroDescriptors[i][1]);
                String ringOpeningLabel = String.valueOf(smiles.charAt(ringOpeningPos));
                ++ringOpeningPos;
                if (ringOpeningLabel.equals("%")) {
                    while (smiles.charAt(ringOpeningPos) >= '0' && smiles.charAt(ringOpeningPos) <= '9' && ringOpeningPos < smiles.length()) {
                        ringOpeningLabel = ringOpeningLabel + smiles.charAt(ringOpeningPos);
                        ++ringOpeningPos;
                    }
                }
                if (smiles.indexOf("C" + ringOpeningLabel, ringOpeningPos) >= 0) {
                    smiles = smiles.substring(0, ringOpeningPos) + this.ringClosure(curIndex) + smiles.substring(ringOpeningPos);
                    smiles = smiles + "(" + StringTools.multiplyString("C", spiroDescriptors[i][0]) + this.ringClosure(curIndex) + ")";
                    ++curIndex;
                    continue;
                }
                smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]) + ringOpeningLabel + ")";
                continue;
            }
            if (numOfOpenedBrackets >= numberOfSpiros) {
                smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]);
                smiles = smiles + this.ringClosure(--curIndex) + ")";
                continue;
            }
            smiles = smiles + StringTools.multiplyString("C", spiroDescriptors[i][0]);
            smiles = smiles + "C" + this.ringClosure(curIndex++) + "(";
            ++numOfOpenedBrackets;
        }
        chainGroup.getAttribute("value").setValue(smiles);
        chainGroup.getAttribute("type").setValue("ring");
        if (chainGroup.getAttribute("usableAsAJoiner") != null) {
            chainGroup.removeAttribute(chainGroup.getAttribute("usableAsAJoiner"));
        }
        spiroEl.detach();
    }

    private String ringClosure(int ringClosure) {
        if (ringClosure > 9) {
            return "%" + Integer.toString(ringClosure);
        }
        return Integer.toString(ringClosure);
    }

    private int[][] getSpiroDescriptors(String text2) {
        text2 = text2.indexOf("-") == 5 ? text2.substring(7, text2.length() - 1) : text2.substring(6, text2.length() - 1);
        String[] spiroDescriptorStrings = matchCommaOrDot.split(text2);
        int[][] spiroDescriptors = new int[spiroDescriptorStrings.length][2];
        for (int i = 0; i < spiroDescriptorStrings.length; ++i) {
            String[] elements = matchNonDigit.split(spiroDescriptorStrings[i]);
            if (elements.length > 1) {
                spiroDescriptors[i][0] = Integer.parseInt(elements[0]);
                StringBuilder superScriptedNumber = new StringBuilder();
                for (int j = 1; j < elements.length; ++j) {
                    superScriptedNumber.append(elements[j]);
                }
                spiroDescriptors[i][1] = Integer.parseInt(superScriptedNumber.toString());
                continue;
            }
            spiroDescriptors[i][0] = Integer.parseInt(spiroDescriptorStrings[i]);
            spiroDescriptors[i][1] = -1;
        }
        return spiroDescriptors;
    }

    private Integer findIndexOfRingOpenings(String smiles, int locant) throws ComponentGenerationException {
        int count2 = 0;
        int pos = -1;
        for (int i = 0; i < smiles.length(); ++i) {
            if (smiles.charAt(i) == 'C') {
                ++count2;
            }
            if (count2 != locant) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            throw new ComponentGenerationException("Unable to find atom corresponding to number indicated by superscript in spiro descriptor");
        }
        return ++pos;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVonBaeyerSystem(Element chainEl, Element vonBaeyerBracketEl) throws ComponentGenerationException {
        ArrayList<HashMap> arrayList;
        String vonBaeyerBracket = StringTools.removeDashIfPresent(vonBaeyerBracketEl.getValue());
        Element multiplier = (Element)XOMTools.getPreviousSibling(vonBaeyerBracketEl);
        int numberOfRings = Integer.parseInt(multiplier.getAttributeValue("value"));
        multiplier.detach();
        LinkedList<String> elementSymbolArray = new LinkedList<String>();
        if (!chainEl.getAttributeValue("valType").equals("SMILES")) throw new ComponentGenerationException("unexpected group valType: " + chainEl.getAttributeValue("valType"));
        String smiles = chainEl.getAttributeValue("value");
        char[] smilesArray = smiles.toCharArray();
        for (int i = 0; i < smilesArray.length; ++i) {
            char currentChar = smilesArray[i];
            if (currentChar == '[') {
                if (smilesArray[i + 2] == ']') {
                    elementSymbolArray.add("[" + String.valueOf(smilesArray[i + 1]) + "]");
                    i += 2;
                    continue;
                }
                elementSymbolArray.add("[" + String.valueOf(smilesArray[i + 1]) + String.valueOf(smilesArray[i + 2]) + "]");
                i += 3;
                continue;
            }
            elementSymbolArray.add(String.valueOf(currentChar));
        }
        int alkylChainLength = elementSymbolArray.size();
        int totalLengthOfBridges = 0;
        int bridgeLabelsUsed = 3;
        ArrayList bridges = new ArrayList();
        HashMap bridgeLocations = new HashMap(alkylChainLength);
        vonBaeyerBracket = vonBaeyerBracket.indexOf("-") == 5 ? vonBaeyerBracket.substring(7, vonBaeyerBracket.length() - 1) : vonBaeyerBracket.substring(6, vonBaeyerBracket.length() - 1);
        String[] bridgeDescriptors = matchCommaOrDot.split(vonBaeyerBracket);
        for (int i = 0; i < bridgeDescriptors.length; ++i) {
            String bridgeDescriptor = bridgeDescriptors[i];
            HashMap<String, Integer> bridge2 = new HashMap<String, Integer>();
            int bridgeLength = 0;
            if (i > 2) {
                void var17_25;
                String string2 = bridgeDescriptors[++i].replaceAll("\\D", "");
                String[] tempArray = bridgeDescriptor.split("\\D+");
                if (tempArray.length == 1) {
                    char[] tempCharArray = bridgeDescriptor.toCharArray();
                    if (tempCharArray.length == 2) {
                        bridgeLength = Character.getNumericValue(tempCharArray[0]);
                        String string3 = Character.toString(tempCharArray[1]);
                    } else if (tempCharArray.length == 3) {
                        bridgeLength = Character.getNumericValue(tempCharArray[0]);
                        String string4 = Character.toString(tempCharArray[1]) + Character.toString(tempCharArray[2]);
                    } else {
                        if (tempCharArray.length != 4) throw new ComponentGenerationException("Unsupported Von Baeyer locant description: " + bridgeDescriptor);
                        bridgeLength = Integer.parseInt(Character.toString(tempCharArray[0]) + Character.toString(tempCharArray[1]));
                        String string5 = Character.toString(tempCharArray[2]) + Character.toString(tempCharArray[3]);
                    }
                } else {
                    bridgeLength = Integer.parseInt(tempArray[0]);
                    String string6 = tempArray[1];
                }
                bridge2.put("Bridge Length", bridgeLength);
                int coordinates1 = Integer.parseInt((String)var17_25);
                int coordinates2 = Integer.parseInt(string2);
                if (coordinates1 > alkylChainLength || coordinates2 > alkylChainLength) {
                    throw new ComponentGenerationException("Indicated bridge position is not on chain: " + coordinates1 + "," + coordinates2);
                }
                if (coordinates2 > coordinates1) {
                    int swap = coordinates1;
                    coordinates1 = coordinates2;
                    coordinates2 = swap;
                }
                if (bridgeLocations.get(coordinates1) == null) {
                    bridgeLocations.put(coordinates1, new ArrayList());
                }
                if (bridgeLocations.get(coordinates2) == null) {
                    bridgeLocations.put(coordinates2, new ArrayList());
                }
                ((ArrayList)bridgeLocations.get(coordinates1)).add(bridgeLabelsUsed);
                bridge2.put("AtomId_Larger_Label", bridgeLabelsUsed);
                ++bridgeLabelsUsed;
                if (bridgeLength == 0) {
                    ((ArrayList)bridgeLocations.get(coordinates2)).add(bridgeLabelsUsed - 1);
                    bridge2.put("AtomId_Smaller_Label", bridgeLabelsUsed - 1);
                } else {
                    ((ArrayList)bridgeLocations.get(coordinates2)).add(bridgeLabelsUsed);
                    bridge2.put("AtomId_Smaller_Label", bridgeLabelsUsed);
                }
                ++bridgeLabelsUsed;
                bridge2.put("AtomId_Larger", coordinates1);
                bridge2.put("AtomId_Smaller", coordinates2);
            } else {
                bridgeLength = Integer.parseInt(bridgeDescriptor);
                bridge2.put("Bridge Length", bridgeLength);
            }
            totalLengthOfBridges += bridgeLength;
            bridges.add(bridge2);
        }
        if (totalLengthOfBridges + 2 != alkylChainLength) {
            throw new ComponentGenerationException("Disagreement between lengths of bridges and alkyl chain length");
        }
        if (numberOfRings + 1 != bridges.size()) {
            throw new ComponentGenerationException("Disagreement between number of rings and number of bridges");
        }
        StringBuilder smilesSB = new StringBuilder();
        int atomCounter = 1;
        int bridgeCounter = 1;
        for (HashMap hashMap : bridges) {
            if (bridgeCounter == 1) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                smilesSB.append("1");
                if (bridgeLocations.get(atomCounter) != null) {
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
                smilesSB.append("(");
            }
            int n = (Integer)hashMap.get("Bridge Length");
            for (int i = 0; i < n; ++i) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                if (bridgeLocations.get(++atomCounter) == null) continue;
                for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                    smilesSB.append(this.ringClosure(bridgeAtomLabel));
                }
            }
            if (bridgeCounter == 1) {
                smilesSB.append((String)elementSymbolArray.removeFirst());
                smilesSB.append("2");
                if (bridgeLocations.get(++atomCounter) != null) {
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
            }
            if (bridgeCounter == 2) {
                smilesSB.append("1)");
            }
            if (bridgeCounter == 3) {
                smilesSB.append("2");
            }
            if (++bridgeCounter <= 3) continue;
            break;
        }
        ArrayList<HashMap> secondaryBridges = new ArrayList<HashMap>();
        for (HashMap hashMap : bridges) {
            if (hashMap.get("AtomId_Larger") == null || (Integer)hashMap.get("Bridge Length") == 0) continue;
            secondaryBridges.add(hashMap);
        }
        VonBaeyerSecondaryBridgeSort vonBaeyerSecondaryBridgeSort = new VonBaeyerSecondaryBridgeSort();
        Collections.sort(secondaryBridges, vonBaeyerSecondaryBridgeSort);
        do {
            arrayList = new ArrayList<HashMap>();
            for (HashMap bridge3 : secondaryBridges) {
                int bridgeLength = (Integer)bridge3.get("Bridge Length");
                if ((Integer)bridge3.get("AtomId_Larger") > atomCounter) {
                    arrayList.add(bridge3);
                    continue;
                }
                smilesSB.append(".");
                for (int i = 0; i < bridgeLength; ++i) {
                    ++atomCounter;
                    smilesSB.append((String)elementSymbolArray.removeFirst());
                    if (i == 0) {
                        smilesSB.append(this.ringClosure((Integer)bridge3.get("AtomId_Larger_Label")));
                    }
                    if (bridgeLocations.get(atomCounter) == null) continue;
                    for (Integer bridgeAtomLabel : (ArrayList)bridgeLocations.get(atomCounter)) {
                        smilesSB.append(this.ringClosure(bridgeAtomLabel));
                    }
                }
                smilesSB.append(this.ringClosure((Integer)bridge3.get("AtomId_Smaller_Label")));
            }
            if (arrayList.size() > 0 && arrayList.size() == secondaryBridges.size()) {
                throw new ComponentGenerationException("Unable to resolve all dependant bridges!!!");
            }
            secondaryBridges = arrayList;
        } while (arrayList.size() > 0);
        chainEl.getAttribute("value").setValue(smilesSB.toString());
        chainEl.getAttribute("type").setValue("ring");
        if (chainEl.getAttribute("usableAsAJoiner") != null) {
            chainEl.removeAttribute(chainEl.getAttribute("usableAsAJoiner"));
        }
        vonBaeyerBracketEl.detach();
    }

    private void processCyclisedChain(Element chainGroup, Element cycloEl) throws ComponentGenerationException {
        String smiles = chainGroup.getAttributeValue("value");
        int chainlen = 0;
        for (int i = smiles.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(smiles.charAt(i)) || smiles.charAt(i) == 'H') continue;
            ++chainlen;
        }
        if (chainlen < 3) {
            throw new ComponentGenerationException("Heteroatom chain too small to create a ring: " + chainlen);
        }
        if ((smiles = smiles + "1").charAt(0) == '[') {
            int closeBracketIndex = smiles.indexOf(93);
            smiles = smiles.substring(0, closeBracketIndex + 1) + "1" + smiles.substring(closeBracketIndex + 1);
        } else {
            smiles = Character.getType(smiles.charAt(1)) == 2 ? smiles.substring(0, 2) + "1" + smiles.substring(2) : smiles.substring(0, 1) + "1" + smiles.substring(1);
        }
        chainGroup.getAttribute("value").setValue(smiles);
        if (chainlen == 6) {
            if (chainGroup.getAttribute("labels") != null) {
                chainGroup.getAttribute("labels").setValue("1/2,ortho/3,meta/4,para/5/6");
            } else {
                chainGroup.addAttribute(new Attribute("labels", "1/2,ortho/3,meta/4,para/5/6"));
            }
        }
        chainGroup.getAttribute("type").setValue("ring");
        if (chainGroup.getAttribute("usableAsAJoiner") != null) {
            chainGroup.removeAttribute(chainGroup.getAttribute("usableAsAJoiner"));
        }
        cycloEl.detach();
    }

    private void handleGroupIrregularities(Element group) throws ComponentGenerationException {
        Elements children2;
        Element substituent;
        Element suffix;
        Element enclosingSubOrRoot;
        Element previous;
        Node next2;
        String groupValue = group.getValue();
        if (group.getAttribute("functionalIDs") != null && (groupValue.endsWith("ic") || groupValue.endsWith("ous")) && (next2 = XOMTools.getNext(group)) == null) {
            throw new ComponentGenerationException("\"acid\" not found after " + groupValue);
        }
        if (groupValue.equals("thiophen") || groupValue.equals("selenophen") || groupValue.equals("tellurophen")) {
            Element isThisALocant;
            Element possibleSuffix = (Element)XOMTools.getNextSibling(group);
            if (!"e".equals(group.getAttributeValue("subsequentUnsemanticToken")) && possibleSuffix != null && possibleSuffix.getLocalName().equals("suffix") && possibleSuffix.getValue().startsWith("ol") && ((isThisALocant = (Element)XOMTools.getPreviousSibling(group)) == null || !isThisALocant.getLocalName().equals("locant") || OpsinTools.MATCH_COMMA.split(isThisALocant.getValue()).length != 1)) {
                throw new ComponentGenerationException(groupValue + "ol has been incorrectly interpreted as " + groupValue + ", ol instead of phenol with the oxgen replaced");
            }
        } else if (groupValue.equals("methylene") || groupValue.equals("methylen")) {
            Elements children3;
            Element nextSub = (Element)XOMTools.getNextSibling(group.getParent());
            if (nextSub != null && nextSub.getLocalName().equals("substituent") && XOMTools.getNextSibling(group) == null && (XOMTools.getPreviousSibling(group) == null || !((Element)XOMTools.getPreviousSibling(group)).getLocalName().equals("multiplier")) && (children3 = nextSub.getChildElements()).size() >= 2 && children3.get(0).getValue().equals("di") && children3.get(1).getValue().equals("oxy")) {
                XOMTools.setTextChild(group, groupValue + "dioxy");
                group.getAttribute("value").setValue("C(O)O");
                group.getAttribute("valType").setValue("SMILES");
                group.getAttribute("outIDs").setValue("2,3");
                group.getAttribute("subType").setValue("epoxyLike");
                if (group.getAttribute("labels") != null) {
                    group.getAttribute("labels").setValue("none");
                } else {
                    group.addAttribute(new Attribute("labels", "none"));
                }
                nextSub.detach();
                for (int i = children3.size() - 1; i >= 2; --i) {
                    children3.get(i).detach();
                    XOMTools.insertAfter(group, children3.get(i));
                }
            }
        } else if (groupValue.equals("ethylene") || groupValue.equals("ethylen")) {
            previous = (Element)XOMTools.getPreviousSibling(group);
            if (previous != null && previous.getLocalName().equals("multiplier")) {
                Elements children4;
                int multiplierValue = Integer.parseInt(previous.getAttributeValue("value"));
                Element possibleRoot = (Element)XOMTools.getNextSibling(group.getParent());
                if (possibleRoot == null && OpsinTools.getParentWordRule(group).getAttributeValue("wordRule").equals(WordRule.glycol.toString())) {
                    StringBuilder smiles = new StringBuilder("CC");
                    for (int i = 1; i < multiplierValue; ++i) {
                        smiles.append("OCC");
                    }
                    group.getAttribute("outIDs").setValue("1," + Integer.toString(3 * (multiplierValue - 1) + 2));
                    group.getAttribute("value").setValue(smiles.toString());
                    previous.detach();
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("numeric");
                    } else {
                        group.addAttribute(new Attribute("labels", "numeric"));
                    }
                } else if (possibleRoot != null && possibleRoot.getLocalName().equals("root") && (children4 = possibleRoot.getChildElements()).size() == 2) {
                    Element amineMultiplier = children4.get(0);
                    Element amine = children4.get(1);
                    if (amineMultiplier.getLocalName().equals("multiplier") && (amine.getValue().equals("amine") || amine.getValue().equals("amin"))) {
                        if (Integer.parseInt(amineMultiplier.getAttributeValue("value")) != multiplierValue + 1) {
                            throw new ComponentGenerationException("Invalid polyethylene amine!");
                        }
                        StringBuilder smiles = new StringBuilder();
                        for (int i = 0; i < multiplierValue; ++i) {
                            smiles.append("NCC");
                        }
                        smiles.append("N");
                        group.removeAttribute(group.getAttribute("outIDs"));
                        group.getAttribute("value").setValue(smiles.toString());
                        previous.detach();
                        possibleRoot.detach();
                        ((Element)group.getParent()).setLocalName("root");
                        if (group.getAttribute("labels") != null) {
                            group.getAttribute("labels").setValue("numeric");
                        } else {
                            group.addAttribute(new Attribute("labels", "numeric"));
                        }
                    }
                }
            } else {
                Elements children5;
                Element nextSub = (Element)XOMTools.getNextSibling(group.getParent());
                if (nextSub != null && nextSub.getLocalName().equals("substituent") && XOMTools.getNextSibling(group) == null && (children5 = nextSub.getChildElements()).size() >= 2 && children5.get(0).getValue().equals("di") && children5.get(1).getValue().equals("oxy")) {
                    XOMTools.setTextChild(group, groupValue + "dioxy");
                    group.getAttribute("value").setValue("C(O)CO");
                    group.getAttribute("valType").setValue("SMILES");
                    group.getAttribute("outIDs").setValue("2,4");
                    group.getAttribute("subType").setValue("epoxyLike");
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("none");
                    } else {
                        group.addAttribute(new Attribute("labels", "none"));
                    }
                    nextSub.detach();
                    for (int i = children5.size() - 1; i >= 2; --i) {
                        children5.get(i).detach();
                        XOMTools.insertAfter(group, children5.get(i));
                    }
                }
            }
        } else if (groupValue.equals("propylene") || groupValue.equals("propylen")) {
            previous = (Element)XOMTools.getPreviousSibling(group);
            if (previous != null && previous.getLocalName().equals("multiplier")) {
                int multiplierValue = Integer.parseInt(previous.getAttributeValue("value"));
                Element possibleRoot = (Element)XOMTools.getNextSibling(group.getParent());
                if (possibleRoot == null && OpsinTools.getParentWordRule(group).getAttributeValue("wordRule").equals(WordRule.glycol.toString())) {
                    StringBuilder smiles = new StringBuilder("CCC");
                    for (int i = 1; i < multiplierValue; ++i) {
                        smiles.append("OC(C)C");
                    }
                    group.getAttribute("outIDs").setValue("2," + Integer.toString(4 * (multiplierValue - 1) + 3));
                    group.getAttribute("value").setValue(smiles.toString());
                    if (group.getAttribute("labels") != null) {
                        group.getAttribute("labels").setValue("none");
                    } else {
                        group.addAttribute(new Attribute("labels", "none"));
                    }
                    previous.detach();
                }
            }
        } else if (groupValue.equals("anthr") || groupValue.equals("phenanthr") || groupValue.equals("xanth") || groupValue.equals("thioxanth") || groupValue.equals("selenoxanth") || groupValue.equals("telluroxanth") || groupValue.equals("xanthen")) {
            Element possibleLocant = (Element)XOMTools.getPreviousSibling(group);
            if (possibleLocant == null || !possibleLocant.getLocalName().equals("locant")) {
                String suffixVal;
                Element possibleSuffix = (Element)XOMTools.getNextSibling(group);
                if (possibleSuffix != null && "one".equals(possibleSuffix.getAttributeValue("value"))) {
                    Element newLocant = new Element("locant");
                    newLocant.appendChild("9");
                    XOMTools.insertBefore(possibleSuffix, newLocant);
                    Element newAddedHydrogen = new Element("addedHydrogen");
                    newAddedHydrogen.addAttribute(new Attribute("locant", "10"));
                    XOMTools.insertBefore(newLocant, newAddedHydrogen);
                } else if ((possibleSuffix != null && possibleSuffix.getLocalName().equals("suffix") && groupValue.equals("xanth") || groupValue.equals("thioxanth") || groupValue.equals("selenoxanth") || groupValue.equals("telluroxanth")) && ((suffixVal = possibleSuffix.getAttributeValue("value")).equals("ic") || suffixVal.equals("ate"))) {
                    throw new ComponentGenerationException(groupValue + possibleSuffix.getValue() + " is not a derivative of xanthene");
                }
            }
        } else if (groupValue.equals("phospho")) {
            Element nextGroup;
            Element substituent2 = (Element)group.getParent();
            Element nextSubstituent = (Element)XOMTools.getNextSibling(substituent2);
            if (nextSubstituent != null && (nextGroup = nextSubstituent.getFirstChildElement("group")) != null && (nextGroup.getAttributeValue("type").equals("aminoAcid") || "biochemical".equals(nextGroup.getAttributeValue("subType")) || "carbohydrate".equals(nextGroup.getAttributeValue("subType")))) {
                group.getAttribute("value").setValue("-P(=O)(O)O");
                group.addAttribute(new Attribute("usableAsAJoiner", "yes"));
            }
        } else if (groupValue.equals("cyste")) {
            Element ine;
            if (group.getAttributeValue("subType").equals("endInIne") && !(ine = (Element)XOMTools.getNextSibling(group)).getAttributeValue("value").equals("ine")) {
                throw new ComponentGenerationException("This is a cysteic acid derivative, not a cysteine derivative");
            }
        } else if (groupValue.equals("hydrogen")) {
            Element hydrogenParentEl = (Element)group.getParent();
            Element nextSubOrRoot = (Element)XOMTools.getNextSibling(hydrogenParentEl);
            if (nextSubOrRoot != null) {
                Element possibleSuitableAteGroup = (Element)nextSubOrRoot.getChild(0);
                if (!possibleSuitableAteGroup.getLocalName().equals("group") || !"nonCarboxylicAcid".equals(possibleSuitableAteGroup.getAttributeValue("type"))) {
                    throw new ComponentGenerationException("Hydrogen is not meant as a substituent in this context!");
                }
                Element possibleMultiplier = (Element)XOMTools.getPreviousSibling(group);
                String multiplier = "1";
                if (possibleMultiplier != null && possibleMultiplier.getLocalName().equals("multiplier")) {
                    multiplier = possibleMultiplier.getAttributeValue("value");
                    possibleMultiplier.detach();
                }
                possibleSuitableAteGroup.addAttribute(new Attribute("numberOfFunctionalAtomsToRemove", multiplier));
                group.detach();
                Elements childrenToMove = hydrogenParentEl.getChildElements();
                for (int i = childrenToMove.size() - 1; i >= 0; --i) {
                    childrenToMove.get(i).detach();
                    nextSubOrRoot.insertChild(childrenToMove.get(i), 0);
                }
                hydrogenParentEl.detach();
            }
        } else if (groupValue.equals("acryl")) {
            Element nextEl;
            if ("simpleSubstituent".equals(group.getAttributeValue("subType")) && (nextEl = (Element)XOMTools.getNext(group)) != null && nextEl.getValue().equals("amid")) {
                throw new ComponentGenerationException("amide in acrylamide is not [NH2-]");
            }
        } else if (groupValue.equals("azo") || groupValue.equals("azoxy") || groupValue.equals("nno-azoxy") || groupValue.equals("non-azoxy") || groupValue.equals("onn-azoxy") || groupValue.equals("diazoamino") || groupValue.equals("hydrazo")) {
            List<Element> suffixes;
            Element enclosingSub = (Element)group.getParent();
            Element next3 = XOMTools.getNextSiblingIgnoringCertainElements(enclosingSub, new String[]{"hyphen"});
            if (next3 == null && XOMTools.getPreviousSibling(enclosingSub) == null) {
                next3 = XOMTools.getNextSiblingIgnoringCertainElements((Element)enclosingSub.getParent(), new String[]{"hyphen"});
            }
            if (next3 != null && next3.getLocalName().equals("root") && !((Element)next3.getChild(0)).getLocalName().equals("multiplier") && (suffixes = XOMTools.getChildElementsWithTagName(next3, "suffix")).size() == 0) {
                Element newMultiplier = new Element("multiplier");
                newMultiplier.addAttribute(new Attribute("value", "2"));
                next3.insertChild(newMultiplier, 0);
                Element interSubstituentHyphen = (Element)XOMTools.getPrevious(group);
                if (interSubstituentHyphen != null && !interSubstituentHyphen.getLocalName().equals("hyphen")) {
                    XOMTools.insertAfter(interSubstituentHyphen, new Element("hyphen"));
                }
            }
        } else if (groupValue.equals("coenzyme a") || groupValue.equals("coa")) {
            Element possibleAcid;
            List<Element> groups;
            enclosingSubOrRoot = (Element)group.getParent();
            Element previous2 = (Element)XOMTools.getPreviousSibling(enclosingSubOrRoot);
            if (previous2 != null && (groups = XOMTools.getDescendantElementsWithTagName(previous2, "group")).size() > 0 && "acidStem".equals((possibleAcid = groups.get(groups.size() - 1)).getAttributeValue("type"))) {
                String subType;
                Element suffix2;
                if (possibleAcid.getAttribute("suffixAppliesTo") != null && (suffix2 = (Element)XOMTools.getNextSibling(possibleAcid, "suffix")).getAttribute("additionalValue") == null) {
                    suffix2.addAttribute(new Attribute("additionalValue", "ic"));
                }
                if ((subType = possibleAcid.getAttributeValue("subType")).equals("ylForYl") || subType.equals("ylForNothing")) {
                    possibleAcid.getAttribute("subType").setValue("ylForAcyl");
                }
            }
            Element newBracket = new Element("bracket");
            XOMTools.insertAfter(enclosingSubOrRoot, newBracket);
            enclosingSubOrRoot.detach();
            newBracket.appendChild(enclosingSubOrRoot);
        } else if (groupValue.equals("sphinganine") || groupValue.equals("icosasphinganine") || groupValue.equals("eicosasphinganine") || groupValue.equals("phytosphingosine") || groupValue.equals("sphingosine")) {
            List<Element> inlineSuffixes;
            Element possibleAcid;
            List<Element> groups;
            enclosingSubOrRoot = (Element)group.getParent();
            Element previous3 = (Element)XOMTools.getPreviousSibling(enclosingSubOrRoot);
            if (previous3 != null && (groups = XOMTools.getDescendantElementsWithTagName(previous3, "group")).size() > 0 && "alkaneStem".equals((possibleAcid = groups.get(groups.size() - 1)).getAttributeValue("subType")) && (inlineSuffixes = XOMTools.getChildElementsWithTagNameAndAttribute((Element)possibleAcid.getParent(), "suffix", "type", "inline")).size() == 1 && inlineSuffixes.get(0).getAttributeValue("value").equals("yl")) {
                inlineSuffixes.get(0).getAttribute("value").setValue("oyl");
            }
        } else if (groupValue.equals("sel")) {
            Element ium;
            Element unsaturator;
            if ("heteroStem".equals(group.getAttributeValue("subType")) && group.getAttribute("subsequentUnsemanticToken") == null && (unsaturator = (Element)XOMTools.getNextSibling(group)) != null && unsaturator.getLocalName().equals("unsaturator") && unsaturator.getValue().equals("en") && group.getAttribute("subsequentUnsemanticToken") == null && (ium = (Element)XOMTools.getNextSibling(unsaturator)) != null && ium.getLocalName().equals("suffix") && ium.getValue().equals("ium")) {
                throw new ComponentGenerationException("<multiplier>selenium does not indicate a chain of selenium atoms with a double bond and a positive charge");
            }
        } else if (groupValue.equals("keto") && "simpleSubstituent".equals(group.getAttributeValue("subType"))) {
            Element possibleCarbohydrate;
            Element parentSubstituent = (Element)group.getParent();
            Element nextSubOrRoot = (Element)XOMTools.getNextSibling(parentSubstituent);
            if (nextSubOrRoot != null && (possibleCarbohydrate = nextSubOrRoot.getFirstChildElement("group")) != null && "carbohydrate".equals(possibleCarbohydrate.getAttributeValue("subType"))) {
                group.detach();
                Elements childrenToMove = parentSubstituent.getChildElements();
                for (int i = childrenToMove.size() - 1; i >= 0; --i) {
                    Element el = childrenToMove.get(i);
                    if (el.getLocalName().equals("hyphen")) continue;
                    el.detach();
                    nextSubOrRoot.insertChild(el, 0);
                }
                parentSubstituent.detach();
            }
        } else if (groupValue.equals("bor")) {
            Elements children6;
            Element substituent3;
            suffix = (Element)XOMTools.getNextSibling(group);
            if (suffix != null && (suffix.getAttributeValue("value").equals("ic") || suffix.getAttributeValue("value").equals("ate")) && (substituent3 = (Element)XOMTools.getPreviousSibling(group.getParent())) != null && (children6 = substituent3.getChildElements()).size() == 1 && children6.get(0).getLocalName().equals("group") && (children6.get(0).getValue().equals("fluoro") || children6.get(0).getValue().equals("fluor"))) {
                if (suffix.getAttributeValue("value").equals("ic")) {
                    group.getAttribute("value").setValue("F[B-](F)(F)F.[H+]");
                } else {
                    group.getAttribute("value").setValue("F[B-](F)(F)F");
                }
                substituent3.detach();
                suffix.detach();
            }
        } else if (groupValue.equals("antimon") && (suffix = (Element)XOMTools.getNextSibling(group)) != null && suffix.getAttributeValue("value").equals("ic") && (substituent = (Element)XOMTools.getPreviousSibling(group.getParent())) != null && (children2 = substituent.getChildElements()).size() == 1 && children2.get(0).getLocalName().equals("group") && (children2.get(0).getValue().equals("fluoro") || children2.get(0).getValue().equals("fluor"))) {
            substituent.detach();
            suffix.detach();
            group.getAttribute("value").setValue("F[Sb-](F)(F)(F)(F)F.[H+]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VonBaeyerSecondaryBridgeSort
    implements Comparator<HashMap<String, Integer>> {
        private VonBaeyerSecondaryBridgeSort() {
        }

        @Override
        public int compare(HashMap<String, Integer> bridge1, HashMap<String, Integer> bridge2) {
            int bridgelength2;
            int smallerCoordinate2;
            int largerCoordinate2;
            int largerCoordinate1 = bridge1.get("AtomId_Larger");
            if (largerCoordinate1 > (largerCoordinate2 = bridge2.get("AtomId_Larger").intValue())) {
                return -1;
            }
            if (largerCoordinate2 > largerCoordinate1) {
                return 1;
            }
            int smallerCoordinate1 = bridge1.get("AtomId_Smaller");
            if (smallerCoordinate1 > (smallerCoordinate2 = bridge2.get("AtomId_Smaller").intValue())) {
                return -1;
            }
            if (smallerCoordinate2 > smallerCoordinate1) {
                return 1;
            }
            int bridgelength1 = bridge1.get("Bridge Length");
            if (bridgelength1 > (bridgelength2 = bridge2.get("Bridge Length").intValue())) {
                return -1;
            }
            if (bridgelength2 > bridgelength1) {
                return 1;
            }
            return 0;
        }
    }
}

