/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentManager;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

class CMLFragmentBuilder {
    private Document fragmentDoc;

    CMLFragmentBuilder(ResourceGetter resourceGetter) throws IOException {
        this.fragmentDoc = resourceGetter.getXMLDocument("fragments.xml");
    }

    Fragment build(String id, String type, String subType, FragmentManager fragManager) throws StructureBuildingException {
        List<Element> toBuildElements = XOMTools.getChildElementsWithTagNameAndAttribute(this.fragmentDoc.getRootElement(), "molecule", "id", id);
        if (toBuildElements.size() == 0) {
            throw new StructureBuildingException("Fragment " + id + " could not be found in the fragments file.");
        }
        if (toBuildElements.size() > 1) {
            throw new StructureBuildingException("Fragment " + id + " is not unique in the fragments file.");
        }
        Element cmlMol = toBuildElements.get(0);
        return this.build(cmlMol, type, subType, fragManager);
    }

    private Fragment build(Element cmlMol, String type, String subType, FragmentManager fragManager) throws StructureBuildingException {
        Element atomArray = cmlMol.getFirstChildElement("atomArray");
        Element bondArray = cmlMol.getFirstChildElement("bondArray");
        HashMap<String, Atom> idDict = new HashMap<String, Atom>();
        Fragment currentFrag = new Fragment(type, subType);
        Elements atoms = atomArray.getChildElements("atom");
        for (int i = 0; i < atoms.size(); ++i) {
            Atom atom = this.buildAtomFromCML(fragManager, atoms.get(i), currentFrag);
            idDict.put(atoms.get(i).getAttributeValue("id"), atom);
        }
        Elements bonds = bondArray.getChildElements("bond");
        for (int i = 0; i < bonds.size(); ++i) {
            String ar2 = bonds.get(i).getAttributeValue("atomRefs2");
            String[] ar2a = ar2.split(" ");
            Atom fromAtom = (Atom)idDict.get(ar2a[0]);
            Atom toAtom = (Atom)idDict.get(ar2a[1]);
            String bondOrder = bonds.get(i).getAttributeValue("order");
            if (bondOrder.equalsIgnoreCase("s")) {
                bondOrder = "1";
            }
            if (bondOrder.equalsIgnoreCase("d")) {
                bondOrder = "2";
            }
            if (bondOrder.equalsIgnoreCase("t")) {
                bondOrder = "3";
            }
            fragManager.createBond(fromAtom, toAtom, Integer.parseInt(bondOrder));
        }
        CycleDetector.assignWhetherAtomsAreInCycles(currentFrag);
        return currentFrag;
    }

    Atom buildAtomFromCML(FragmentManager fragManager, Element cmlAtom, Fragment frag) throws StructureBuildingException {
        String hcStr;
        String elementType = cmlAtom.getAttributeValue("elementType");
        if (elementType.equals("H")) {
            throw new StructureBuildingException("Explicit hydrogens are not yet supported in OPSIN's CML reading implementation");
        }
        Atom a = fragManager.createAtom(elementType, frag);
        Elements cmlLocants = cmlAtom.getChildElements("label");
        for (int i = 0; i < cmlLocants.size(); ++i) {
            a.addLocant(cmlLocants.get(i).getAttributeValue("value"));
        }
        String chargeStr = cmlAtom.getAttributeValue("formalCharge");
        if (chargeStr != null) {
            a.setCharge(Integer.parseInt(chargeStr));
        }
        if ((hcStr = cmlAtom.getAttributeValue("hydrogenCount")) != null) {
            throw new StructureBuildingException("Hydrogen count attribute is not yet supported in OPSIN's CML reading implementation");
        }
        return a;
    }
}

