/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import nu.xom.Attribute;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.PropertyKey;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Atom {
    private int ID;
    private String element;
    private final List<String> locants = new ArrayList<String>();
    private int charge = 0;
    private Integer isotope = null;
    private AtomParity atomParity = null;
    private final Set<Bond> bonds = new LinkedHashSet<Bond>();
    private final Map<PropertyKey, Object> properties = new HashMap<PropertyKey, Object>();
    static final PropertyKey<Set<Atom>> AMBIGUOUS_ELEMENT_ASSIGNMENT = new PropertyKey("ambiguousElementAssignment");
    static final PropertyKey<Integer> SMILES_HYDROGEN_COUNT = new PropertyKey("smilesHydrogenCount");
    static final PropertyKey<Integer> OXIDATION_NUMBER = new PropertyKey("oxidationNumber");
    static final PropertyKey<Boolean> ISALDEHYDE = new PropertyKey("isAldehyde");
    static final PropertyKey<Integer> VISITED = new PropertyKey("visited");
    private Fragment frag;
    private boolean spareValency = false;
    private int outValency = 0;
    private Integer lambdaConventionValency;
    private Integer minimumValency;
    private int protonsExplicitlyAddedOrRemoved = 0;
    private String type;
    private boolean atomIsInACycle = false;

    Atom(int ID, String element, Fragment frag) {
        if (frag == null) {
            throw new IllegalArgumentException("Atom is not in a fragment!");
        }
        if (element == null) {
            throw new IllegalArgumentException("Atom does not have an element!");
        }
        this.frag = frag;
        this.ID = ID;
        this.element = element;
        this.type = frag.getType();
    }

    Atom(String element) {
        this.element = element;
    }

    Element toCMLAtom() {
        Element elem2 = new Element("atom", "http://www.xml-cml.org/schema");
        elem2.addAttribute(new Attribute("id", "a" + Integer.toString(this.ID)));
        elem2.addAttribute(new Attribute("elementType", this.element));
        if (this.charge != 0) {
            elem2.addAttribute(new Attribute("formalCharge", Integer.toString(this.charge)));
        }
        if (this.isotope != null) {
            elem2.addAttribute(new Attribute("isotopeNumber", Integer.toString(this.isotope)));
        }
        if (!this.element.equals("H")) {
            int hydrogenCount = 0;
            List<Atom> neighbours = this.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (!neighbour.getElement().equals("H")) continue;
                ++hydrogenCount;
            }
            if (hydrogenCount == 0) {
                elem2.addAttribute(new Attribute("hydrogenCount", "0"));
            }
        }
        if (this.atomParity != null) {
            elem2.appendChild(this.atomParity.toCML());
        }
        for (String l : this.locants) {
            Element locant = new Element("label", "http://www.xml-cml.org/schema");
            locant.addAttribute(new Attribute("value", l));
            locant.addAttribute(new Attribute("dictRef", "cmlDict:locant"));
            elem2.appendChild(locant);
        }
        return elem2;
    }

    int determineValency(boolean considerOutValency) {
        Integer defaultValency;
        Integer calculatedMinValency;
        if (this.lambdaConventionValency != null) {
            return this.lambdaConventionValency + this.protonsExplicitlyAddedOrRemoved;
        }
        int currentValency = this.getIncomingValency();
        if (considerOutValency) {
            currentValency += this.outValency;
        }
        Integer n = calculatedMinValency = this.minimumValency == null ? null : Integer.valueOf(this.minimumValency + this.protonsExplicitlyAddedOrRemoved);
        if (!(this.charge != 0 && this.protonsExplicitlyAddedOrRemoved == 0 || (defaultValency = ValencyChecker.getDefaultValency(this.element)) == null || currentValency > (defaultValency = Integer.valueOf(defaultValency + this.protonsExplicitlyAddedOrRemoved)) || calculatedMinValency != null && defaultValency < calculatedMinValency)) {
            return defaultValency;
        }
        Integer[] possibleValencies = ValencyChecker.getPossibleValencies(this.element, this.charge);
        if (possibleValencies != null) {
            if (calculatedMinValency != null && calculatedMinValency >= currentValency) {
                return calculatedMinValency;
            }
            for (Integer possibleValency : possibleValencies) {
                if (calculatedMinValency != null && possibleValency < calculatedMinValency || currentValency > possibleValency) continue;
                return possibleValency;
            }
        }
        if (calculatedMinValency != null && calculatedMinValency >= currentValency) {
            return calculatedMinValency;
        }
        return currentValency;
    }

    void addLocant(String locant) {
        this.locants.add(locant);
        this.frag.addMappingToAtomLocantMap(locant, this);
    }

    void replaceLocants(String locant) {
        this.clearLocants();
        this.addLocant(locant);
    }

    void removeLocant(String locantToRemove) {
        int locantArraySize = this.locants.size();
        for (int i = locantArraySize - 1; i >= 0; --i) {
            if (!this.locants.get(i).equals(locantToRemove)) continue;
            this.locants.remove(i);
            this.frag.removeMappingFromAtomLocantMap(locantToRemove);
        }
    }

    void clearLocants() {
        for (String l : this.locants) {
            this.frag.removeMappingFromAtomLocantMap(l);
        }
        this.locants.clear();
    }

    void removeElementSymbolLocants() {
        for (int i = this.locants.size() - 1; i >= 0; --i) {
            String l = this.locants.get(i);
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(l).matches()) continue;
            this.frag.removeMappingFromAtomLocantMap(l);
            this.locants.remove(i);
        }
    }

    void removeLocantsOtherThanElementSymbolLocants() {
        for (int i = this.locants.size() - 1; i >= 0; --i) {
            String l = this.locants.get(i);
            if (OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(l).matches()) continue;
            this.frag.removeMappingFromAtomLocantMap(l);
            this.locants.remove(i);
        }
    }

    boolean hasLocant(String locant) {
        for (String l : this.locants) {
            if (!l.equals(locant)) continue;
            return true;
        }
        Matcher m = OpsinTools.MATCH_AMINOACID_STYLE_LOCANT.matcher(locant);
        if (m.matches() && this.element.equals(m.group(1))) {
            if (!m.group(2).equals("") && !this.hasLocant(m.group(1) + m.group(2))) {
                return false;
            }
            if (OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(this, m.group(3)) != null) {
                return true;
            }
        }
        return false;
    }

    String getFirstLocant() {
        if (this.locants.size() == 0) {
            return null;
        }
        return this.locants.get(0);
    }

    List<String> getLocants() {
        return Collections.unmodifiableList(this.locants);
    }

    List<String> getElementSymbolLocants() {
        ArrayList<String> elementSymbolLocants = new ArrayList<String>();
        for (String l : this.locants) {
            if (!OpsinTools.MATCH_ELEMENT_SYMBOL_LOCANT.matcher(l).matches()) continue;
            elementSymbolLocants.add(l);
        }
        return elementSymbolLocants;
    }

    void setFrag(Fragment f2) {
        this.frag = f2;
    }

    Fragment getFrag() {
        return this.frag;
    }

    int getID() {
        return this.ID;
    }

    String getElement() {
        return this.element;
    }

    void setElement(String elem2) {
        this.element = elem2;
    }

    int getCharge() {
        return this.charge;
    }

    void addChargeAndProtons(int charge, int protons) {
        this.charge += charge;
        this.protonsExplicitlyAddedOrRemoved += protons;
    }

    void setCharge(int c) {
        this.charge = c;
    }

    void neutraliseCharge() {
        this.charge = 0;
        this.protonsExplicitlyAddedOrRemoved = 0;
    }

    Integer getIsotope() {
        return this.isotope;
    }

    void setIsotope(Integer isotope) {
        this.isotope = isotope;
    }

    void addBond(Bond b) {
        this.bonds.add(b);
    }

    boolean removeBond(Bond b) {
        return this.bonds.remove(b);
    }

    int getIncomingValency() {
        int v = 0;
        for (Bond b : this.bonds) {
            v += b.getOrder();
        }
        return v;
    }

    int getProtonsExplicitlyAddedOrRemoved() {
        return this.protonsExplicitlyAddedOrRemoved;
    }

    void setProtonsExplicitlyAddedOrRemoved(int protonsExplicitlyAddedOrRemoved) {
        this.protonsExplicitlyAddedOrRemoved = protonsExplicitlyAddedOrRemoved;
    }

    boolean hasSpareValency() {
        return this.spareValency;
    }

    void setSpareValency(boolean sv) {
        this.spareValency = sv;
    }

    int getOutValency() {
        return this.outValency;
    }

    void addOutValency(int outV) {
        this.outValency += outV;
    }

    Set<Bond> getBonds() {
        return Collections.unmodifiableSet(this.bonds);
    }

    List<Atom> getAtomNeighbours() {
        ArrayList<Atom> results = new ArrayList<Atom>();
        for (Bond b : this.bonds) {
            results.add(b.getOtherAtom(this));
        }
        return results;
    }

    Integer getLambdaConventionValency() {
        return this.lambdaConventionValency;
    }

    void setLambdaConventionValency(Integer valency) {
        this.lambdaConventionValency = valency;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    boolean getAtomIsInACycle() {
        return this.atomIsInACycle;
    }

    void setAtomIsInACycle(boolean atomIsInACycle) {
        this.atomIsInACycle = atomIsInACycle;
    }

    AtomParity getAtomParity() {
        return this.atomParity;
    }

    void setAtomParity(AtomParity atomParity) {
        this.atomParity = atomParity;
    }

    void setAtomParity(Atom[] atomRefs4, int parity) {
        this.atomParity = new AtomParity(atomRefs4, parity);
    }

    Integer getMinimumValency() {
        return this.minimumValency;
    }

    void setMinimumValency(Integer minimumValency) {
        this.minimumValency = minimumValency;
    }

    <T> T getProperty(PropertyKey<T> propertyKey) {
        return (T)this.properties.get(propertyKey);
    }

    <T> void setProperty(PropertyKey<T> propertyKey, T value2) {
        this.properties.put(propertyKey, value2);
    }

    void ensureSVIsConsistantWithValency(boolean takeIntoAccountExternalBonds) throws StructureBuildingException {
        if (this.spareValency) {
            Integer maxValency;
            if (this.lambdaConventionValency != null) {
                maxValency = this.lambdaConventionValency + this.protonsExplicitlyAddedOrRemoved;
            } else if (this.element.equals("C")) {
                maxValency = 4 + this.protonsExplicitlyAddedOrRemoved;
            } else {
                if (ValencyChecker.getHWValency(this.element) == null) {
                    throw new StructureBuildingException(this.element + " is not expected to be aromatic!");
                }
                maxValency = ValencyChecker.getHWValency(this.element) + this.protonsExplicitlyAddedOrRemoved;
            }
            int maxSpareValency = takeIntoAccountExternalBonds ? maxValency - this.getIncomingValency() - this.outValency : maxValency - this.frag.getIntraFragmentIncomingValency(this);
            if (maxSpareValency < 1) {
                this.setSpareValency(false);
            }
        }
    }

    Bond getFirstBond() {
        Iterator<Bond> bondIterator = this.bonds.iterator();
        if (bondIterator.hasNext()) {
            return bondIterator.next();
        }
        return null;
    }

    Bond getBondToAtom(Atom a) {
        for (Bond b : this.bonds) {
            if (b.getOtherAtom(this) != a) continue;
            return b;
        }
        return null;
    }

    Bond getBondToAtomOrThrow(Atom a) throws StructureBuildingException {
        Bond b = this.getBondToAtom(a);
        if (b == null) {
            throw new StructureBuildingException("Couldn't find specified bond");
        }
        return b;
    }
}

