/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import scala.CountedIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static int initialSize(HashTable $this) {
        return HashTable$.MODULE$.initialSize();
    }

    public static void init(HashTable $this, ObjectInputStream in, Function2 f2) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size2 >= 0);
        boolean smDefined = in.readBoolean();
        $this.table_$eq(new HashEntry[HashTable$.MODULE$.capacity(HashTable$.MODULE$.sizeForThreshold($this._loadFactor(), size2))]);
        $this.threshold_$eq(HashTable$.MODULE$.newThreshold($this._loadFactor(), Predef$.MODULE$.refArrayOps((Object[])$this.table()).size()));
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index2 = 0; index2 < size2; ++index2) {
            $this.addEntry((HashEntry)f2.apply(in.readObject(), in.readObject()));
        }
    }

    public static void serializeTo(HashTable $this, ObjectOutputStream out$1, Function1 value$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        out$1.writeBoolean($this.isSizeMapDefined());
        $this.foreachEntry(new Serializable($this, out$1, value$1){
            public static final long serialVersionUID;
            public final ObjectOutputStream out$1;
            public final Function1 value$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Entry entry) {
                this.out$1.writeObject(entry.key());
                this.out$1.writeObject(this.value$1.apply(entry));
            }
            {
                this.out$1 = hashTable;
                this.value$1 = var3_3;
            }
        });
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        while (e != null && !$this.elemEquals(e.key(), key)) {
            e = (HashEntry)e.next();
        }
        return e;
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        $this.nnSizeMapAdd(h);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashEntry removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        if (e == null) return null;
        if ($this.elemEquals(e.key(), key)) {
            $this.table()[h] = (HashEntry)e.next();
            $this.tableSize_$eq($this.tableSize() - 1);
            $this.nnSizeMapRemove(h);
            return e;
        }
        HashEntry e1 = (HashEntry)e.next();
        while (true) {
            if (e1 == null || $this.elemEquals(e1.key(), key)) {
                if (e1 == null) {
                    return null;
                }
                e.next_$eq(e1.next());
                $this.tableSize_$eq($this.tableSize() - 1);
                $this.nnSizeMapRemove(h);
                return e1;
            }
            e = e1;
            e1 = (HashEntry)e1.next();
        }
    }

    public static Iterator entriesIterator(HashTable $this) {
        return new Iterator<Entry>($this){
            private final HashEntry<A, Entry>[] iterTable;
            private int idx;
            private Entry es;

            public Iterator<Entry> seq() {
                return Iterator$class.seq(this);
            }

            public boolean isEmpty() {
                return Iterator$class.isEmpty(this);
            }

            public boolean isTraversableAgain() {
                return Iterator$class.isTraversableAgain(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator$class.hasDefiniteSize(this);
            }

            public Iterator<Entry> take(int n) {
                return Iterator$class.take(this, n);
            }

            public Iterator<Entry> drop(int n) {
                return Iterator$class.drop(this, n);
            }

            public Iterator<Entry> slice(int from2, int until2) {
                return Iterator$class.slice(this, from2, until2);
            }

            public <B> Iterator<B> map(Function1<Entry, B> f2) {
                return Iterator$class.map(this, f2);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator$class.$plus$plus(this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Entry, GenTraversableOnce<B>> f2) {
                return Iterator$class.flatMap(this, f2);
            }

            public Iterator<Entry> filter(Function1<Entry, Object> p) {
                return Iterator$class.filter(this, p);
            }

            public Iterator<Entry> withFilter(Function1<Entry, Object> p) {
                return Iterator$class.withFilter(this, p);
            }

            public Iterator<Entry> filterNot(Function1<Entry, Object> p) {
                return Iterator$class.filterNot(this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Entry, B> pf) {
                return Iterator$class.collect(this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Entry, B> op) {
                return Iterator$class.scanLeft(this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Entry, B, B> op) {
                return Iterator$class.scanRight(this, z, op);
            }

            public Iterator<Entry> takeWhile(Function1<Entry, Object> p) {
                return Iterator$class.takeWhile(this, p);
            }

            public Tuple2<Iterator<Entry>, Iterator<Entry>> partition(Function1<Entry, Object> p) {
                return Iterator$class.partition(this, p);
            }

            public Tuple2<Iterator<Entry>, Iterator<Entry>> span(Function1<Entry, Object> p) {
                return Iterator$class.span(this, p);
            }

            public Iterator<Entry> dropWhile(Function1<Entry, Object> p) {
                return Iterator$class.dropWhile(this, p);
            }

            public <B> Object zip(Iterator<B> that) {
                return Iterator$class.zip(this, that);
            }

            public <A1> Object padTo(int len, A1 elem2) {
                return Iterator$class.padTo(this, len, elem2);
            }

            public Iterator zipWithIndex() {
                return Iterator$class.zipWithIndex(this);
            }

            public <B, A1, B1> Object zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator$class.zipAll(this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Entry, U> f2) {
                Iterator$class.foreach(this, f2);
            }

            public boolean forall(Function1<Entry, Object> p) {
                return Iterator$class.forall(this, p);
            }

            public boolean exists(Function1<Entry, Object> p) {
                return Iterator$class.exists(this, p);
            }

            public boolean contains(Object elem2) {
                return Iterator$class.contains(this, elem2);
            }

            public Option<Entry> find(Function1<Entry, Object> p) {
                return Iterator$class.find(this, p);
            }

            public int indexWhere(Function1<Entry, Object> p) {
                return Iterator$class.indexWhere(this, p);
            }

            public <B> int indexOf(B elem2) {
                return Iterator$class.indexOf(this, elem2);
            }

            public BufferedIterator buffered() {
                return Iterator$class.buffered(this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator$class.grouped(this, size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator$class.sliding(this, size2, step);
            }

            public int length() {
                return Iterator$class.length(this);
            }

            public Tuple2<Iterator<Entry>, Iterator<Entry>> duplicate() {
                return Iterator$class.duplicate(this);
            }

            public <B> Object patch(int from2, Iterator<B> patchElems, int replaced) {
                return Iterator$class.patch(this, from2, patchElems, replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator$class.copyToArray(this, xs, start, len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator$class.sameElements(this, that);
            }

            public Traversable<Entry> toTraversable() {
                return Iterator$class.toTraversable(this);
            }

            public Iterator<Entry> toIterator() {
                return Iterator$class.toIterator(this);
            }

            public Stream<Entry> toStream() {
                return Iterator$class.toStream(this);
            }

            public String toString() {
                return Iterator$class.toString(this);
            }

            public <B> Iterator<B> append(Iterator<B> that) {
                return Iterator$class.append(this, that);
            }

            public int findIndexOf(Function1<Entry, Object> p) {
                return Iterator$class.findIndexOf(this, p);
            }

            public CountedIterator counted() {
                return Iterator$class.counted(this);
            }

            public <B> void readInto(Object xs, int start, int sz) {
                Iterator$class.readInto(this, xs, start, sz);
            }

            public <B> void readInto(Object xs, int start) {
                Iterator$class.readInto(this, xs, start);
            }

            public <B> void readInto(Object xs) {
                Iterator$class.readInto(this, xs);
            }

            public int sliding$default$2() {
                return Iterator$class.sliding$default$2(this);
            }

            public List<Entry> reversed() {
                return TraversableOnce$class.reversed(this);
            }

            public int size() {
                return TraversableOnce$class.size(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce$class.nonEmpty(this);
            }

            public int count(Function1<Entry, Object> p) {
                return TraversableOnce$class.count(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Entry, B> pf) {
                return TraversableOnce$class.collectFirst(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Entry, B> op) {
                return (B)TraversableOnce$class.$div$colon(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Entry, B, B> op) {
                return (B)TraversableOnce$class.$colon$bslash(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Entry, B> op) {
                return (B)TraversableOnce$class.foldLeft(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Entry, B, B> op) {
                return (B)TraversableOnce$class.foldRight(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Entry, B> op) {
                return (B)TraversableOnce$class.reduceLeft(this, op);
            }

            public <B> B reduceRight(Function2<Entry, B, B> op) {
                return (B)TraversableOnce$class.reduceRight(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Entry, B> op) {
                return TraversableOnce$class.reduceLeftOption(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Entry, B, B> op) {
                return TraversableOnce$class.reduceRightOption(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce$class.reduce(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce$class.reduceOption(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce$class.fold(this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, Entry, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce$class.aggregate(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num2) {
                return (B)TraversableOnce$class.sum(this, num2);
            }

            public <B> B product(Numeric<B> num2) {
                return (B)TraversableOnce$class.product(this, num2);
            }

            public <B> Entry min(Ordering<B> cmp) {
                return (Entry)TraversableOnce$class.min(this, cmp);
            }

            public <B> Entry max(Ordering<B> cmp) {
                return (Entry)TraversableOnce$class.max(this, cmp);
            }

            public <B> Entry maxBy(Function1<Entry, B> f2, Ordering<B> cmp) {
                return (Entry)TraversableOnce$class.maxBy(this, f2, cmp);
            }

            public <B> Entry minBy(Function1<Entry, B> f2, Ordering<B> cmp) {
                return (Entry)TraversableOnce$class.minBy(this, f2, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce$class.copyToBuffer(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce$class.copyToArray(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce$class.copyToArray(this, xs);
            }

            public <B> Object toArray(ClassManifest<B> evidence$1) {
                return TraversableOnce$class.toArray(this, evidence$1);
            }

            public List<Entry> toList() {
                return TraversableOnce$class.toList(this);
            }

            public Iterable<Entry> toIterable() {
                return TraversableOnce$class.toIterable(this);
            }

            public Seq<Entry> toSeq() {
                return TraversableOnce$class.toSeq(this);
            }

            public <B> IndexedSeq<B> toIndexedSeq() {
                return TraversableOnce$class.toIndexedSeq(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce$class.toBuffer(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce$class.toSet(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Entry, Tuple2<T, U>> ev) {
                return TraversableOnce$class.toMap(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce$class.mkString(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce$class.mkString(this, sep);
            }

            public String mkString() {
                return TraversableOnce$class.mkString(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce$class.addString(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce$class.addString(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce$class.addString(this, b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce$class.$div$colon$bslash(this, z, op);
            }

            private HashEntry<A, Entry>[] iterTable() {
                return this.iterTable;
            }

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int n) {
                this.idx = n;
            }

            private Entry es() {
                return this.es;
            }

            private void es_$eq(Entry Entry2) {
                this.es = Entry2;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            /*
             * WARNING - void declaration
             */
            public Entry next() {
                void var1_1;
                Entry res = this.es();
                this.es_$eq((HashEntry)this.es().next());
                this.scan();
                return var1_1;
            }

            private void scan() {
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
            }
            {
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.iterTable = $outer.table();
                this.idx = $outer.table().length - 1;
                this.es = this.iterTable()[this.idx()];
                this.scan();
            }
        };
    }

    public static final void foreachEntry(HashTable $this, Function1 f2) {
        $this.entriesIterator().foreach(f2);
    }

    public static Iterator entries(HashTable $this) {
        return $this.entriesIterator();
    }

    public static void clearTable(HashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset(0);
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, Entry>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        $this.nnSizeMapReset($this.table().length);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                if (e == null) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = (HashEntry)e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
                $this.nnSizeMapAdd(h);
            }
        }
        $this.threshold_$eq(HashTable$.MODULE$.newThreshold($this._loadFactor(), newSize));
    }

    public static void nnSizeMapAdd(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] + 1;
        }
    }

    public static void nnSizeMapRemove(HashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> $this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(HashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
            } else {
                Arrays.fill($this.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(HashTable $this) {
        return $this.sizeMapBucketSize() < $this.table().length ? 1 : $this.table().length / $this.sizeMapBucketSize();
    }

    public static int calcSizeMapSize(HashTable $this, int tableLength) {
        return (tableLength >> $this.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(HashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    public static void sizeMapInitAndRebuild(HashTable $this) {
        $this.sizeMapInit($this.table().length);
        int tableidx = 0;
        HashEntry<A, Entry>[] tbl = $this.table();
        int tableuntil = tbl.length < $this.sizeMapBucketSize() ? tbl.length : $this.sizeMapBucketSize();
        int totalbuckets = $this.totalSizeMapBuckets();
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsize = 0;
            while (tableidx < tableuntil) {
                for (HashEntry e = tbl[tableidx]; e != null; e = (HashEntry)e.next()) {
                    ++currbucketsize;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsize;
            tableuntil += $this.sizeMapBucketSize();
        }
    }

    public static void printSizeMap(HashTable $this) {
        Predef$.MODULE$.println(Predef$.MODULE$.intArrayOps($this.sizemap()).toList());
    }

    public static void sizeMapDisable(HashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(HashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(HashTable $this) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        void y1;
        void x1;
        Object object = key1;
        Object object2 = key2;
        return object == object2 ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))));
    }

    public static final int index(HashTable $this, int hcode) {
        int ones = $this.table().length - 1;
        int improved = $this.improve(hcode);
        int shifted = improved >> 32 - Integer.bitCount(ones) & ones;
        return shifted;
    }

    public static void initWithContents(HashTable $this, HashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap() && $this.sizemap() == null) {
            $this.sizeMapInitAndRebuild();
        }
    }

    public static HashTable.Contents hashTableContents(HashTable $this) {
        return new HashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.sizemap());
    }

    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq(HashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new HashEntry[HashTable$.MODULE$.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(HashTable$.MODULE$.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
    }
}

