/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.util;

import java.lang.reflect.Field;
import java.util.Locale;

public class LocaleUtil {
    public static Locale getLocaleConstant(String localeConstant) {
        try {
            Field field2 = Locale.class.getField(localeConstant);
            if (field2 != null && field2.getType().equals(Locale.class)) {
                return (Locale)field2.get(null);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Locale createLocale(String localeString) {
        String[] parts = localeString.split("[_-]", 3);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException("Invalid locale: " + localeString);
    }

    public static Locale getLocale(String localeString) {
        Locale locale = LocaleUtil.getLocaleConstant(localeString);
        if (locale != null) {
            return locale;
        }
        return LocaleUtil.createLocale(localeString);
    }
}

