/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.uimafit.util.JCasUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainmentIndex<S extends AnnotationFS, U extends AnnotationFS> {
    private Map<S, Collection<U>> data = new LinkedHashMap<S, Collection<U>>();
    private Map<U, Collection<S>> dataRev = new LinkedHashMap<U, Collection<S>>();

    public ContainmentIndex(JCas aJcas, Class<? extends S> aSuper, Class<? extends U> aUnder, Type aType) {
        for (AnnotationFS s : JCasUtil.iterate(aJcas, aSuper)) {
            for (AnnotationFS u : JCasUtil.selectCovered(aUnder, s)) {
                switch (aType) {
                    case DIRECT: {
                        this.put(this.data, s, u);
                        break;
                    }
                    case REVERSE: {
                        this.put(this.dataRev, u, s);
                        break;
                    }
                    case BOTH: {
                        this.put(this.data, s, u);
                        this.put(this.dataRev, u, s);
                    }
                }
            }
        }
    }

    private <X, Y> void put(Map<X, Collection<Y>> map2, X key, Y value2) {
        Collection<Y> c = map2.get(key);
        if (c == null) {
            c = new LinkedList<Y>();
            map2.put(key, c);
        }
        c.add(value2);
    }

    public Collection<U> containedIn(S aSuper) {
        Collection<U> c = this.data.get(aSuper);
        if (c == null) {
            return Collections.emptySet();
        }
        return c;
    }

    public Collection<S> containing(U aUnder) {
        Collection<S> c = this.dataRev.get(aUnder);
        if (c == null) {
            return Collections.emptySet();
        }
        return c;
    }

    public boolean isContainedIn(S aSuper, U aUnder) {
        return this.containedIn(aSuper).contains(aUnder);
    }

    public boolean isContainedInAny(U aUnder) {
        Collection<S> containers = this.containing(aUnder);
        return containers != null && !containers.isEmpty();
    }

    public static <A extends AnnotationFS, B extends AnnotationFS> ContainmentIndex<A, B> create(JCas aJcas, Class<A> aSuper, Class<B> aUnder, Type aType) {
        return new ContainmentIndex<A, B>(aJcas, aSuper, aUnder, aType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DIRECT,
        REVERSE,
        BOTH;

    }
}

