/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasUtil {
    public static final String UIMA_BUILTIN_JCAS_PREFIX = "org.apache.uima.jcas.";

    public static <T extends AnnotationFS> Iterable<T> iterate(final CAS cas, final Type type) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return CasUtil.iterator(cas, type);
            }
        };
    }

    public static <T extends AnnotationFS> Iterator<T> iterator(CAS cas, Type type) {
        return cas.getAnnotationIndex(type).iterator();
    }

    public static Type getType(CAS cas, Class<?> type) {
        Type t;
        String typeName = type.getName();
        if (typeName.startsWith(UIMA_BUILTIN_JCAS_PREFIX)) {
            typeName = "uima." + typeName.substring(UIMA_BUILTIN_JCAS_PREFIX.length());
        }
        if ((t = cas.getTypeSystem().getType(typeName)) == null) {
            throw new IllegalArgumentException("Undeclared type [" + typeName + "]");
        }
        return t;
    }

    public static <T extends AnnotationFS> List<T> selectCovered(CAS cas, Type type, AnnotationFS coveringAnnotation) {
        AnnotationFS a;
        int begin = coveringAnnotation.getBegin();
        int end = coveringAnnotation.getEnd();
        ArrayList<AnnotationFS> list2 = new ArrayList<AnnotationFS>();
        FSIterator it = cas.getAnnotationIndex(type).iterator();
        it.moveTo(coveringAnnotation);
        if (!it.isValid()) {
            it.moveToLast();
            if (!it.isValid()) {
                return list2;
            }
        }
        boolean moved = false;
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() >= begin) {
            it.moveToPrevious();
            moved = true;
        }
        if (moved) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            it.moveToFirst();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        boolean strict = true;
        while (it.isValid() && (a = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && a.getEnd() > end) continue;
            assert (a.getBegin() >= coveringAnnotation.getBegin()) : "Illegal begin " + a.getBegin() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]";
            assert (a.getEnd() >= coveringAnnotation.getBegin()) : "Illegal end " + a.getEnd() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]";
            if (a.equals(coveringAnnotation)) continue;
            list2.add(a);
        }
        return list2;
    }

    public static <T extends AnnotationFS> List<T> selectPreceding(CAS cas, Type type, Annotation annotation, int count2) {
        LinkedList<AnnotationFS> precedingAnnotations = new LinkedList<AnnotationFS>();
        FSIterator itr = cas.getAnnotationIndex(type).iterator();
        itr.moveTo(annotation);
        itr.moveToPrevious();
        for (int currentAnnotation = 0; currentAnnotation < count2 && itr.isValid(); ++currentAnnotation) {
            AnnotationFS buf = (AnnotationFS)itr.get();
            precedingAnnotations.add(buf);
            itr.moveToPrevious();
        }
        Collections.reverse(precedingAnnotations);
        return precedingAnnotations;
    }

    public static <T extends AnnotationFS> List<T> selectFollowing(CAS cas, Type type, Annotation annotation, int count2) {
        LinkedList<AnnotationFS> followingAnnotations = new LinkedList<AnnotationFS>();
        FSIterator itr = cas.getAnnotationIndex(type).iterator();
        itr.moveTo(annotation);
        itr.moveToNext();
        for (int currentAnnotation = 0; currentAnnotation < count2 && itr.isValid(); ++currentAnnotation) {
            AnnotationFS buf = (AnnotationFS)itr.get();
            followingAnnotations.add(buf);
            itr.moveToNext();
        }
        return followingAnnotations;
    }
}

