/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.testing.factory;

import java.util.ArrayList;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.uimafit.factory.AnnotationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenBuilder<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation> {
    private Class<TOKEN_TYPE> tokenClass;
    private Class<SENTENCE_TYPE> sentenceClass;
    private String posFeatureName;
    private String stemFeatureName;

    public TokenBuilder(Class<TOKEN_TYPE> tokenClass, Class<SENTENCE_TYPE> sentenceClass) {
        this(tokenClass, sentenceClass, null, null);
    }

    public TokenBuilder(Class<TOKEN_TYPE> tokenClass, Class<SENTENCE_TYPE> sentenceClass, String posFeatureName, String stemFeatureName) {
        this.tokenClass = tokenClass;
        this.sentenceClass = sentenceClass;
        this.setPosFeatureName(posFeatureName);
        this.setStemFeatureName(stemFeatureName);
    }

    public static <T extends Annotation, S extends Annotation> TokenBuilder<T, S> create(Class<T> tokenClass, Class<S> sentenceClass) {
        return new TokenBuilder<T, S>(tokenClass, sentenceClass);
    }

    public void setPosFeatureName(String posFeatureName) {
        this.posFeatureName = posFeatureName;
    }

    public void setStemFeatureName(String stemFeatureName) {
        this.stemFeatureName = stemFeatureName;
    }

    public void buildTokens(JCas jCas, String text2) throws UIMAException {
        if (text2 == null) {
            throw new IllegalArgumentException("text may not be null.");
        }
        this.buildTokens(jCas, text2, text2, null, null);
    }

    public void buildTokens(JCas jCas, String text2, String tokensString) throws UIMAException {
        if (tokensString == null) {
            throw new IllegalArgumentException("tokensText may not be null.");
        }
        this.buildTokens(jCas, text2, tokensString, null, null);
    }

    public void buildTokens(JCas jCas, String text2, String tokensString, String posTagsString) throws UIMAException {
        this.buildTokens(jCas, text2, tokensString, posTagsString, null);
    }

    public void buildTokens(JCas jCas, String text2, String tokensString, String posTagsString, String stemsString) throws UIMAException {
        jCas.setDocumentText(text2);
        if (posTagsString != null && this.posFeatureName == null) {
            throw new IllegalArgumentException("posTagsString must be null if TokenBuilder is not initialized with a feature name corresponding to the part-of-speech feature of the token type (assuming your token type has such a feature).");
        }
        if (stemsString != null && this.stemFeatureName == null) {
            throw new IllegalArgumentException("stemsString must be null if TokenBuilder is not initialized with a feature name corresponding to the part-of-speech feature of the token type (assuming your token type has such a feature).");
        }
        Feature posFeature = null;
        if (this.posFeatureName != null) {
            posFeature = jCas.getTypeSystem().getType(this.tokenClass.getName()).getFeatureByBaseName(this.posFeatureName);
        }
        Feature stemFeature = null;
        if (this.stemFeatureName != null) {
            stemFeature = jCas.getTypeSystem().getType(this.tokenClass.getName()).getFeatureByBaseName(this.stemFeatureName);
        }
        tokensString = tokensString.replaceAll("\\s*\n\\s*", "\n");
        String[] sentenceStrings = tokensString.split("\n");
        String[] posTags = posTagsString != null ? posTagsString.split("\\s+") : null;
        String[] stems = stemsString != null ? stemsString.split("\\s+") : null;
        int offset = 0;
        int tokenIndex = 0;
        for (String sentenceString : sentenceStrings) {
            String[] tokenStrings = sentenceString.trim().split("\\s+");
            ArrayList<TOKEN_TYPE> tokenAnnotations = new ArrayList<TOKEN_TYPE>();
            for (String tokenString : tokenStrings) {
                while (!text2.startsWith(tokenString, offset)) {
                    if (++offset <= text2.length()) continue;
                    throw new IllegalArgumentException(String.format("unable to find string %s", tokenString));
                }
                int start = offset;
                TOKEN_TYPE token2 = AnnotationFactory.createAnnotation(jCas, start, offset += tokenString.length(), this.tokenClass);
                tokenAnnotations.add(token2);
                if (posTags != null) {
                    ((FeatureStructureImpl)token2).setStringValue(posFeature, posTags[tokenIndex]);
                }
                if (stems != null) {
                    ((FeatureStructureImpl)token2).setStringValue(stemFeature, stems[tokenIndex]);
                }
                ++tokenIndex;
            }
            if (tokenAnnotations.size() <= 0) continue;
            int begin = ((Annotation)tokenAnnotations.get(0)).getBegin();
            int end = ((Annotation)tokenAnnotations.get(tokenAnnotations.size() - 1)).getEnd();
            AnnotationFactory.createAnnotation(jCas, begin, end, this.sentenceClass);
        }
    }
}

