/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.pipeline;

import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.jcas.JCas;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.pipeline.JCasIterable;

public final class SimplePipeline {
    private SimplePipeline() {
    }

    public static void runPipeline(CollectionReader reader, AnalysisEngineDescription ... descs) throws UIMAException, IOException {
        AnalysisEngine[] engines = SimplePipeline.createEngines(descs);
        SimplePipeline.runPipeline(reader, engines);
    }

    private static AnalysisEngine[] createEngines(AnalysisEngineDescription ... descs) throws UIMAException {
        AnalysisEngine[] engines = new AnalysisEngine[descs.length];
        for (int i = 0; i < engines.length; ++i) {
            engines[i] = descs[i].isPrimitive() ? AnalysisEngineFactory.createPrimitive(descs[i], new Object[0]) : AnalysisEngineFactory.createAggregate(descs[i]);
        }
        return engines;
    }

    public static void runPipeline(CollectionReader reader, AnalysisEngine ... engines) throws UIMAException, IOException {
        for (JCas jCas : new JCasIterable(reader, engines)) {
            assert (jCas != null);
        }
        for (AnalysisEngine engine : engines) {
            engine.collectionProcessComplete();
        }
        reader.close();
    }

    public static void runPipeline(JCas jCas, AnalysisEngineDescription ... descs) throws UIMAException, IOException {
        AnalysisEngine[] engines = SimplePipeline.createEngines(descs);
        SimplePipeline.runPipeline(jCas, engines);
    }

    public static void runPipeline(JCas jCas, AnalysisEngine ... engines) throws UIMAException, IOException {
        for (AnalysisEngine engine : engines) {
            engine.process(jCas);
        }
        for (AnalysisEngine engine : engines) {
            engine.collectionProcessComplete();
        }
    }
}

