/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.uimafit.component.JCasAnnotatorAdapter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCasFactory {
    private JCasFactory() {
    }

    public static JCas createJCas() throws UIMAException {
        return CasCreationUtils.createCas(TypeSystemDescriptionFactory.createTypeSystemDescription(), null, null).getJCas();
    }

    public static JCas createJCas(String ... typeSystemDescriptorNames) throws UIMAException {
        AnalysisEngine engine = AnalysisEngineFactory.createPrimitive(JCasAnnotatorAdapter.class, TypeSystemDescriptionFactory.createTypeSystemDescription(typeSystemDescriptorNames), new Object[0]);
        return engine.newJCas();
    }

    public static JCas createJCasFromPath(String ... typeSystemDescriptorPaths) throws UIMAException {
        return JCasFactory.createJCas(TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath(typeSystemDescriptorPaths));
    }

    public static JCas createJCas(Class<?> ... typeSystemClasses) throws UIMAException {
        return JCasFactory.createJCas(TypeSystemDescriptionFactory.createTypeSystemDescription(typeSystemClasses));
    }

    public static JCas createJCas(TypeSystemDescription typeSystemDescription) throws UIMAException {
        return CasCreationUtils.createCas(typeSystemDescription, null, null).getJCas();
    }

    public static JCas createJCas(String xmiFileName, TypeSystemDescription typeSystemDescription) throws UIMAException, IOException {
        return JCasFactory.createJCas(xmiFileName, typeSystemDescription, true);
    }

    public static JCas createJCas(String xmlFileName, TypeSystemDescription typeSystemDescription, boolean isXmi) throws UIMAException, IOException {
        JCas jCas = JCasFactory.createJCas(typeSystemDescription);
        JCasFactory.loadJCas(jCas, xmlFileName, isXmi);
        return jCas;
    }

    public static void loadJCas(JCas jCas, String xmiFileName) throws IOException {
        JCasFactory.loadJCas(jCas, xmiFileName, true);
    }

    public static void loadJCas(JCas jCas, String xmlFileName, boolean isXmi) throws IOException {
        FileInputStream inputStream = new FileInputStream(xmlFileName);
        JCasFactory.loadJCas(jCas, inputStream, isXmi);
    }

    public static void loadJCas(JCas jCas, InputStream xmiInputStream) throws IOException {
        JCasFactory.loadJCas(jCas, xmiInputStream, true);
    }

    public static void loadJCas(JCas jCas, InputStream xmlInputStream, boolean isXmi) throws IOException {
        jCas.reset();
        try {
            CAS cas = jCas.getCas();
            if (isXmi) {
                XmiCasDeserializer.deserialize(xmlInputStream, cas);
            } else {
                XCASDeserializer.deserialize(xmlInputStream, cas);
            }
        }
        catch (SAXException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            IOUtils.closeQuietly(xmlInputStream);
        }
    }
}

