/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.component.xwriter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.uimafit.component.JCasConsumer_ImplBase;
import org.uimafit.component.xwriter.XWriterFileNamer;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;
import org.xml.sax.SAXException;

public class XWriter
extends JCasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = ConfigurationParameterFactory.createConfigurationParameterName(XWriter.class, "outputDirectoryName");
    @ConfigurationParameter(mandatory=true, description="takes a path to directory into which output files will be written.")
    private String outputDirectoryName;
    public static final String PARAM_XML_SCHEME_NAME = ConfigurationParameterFactory.createConfigurationParameterName(XWriter.class, "xmlSchemeName");
    @ConfigurationParameter(mandatory=true, defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' (default) and 'XCAS'.")
    private String xmlSchemeName;
    public static final String PARAM_FILE_NAMER_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(XWriter.class, "fileNamerClassName");
    @ConfigurationParameter(mandatory=true, description="the class name of the XWriterFileNamer implementation to use", defaultValue={"org.uimafit.component.xwriter.IntegerFileNamer"})
    protected String fileNamerClassName;
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    private File outputDirectory;
    private boolean useXMI = true;
    private XWriterFileNamer fileNamer;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (this.xmlSchemeName.equals(XMI)) {
            this.useXMI = true;
        } else if (this.xmlSchemeName.equals(XCAS)) {
            this.useXMI = false;
        } else {
            throw new ResourceInitializationException(String.format("parameter '%1$s' must be either '%2$s' or '%3$s'.", PARAM_XML_SCHEME_NAME, XMI, XCAS), null);
        }
        this.fileNamer = InitializableFactory.create(context, this.fileNamerClassName, XWriterFileNamer.class);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String fileName = this.fileNamer.nameFile(jcas);
        try {
            if (this.useXMI) {
                this.writeXmi(jcas.getCas(), fileName);
            } else {
                this.writeXCas(jcas.getCas(), fileName);
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXCas(CAS aCas, String fileName) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, fileName + ".xcas");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            XCASSerializer ser = new XCASSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer(out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, String id) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, id + ".xmi");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer(out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

