/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.component.xwriter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.component.CasConsumer_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASDumpWriter
extends CasConsumer_ImplBase {
    public static final String INCLUDE_PREFIX = "+|";
    public static final String EXCLUDE_PREFIX = "-|";
    public static final String PARAM_OUTPUT_FILE = "OutputFile";
    @ConfigurationParameter(name="OutputFile", mandatory=true)
    private File outFile;
    public static final String PARAM_WRITE_DOCUMENT_META_DATA = "WriteDocumentMetaData";
    @ConfigurationParameter(name="WriteDocumentMetaData", mandatory=true, defaultValue={"true"})
    private boolean writeDocumentMetaData;
    public static final String PARAM_FEATURE_PATTERNS = "FeaturePatterns";
    @ConfigurationParameter(name="FeaturePatterns", mandatory=true, defaultValue={"+|.*", "-|^.*documentUri:.*$", "-|^.*collectionId:.*$", "-|^.*documentBaseUri:.*$"})
    private String[] rawFeaturePatterns;
    private InExPattern[] featurePatterns;
    public static final String PARAM_TYPE_PATTERNS = "TypePatterns";
    @ConfigurationParameter(name="TypePatterns", mandatory=true, defaultValue={"+|.*"})
    private String[] rawTypePatterns;
    private InExPattern[] typePatterns;
    private PrintWriter out;
    private int iCas;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            if (this.out == null) {
                if (this.outFile.getParentFile() != null) {
                    this.outFile.getParentFile().mkdirs();
                }
                this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), "UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException(e);
        }
        this.typePatterns = CASDumpWriter.compilePatterns(this.rawTypePatterns);
        this.featurePatterns = CASDumpWriter.compilePatterns(this.rawFeaturePatterns);
    }

    @Override
    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        this.out.println("======== CAS " + this.iCas + " begin ==================================");
        this.out.println();
        Iterator<CAS> viewIt = aCAS.getViewIterator();
        while (viewIt.hasNext()) {
            this.processView(viewIt.next());
        }
        this.out.println("======== CAS " + this.iCas + " end ==================================");
        this.out.println();
        this.out.println();
        this.out.flush();
        ++this.iCas;
    }

    @Override
    public void collectionProcessComplete() {
        IOUtils.closeQuietly(this.out);
        this.out = null;
    }

    private void processDocumentMetadata(CAS aCAS) {
        if (!this.writeDocumentMetaData) {
            return;
        }
        this.processFeatureStructure(aCAS.getDocumentAnnotation());
    }

    private void processDocumentText(CAS aCAS) {
        this.out.println();
        this.out.println("CAS-Text:");
        this.out.println(aCAS.getDocumentText());
    }

    private void processFeatureStructures(CAS aCAS) {
        Set<String> typesToPrint = this.getTypes(aCAS);
        for (AnnotationFS annotation : aCAS.getAnnotationIndex()) {
            if (!typesToPrint.contains(annotation.getType().getName())) continue;
            try {
                this.out.println("[" + annotation.getCoveredText() + "]");
            }
            catch (IndexOutOfBoundsException e) {
                this.out.println("<OFFSETS OUT OF BOUNDS>");
            }
            this.processFeatureStructure(annotation);
        }
    }

    private void processFeatureStructure(FeatureStructure aFS) {
        String meta = aFS.toString();
        for (String line : meta.split("\n")) {
            boolean print = false;
            for (InExPattern p : this.featurePatterns) {
                p.matchter.reset(line);
                if (!p.matchter.matches()) continue;
                print = p.includeInOutput;
            }
            if (!print) continue;
            this.out.println(line);
        }
    }

    private void processView(CAS aCAS) {
        this.out.println("-------- View " + aCAS.getViewName() + " begin ----------------------------------");
        this.out.println();
        this.processDocumentMetadata(aCAS);
        this.processDocumentText(aCAS);
        this.processFeatureStructures(aCAS);
        this.out.println("-------- View " + aCAS.getViewName() + " end ----------------------------------");
        this.out.println();
    }

    private static InExPattern[] compilePatterns(String[] aPatterns) {
        InExPattern[] patterns = new InExPattern[aPatterns.length];
        for (int i = 0; i < aPatterns.length; ++i) {
            patterns[i] = aPatterns[i].startsWith(INCLUDE_PREFIX) ? new InExPattern(aPatterns[i].substring(INCLUDE_PREFIX.length()), true) : (aPatterns[i].startsWith(EXCLUDE_PREFIX) ? new InExPattern(aPatterns[i].substring(EXCLUDE_PREFIX.length()), false) : new InExPattern(aPatterns[i], false));
        }
        return patterns;
    }

    private Set<String> getTypes(CAS cas) {
        HashSet<String> types = new HashSet<String>();
        Iterator<Type> typeIt = cas.getTypeSystem().getTypeIterator();
        block0: while (typeIt.hasNext()) {
            Type type = typeIt.next();
            if (type.getName().equals(cas.getDocumentAnnotation().getType().getName())) continue;
            for (InExPattern p : this.typePatterns) {
                p.matchter.reset(type.getName());
                if (!p.matchter.matches()) continue;
                if (p.includeInOutput) {
                    types.add(type.getName());
                    continue block0;
                }
                types.remove(type.getName());
                continue block0;
            }
        }
        return types;
    }

    private static class InExPattern {
        final boolean includeInOutput;
        final Matcher matchter;

        public InExPattern(String aPattern, boolean aInclude) {
            this.includeInOutput = aInclude;
            this.matchter = Pattern.compile(aPattern).matcher("");
        }
    }
}

