/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.component.initialize;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.LocaleUtil;
import org.uimafit.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParameterInitializer {
    private static final Map<Class<?>, Converter<?>> converters = new HashMap();

    public static void initialize(Object component, UimaContext context) throws ResourceInitializationException {
        try {
            for (Field field2 : ReflectionUtil.getFields(component)) {
                if (!ConfigurationParameterFactory.isConfigurationParameterField(field2)) continue;
                ConfigurationParameter annotation = field2.getAnnotation(ConfigurationParameter.class);
                String configurationParameterName = ConfigurationParameterFactory.getConfigurationParameterName(field2);
                Object parameterValue = context.getConfigParameterValue(configurationParameterName);
                if (parameterValue == null) {
                    parameterValue = ConfigurationParameterFactory.getDefaultValue(field2);
                }
                if (annotation.mandatory()) {
                    if (parameterValue == null) {
                        String key = "config_setting_absent";
                        throw new ResourceInitializationException(key, new Object[]{configurationParameterName});
                    }
                } else if (parameterValue == null) continue;
                Object fieldValue = ConfigurationParameterInitializer.convertValue(field2, parameterValue);
                ConfigurationParameterInitializer.setParameterValue(component, field2, fieldValue);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    public static Object convertValue(Field field2, Object uimaValue) {
        if (ConfigurationParameterFactory.isConfigurationParameterField(field2)) {
            Object result2;
            Class<?> fieldType = field2.getType();
            Class<?> componentType = ConfigurationParameterInitializer.getComponentType(field2);
            Converter<?> converter = ConfigurationParameterInitializer.getConverter(componentType);
            if (fieldType.isArray()) {
                Object[] uimaValues = (Object[])uimaValue;
                result2 = Array.newInstance(componentType, uimaValues.length);
                for (int index = 0; index < uimaValues.length; ++index) {
                    Array.set(result2, index, converter.convert(uimaValues[index]));
                }
            } else if (Collection.class.isAssignableFrom(fieldType)) {
                Object[] uimaValues;
                Collection<Object> collection = fieldType == List.class ? new ArrayList() : (fieldType == Set.class ? new HashSet() : ConfigurationParameterInitializer.newCollection(fieldType));
                for (Object value2 : uimaValues = (Object[])uimaValue) {
                    collection.add(converter.convert(value2));
                }
                result2 = collection;
            } else {
                result2 = converter.convert(uimaValue);
            }
            return result2;
        }
        throw new IllegalArgumentException("field is not annotated with annotation of type " + ConfigurationParameter.class.getName());
    }

    private static Collection<Object> newCollection(Class<?> cls) {
        try {
            return cls.asSubclass(Collection.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getComponentType(Field field2) {
        Class<?> fieldType = field2.getType();
        if (fieldType.isArray()) {
            return fieldType.getComponentType();
        }
        if (Collection.class.isAssignableFrom(fieldType)) {
            ParameterizedType collectionType = (ParameterizedType)field2.getGenericType();
            return (Class)collectionType.getActualTypeArguments()[0];
        }
        return fieldType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setParameterValue(Object component, Field field2, Object value2) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        boolean accessible = field2.isAccessible();
        field2.setAccessible(true);
        try {
            field2.set(component, value2);
        }
        finally {
            field2.setAccessible(accessible);
        }
    }

    private ConfigurationParameterInitializer() {
    }

    private static Converter<?> getConverter(Class<?> cls) {
        Converter<?> converter = converters.get(cls);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            EnumConverter tmp = new EnumConverter(cls);
            return tmp;
        }
        try {
            Constructor<?> constructor = cls.getConstructor(String.class);
            return new ConstructorConverter(constructor);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("don't know how to convert type " + cls);
        }
    }

    static {
        converters.put(Boolean.class, new BooleanConverter());
        converters.put(Float.class, new FloatConverter());
        converters.put(Integer.class, new IntegerConverter());
        converters.put(String.class, new StringConverter());
        converters.put(Boolean.TYPE, new BooleanConverter());
        converters.put(Float.TYPE, new FloatConverter());
        converters.put(Integer.TYPE, new IntegerConverter());
        converters.put(Pattern.class, new PatternConverter());
        converters.put(Locale.class, new LocaleConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleConverter
    implements Converter<Locale> {
        private LocaleConverter() {
        }

        @Override
        public Locale convert(Object o) {
            if (o == null) {
                return Locale.getDefault();
            }
            if (o.equals("")) {
                return Locale.getDefault();
            }
            if (o instanceof String) {
                return LocaleUtil.getLocale((String)o);
            }
            throw new RuntimeException("the value for a locale should be either null or an empty string to get the default locale.  Otherwise, the locale should be specified by a single string that names a locale constant (e.g. 'US') or that contains hyphen delimited locale information (e.g. 'en-US').");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumConverter<T extends Enum<T>>
    implements Converter<Object> {
        private Class<T> enumClass;

        public EnumConverter(Class<T> aClass) {
            this.enumClass = aClass;
        }

        @Override
        public T convert(Object o) {
            try {
                return Enum.valueOf(this.enumClass, o.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorConverter
    implements Converter<Object> {
        private Constructor<?> constructor;

        public ConstructorConverter(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object convert(Object o) {
            try {
                return this.constructor.newInstance(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternConverter
    implements Converter<Pattern> {
        private PatternConverter() {
        }

        @Override
        public Pattern convert(Object o) {
            return Pattern.compile(o.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringConverter
    implements Converter<String> {
        private StringConverter() {
        }

        @Override
        public String convert(Object o) {
            return o.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerConverter
    implements Converter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public Integer convert(Object o) {
            return (Integer)o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatConverter
    implements Converter<Float> {
        private FloatConverter() {
        }

        @Override
        public Float convert(Object o) {
            return (Float)o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanConverter
    implements Converter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean convert(Object o) {
            return (Boolean)o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Converter<T> {
        public T convert(Object var1);
    }
}

