/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TypeUtils {
    public static boolean isAssignable(Type lhsType, Type rhsType) {
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.equals(rhsType) || lhsType.equals(Object.class)) {
            return true;
        }
        if (lhsType instanceof Class) {
            Class lhsClass = (Class)lhsType;
            if (rhsType instanceof Class) {
                return ClassUtils.isAssignable(lhsClass, (Class)rhsType);
            }
            if (rhsType instanceof ParameterizedType) {
                Type rhsRaw = ((ParameterizedType)rhsType).getRawType();
                if (rhsRaw instanceof Class) {
                    return ClassUtils.isAssignable(lhsClass, (Class)rhsRaw);
                }
            } else if (lhsClass.isArray() && rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return TypeUtils.isAssignable(lhsClass.getComponentType(), rhsComponent);
            }
        }
        if (lhsType instanceof ParameterizedType) {
            if (rhsType instanceof Class) {
                Type lhsRaw = ((ParameterizedType)lhsType).getRawType();
                if (lhsRaw instanceof Class) {
                    return ClassUtils.isAssignable((Class)lhsRaw, (Class)rhsType);
                }
            } else if (rhsType instanceof ParameterizedType) {
                return TypeUtils.isAssignable((ParameterizedType)lhsType, (ParameterizedType)rhsType);
            }
        }
        if (lhsType instanceof GenericArrayType) {
            Type lhsComponent = ((GenericArrayType)lhsType).getGenericComponentType();
            if (rhsType instanceof Class) {
                Class rhsClass = (Class)rhsType;
                if (rhsClass.isArray()) {
                    return TypeUtils.isAssignable(lhsComponent, rhsClass.getComponentType());
                }
            } else if (rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return TypeUtils.isAssignable(lhsComponent, rhsComponent);
            }
        }
        if (lhsType instanceof WildcardType) {
            return TypeUtils.isAssignable((WildcardType)lhsType, rhsType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size2 = lhsTypeArguments.length;
        int i = 0;
        while (i < size2) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (!(lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && TypeUtils.isAssignable((WildcardType)lhsArg, rhsArg))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        Type[] lLowerBounds;
        Type[] lUpperBounds = lhsType.getUpperBounds();
        if (lUpperBounds.length == 0) {
            lUpperBounds = new Type[]{Object.class};
        }
        if ((lLowerBounds = lhsType.getLowerBounds()).length == 0) {
            lLowerBounds = new Type[1];
        }
        if (rhsType instanceof WildcardType) {
            Type rBound;
            int n;
            int n2;
            Type[] typeArray;
            Type lBound;
            Type[] rLowerBounds;
            WildcardType rhsWcType = (WildcardType)rhsType;
            Type[] rUpperBounds = rhsWcType.getUpperBounds();
            if (rUpperBounds.length == 0) {
                rUpperBounds = new Type[]{Object.class};
            }
            if ((rLowerBounds = rhsWcType.getLowerBounds()).length == 0) {
                rLowerBounds = new Type[1];
            }
            Type[] typeArray2 = lUpperBounds;
            int n3 = lUpperBounds.length;
            int n4 = 0;
            while (n4 < n3) {
                lBound = typeArray2[n4];
                typeArray = rUpperBounds;
                n2 = rUpperBounds.length;
                n = 0;
                while (n < n2) {
                    rBound = typeArray[n];
                    if (!TypeUtils.isAssignableBound(lBound, rBound)) {
                        return false;
                    }
                    ++n;
                }
                typeArray = rLowerBounds;
                n2 = rLowerBounds.length;
                n = 0;
                while (n < n2) {
                    rBound = typeArray[n];
                    if (!TypeUtils.isAssignableBound(lBound, rBound)) {
                        return false;
                    }
                    ++n;
                }
                ++n4;
            }
            typeArray2 = lLowerBounds;
            n3 = lLowerBounds.length;
            n4 = 0;
            while (n4 < n3) {
                lBound = typeArray2[n4];
                typeArray = rUpperBounds;
                n2 = rUpperBounds.length;
                n = 0;
                while (n < n2) {
                    rBound = typeArray[n];
                    if (!TypeUtils.isAssignableBound(rBound, lBound)) {
                        return false;
                    }
                    ++n;
                }
                typeArray = rLowerBounds;
                n2 = rLowerBounds.length;
                n = 0;
                while (n < n2) {
                    rBound = typeArray[n];
                    if (!TypeUtils.isAssignableBound(rBound, lBound)) {
                        return false;
                    }
                    ++n;
                }
                ++n4;
            }
        } else {
            Type lBound;
            Type[] typeArray = lUpperBounds;
            int n = lUpperBounds.length;
            int n5 = 0;
            while (n5 < n) {
                lBound = typeArray[n5];
                if (!TypeUtils.isAssignableBound(lBound, rhsType)) {
                    return false;
                }
                ++n5;
            }
            typeArray = lLowerBounds;
            n = lLowerBounds.length;
            n5 = 0;
            while (n5 < n) {
                lBound = typeArray[n5];
                if (!TypeUtils.isAssignableBound(rhsType, lBound)) {
                    return false;
                }
                ++n5;
            }
        }
        return true;
    }

    public static boolean isAssignableBound(Type lhsType, Type rhsType) {
        if (rhsType == null) {
            return true;
        }
        if (lhsType == null) {
            return false;
        }
        return TypeUtils.isAssignable(lhsType, rhsType);
    }
}

