/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingMapDecorator<K, V>
implements Map<K, V>,
Serializable {
    private static Object NULL_VALUE = new Object();
    private final Map<K, Object> targetMap;
    private final boolean synchronize;
    private final boolean weak;

    public CachingMapDecorator() {
        this(false);
    }

    public CachingMapDecorator(boolean weak) {
        AbstractMap internalMap = weak ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(boolean weak, int size2) {
        AbstractMap internalMap = weak ? new WeakHashMap(size2) : new HashMap(size2);
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(Map<K, V> targetMap) {
        this(targetMap, false, false);
    }

    public CachingMapDecorator(Map<K, V> targetMap, boolean synchronize, boolean weak) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        this.targetMap = synchronize ? Collections.synchronizedMap(targetMap) : targetMap;
        this.synchronize = synchronize;
        this.weak = weak;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value2) {
        Object valueToCheck;
        Object object = valueToCheck = value2 != null ? value2 : NULL_VALUE;
        if (this.synchronize) {
            Map<K, Object> map2 = this.targetMap;
            synchronized (map2) {
                return this.containsValueOrReference(valueToCheck);
            }
        }
        return this.containsValueOrReference(valueToCheck);
    }

    private boolean containsValueOrReference(Object value2) {
        if (this.targetMap.containsValue(value2)) {
            return true;
        }
        for (Object mapVal : this.targetMap.values()) {
            if (!(mapVal instanceof Reference) || !value2.equals(((Reference)mapVal).get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        return this.unwrapReturnValue(this.targetMap.remove(key));
    }

    private V unwrapReturnValue(Object value2) {
        Object returnValue = value2;
        if (returnValue instanceof Reference) {
            returnValue = ((Reference)returnValue).get();
        }
        return (V)(returnValue == NULL_VALUE ? null : returnValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        this.targetMap.putAll(map2);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        if (this.synchronize) {
            Map<K, Object> map2 = this.targetMap;
            synchronized (map2) {
                return new LinkedHashSet(this.targetMap.keySet());
            }
        }
        return new LinkedHashSet(this.targetMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        if (this.synchronize) {
            Map<K, Object> map2 = this.targetMap;
            synchronized (map2) {
                return this.valuesCopy();
            }
        }
        return this.valuesCopy();
    }

    private Collection<V> valuesCopy() {
        LinkedList<Object> values2 = new LinkedList<Object>();
        Iterator<Object> it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object value2 = it.next();
            if (value2 instanceof Reference && (value2 = ((Reference)value2).get()) == null) {
                it.remove();
                continue;
            }
            values2.add(value2 == NULL_VALUE ? null : value2);
        }
        return values2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.synchronize) {
            Map<K, Object> map2 = this.targetMap;
            synchronized (map2) {
                return this.entryCopy();
            }
        }
        return this.entryCopy();
    }

    private Set<Map.Entry<K, V>> entryCopy() {
        LinkedHashMap<K, Object> entries = new LinkedHashMap<K, Object>();
        Iterator<Map.Entry<K, Object>> it = this.targetMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Object> entry = it.next();
            Object value2 = entry.getValue();
            if (value2 instanceof Reference && (value2 = ((Reference)value2).get()) == null) {
                it.remove();
                continue;
            }
            entries.put(entry.getKey(), value2 == NULL_VALUE ? null : value2);
        }
        return entries.entrySet();
    }

    @Override
    public V put(K key, V value2) {
        Object newValue = value2;
        if (value2 == null) {
            newValue = NULL_VALUE;
        } else if (this.useWeakValue(key, value2)) {
            newValue = new WeakReference<V>(newValue);
        }
        return this.unwrapReturnValue(this.targetMap.put(key, newValue));
    }

    protected boolean useWeakValue(K key, V value2) {
        return this.weak;
    }

    @Override
    public V get(Object key) {
        Object value2 = this.targetMap.get(key);
        if (value2 instanceof Reference) {
            value2 = ((Reference)value2).get();
        }
        if (value2 == null) {
            V newValue = this.create(key);
            this.put(key, newValue);
            return newValue;
        }
        return (V)(value2 == NULL_VALUE ? null : value2);
    }

    protected abstract V create(K var1);

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

