/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    static final String VALUE = "value";

    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        A ann = resolvedMethod.getAnnotation(annotationType);
        if (ann == null) {
            Annotation[] annotationArray = resolvedMethod.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation metaAnn = annotationArray[n2];
                ann = metaAnn.annotationType().getAnnotation(annotationType);
                if (ann != null) break;
                ++n2;
            }
        }
        return ann;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation == null) {
            if ((cl = cl.getSuperclass()) == null || cl == Object.class) break;
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                if (annotation != null) continue;
                annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotation;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class[] ifcs) {
        A annotation = null;
        Class[] classArray = ifcs;
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class iface = classArray[n2];
            Method equivalentMethod = null;
            try {
                equivalentMethod = iface.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (annotation != null) break;
            ++n2;
        }
        return annotation;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        Assert.notNull(clazz, "Class must not be null");
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Object[] objectArray = clazz.getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ifc = objectArray[n2];
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation != null) {
                return annotation;
            }
            ++n2;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            objectArray = clazz.getAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object ann = objectArray[n2];
                annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation != null) {
                    return annotation;
                }
                ++n2;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz) ? clazz : AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        for (Annotation annotation : Arrays.asList(clazz.getDeclaredAnnotations())) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            declaredLocally = true;
            break;
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotation, false);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean classValuesAsString) {
        Method[] methods;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Method[] methodArray = methods = annotation.annotationType().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                try {
                    String[] value2 = method.invoke((Object)annotation, new Object[0]);
                    if (classValuesAsString) {
                        if (value2 instanceof Class) {
                            value2 = ((Class)value2).getName();
                        } else if (value2 instanceof Class[]) {
                            Class[] clazzArray = (Class[])value2;
                            String[] newValue = new String[clazzArray.length];
                            int i = 0;
                            while (i < clazzArray.length) {
                                newValue[i] = clazzArray[i].getName();
                                ++i;
                            }
                            value2 = newValue;
                        }
                    }
                    attrs.put(method.getName(), value2);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain annotation attribute values", ex);
                }
            }
            ++n2;
        }
        return attrs;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            Method method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
            return method.getDefaultValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

