/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public void setAttribute(String name, Object value2) {
        Assert.notNull(name, "Name must not be null");
        if (value2 != null) {
            this.attributes.put(name, value2);
        } else {
            this.removeAttribute(name);
        }
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.containsKey(name);
    }

    public String[] attributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    protected void copyAttributesFrom(AttributeAccessor source) {
        String[] attributeNames;
        Assert.notNull(source, "Source must not be null");
        String[] stringArray = attributeNames = source.attributeNames();
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            this.setAttribute(attributeName, source.getAttribute(attributeName));
            ++n2;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeAccessorSupport)) {
            return false;
        }
        AttributeAccessorSupport that = (AttributeAccessorSupport)other;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }
}

