/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.j_paine.formatter.EndOfVectorOnWriteException;
import org.j_paine.formatter.Format;
import org.j_paine.formatter.FormatMap;
import org.j_paine.formatter.FormatX;
import org.j_paine.formatter.InputFormatException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidFormatException;
import org.j_paine.formatter.OutputFormatException;
import org.j_paine.formatter.StringsHashtableAndPointer;
import org.j_paine.formatter.VectorAndPointer;

public class Formatter {
    private Format format = null;
    private FormatMap format_map = null;

    public Formatter(String string2) throws InvalidFormatException {
        this(new Format(string2));
    }

    public Formatter(Format format2) {
        this.format = format2;
    }

    public void setFormatMap(FormatMap formatMap) {
        this.format_map = formatMap;
    }

    public void write(Vector vector, PrintStream printStream) throws OutputFormatException {
        FormatX formatX = new FormatX();
        VectorAndPointer vectorAndPointer = new VectorAndPointer(vector);
        try {
            while (true) {
                this.format.write(vectorAndPointer, printStream);
                vectorAndPointer.checkCurrentElementForWrite(formatX);
                printStream.println();
            }
        }
        catch (EndOfVectorOnWriteException endOfVectorOnWriteException) {
            return;
        }
    }

    public void write(int n, PrintStream printStream) throws OutputFormatException {
        this.write(new Integer(n), printStream);
    }

    public void write(long l, PrintStream printStream) throws OutputFormatException {
        this.write(new Long(l), printStream);
    }

    public void write(float f2, PrintStream printStream) throws OutputFormatException {
        this.write(new Float(f2), printStream);
    }

    public void write(double d, PrintStream printStream) throws OutputFormatException {
        this.write(new Double(d), printStream);
    }

    public void write(Object object, PrintStream printStream) throws OutputFormatException {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        this.write(vector, printStream);
    }

    public void read(Vector vector, DataInputStream dataInputStream) throws InputFormatException {
        VectorAndPointer vectorAndPointer = new VectorAndPointer(vector);
        InputStreamAndBuffer inputStreamAndBuffer = new InputStreamAndBuffer(dataInputStream);
        this.format.read(vectorAndPointer, inputStreamAndBuffer, this.format_map);
    }

    public void read(Vector vector, Hashtable hashtable, DataInputStream dataInputStream) throws InputFormatException {
        StringsHashtableAndPointer stringsHashtableAndPointer = new StringsHashtableAndPointer(vector, hashtable);
        InputStreamAndBuffer inputStreamAndBuffer = new InputStreamAndBuffer(dataInputStream);
        this.format.read(stringsHashtableAndPointer, inputStreamAndBuffer, this.format_map);
    }

    public void read(String[] stringArray, Hashtable hashtable, DataInputStream dataInputStream) throws InputFormatException {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        this.read(vector, hashtable, dataInputStream);
    }

    public Object read(DataInputStream dataInputStream) throws InputFormatException {
        Vector vector = new Vector();
        this.read(vector, dataInputStream);
        return vector.elementAt(0);
    }

    public boolean eof(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.available() <= 0;
    }

    public String toString() {
        return "[Formatter " + this.format.toString() + "]";
    }
}

