/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.util;

import org.apache.vinci.transport.util.Base64FormatException;

public class Base64Converter {
    public static final int LINE_LENGTH = 70;
    private static final byte[] B64_CODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private Base64Converter() {
    }

    public static byte[] convertBinaryToBase64(byte[] from2) {
        return Base64Converter.convertBinaryToBase64(from2, from2.length, true);
    }

    public static String convertStringToBase64String(String convert_me) {
        return new String(Base64Converter.convertBinaryToBase64(convert_me.getBytes()));
    }

    public static String convertBase64StringToString(String base64) throws Base64FormatException {
        return new String(Base64Converter.convertBase64ToBinary(base64.getBytes()));
    }

    public static byte[] convertBinaryToBase64(byte[] from2, int count2, boolean line_breaks) {
        int size2 = Base64Converter.calculateBase64OutputSize(count2, line_breaks);
        byte[] tmp = new byte[size2];
        int used = 0;
        for (int done = 0; done < count2; done += 3) {
            Base64Converter.b64encodeOctet(tmp, used, from2, done, count2 - done);
            used += 4;
        }
        if (line_breaks) {
            byte[] to2 = new byte[size2];
            int pos = 0;
            for (int breaks = 0; breaks < used; breaks += 70) {
                int length = used - breaks;
                if (length > 70) {
                    length = 70;
                }
                System.arraycopy(tmp, breaks, to2, pos, length);
                pos += length;
                to2[pos++] = 10;
            }
            return to2;
        }
        return tmp;
    }

    public static int calculateBase64OutputSize(int input_size, boolean line_breaks) {
        int q = input_size / 3;
        if (input_size % 3 != 0) {
            ++q;
        }
        q *= 4;
        if (line_breaks) {
            q += q / 70 + (q % 70 == 0 ? 0 : 1);
        }
        return q;
    }

    public static byte[] convertBase64ToBinary(byte[] input2) throws Base64FormatException {
        return Base64Converter.convertBase64ToBinary(input2, input2.length);
    }

    public static byte[] convertBase64ToBinary(byte[] input2, int input_size) throws Base64FormatException {
        int output_size = Base64Converter.calculateBinaryOutputSize(input2, input_size);
        byte[] output2 = new byte[output_size];
        int pos = 0;
        int i = 0;
        while (pos + 4 <= input_size) {
            pos = Base64Converter.b64decodeOctet(input2, pos, output2, 3 * i, input_size);
            ++i;
        }
        return output2;
    }

    public static int calculateBinaryOutputSize(byte[] input2, int input_size) throws Base64FormatException {
        int output_size = 0;
        int i = 0;
        while (i + 4 <= input_size) {
            i = Base64Converter.consumeInvalidDigits(input2, i, input_size);
            ++i;
            i = Base64Converter.consumeInvalidDigits(input2, i, input_size);
            ++i;
            if (input2[i = Base64Converter.consumeInvalidDigits(input2, i, input_size)] == 61) {
                ++output_size;
                break;
            }
            ++i;
            if (input2[i = Base64Converter.consumeInvalidDigits(input2, i, input_size)] == 61) {
                output_size += 2;
                break;
            }
            ++i;
            output_size += 3;
        }
        return output_size;
    }

    private static int consumeInvalidDigits(byte[] in, int off, int max_offset) throws Base64FormatException {
        if (off >= max_offset) {
            throw new Base64FormatException("short read");
        }
        while (!Base64Converter.b64validDigit(in[off])) {
            if (++off < max_offset) continue;
            throw new Base64FormatException("short read");
        }
        return off;
    }

    private static int b64decodeOctet(byte[] in, int in_offset, byte[] out, int out_offset, int max_offset) throws Base64FormatException {
        int B;
        int A;
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        if ((A = in[in_offset++]) < 0) {
            throw new Base64FormatException();
        }
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        if ((B = in[in_offset++]) < 0) {
            throw new Base64FormatException();
        }
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        int C = in[in_offset++];
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        int D = in[in_offset++];
        A = Base64Converter.b64decodeDigit(A);
        A <<= 2;
        B = Base64Converter.b64decodeDigit(B);
        out[out_offset] = (byte)(A |= B >> 4);
        B <<= 4;
        if ((C = Base64Converter.b64decodeDigit(C)) < 0) {
            return max_offset;
        }
        out[out_offset + 1] = (byte)(B |= C >> 2);
        C <<= 6;
        if ((D = Base64Converter.b64decodeDigit(D)) < 0) {
            return max_offset;
        }
        out[out_offset + 2] = (byte)(C |= D);
        return in_offset;
    }

    private static int b64decodeDigit(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c - 97 + 26;
        }
        if (c >= 48 && c <= 57) {
            return c - 48 + 52;
        }
        if (c == 43) {
            return 62;
        }
        if (c == 47) {
            return 63;
        }
        if (c == 61) {
            return -2;
        }
        return -1;
    }

    private static boolean b64validDigit(byte a) {
        if (a >= 65 && a <= 90) {
            return true;
        }
        if (a >= 97 && a <= 122) {
            return true;
        }
        if (a >= 48 && a <= 57) {
            return true;
        }
        return a == 47 || a == 43 || a == 61;
    }

    private static void b64encodeOctet(byte[] to2, int to_offset, byte[] from2, int from_offset, int count2) {
        int A = 0;
        int B = 0;
        int C = 0;
        int D = 0;
        int tmp = 0;
        A = from2[from_offset];
        if (A < 0) {
            A += 256;
        }
        A >>= 2;
        B = from2[from_offset];
        if (B < 0) {
            B += 256;
        }
        B &= 3;
        B <<= 4;
        if (count2 > 1) {
            tmp = from2[from_offset + 1] < 0 ? from2[from_offset + 1] + 256 : from2[from_offset + 1];
            B |= tmp >> 4;
            C = from2[from_offset + 1];
            if (C < 0) {
                C += 256;
            }
            C &= 0xF;
            C <<= 2;
        }
        if (count2 > 2) {
            tmp = from2[from_offset + 2] < 0 ? from2[from_offset + 2] + 256 : from2[from_offset + 2];
            C |= tmp >> 6;
            D = from2[from_offset + 2];
            if (D < 0) {
                D += 256;
            }
            D &= 0x3F;
        }
        to2[to_offset] = Base64Converter.b64codes(A);
        to2[to_offset + 1] = Base64Converter.b64codes(B);
        to2[to_offset + 2] = count2 > 1 ? Base64Converter.b64codes(C) : (byte)61;
        to2[to_offset + 3] = count2 > 2 ? Base64Converter.b64codes(D) : (byte)61;
    }

    private static byte b64codes(int which) {
        if (which < 0) {
            which += 256;
        }
        return B64_CODE[which];
    }
}

