/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.util.ProcessTraceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTraceEvent_impl
implements ProcessTraceEvent {
    private static final long serialVersionUID = 4275351517280216988L;
    private String mComponentName;
    private String mType;
    private String mDescription;
    private int mDuration;
    private String mResultMessage;
    private List<ProcessTraceEvent> mSubEvents;
    private long mStartTime;

    public ProcessTraceEvent_impl() {
    }

    public ProcessTraceEvent_impl(String aComponentName, String aType, String aDescription) {
        this.mComponentName = aComponentName;
        this.mType = aType;
        this.mDescription = aDescription;
    }

    @Override
    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String aName) {
        this.mComponentName = aName;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    public void setType(String aType) {
        this.mType = aType;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int aDuration) {
        this.mDuration = aDuration;
    }

    public void addToDuration(long aAdditionalDuration) {
        this.mDuration = (int)((long)this.mDuration + aAdditionalDuration);
    }

    @Override
    public String getResultMessage() {
        return this.mResultMessage;
    }

    public void setResultMessage(String aResultMessage) {
        this.mResultMessage = aResultMessage;
    }

    @Override
    public List<ProcessTraceEvent> getSubEvents() {
        if (this.mSubEvents == null) {
            return Collections.emptyList();
        }
        return this.mSubEvents;
    }

    public void addSubEvent(ProcessTraceEvent aEvent) {
        if (this.mSubEvents == null) {
            this.mSubEvents = new ArrayList<ProcessTraceEvent>();
        }
        this.mSubEvents.add(aEvent);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toString(buf, 0);
        return buf.toString();
    }

    @Override
    public void toString(StringBuffer aBuf, int aIndentLevel) {
        this.toString(aBuf, aIndentLevel, 0);
    }

    @Override
    public void toString(StringBuffer aBuf, int aIndentLevel, int aTotalTime) {
        List<ProcessTraceEvent> subEvents;
        int duration;
        DecimalFormat pctFmt = new DecimalFormat("##.##%");
        this.writeTabs(aIndentLevel, aBuf);
        aBuf.append("Component Name: ").append(this.getComponentName()).append("\n");
        this.writeTabs(aIndentLevel, aBuf);
        aBuf.append("Event Type: ").append(this.getType()).append("\n");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            this.writeTabs(aIndentLevel, aBuf);
            aBuf.append("Description: ").append(this.getDescription()).append("\n");
        }
        if ((duration = this.getDuration()) >= 0) {
            this.writeTabs(aIndentLevel, aBuf);
            aBuf.append("Duration: ").append(duration).append("ms");
            if (aTotalTime > 0) {
                double pct = (double)duration / (double)aTotalTime;
                String pctStr = pctFmt.format(pct);
                aBuf.append(" (").append(pctStr).append(')');
            }
            aBuf.append('\n');
        }
        if (this.getResultMessage() != null && this.getResultMessage().length() > 0) {
            this.writeTabs(aIndentLevel, aBuf);
            aBuf.append("Result: ").append(this.getResultMessage()).append("\n");
        }
        if (!(subEvents = this.getSubEvents()).isEmpty()) {
            this.writeTabs(aIndentLevel, aBuf);
            aBuf.append("Sub-events:").append("\n");
            for (ProcessTraceEvent evt : subEvents) {
                evt.toString(aBuf, aIndentLevel + 1, aTotalTime);
                aBuf.append("\n");
            }
        }
    }

    @Override
    public int getDurationExcludingSubEvents() {
        int result2 = this.getDuration();
        for (ProcessTraceEvent evt : this.getSubEvents()) {
            result2 -= evt.getDuration();
        }
        return result2;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long aStartTime) {
        this.mStartTime = aStartTime;
    }

    protected void writeTabs(int aNumTabs, StringBuffer aBuf) {
        for (int i = 0; i < aNumTabs; ++i) {
            aBuf.append('\t');
        }
    }
}

