/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.text.AnnotationFS;

public class CasCopier {
    private CAS mSrcCas;
    private CAS mDestCas;
    private LowLevelCAS mLowLevelDestCas;
    private Feature mDestSofaFeature;
    private Map<FeatureStructure, FeatureStructure> mFsMap = new HashMap<FeatureStructure, FeatureStructure>();

    public CasCopier(CAS aSrcCas, CAS aDestCas) {
        this.mSrcCas = aSrcCas;
        this.mDestCas = aDestCas;
        this.mLowLevelDestCas = aDestCas.getLowLevelCAS();
        this.mDestSofaFeature = aDestCas.getTypeSystem().getFeatureByFullName("uima.tcas.Annotation:sofa");
    }

    public static void copyCas(CAS aSrcCas, CAS aDestCas, boolean aCopySofa) {
        CasCopier copier = new CasCopier(aSrcCas, aDestCas);
        FSIterator<SofaFS> sofaIter = aSrcCas.getSofaIterator();
        while (sofaIter.hasNext()) {
            SofaFS sofa = (SofaFS)sofaIter.next();
            CAS view = aSrcCas.getView(sofa);
            copier.copyCasView(view, aCopySofa);
        }
    }

    public void copyCasView(CAS aSrcCasView, boolean aCopySofa) {
        CAS targetView = CasCopier.getOrCreateView(this.mDestCas, aSrcCasView.getViewName());
        if (aCopySofa) {
            String sofaMime = aSrcCasView.getSofa().getSofaMime();
            if (aSrcCasView.getDocumentText() != null) {
                targetView.setSofaDataString(aSrcCasView.getDocumentText(), sofaMime);
            } else if (aSrcCasView.getSofaDataURI() != null) {
                targetView.setSofaDataURI(aSrcCasView.getSofaDataURI(), sofaMime);
            } else if (aSrcCasView.getSofaDataArray() != null) {
                targetView.setSofaDataArray(this.copyFs(aSrcCasView.getSofaDataArray()), sofaMime);
            }
        }
        HashSet<FeatureStructure> indexedFs = new HashSet<FeatureStructure>();
        Iterator<FSIndex<FeatureStructure>> indexes = aSrcCasView.getIndexRepository().getIndexes();
        while (indexes.hasNext()) {
            FSIndex<FeatureStructure> index = indexes.next();
            for (FeatureStructure fs : index) {
                FeatureStructure sofa;
                if (indexedFs.contains(fs)) continue;
                FeatureStructure copyOfFs = this.copyFs(fs);
                if (fs instanceof AnnotationFS && (sofa = ((AnnotationFS)copyOfFs).getFeatureValue(this.mDestSofaFeature)) == null) {
                    copyOfFs.setFeatureValue(this.mDestSofaFeature, targetView.getSofa());
                }
                if (!CasCopier.isDocumentAnnotation(copyOfFs)) {
                    targetView.addFsToIndexes(copyOfFs);
                }
                indexedFs.add(fs);
            }
        }
    }

    public FeatureStructure copyFs(FeatureStructure aFS) {
        assert (((CASImpl)aFS.getCAS()).getBaseCAS() == ((CASImpl)this.mSrcCas).getBaseCAS());
        FeatureStructure copy = this.mFsMap.get(aFS);
        if (copy != null) {
            return copy;
        }
        Type srcType = aFS.getType();
        if (aFS instanceof SofaFS) {
            String sofaId = ((SofaFS)aFS).getSofaID();
            return CasCopier.getOrCreateView(this.mDestCas, sofaId).getSofa();
        }
        if (CasCopier.isDocumentAnnotation(aFS)) {
            String viewName = ((AnnotationFS)aFS).getView().getViewName();
            CAS destView = this.mDestCas.getView(viewName);
            AnnotationFS destDocAnnot = destView.getDocumentAnnotation();
            if (destDocAnnot != null) {
                this.copyFeatures(aFS, destDocAnnot);
            }
            return destDocAnnot;
        }
        if (aFS.getType().isArray()) {
            copy = this.copyArray(aFS);
            this.mFsMap.put(aFS, copy);
            return copy;
        }
        Type destType = this.mDestCas.getTypeSystem() == this.mSrcCas.getTypeSystem() ? srcType : this.mDestCas.getTypeSystem().getType(srcType.getName());
        if (destType == null) {
            throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{srcType.getName()});
        }
        int typeCode = this.mLowLevelDestCas.ll_getTypeSystem().ll_getCodeForType(destType);
        int destFsAddr = this.mLowLevelDestCas.ll_createFS(typeCode);
        FeatureStructure destFs = this.mDestCas.getLowLevelCAS().ll_getFSForRef(destFsAddr);
        this.mFsMap.put(aFS, destFs);
        this.copyFeatures(aFS, destFs);
        return destFs;
    }

    private void copyFeatures(FeatureStructure aSrcFS, FeatureStructure aDestFS) {
        Type srcType = aSrcFS.getType();
        Type destType = aDestFS.getType();
        for (Feature srcFeat : srcType.getFeatures()) {
            Feature destFeat;
            if (destType == aSrcFS.getType()) {
                destFeat = srcFeat;
            } else {
                destFeat = destType.getFeatureByBaseName(srcFeat.getShortName());
                if (destFeat == null) {
                    throw new UIMARuntimeException("type_not_found_during_cas_copy", new Object[]{srcFeat.getName()});
                }
            }
            if (srcFeat.getRange().isPrimitive()) {
                aDestFS.setFeatureValueFromString(destFeat, aSrcFS.getFeatureValueAsString(srcFeat));
                continue;
            }
            FeatureStructure refFS = aSrcFS.getFeatureValue(srcFeat);
            if (refFS == null) continue;
            FeatureStructure copyRefFs = this.copyFs(refFS);
            aDestFS.setFeatureValue(destFeat, copyRefFs);
        }
    }

    public boolean alreadyCopied(FeatureStructure aFS) {
        return this.mFsMap.containsKey(aFS);
    }

    private FeatureStructure copyArray(FeatureStructure aSrcFs) {
        if (aSrcFs instanceof StringArrayFS) {
            StringArrayFS arrayFs = (StringArrayFS)aSrcFs;
            int len = arrayFs.size();
            StringArrayFS destFS = this.mDestCas.createStringArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof IntArrayFS) {
            IntArrayFS arrayFs = (IntArrayFS)aSrcFs;
            int len = arrayFs.size();
            IntArrayFS destFS = this.mDestCas.createIntArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ByteArrayFS) {
            ByteArrayFS arrayFs = (ByteArrayFS)aSrcFs;
            int len = arrayFs.size();
            ByteArrayFS destFS = this.mDestCas.createByteArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ShortArrayFS) {
            ShortArrayFS arrayFs = (ShortArrayFS)aSrcFs;
            int len = arrayFs.size();
            ShortArrayFS destFS = this.mDestCas.createShortArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof LongArrayFS) {
            LongArrayFS arrayFs = (LongArrayFS)aSrcFs;
            int len = arrayFs.size();
            LongArrayFS destFS = this.mDestCas.createLongArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof FloatArrayFS) {
            FloatArrayFS arrayFs = (FloatArrayFS)aSrcFs;
            int len = arrayFs.size();
            FloatArrayFS destFS = this.mDestCas.createFloatArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof DoubleArrayFS) {
            DoubleArrayFS arrayFs = (DoubleArrayFS)aSrcFs;
            int len = arrayFs.size();
            DoubleArrayFS destFS = this.mDestCas.createDoubleArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof BooleanArrayFS) {
            BooleanArrayFS arrayFs = (BooleanArrayFS)aSrcFs;
            int len = arrayFs.size();
            BooleanArrayFS destFS = this.mDestCas.createBooleanArrayFS(len);
            for (int i = 0; i < len; ++i) {
                destFS.set(i, arrayFs.get(i));
            }
            return destFS;
        }
        if (aSrcFs instanceof ArrayFS) {
            ArrayFS arrayFs = (ArrayFS)aSrcFs;
            int len = arrayFs.size();
            ArrayFS destFS = this.mDestCas.createArrayFS(len);
            for (int i = 0; i < len; ++i) {
                FeatureStructure srcElem = arrayFs.get(i);
                if (srcElem == null) continue;
                FeatureStructure copyElem = this.copyFs(arrayFs.get(i));
                destFS.set(i, copyElem);
            }
            return destFS;
        }
        assert (false);
        return null;
    }

    private static CAS getOrCreateView(CAS aCas, String aViewName) {
        try {
            return aCas.getView(aViewName);
        }
        catch (CASRuntimeException e) {
            return aCas.createView(aViewName);
        }
    }

    private static boolean isDocumentAnnotation(FeatureStructure aFS) {
        return aFS instanceof AnnotationFS && ((Object)aFS).equals(((AnnotationFS)aFS).getView().getDocumentAnnotation());
    }
}

