/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex4;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.DateAnnot;
import org.apache.uima.tutorial.Meeting;
import org.apache.uima.tutorial.RoomNumber;
import org.apache.uima.tutorial.TimeAnnot;

public class MeetingAnnotator
extends JCasAnnotator_ImplBase {
    private int mWindowSize;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mWindowSize = (Integer)aContext.getConfigParameterValue("WindowSize");
    }

    public void process(JCas aJCas) {
        AnnotationIndex<Annotation> roomNumberIndex = aJCas.getAnnotationIndex(RoomNumber.type);
        AnnotationIndex<Annotation> dateIndex = aJCas.getAnnotationIndex(DateAnnot.type);
        AnnotationIndex<Annotation> timeIndex = aJCas.getAnnotationIndex(TimeAnnot.type);
        int lastMeetingEnd = -1;
        for (RoomNumber roomNumber : roomNumberIndex) {
            for (DateAnnot dateAnnot : dateIndex) {
                for (TimeAnnot timeAnnot : timeIndex) {
                    for (TimeAnnot timeAnnot2 : timeIndex) {
                        if (timeAnnot == timeAnnot2) continue;
                        int minBegin = Math.min(Math.min(timeAnnot.getBegin(), timeAnnot2.getBegin()), Math.min(dateAnnot.getBegin(), roomNumber.getBegin()));
                        int maxEnd = Math.max(Math.max(timeAnnot.getEnd(), timeAnnot2.getEnd()), Math.max(dateAnnot.getEnd(), roomNumber.getEnd()));
                        if (maxEnd - minBegin >= this.mWindowSize || minBegin <= lastMeetingEnd) continue;
                        Meeting mtg = new Meeting(aJCas, minBegin, maxEnd, roomNumber, dateAnnot, timeAnnot, timeAnnot2);
                        mtg.addToIndexes();
                        lastMeetingEnd = maxEnd;
                    }
                }
            }
        }
    }
}

