/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.viewer;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JApplet;
import org.apache.uima.cas.admin.CASFactory;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.internal.util.SerializationUtils;
import org.apache.uima.tools.viewer.CasAnnotationViewer;

public class CasAnnotationViewerApplet
extends JApplet {
    private static final long serialVersionUID = 1273090141115008715L;
    private CasAnnotationViewer mViewer;

    public void init() {
        try {
            String casURL = this.getParameter("CasUrl");
            URLConnection con = new URL(casURL).openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setDefaultUseCaches(false);
            con.setRequestProperty("Content-Type", "application/octet-stream");
            InputStream in = con.getInputStream();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] buf = new byte[2048];
            int bytesRead = in.read(buf);
            while (bytesRead > 0) {
                byteStream.write(buf, 0, bytesRead);
                bytesRead = in.read(buf);
            }
            byte[] bytes = byteStream.toByteArray();
            in.close();
            byteStream.close();
            System.out.println("Got " + bytes.length + " bytes.");
            CASMgr casMgr = CASFactory.createCAS();
            CASCompleteSerializer serializer = (CASCompleteSerializer)SerializationUtils.deserialize(bytes);
            Serialization.deserializeCASComplete(serializer, casMgr);
            boolean rightToLeft = false;
            String rightToLeftParam = this.getParameter("RightToLeftTextOrientation");
            if (rightToLeftParam != null && rightToLeftParam.equalsIgnoreCase("true")) {
                rightToLeft = true;
            }
            this.mViewer = new CasAnnotationViewer();
            this.getContentPane().add(this.mViewer);
            this.mViewer.setCAS(casMgr.getCAS().getView("_InitialView"));
            this.mViewer.setRightToLeftTextOrientation(rightToLeft);
            this.addComponentListener(new MyComponentListener());
            this.resizeTreeViewer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resizeTreeViewer() {
        System.out.println("Resizing viewer");
        Dimension appletSize = this.getSize();
        Insets insets = this.getInsets();
        Dimension panelSize = new Dimension(appletSize.width - insets.left - insets.right - 10, appletSize.height - insets.top - insets.bottom - 10);
        this.mViewer.setPreferredSize(panelSize);
        this.mViewer.setSize(panelSize);
        this.validate();
        System.out.println("Resize complete");
    }

    class MyComponentListener
    extends ComponentAdapter {
        MyComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            CasAnnotationViewerApplet.this.resizeTreeViewer();
        }
    }
}

