/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.tsview;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.util.EventListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASFactory;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.tools.cvd.tsview.FeatureTableModel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 5606886216212480040L;
    TypeSystem ts = null;
    private Type selectedType;
    private JTable featureTable = null;
    private JTree typeTree = null;

    public MainFrame() {
        this.init();
    }

    public MainFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public MainFrame(String title) {
        super(title);
        this.init();
    }

    public MainFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    private void init() {
        this.setTitle("Type System Editor");
        JSplitPane contentPane = new JSplitPane(1);
        this.setContentPane(contentPane);
        DefaultMutableTreeNode root2 = new DefaultMutableTreeNode("<html><b>No CAS!</b></html>");
        DefaultTreeModel treeModel = new DefaultTreeModel(root2);
        this.typeTree = new JTree(treeModel);
        this.typeTree.addTreeSelectionListener(new TypeTreeSelectionListener());
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.typeTree.setSelectionModel(treeSelectionModel);
        JScrollPane treePane = new JScrollPane(this.typeTree);
        contentPane.setLeftComponent(treePane);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        this.typeTree.setCellRenderer(cellRenderer);
        this.featureTable = new JTable(new FeatureTableModel());
        JScrollPane featurePane = new JScrollPane(this.featureTable);
        featurePane.getViewport().setBackground(Color.WHITE);
        contentPane.setRightComponent(featurePane);
        this.setJMenuBar(this.createMenuBar());
    }

    public void showAnnotFeats() {
        this.selectedType = this.ts.getType("uima.tcas.Annotation");
        this.updateFeatureTable();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu optionsMenu = new JMenu("Options");
        JMenuItem showInheritedFeatsItem = new JMenuItem("Show Inherited Features");
        optionsMenu.add(showInheritedFeatsItem);
        menuBar.add(optionsMenu);
        return menuBar;
    }

    private void updateFeatureTable() {
        if (this.selectedType == null) {
            return;
        }
        ((FeatureTableModel)this.featureTable.getModel()).setType(this.selectedType);
    }

    private DefaultMutableTreeNode createTypeTree(Type type) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(type);
        List<Type> types = this.ts.getDirectSubtypes(type);
        int max2 = types.size();
        for (int i = 0; i < max2; ++i) {
            DefaultMutableTreeNode child = this.createTypeTree(types.get(i));
            node.add(child);
        }
        return node;
    }

    private void updateTypeTree() {
        if (this.ts == null) {
            return;
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.typeTree.getModel().getRoot();
        rootNode.removeAllChildren();
        Type top = this.ts.getTopType();
        rootNode.setUserObject(top);
        List<Type> types = this.ts.getDirectSubtypes(top);
        for (int i = 0; i < types.size(); ++i) {
            rootNode.add(this.createTypeTree(types.get(i)));
        }
        DefaultTreeModel model = (DefaultTreeModel)this.typeTree.getModel();
        TreeModelListener[] listeners = MainFrame.getTreeModelListeners(model);
        Object[] path = new Object[]{rootNode};
        TreeModelEvent event = new TreeModelEvent((Object)rootNode, path);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeStructureChanged(event);
        }
    }

    public static TreeModelListener[] getTreeModelListeners(DefaultTreeModel model) {
        EventListener[] eventListeners = model.getListeners(TreeModelListener.class);
        TreeModelListener[] modelListeners = new TreeModelListener[eventListeners.length];
        for (int i = 0; i < modelListeners.length; ++i) {
            modelListeners[i] = (TreeModelListener)eventListeners[i];
        }
        return modelListeners;
    }

    public void setTypeSystem(TypeSystem ts) {
        this.ts = ts;
        this.updateTypeTree();
    }

    public static void main(String[] args) {
        try {
            MainFrame frame = new MainFrame();
            frame.setDefaultCloseOperation(3);
            CASMgr casMgr = CASFactory.createCAS();
            frame.setTypeSystem(casMgr.getTypeSystemMgr());
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TypeTreeSelectionListener
    implements TreeSelectionListener {
        private TypeTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainFrame.this.typeTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Type t = (Type)node.getUserObject();
            if (t != null) {
                MainFrame.this.selectedType = t;
                MainFrame.this.updateFeatureTable();
            }
        }
    }
}

