/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.tools.cvd.ColorIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDisplayCustomizationFrame
extends JFrame {
    private static final long serialVersionUID = -6695661439132793537L;
    private static final int FG = 0;
    private static final int BG = 1;
    private JSplitPane splitPane;
    private Color fgColor;
    private Color bgColor;
    private ColorIcon fgIcon;
    private ColorIcon bgIcon;
    private JTextPane textPane;
    private static final String defaultStyleName = "defaultUnannotStyle";
    private static final String currentStyleName = "currentStyle";
    private Style currentStyle;
    private String currentTypeName;
    private JButton acceptButton;
    private JButton cancelButton;
    private Map<String, Style> styleMap;
    private JTree tree;

    public AnnotationDisplayCustomizationFrame() {
    }

    public AnnotationDisplayCustomizationFrame(GraphicsConfiguration arg0) {
        super(arg0);
    }

    public AnnotationDisplayCustomizationFrame(String arg0) {
        super(arg0);
    }

    public AnnotationDisplayCustomizationFrame(String arg0, GraphicsConfiguration arg1) {
        super(arg0, arg1);
    }

    private void setCurrentStyle(Style style) {
        this.currentStyle = this.textPane.addStyle(currentStyleName, style);
        StyleConstants.setForeground(this.currentStyle, StyleConstants.getForeground(style));
        StyleConstants.setBackground(this.currentStyle, StyleConstants.getBackground(style));
    }

    private void enableButtons(boolean flag) {
        this.acceptButton.setEnabled(flag);
        this.cancelButton.setEnabled(flag);
    }

    public void init(Map<String, Style> styleMap1, CAS cas) {
        this.styleMap = styleMap1;
        this.splitPane = new JSplitPane(1);
        this.setContentPane(this.splitPane);
        this.tree = new JTree(this.createTreeModel(cas.getTypeSystem()));
        this.tree.addTreeSelectionListener(new TypeTreeSelectionListener());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(treeScrollPane);
        this.splitPane.setRightComponent(this.createCustomizationPanel("uima.tcas.Annotation"));
    }

    private JPanel createCustomizationPanel(String typeName) {
        this.currentTypeName = typeName;
        String defaultAnnotStyleName = "uima.tcas.Annotation";
        Style defaultAnnotStyle = this.styleMap.get(defaultAnnotStyleName);
        GridLayout layout = new GridLayout(0, 1);
        JPanel topPanel = new JPanel(layout);
        this.textPane = new JTextPane();
        Style style = this.styleMap.get(typeName);
        if (style == null) {
            style = defaultAnnotStyle;
        }
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        this.textPane.addStyle(defaultStyleName, defaultStyle);
        this.setCurrentStyle(style);
        this.fgColor = StyleConstants.getForeground(this.currentStyle);
        this.bgColor = StyleConstants.getBackground(this.currentStyle);
        this.fgIcon = new ColorIcon(this.fgColor);
        this.bgIcon = new ColorIcon(this.bgColor);
        topPanel.add(this.createColorPanel("Foreground: ", this.fgIcon, 0));
        topPanel.add(this.createColorPanel("Background: ", this.bgIcon, 1));
        this.setTextPane();
        topPanel.add(this.textPane);
        JPanel buttonPanel = new JPanel();
        this.createButtonPanel(buttonPanel);
        topPanel.add(buttonPanel);
        return topPanel;
    }

    private void setCustomizationPanel(String typeName) {
        this.currentTypeName = typeName;
        Style defaultAnnotStyle = this.styleMap.get("uima.tcas.Annotation");
        Style style = this.styleMap.get(typeName);
        if (style == null) {
            style = defaultAnnotStyle;
        }
        this.setCurrentStyle(style);
        this.fgColor = StyleConstants.getForeground(this.currentStyle);
        this.bgColor = StyleConstants.getBackground(this.currentStyle);
        this.fgIcon.setColor(this.fgColor);
        this.bgIcon.setColor(this.bgColor);
        this.setTextPane();
        this.enableButtons(false);
        this.repaint();
    }

    private void createButtonPanel(JPanel buttonPanel) {
        this.acceptButton = new JButton("OK");
        this.acceptButton.addActionListener(new AcceptButtonHandler());
        buttonPanel.add(this.acceptButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new CancelButtonHandler());
        buttonPanel.add(this.cancelButton);
        this.enableButtons(false);
    }

    private void setTextPane() {
        Style defaultStyle = this.textPane.getStyle(defaultStyleName);
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(doc.getLength(), "This is what an ", defaultStyle);
            doc.insertString(doc.getLength(), "annotation", this.currentStyle);
            doc.insertString(doc.getLength(), " of type ", defaultStyle);
            doc.insertString(doc.getLength(), this.currentTypeName, this.currentStyle);
            doc.insertString(doc.getLength(), " will look like.", defaultStyle);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textPane.repaint();
    }

    private JPanel createColorPanel(String text2, ColorIcon icon, int buttonType) {
        JPanel colorPanel = new JPanel();
        JLabel label = new JLabel(text2);
        colorPanel.add(label);
        label = new JLabel(icon);
        colorPanel.add(label);
        JButton button = new JButton("Customize");
        if (buttonType == 0) {
            button.addActionListener(new CustomizeFgButtonHandler());
        } else {
            button.addActionListener(new CustomizeBgButtonHandler());
        }
        colorPanel.add(button);
        return colorPanel;
    }

    private TreeModel createTreeModel(TypeSystem ts) {
        String typeName = "uima.tcas.Annotation";
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(typeName);
        Type type = ts.getType(typeName);
        AnnotationDisplayCustomizationFrame.addChildren(node, type, ts);
        DefaultTreeModel treeModel = new DefaultTreeModel(node);
        return treeModel;
    }

    private static void addChildren(DefaultMutableTreeNode node, Type type, TypeSystem ts) {
        List<Type> dtrs = ts.getDirectSubtypes(type);
        for (int i = 0; i < dtrs.size(); ++i) {
            Type dtrType = dtrs.get(i);
            DefaultMutableTreeNode dtrNode = new DefaultMutableTreeNode(dtrType.getName());
            node.add(dtrNode);
            AnnotationDisplayCustomizationFrame.addChildren(dtrNode, dtrType, ts);
        }
    }

    private class CancelButtonHandler
    implements ActionListener {
        private CancelButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Style style = (Style)AnnotationDisplayCustomizationFrame.this.styleMap.get(AnnotationDisplayCustomizationFrame.this.currentTypeName);
            if (style == null) {
                style = (Style)AnnotationDisplayCustomizationFrame.this.styleMap.get("uima.tcas.Annotation");
            }
            AnnotationDisplayCustomizationFrame.this.fgColor = StyleConstants.getForeground(style);
            AnnotationDisplayCustomizationFrame.this.fgIcon.setColor(AnnotationDisplayCustomizationFrame.this.fgColor);
            AnnotationDisplayCustomizationFrame.this.bgColor = StyleConstants.getBackground(style);
            AnnotationDisplayCustomizationFrame.this.bgIcon.setColor(AnnotationDisplayCustomizationFrame.this.bgColor);
            AnnotationDisplayCustomizationFrame.this.setCurrentStyle(style);
            AnnotationDisplayCustomizationFrame.this.setTextPane();
            AnnotationDisplayCustomizationFrame.this.enableButtons(false);
            AnnotationDisplayCustomizationFrame.this.repaint();
        }
    }

    private class AcceptButtonHandler
    implements ActionListener {
        private AcceptButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Style style = (Style)AnnotationDisplayCustomizationFrame.this.styleMap.get(AnnotationDisplayCustomizationFrame.this.currentTypeName);
            if (style == null) {
                style = AnnotationDisplayCustomizationFrame.this.textPane.addStyle(AnnotationDisplayCustomizationFrame.this.currentTypeName, (Style)AnnotationDisplayCustomizationFrame.this.styleMap.get("uima.tcas.Annotation"));
            }
            StyleConstants.setForeground(style, StyleConstants.getForeground(AnnotationDisplayCustomizationFrame.this.currentStyle));
            StyleConstants.setBackground(style, StyleConstants.getBackground(AnnotationDisplayCustomizationFrame.this.currentStyle));
            AnnotationDisplayCustomizationFrame.this.styleMap.put(AnnotationDisplayCustomizationFrame.this.currentTypeName, style);
            AnnotationDisplayCustomizationFrame.this.enableButtons(false);
            AnnotationDisplayCustomizationFrame.this.repaint();
        }
    }

    private class CustomizeFgButtonHandler
    implements ActionListener {
        private CustomizeFgButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Color color = JColorChooser.showDialog(AnnotationDisplayCustomizationFrame.this, "Choose color", AnnotationDisplayCustomizationFrame.this.fgColor);
            if (color != null) {
                AnnotationDisplayCustomizationFrame.this.fgColor = color;
                AnnotationDisplayCustomizationFrame.this.fgIcon.setColor(color);
                StyleConstants.setForeground(AnnotationDisplayCustomizationFrame.this.currentStyle, color);
                AnnotationDisplayCustomizationFrame.this.setTextPane();
                AnnotationDisplayCustomizationFrame.this.enableButtons(true);
                AnnotationDisplayCustomizationFrame.this.repaint();
            }
        }
    }

    private class CustomizeBgButtonHandler
    implements ActionListener {
        private CustomizeBgButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Color color = JColorChooser.showDialog(AnnotationDisplayCustomizationFrame.this, "Choose color", AnnotationDisplayCustomizationFrame.this.bgColor);
            if (color != null) {
                AnnotationDisplayCustomizationFrame.this.bgColor = color;
                AnnotationDisplayCustomizationFrame.this.bgIcon.setColor(color);
                StyleConstants.setBackground(AnnotationDisplayCustomizationFrame.this.currentStyle, color);
                AnnotationDisplayCustomizationFrame.this.setTextPane();
                AnnotationDisplayCustomizationFrame.this.enableButtons(true);
                AnnotationDisplayCustomizationFrame.this.repaint();
            }
        }
    }

    private class TypeTreeSelectionListener
    implements TreeSelectionListener {
        private TypeTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AnnotationDisplayCustomizationFrame.this.tree.getLastSelectedPathComponent();
            String typeName = (String)node.getUserObject();
            if (typeName.equals(AnnotationDisplayCustomizationFrame.this.currentTypeName)) {
                return;
            }
            AnnotationDisplayCustomizationFrame.this.setCustomizationPanel(typeName);
        }
    }
}

