/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class FileSystemCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_XCAS = "XCAS";
    public static final String PARAM_LENIENT = "LENIENT";
    private ArrayList mFiles;
    private String mEncoding;
    private String mLanguage;
    private int mCurrentIndex;
    private boolean mTEXT;
    private String mXCAS;
    private boolean lenient;

    public void initialize() throws ResourceInitializationException {
        String dirPath = ((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim();
        File directory = new File(dirPath);
        this.mEncoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mXCAS = (String)this.getConfigParameterValue(PARAM_XCAS);
        this.mTEXT = !"xcas".equalsIgnoreCase(this.mXCAS) && !"xmi".equalsIgnoreCase(this.mXCAS) && !"true".equalsIgnoreCase(this.mXCAS);
        String mLenient = (String)this.getConfigParameterValue(PARAM_LENIENT);
        this.lenient = "true".equalsIgnoreCase(mLenient);
        this.mCurrentIndex = 0;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList();
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            this.mFiles.add(files[i]);
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        File file = (File)this.mFiles.get(this.mCurrentIndex++);
        FileInputStream fis = new FileInputStream(file);
        if (this.mTEXT) {
            try {
                if (this.getCasInitializer() != null) {
                    this.getCasInitializer().initializeCas(fis, aCAS);
                } else {
                    String text2 = FileUtils.file2String(file, this.mEncoding);
                    jcas.setDocumentText(text2);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            if (this.mLanguage != null) {
                jcas.setDocumentLanguage(this.mLanguage);
            }
            SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
            srcDocInfo.setUri(file.getAbsoluteFile().toURL().toString());
            srcDocInfo.setOffsetInSource(0);
            srcDocInfo.setDocumentSize((int)file.length());
            srcDocInfo.setLastSegment(this.mCurrentIndex == this.mFiles.size());
            srcDocInfo.addToIndexes();
        } else {
            try {
                if (this.mXCAS.equalsIgnoreCase("xmi")) {
                    XmiCasDeserializer.deserialize(fis, aCAS, this.lenient);
                } else {
                    XCASDeserializer.deserialize(fis, aCAS, this.lenient);
                }
            }
            catch (SAXException e) {
                UIMAFramework.getLogger(FileSystemCollectionReader.class).log(Level.WARNING, "Problem with XML input file: " + file.getAbsolutePath());
                throw new CollectionException(e);
            }
            finally {
                fis.close();
            }
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mFiles.size();
    }

    public static CollectionReaderDescription getDescription() throws InvalidXMLException {
        InputStream descStream = FileSystemCollectionReader.class.getResourceAsStream("FileSystemCollectionReader.xml");
        return UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return FileSystemCollectionReader.class.getResource("FileSystemCollectionReader.xml");
    }
}

