/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class MessageRouter
implements Runnable {
    private static final String OUT_MSG_ID = "OUT";
    private static final String ERR_MSG_ID = "ERR";
    private static final long WAITING_TIME = 5L;
    private StringWriter _errStream;
    private StringBuffer _errBuffer;
    private PrintWriter _errWriter;
    private int _errOffset;
    private StringWriter _outStream;
    private StringBuffer _outBuffer;
    private PrintWriter _outWriter;
    private int _outOffset;
    private boolean _terminated = false;
    private Thread _thread;
    private List<String> _stdHistory = new ArrayList<String>();
    private List<StdChannelListener> _stdListeners = new ArrayList<StdChannelListener>();

    public MessageRouter() {
        this._errStream = new StringWriter();
        this._errBuffer = this._errStream.getBuffer();
        this._errWriter = new PrintWriter(this._errStream);
        this._errOffset = this._errBuffer.length();
        this._outStream = new StringWriter();
        this._outBuffer = this._outStream.getBuffer();
        this._outWriter = new PrintWriter(this._outStream);
        this._outOffset = this._outBuffer.length();
        this._thread = new Thread((Runnable)this, "MessageRouter");
    }

    public synchronized void addChannelListener(StdChannelListener listener) {
        if (!this._stdListeners.contains(listener)) {
            if (this._stdHistory.size() > 0) {
                for (String entry : this._stdHistory) {
                    String message = entry.substring(4);
                    if (entry.startsWith(ERR_MSG_ID)) {
                        listener.errMsgPosted(message);
                        continue;
                    }
                    listener.outMsgPosted(message);
                }
            }
            this._stdListeners.add(listener);
        }
    }

    public int countStdChannelListeners() {
        return this._stdListeners.size();
    }

    public boolean isRunning() {
        return this._thread.isAlive();
    }

    public synchronized void removeChannelListener(StdChannelListener listener) {
        this._stdListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean terminated2 = false;
        String errMessage = null;
        String outMessage = null;
        while (!terminated2) {
            Object object = this._errStream;
            synchronized (object) {
                if (this._errBuffer.length() > this._errOffset) {
                    errMessage = this._errBuffer.substring(this._errOffset);
                    this._errOffset = this._errBuffer.length();
                }
            }
            object = this._outStream;
            synchronized (object) {
                if (this._outBuffer.length() > this._outOffset) {
                    outMessage = this._outBuffer.substring(this._outOffset);
                    this._outOffset = this._outBuffer.length();
                }
            }
            object = this;
            synchronized (object) {
                if (errMessage != null || outMessage != null) {
                    if (errMessage != null) {
                        this._stdHistory.add("ERR^" + errMessage);
                    }
                    if (outMessage != null) {
                        this._stdHistory.add("OUT^" + outMessage);
                    }
                    for (StdChannelListener client : this._stdListeners) {
                        if (errMessage != null) {
                            client.errMsgPosted(errMessage);
                        }
                        if (outMessage == null) continue;
                        client.outMsgPosted(outMessage);
                    }
                    errMessage = null;
                    outMessage = null;
                }
                terminated2 = this._terminated;
            }
            if (terminated2) continue;
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {}
        }
    }

    public PrintWriter errWriter() {
        return this._errWriter;
    }

    public PrintWriter outWriter() {
        return this._outWriter;
    }

    public void start() {
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this._errWriter.flush();
        this._outWriter.flush();
        MessageRouter messageRouter = this;
        synchronized (messageRouter) {
            this._terminated = true;
        }
        try {
            this._thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface StdChannelListener {
        public void errMsgPosted(String var1);

        public void outMsgPosted(String var1);
    }
}

