/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.pear.util.StringUtil;
import org.xml.sax.SAXException;

public class PackageBrowser {
    public static final String BINARY_DIR = File.separator + "bin";
    public static final String CONFIGURATION_DIR = File.separator + "conf";
    public static final String DATA_DIR = File.separator + "data";
    public static final String DESCRIPTORS_DIR = File.separator + "desc";
    public static final String DOCUMENTATION_DIR = File.separator + "doc";
    public static final String LIBRARY_DIR = File.separator + "lib";
    public static final String METADATA_DIR = File.separator + "metadata";
    public static final String RESOURCES_DIR = File.separator + "resources";
    public static final String SOURCES_DIR = File.separator + "src";
    public static final String INSTALLATION_DESCRIPTOR_FILE = File.separator + "metadata/install.xml";
    public static final String PEAR_PROPERTIES_FILE = File.separator + "metadata/PEAR.properties";
    public static final String SUBMISSION_PROPERTIES_FILE = METADATA_DIR + "/submission.properties";
    public static final String SETENV_TXT_FILE = File.separator + "metadata/setenv.txt";
    private File _rootDir;
    private JarFile _pearPackage;
    private File _pearFile;
    private boolean _archived;
    private TreeSet<File> _allFiles = new TreeSet();
    private TreeSet<File> _allDirs = new TreeSet();

    public PackageBrowser(JarFile pearPackage) throws IOException {
        this._pearPackage = pearPackage;
        this._pearFile = new File(pearPackage.getName());
        int nameEndIndex = this._pearFile.getAbsolutePath().lastIndexOf(46);
        String rootDirPath = nameEndIndex > 0 ? this._pearFile.getAbsolutePath().substring(0, nameEndIndex) : this._pearFile.getAbsolutePath();
        this._rootDir = new File(rootDirPath);
        this._archived = true;
        this._allDirs.addAll(FileUtil.createDirList(pearPackage));
        this._allFiles.addAll(FileUtil.createFileList(pearPackage));
    }

    public PackageBrowser(File pearPackageDir) throws IOException {
        this._rootDir = pearPackageDir;
        this._archived = false;
        this._allFiles.addAll(FileUtil.createFileList(this._rootDir, true));
        this._allDirs.addAll(FileUtil.createDirList(this._rootDir, true));
    }

    public String buildComponentClassPath() throws IOException {
        return this.buildComponentClassPath(false, true);
    }

    public String buildComponentRuntimeClassPath() throws IOException {
        return this.buildComponentClassPath(false, false);
    }

    public String buildComponentClassPath(boolean relativePath, boolean addLibDir) throws IOException {
        InstallationDescriptor insdObject;
        if (!this.isArchived() && (insdObject = this.getInstallationDescriptor()) != null) {
            String absoluteClassPath = InstallationController.buildComponentClassPath(this.getRootDirectory().getAbsolutePath(), insdObject, addLibDir);
            String absoluteRootDirPathExp = StringUtil.toRegExpReplacement(this.getRootDirectory().getAbsolutePath().replace('\\', '/'));
            return relativePath ? absoluteClassPath.replaceAll(absoluteRootDirPathExp, "\\.") : absoluteClassPath;
        }
        return null;
    }

    public String buildComponentPath() throws IOException {
        return this.buildComponentPath(false);
    }

    public String buildComponentPath(boolean relativePath) throws IOException {
        InstallationDescriptor insdObject;
        if (!this.isArchived() && (insdObject = this.getInstallationDescriptor()) != null) {
            String absolutePath = InstallationController.buildComponentPath(this.getRootDirectory().getAbsolutePath(), insdObject);
            String absoluteRootDirPathExp = StringUtil.toRegExpReplacement(this.getRootDirectory().getAbsolutePath().replace('\\', '/'));
            return relativePath ? absolutePath.replaceAll(absoluteRootDirPathExp, "\\.") : absolutePath;
        }
        return null;
    }

    public File[] findDirectory(String dirNamePattern) {
        String pattern = dirNamePattern.replace('\\', '/');
        File[] foundDirs = new File[]{};
        ArrayList<File> foundDirList = new ArrayList<File>();
        for (File dir2 : this._allDirs) {
            String dirName = dir2.getAbsolutePath().substring(this._rootDir.getAbsolutePath().length()).replace('\\', '/');
            if (pattern.startsWith(File.separator)) {
                if (!dirName.startsWith(pattern)) continue;
                foundDirList.add(dir2);
                continue;
            }
            if (dirName.indexOf(pattern) < 0) continue;
            foundDirList.add(dir2);
        }
        if (foundDirList.size() > 0) {
            foundDirs = new File[foundDirList.size()];
            foundDirList.toArray(foundDirs);
        }
        return foundDirs;
    }

    public File[] findFile(String fileNamePattern) {
        String pattern = fileNamePattern.replace('\\', '/');
        File[] foundFiles = new File[]{};
        ArrayList<File> foundFileList = new ArrayList<File>();
        for (File file : this._allFiles) {
            String fileName = file.getAbsolutePath().substring(this._rootDir.getAbsolutePath().length()).replace('\\', '/');
            if (pattern.startsWith(File.separator) && fileName.startsWith(pattern)) {
                foundFileList.add(file);
            }
            if (fileName.indexOf(pattern) < 0) continue;
            foundFileList.add(file);
        }
        if (foundFileList.size() > 0) {
            foundFiles = new File[foundFileList.size()];
            foundFileList.toArray(foundFiles);
        }
        return foundFiles;
    }

    public File findStandardDirectory(String stdDirName) {
        String dirName = stdDirName.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File dir2 = new File(this._rootDir, dirName);
        File foundDir = this._allDirs.contains(dir2) ? dir2 : null;
        return foundDir;
    }

    public File findStandardFile(String stdFileName) {
        String fileName = stdFileName.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File file = new File(this._rootDir, fileName);
        File foundFile = this._allFiles.contains(file) ? file : null;
        return foundFile;
    }

    public File[] getAllDirectories() {
        File[] array = new File[this._allDirs.size()];
        this._allDirs.toArray(array);
        return array;
    }

    public File[] getAllFiles() {
        File[] array = new File[this._allFiles.size()];
        this._allFiles.toArray(array);
        return array;
    }

    public InstallationDescriptor getInstallationDescriptor() throws IOException {
        InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
        InstallationDescriptor insdObject = null;
        if (this.isArchived()) {
            try {
                insdHandler.parseInstallationDescriptor(this._pearPackage);
                insdObject = insdHandler.getInstallationDescriptor();
            }
            catch (SAXException err2) {
                throw new IOException(err2.toString());
            }
        }
        File insdFile = this.findStandardFile(INSTALLATION_DESCRIPTOR_FILE);
        if (insdFile != null) {
            try {
                insdHandler.parse(insdFile);
                insdObject = insdHandler.getInstallationDescriptor();
                insdObject.setMainComponentRoot(this.getRootDirectory().getAbsolutePath());
            }
            catch (SAXException err3) {
                throw new IOException(err3.toString());
            }
        }
        return insdObject;
    }

    public File getRootDirectory() {
        return this._rootDir;
    }

    public boolean isArchived() {
        return this._archived;
    }

    public String getComponentPearDescPath() throws IOException {
        if (this._archived) {
            return null;
        }
        File pearDescFile = new File(this._rootDir, this.getInstallationDescriptor().getMainComponentId() + "_pear.xml");
        return pearDescFile.getAbsolutePath();
    }

    public String getComponentDataPath() throws IOException {
        Properties pearEnvProps = InstallationController.buildTableOfEnvVars(this.getInstallationDescriptor());
        return (String)pearEnvProps.get("uima.datapath");
    }

    public Properties getComponentEnvVars() throws IOException {
        Properties pearEnvProps = InstallationController.buildTableOfEnvVars(this.getInstallationDescriptor());
        pearEnvProps.remove("uima.datapath");
        return pearEnvProps;
    }
}

