/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class FloatArray
extends TOP
implements FloatArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FloatArray() {
    }

    public FloatArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public FloatArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createArray(jcas.getType((int)FloatArray.typeIndexID).casTypeCode, length), jcas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(length);
    }

    public float get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, i);
    }

    public void set(int i, float v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setFloatArrayValue(this.addr, i, v);
    }

    public void copyFromArray(float[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setFloatArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int srcOffset, float[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, i + srcOffset);
        }
    }

    public float[] toArray() {
        int size2 = this.size();
        float[] outArray = new float[size2];
        this.copyToArray(0, outArray, 0, size2);
        return outArray;
    }

    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Float.toString(this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, i + srcOffset));
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setFloatArrayValue(this.addr, i + destOffset, Float.parseFloat(src[i + srcOffset]));
        }
    }

    public String[] toStringArray() {
        int size2 = this.size();
        String[] strArray = new String[size2];
        this.copyToArray(0, strArray, 0, size2);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(FloatArray.class);
    }
}

